/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.repl;

import java.util.List;
import javax.script.ScriptEngineFactory;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0016J\u0012\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u0016J1\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0013\"\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0014J!\u0010\u0015\u001a\u00020\u00052\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0013\"\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u0016\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/cli/common/repl/KotlinJsr223JvmScriptEngineFactoryBase;", "Ljavax/script/ScriptEngineFactory;", "<init>", "()V", "getLanguageName", "", "getLanguageVersion", "getEngineName", "getEngineVersion", "getExtensions", "", "getMimeTypes", "getNames", "getOutputStatement", "toDisplay", "getMethodCallSyntax", "obj", "m", "args", "", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "getProgram", "statements", "([Ljava/lang/String;)Ljava/lang/String;", "getParameter", "", "key", "cli-common"})
public abstract class KotlinJsr223JvmScriptEngineFactoryBase
implements ScriptEngineFactory {
    @Override
    @NotNull
    public String getLanguageName() {
        return "kotlin";
    }

    @Override
    @NotNull
    public String getLanguageVersion() {
        String string2 = KotlinCompilerVersion.VERSION;
        Intrinsics.checkNotNullExpressionValue(string2, "VERSION");
        return string2;
    }

    @Override
    @NotNull
    public String getEngineName() {
        return "kotlin";
    }

    @Override
    @NotNull
    public String getEngineVersion() {
        String string2 = KotlinCompilerVersion.VERSION;
        Intrinsics.checkNotNullExpressionValue(string2, "VERSION");
        return string2;
    }

    @Override
    @NotNull
    public List<String> getExtensions() {
        return CollectionsKt.listOf("kts");
    }

    @Override
    @NotNull
    public List<String> getMimeTypes() {
        return CollectionsKt.listOf("text/x-kotlin");
    }

    @Override
    @NotNull
    public List<String> getNames() {
        return CollectionsKt.listOf("kotlin");
    }

    @Override
    @NotNull
    public String getOutputStatement(@Nullable String toDisplay) {
        return "print(\"" + toDisplay + "\")";
    }

    @Override
    @NotNull
    public String getMethodCallSyntax(@NotNull String obj, @NotNull String m2, String ... args) {
        Intrinsics.checkNotNullParameter(obj, "obj");
        Intrinsics.checkNotNullParameter(m2, "m");
        Intrinsics.checkNotNullParameter(args, "args");
        return obj + '.' + m2 + '(' + ArraysKt.joinToString$default(args, null, null, null, 0, null, null, 63, null) + ')';
    }

    @Override
    @NotNull
    public String getProgram(String ... statements) {
        Intrinsics.checkNotNullParameter(statements, "statements");
        String sep = System.getProperty("line.separator");
        StringBuilder stringBuilder = new StringBuilder();
        Intrinsics.checkNotNull(sep);
        return stringBuilder.append(ArraysKt.joinToString$default(statements, (CharSequence)sep, null, null, 0, null, null, 62, null)).append(sep).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public Object getParameter(@Nullable String key) {
        String string2 = key;
        if (string2 == null) return null;
        int n2 = -1;
        switch (string2.hashCode()) {
            case -1047659667: {
                if (string2.equals("javax.script.engine")) {
                    n2 = 1;
                }
                break;
            }
            case -852670884: {
                if (string2.equals("javax.script.language_version")) {
                    n2 = 2;
                }
                break;
            }
            case -125973898: {
                if (string2.equals("javax.script.name")) {
                    n2 = 3;
                }
                break;
            }
            case -1073020410: {
                if (string2.equals("javax.script.engine_version")) {
                    n2 = 4;
                }
                break;
            }
            case -917703229: {
                if (string2.equals("javax.script.language")) {
                    n2 = 5;
                }
                break;
            }
        }
        switch (n2) {
            case 3: {
                String string3 = this.getEngineName();
                return string3;
            }
            case 5: {
                String string3 = this.getLanguageName();
                return string3;
            }
            case 2: {
                String string3 = this.getLanguageVersion();
                return string3;
            }
            case 1: {
                String string3 = this.getEngineName();
                return string3;
            }
            case 4: {
                String string3 = this.getEngineVersion();
                return string3;
            }
            default: {
                return null;
            }
        }
    }
}

