/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.plugins;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.io.File;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollectorUtil;
import org.jetbrains.kotlin.cli.plugins.PluginClasspathAndOptions;
import org.jetbrains.kotlin.cli.plugins.PluginsOptionsParserKt;
import org.jetbrains.kotlin.compiler.plugin.CliOptionProcessingException;
import org.jetbrains.kotlin.compiler.plugin.CliOptionValue;
import org.jetbrains.kotlin.compiler.plugin.CliOptionsKt;
import org.jetbrains.kotlin.compiler.plugin.CommandLineProcessor;
import org.jetbrains.kotlin.compiler.plugin.CompilerPluginRegistrar;
import org.jetbrains.kotlin.compiler.plugin.ComponentRegistrar;
import org.jetbrains.kotlin.compiler.plugin.PluginCliOptionProcessingException;
import org.jetbrains.kotlin.compiler.plugin.PluginProcessingException;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.util.ServiceLoaderLite;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JM\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007\u00a2\u0006\u0002\u0010\u000fJB\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J8\u0010\u0018\u001a\u00020\u00172\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00152\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0003J(\u0010\u0019\u001a\u00020\u00172\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001e\u0010\u001c\u001a\u00020\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/cli/jvm/plugins/PluginCliParser;", "", "<init>", "()V", "loadPluginsSafe", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "pluginClasspaths", "", "", "pluginOptions", "pluginConfigurations", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "([Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lcom/intellij/openapi/Disposable;)Lorg/jetbrains/kotlin/cli/common/ExitCode;", "", "loadRegisteredPluginsInfo", "", "Lorg/jetbrains/kotlin/cli/jvm/plugins/PluginCliParser$RegisteredPluginInfo;", "rawPluginConfigurations", "", "loadPluginsModernStyle", "", "loadPluginsLegacyStyle", "processPluginOptions", "classLoader", "Ljava/net/URLClassLoader;", "createClassLoader", "classpath", "RegisteredPluginInfo", "UrlClassLoaderDisposable", "cli"})
@SourceDebugExtension(value={"SMAP\nPluginCliParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginCliParser.kt\norg/jetbrains/kotlin/cli/jvm/plugins/PluginCliParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,196:1\n1563#2:197\n1634#2,3:198\n1563#2:202\n1634#2,3:203\n1617#2,9:210\n1869#2:219\n1870#2:221\n1626#2:222\n1#3:201\n1#3:220\n37#4:206\n36#4,3:207\n*S KotlinDebug\n*F\n+ 1 PluginCliParser.kt\norg/jetbrains/kotlin/cli/jvm/plugins/PluginCliParser\n*L\n92#1:197\n92#1:198,3\n176#1:202\n176#1:203,3\n100#1:210,9\n100#1:219\n100#1:221\n100#1:222\n100#1:220\n176#1:206\n176#1:207,3\n*E\n"})
public final class PluginCliParser {
    @NotNull
    public static final PluginCliParser INSTANCE = new PluginCliParser();

    private PluginCliParser() {
    }

    @JvmStatic
    @NotNull
    public static final ExitCode loadPluginsSafe(@Nullable String[] pluginClasspaths, @Nullable String[] pluginOptions, @Nullable String[] pluginConfigurations, @NotNull CompilerConfiguration configuration2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(configuration2, "configuration");
        Intrinsics.checkNotNullParameter(parentDisposable, "parentDisposable");
        Object object = pluginClasspaths;
        Object object2 = pluginOptions;
        Object object3 = pluginConfigurations;
        return PluginCliParser.loadPluginsSafe(pluginClasspaths != null && (object = ArraysKt.toList(object)) != null ? (Collection)object : (Collection)CollectionsKt.emptyList(), pluginOptions != null && (object2 = ArraysKt.toList(object2)) != null ? (Collection)object2 : (Collection)CollectionsKt.emptyList(), pluginConfigurations != null && (object3 = ArraysKt.toList(object3)) != null ? (Collection)object3 : (Collection)CollectionsKt.emptyList(), configuration2, parentDisposable);
    }

    @JvmStatic
    @NotNull
    public static final ExitCode loadPluginsSafe(@NotNull Collection<String> pluginClasspaths, @NotNull Collection<String> pluginOptions, @NotNull Collection<String> pluginConfigurations, @NotNull CompilerConfiguration configuration2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(pluginClasspaths, "pluginClasspaths");
        Intrinsics.checkNotNullParameter(pluginOptions, "pluginOptions");
        Intrinsics.checkNotNullParameter(pluginConfigurations, "pluginConfigurations");
        Intrinsics.checkNotNullParameter(configuration2, "configuration");
        Intrinsics.checkNotNullParameter(parentDisposable, "parentDisposable");
        MessageCollector messageCollector = configuration2.getNotNull(CommonConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkNotNullExpressionValue(messageCollector, "getNotNull(...)");
        MessageCollector messageCollector2 = messageCollector;
        try {
            PluginCliParser.loadPluginsLegacyStyle((Iterable<String>)pluginClasspaths, (Iterable<String>)pluginOptions, configuration2, parentDisposable);
            INSTANCE.loadPluginsModernStyle((Iterable<String>)pluginConfigurations, configuration2, parentDisposable);
            return ExitCode.OK;
        }
        catch (PluginProcessingException e2) {
            String string2 = e2.getMessage();
            Intrinsics.checkNotNull(string2);
            MessageCollector.report$default(messageCollector2, CompilerMessageSeverity.ERROR, string2, null, 4, null);
        }
        catch (PluginCliOptionProcessingException e3) {
            String message2 = e3.getMessage() + "\n\n" + CliOptionsKt.cliPluginUsageString(e3.getPluginId(), e3.getOptions());
            MessageCollector.report$default(messageCollector2, CompilerMessageSeverity.ERROR, message2, null, 4, null);
        }
        catch (CliOptionProcessingException e4) {
            String string3 = e4.getMessage();
            Intrinsics.checkNotNull(string3);
            MessageCollector.report$default(messageCollector2, CompilerMessageSeverity.ERROR, string3, null, 4, null);
        }
        catch (Throwable t2) {
            MessageCollectorUtil.reportException(messageCollector2, t2);
        }
        return ExitCode.INTERNAL_ERROR;
    }

    /*
     * WARNING - void declaration
     */
    private final List<RegisteredPluginInfo> loadRegisteredPluginsInfo(Iterable<String> rawPluginConfigurations, Disposable parentDisposable) {
        void $this$mapTo$iv$iv;
        List<PluginClasspathAndOptions> pluginConfigurations = PluginsOptionsParserKt.extractPluginClasspathAndOptions(rawPluginConfigurations);
        Iterable $this$map$iv = pluginConfigurations;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void pluginConfiguration;
            PluginClasspathAndOptions pluginClasspathAndOptions = (PluginClasspathAndOptions)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            URLClassLoader classLoader = INSTANCE.createClassLoader((Iterable<String>)pluginConfiguration.getClasspath(), parentDisposable);
            List<ComponentRegistrar> componentRegistrars = ServiceLoaderLite.INSTANCE.loadImplementations(ComponentRegistrar.class, classLoader);
            List<CompilerPluginRegistrar> compilerPluginRegistrars = ServiceLoaderLite.INSTANCE.loadImplementations(CompilerPluginRegistrar.class, classLoader);
            switch (componentRegistrars.size() + compilerPluginRegistrars.size()) {
                case 0: {
                    throw new PluginProcessingException("No plugins found in given classpath: " + CollectionsKt.joinToString$default(pluginConfiguration.getClasspath(), ",", null, null, 0, null, null, 62, null), null, 2, null);
                }
                case 1: {
                    break;
                }
                default: {
                    throw new PluginProcessingException(PluginCliParser.loadRegisteredPluginsInfo$lambda$2$multiplePluginsErrorMessage((PluginClasspathAndOptions)pluginConfiguration, CollectionsKt.plus((Collection)componentRegistrars, (Iterable)compilerPluginRegistrars)), null, 2, null);
                }
            }
            List<CommandLineProcessor> commandLineProcessor = ServiceLoaderLite.INSTANCE.loadImplementations(CommandLineProcessor.class, classLoader);
            if (commandLineProcessor.size() > 1) {
                throw new PluginProcessingException(PluginCliParser.loadRegisteredPluginsInfo$lambda$2$multiplePluginsErrorMessage((PluginClasspathAndOptions)pluginConfiguration, commandLineProcessor), null, 2, null);
            }
            collection.add(new RegisteredPluginInfo(CollectionsKt.firstOrNull(componentRegistrars), CollectionsKt.firstOrNull(compilerPluginRegistrars), CollectionsKt.firstOrNull(commandLineProcessor), pluginConfiguration.getOptions()));
        }
        List pluginInfos = (List)destination$iv$iv;
        return pluginInfos;
    }

    private final void loadPluginsModernStyle(Iterable<String> rawPluginConfigurations, CompilerConfiguration configuration2, Disposable parentDisposable) {
        if (rawPluginConfigurations == null) {
            return;
        }
        List<RegisteredPluginInfo> pluginInfos = this.loadRegisteredPluginsInfo(rawPluginConfigurations, parentDisposable);
        for (RegisteredPluginInfo pluginInfo : pluginInfos) {
            CommandLineProcessor commandLineProcessor;
            Object it;
            if (pluginInfo.getComponentRegistrar() != null) {
                boolean bl = false;
                configuration2.add(ComponentRegistrar.Companion.getPLUGIN_COMPONENT_REGISTRARS(), it);
            }
            if (pluginInfo.getCompilerPluginRegistrar() != null) {
                boolean bl = false;
                configuration2.add(CompilerPluginRegistrar.Companion.getCOMPILER_PLUGIN_REGISTRARS(), it);
            }
            if (pluginInfo.getPluginOptions().isEmpty()) continue;
            if (pluginInfo.getCommandLineProcessor() == null) {
                throw new RuntimeException();
            }
            PluginsOptionsParserKt.processCompilerPluginOptions(commandLineProcessor, pluginInfo.getPluginOptions(), configuration2);
        }
    }

    @JvmStatic
    private static final void loadPluginsLegacyStyle(Iterable<String> pluginClasspaths, Iterable<String> pluginOptions, CompilerConfiguration configuration2, Disposable parentDisposable) {
        Iterable iterable = pluginClasspaths;
        if (iterable == null) {
            iterable = CollectionsKt.emptyList();
        }
        URLClassLoader classLoader = INSTANCE.createClassLoader(iterable, parentDisposable);
        List<ComponentRegistrar> componentRegistrars = ServiceLoaderLite.INSTANCE.loadImplementations(ComponentRegistrar.class, classLoader);
        configuration2.addAll(ComponentRegistrar.Companion.getPLUGIN_COMPONENT_REGISTRARS(), (Collection)componentRegistrars);
        List<CompilerPluginRegistrar> compilerPluginRegistrars = ServiceLoaderLite.INSTANCE.loadImplementations(CompilerPluginRegistrar.class, classLoader);
        configuration2.addAll(CompilerPluginRegistrar.Companion.getCOMPILER_PLUGIN_REGISTRARS(), (Collection)compilerPluginRegistrars);
        INSTANCE.processPluginOptions(pluginOptions, configuration2, classLoader);
    }

    private final void processPluginOptions(Iterable<String> pluginOptions, CompilerConfiguration configuration2, URLClassLoader classLoader) {
        List<CommandLineProcessor> commandLineProcessors = ServiceLoaderLite.INSTANCE.loadImplementations(CommandLineProcessor.class, classLoader);
        PluginsOptionsParserKt.processCompilerPluginsOptions(configuration2, pluginOptions, commandLineProcessors);
    }

    /*
     * WARNING - void declaration
     */
    private final URLClassLoader createClassLoader(Iterable<String> classpath, Disposable parentDisposable) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv = classpath;
        boolean $i$f$map = false;
        Collection collection = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(new File((String)it).toURI().toURL());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
        URLClassLoader classLoader2 = new URLClassLoader(uRLArray, classLoader);
        Disposer.register(parentDisposable, new UrlClassLoaderDisposable(classLoader2));
        return classLoader2;
    }

    /*
     * WARNING - void declaration
     */
    private static final String loadRegisteredPluginsInfo$lambda$2$multiplePluginsErrorMessage(PluginClasspathAndOptions $pluginConfiguration, List<? extends Object> pluginObjects) {
        void $this$mapNotNullTo$iv$iv;
        StringBuilder stringBuilder;
        StringBuilder $this$loadRegisteredPluginsInfo_u24lambda_u242_u24multiplePluginsErrorMessage_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$loadRegisteredPluginsInfo_u24lambda_u242_u24multiplePluginsErrorMessage_u24lambda_u241.append("Multiple plugins found in given classpath: ");
        Iterable $this$mapNotNull$iv = pluginObjects;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl2 = false;
            Object it = element$iv$iv;
            boolean bl3 = false;
            if (Reflection.getOrCreateKotlinClass(it.getClass()).getQualifiedName() == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List extensionNames = (List)destination$iv$iv;
        $this$loadRegisteredPluginsInfo_u24lambda_u242_u24multiplePluginsErrorMessage_u24lambda_u241.append(CollectionsKt.joinToString$default(extensionNames, ", ", null, null, 0, null, null, 62, null)).append('\n');
        $this$loadRegisteredPluginsInfo_u24lambda_u242_u24multiplePluginsErrorMessage_u24lambda_u241.append("  Plugin configuration is: " + $pluginConfiguration.getRawArgument());
        return stringBuilder.toString();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B3\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/plugins/PluginCliParser$RegisteredPluginInfo;", "", "componentRegistrar", "Lorg/jetbrains/kotlin/compiler/plugin/ComponentRegistrar;", "compilerPluginRegistrar", "Lorg/jetbrains/kotlin/compiler/plugin/CompilerPluginRegistrar;", "commandLineProcessor", "Lorg/jetbrains/kotlin/compiler/plugin/CommandLineProcessor;", "pluginOptions", "", "Lorg/jetbrains/kotlin/compiler/plugin/CliOptionValue;", "<init>", "(Lorg/jetbrains/kotlin/compiler/plugin/ComponentRegistrar;Lorg/jetbrains/kotlin/compiler/plugin/CompilerPluginRegistrar;Lorg/jetbrains/kotlin/compiler/plugin/CommandLineProcessor;Ljava/util/List;)V", "getComponentRegistrar", "()Lorg/jetbrains/kotlin/compiler/plugin/ComponentRegistrar;", "getCompilerPluginRegistrar", "()Lorg/jetbrains/kotlin/compiler/plugin/CompilerPluginRegistrar;", "getCommandLineProcessor", "()Lorg/jetbrains/kotlin/compiler/plugin/CommandLineProcessor;", "getPluginOptions", "()Ljava/util/List;", "cli"})
    public static final class RegisteredPluginInfo {
        @Nullable
        private final ComponentRegistrar componentRegistrar;
        @Nullable
        private final CompilerPluginRegistrar compilerPluginRegistrar;
        @Nullable
        private final CommandLineProcessor commandLineProcessor;
        @NotNull
        private final List<CliOptionValue> pluginOptions;

        public RegisteredPluginInfo(@Nullable ComponentRegistrar componentRegistrar, @Nullable CompilerPluginRegistrar compilerPluginRegistrar, @Nullable CommandLineProcessor commandLineProcessor, @NotNull List<CliOptionValue> pluginOptions) {
            Intrinsics.checkNotNullParameter(pluginOptions, "pluginOptions");
            this.componentRegistrar = componentRegistrar;
            this.compilerPluginRegistrar = compilerPluginRegistrar;
            this.commandLineProcessor = commandLineProcessor;
            this.pluginOptions = pluginOptions;
        }

        @Nullable
        public final ComponentRegistrar getComponentRegistrar() {
            return this.componentRegistrar;
        }

        @Nullable
        public final CompilerPluginRegistrar getCompilerPluginRegistrar() {
            return this.compilerPluginRegistrar;
        }

        @Nullable
        public final CommandLineProcessor getCommandLineProcessor() {
            return this.commandLineProcessor;
        }

        @NotNull
        public final List<CliOptionValue> getPluginOptions() {
            return this.pluginOptions;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/plugins/PluginCliParser$UrlClassLoaderDisposable;", "Lcom/intellij/openapi/Disposable;", "classLoader", "Ljava/net/URLClassLoader;", "<init>", "(Ljava/net/URLClassLoader;)V", "classLoaderRef", "Ljava/lang/ref/WeakReference;", "dispose", "", "cli"})
    private static final class UrlClassLoaderDisposable
    implements Disposable {
        @NotNull
        private final WeakReference<URLClassLoader> classLoaderRef;

        public UrlClassLoaderDisposable(@NotNull URLClassLoader classLoader) {
            Intrinsics.checkNotNullParameter(classLoader, "classLoader");
            this.classLoaderRef = new WeakReference<URLClassLoader>(classLoader);
        }

        @Override
        public void dispose() {
            URLClassLoader classLoader = (URLClassLoader)this.classLoaderRef.get();
            if (classLoader != null) {
                classLoader.close();
                this.classLoaderRef.clear();
            }
        }
    }
}

