/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitUnitTypeRef;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000x\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0018\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a-\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\tH\u0082\b\u001a\f\u0010\n\u001a\u00020\u0001*\u00020\u000bH\u0000\u001a\u0010\u0010\n\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\fH\u0000\u001a\u0010\u0010\r\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\fH\u0002\u001a\u001e\u0010\u000e\u001a\u00020\u0001*\u00020\u000b2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u001e\u0010\u000f\u001a\u00020\u0001*\u00020\u000b2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u0012\u0010\u001f\u001a\u00020\u0001*\u00020 2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u0012\u0010\u001f\u001a\u00020\u0001*\u00020!2\u0006\u0010\u001d\u001a\u00020\u001e\u001a_\u0010$\u001a\u00020%*\u00020&2\u0006\u0010'\u001a\u00020&2K\u0010(\u001aG\u0012\u0013\u0012\u00110*\u00a2\u0006\f\b+\u0012\b\b,\u0012\u0004\b\b(-\u0012\u0013\u0012\u00110*\u00a2\u0006\f\b+\u0012\b\b,\u0012\u0004\b\b(.\u0012\u0013\u0012\u00110/\u00a2\u0006\f\b+\u0012\b\b,\u0012\u0004\b\b(0\u0012\u0004\u0012\u00020%0)\"\u0018\u0010\u0010\u001a\u00020\u0001*\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\"\u0015\u0010\u0013\u001a\u00020\u0001*\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015\"\u001c\u0010\u0013\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0016\"\u001c\u0010\u0017\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00188@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0019\"\u0019\u0010\"\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00188F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0019\u00a8\u00061"}, d2={"isInsideExpectClass", "", "containingClass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "isInsideExternalClass", "isInsideSpecificClass", "predicate", "Lkotlin/Function1;", "isEffectivelyFinal", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "isFinal", "isEffectivelyExpect", "isEffectivelyExternal", "canHaveOpenMembers", "getCanHaveOpenMembers", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;)Z", "isLocalMember", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Z", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Z", "isExtensionMember", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)Z", "primaryConstructorSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "needsMultiFieldValueClassFlattening", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "hasExplicitReturnType", "getHasExplicitReturnType", "checkValueParameterNamesWith", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "otherFunctionSymbol", "reportAction", "Lkotlin/Function3;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;", "Lkotlin/ParameterName;", "name", "currentParameter", "conflictingParameter", "", "parameterIndex", "checkers"})
@SourceDebugExtension(value={"SMAP\ndeclarationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 declarationUtils.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/DeclarationUtilsKt\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 5 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n*L\n1#1,151:1\n37#1:152\n38#1:154\n37#1:158\n38#1:160\n34#2:153\n52#2:159\n34#2:172\n52#2:173\n52#2:174\n1761#3,3:155\n1761#3,3:161\n1761#3,3:164\n84#4:167\n42#4:169\n16#4:170\n42#4:171\n71#4:175\n91#4:176\n37#5:168\n*S KotlinDebug\n*F\n+ 1 declarationUtils.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/DeclarationUtilsKt\n*L\n24#1:152\n24#1:154\n28#1:158\n28#1:160\n24#1:153\n28#1:159\n76#1:172\n85#1:173\n95#1:174\n24#1:155,3\n28#1:161,3\n38#1:164,3\n55#1:167\n59#1:169\n64#1:170\n65#1:171\n112#1:175\n113#1:176\n55#1:168\n*E\n"})
public final class DeclarationUtilsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInsideExpectClass(@NotNull FirClass containingClass, @NotNull CheckerContext context2) {
        boolean bl;
        boolean $i$f$isExpect;
        FirMemberDeclaration $this$isExpect$iv;
        Intrinsics.checkNotNullParameter(containingClass, "containingClass");
        Intrinsics.checkNotNullParameter(context2, "context");
        boolean $i$f$isInsideSpecificClass = false;
        FirClass klass = containingClass;
        boolean bl2 = false;
        if (klass instanceof FirRegularClass) {
            $this$isExpect$iv = klass;
            $i$f$isExpect = false;
            if ($this$isExpect$iv.getStatus().isExpect()) {
                return true;
            }
        }
        boolean bl3 = false;
        if (bl3) return true;
        Iterable $this$any$iv$iv = CollectionsKt.asReversed(context2.getContainingDeclarations());
        boolean $i$f$any = false;
        if ($this$any$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv$iv = iterator2.next();
            FirDeclaration it$iv = (FirDeclaration)element$iv$iv;
            boolean bl4 = false;
            if (it$iv instanceof FirRegularClass) {
                klass = (FirClass)it$iv;
                bl2 = false;
                if (klass instanceof FirRegularClass) {
                    $this$isExpect$iv = klass;
                    $i$f$isExpect = false;
                    if ($this$isExpect$iv.getStatus().isExpect()) {
                        return true;
                    }
                }
                boolean bl5 = false;
                if (bl5) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInsideExternalClass(@NotNull FirClass containingClass, @NotNull CheckerContext context2) {
        boolean bl;
        boolean $i$f$isExternal;
        FirMemberDeclaration $this$isExternal$iv;
        Intrinsics.checkNotNullParameter(containingClass, "containingClass");
        Intrinsics.checkNotNullParameter(context2, "context");
        boolean $i$f$isInsideSpecificClass = false;
        FirClass klass = containingClass;
        boolean bl2 = false;
        if (klass instanceof FirRegularClass) {
            $this$isExternal$iv = klass;
            $i$f$isExternal = false;
            if ($this$isExternal$iv.getStatus().isExternal()) {
                return true;
            }
        }
        boolean bl3 = false;
        if (bl3) return true;
        Iterable $this$any$iv$iv = CollectionsKt.asReversed(context2.getContainingDeclarations());
        boolean $i$f$any = false;
        if ($this$any$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv$iv = iterator2.next();
            FirDeclaration it$iv = (FirDeclaration)element$iv$iv;
            boolean bl4 = false;
            if (it$iv instanceof FirRegularClass) {
                klass = (FirClass)it$iv;
                bl2 = false;
                if (klass instanceof FirRegularClass) {
                    $this$isExternal$iv = klass;
                    $i$f$isExternal = false;
                    if ($this$isExternal$iv.getStatus().isExternal()) {
                        return true;
                    }
                }
                boolean bl5 = false;
                if (bl5) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    public static final boolean isEffectivelyFinal(@NotNull FirMemberDeclaration $this$isEffectivelyFinal) {
        Intrinsics.checkNotNullParameter($this$isEffectivelyFinal, "<this>");
        return DeclarationUtilsKt.isEffectivelyFinal($this$isEffectivelyFinal.getSymbol());
    }

    public static final boolean isEffectivelyFinal(@NotNull FirBasedSymbol<?> $this$isEffectivelyFinal) {
        FirClassSymbol containingClass;
        Intrinsics.checkNotNullParameter($this$isEffectivelyFinal, "<this>");
        if (DeclarationUtilsKt.isFinal($this$isEffectivelyFinal)) {
            return true;
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol($this$isEffectivelyFinal);
        FirClassSymbol firClassSymbol = firClassLikeSymbol instanceof FirClassSymbol ? (FirClassSymbol)firClassLikeSymbol : null;
        if (firClassSymbol == null) {
            return true;
        }
        FirClassSymbol $this$isEnumClass$iv = containingClass = firClassSymbol;
        boolean $i$f$isEnumClass = false;
        ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
        boolean $i$f$isEnumClass2 = false;
        boolean bl = $this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS;
        if (bl) {
            return false;
        }
        FirClassLikeSymbol $this$isFinal$iv = containingClass;
        boolean $i$f$isFinal = false;
        return $this$isFinal$iv.getResolvedStatus().getModality() == Modality.FINAL;
    }

    private static final boolean isFinal(FirBasedSymbol<?> $this$isFinal) {
        FirBasedSymbol<?> firBasedSymbol = $this$isFinal;
        if (firBasedSymbol instanceof FirCallableSymbol) {
            FirCallableSymbol $this$isFinal$iv = (FirCallableSymbol)$this$isFinal;
            boolean $i$f$isFinal = false;
            if ($this$isFinal$iv.getResolvedStatus().getModality() == Modality.FINAL) {
                return true;
            }
        } else if (firBasedSymbol instanceof FirClassLikeSymbol) {
            FirClassLikeSymbol $this$isFinal$iv = (FirClassLikeSymbol)$this$isFinal;
            boolean $i$f$isFinal = false;
            if ($this$isFinal$iv.getResolvedStatus().getModality() == Modality.FINAL) {
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public static final boolean isEffectivelyExpect(@NotNull FirMemberDeclaration $this$isEffectivelyExpect, @Nullable FirClass containingClass, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter($this$isEffectivelyExpect, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        FirMemberDeclaration $this$isExpect$iv = $this$isEffectivelyExpect;
        boolean $i$f$isExpect = false;
        if ($this$isExpect$iv.getStatus().isExpect()) {
            return true;
        }
        return containingClass != null && DeclarationUtilsKt.isInsideExpectClass(containingClass, context2);
    }

    public static final boolean isEffectivelyExternal(@NotNull FirMemberDeclaration $this$isEffectivelyExternal, @Nullable FirClass containingClass, @NotNull CheckerContext context2) {
        block9: {
            block10: {
                boolean bl;
                boolean bl2;
                boolean $i$f$isExternal;
                Intrinsics.checkNotNullParameter($this$isEffectivelyExternal, "<this>");
                Intrinsics.checkNotNullParameter(context2, "context");
                FirMemberDeclaration $this$isExternal$iv = $this$isEffectivelyExternal;
                boolean $i$f$isExternal2 = false;
                if ($this$isExternal$iv.getStatus().isExternal()) {
                    return true;
                }
                if ($this$isEffectivelyExternal instanceof FirPropertyAccessor) {
                    FirDeclaration firDeclaration = CollectionsKt.last(context2.getContainingDeclarations());
                    Intrinsics.checkNotNull(firDeclaration, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirProperty");
                    FirProperty property2 = (FirProperty)firDeclaration;
                    return DeclarationUtilsKt.isEffectivelyExternal(property2, containingClass, context2);
                }
                if (!($this$isEffectivelyExternal instanceof FirProperty)) break block9;
                FirPropertyAccessor firPropertyAccessor = ((FirProperty)$this$isEffectivelyExternal).getGetter();
                if (firPropertyAccessor != null) {
                    FirMemberDeclaration $this$isExternal$iv2 = firPropertyAccessor;
                    $i$f$isExternal = false;
                    bl2 = $this$isExternal$iv2.getStatus().isExternal();
                } else {
                    bl2 = false;
                }
                if (!bl2) break block9;
                if (!((FirProperty)$this$isEffectivelyExternal).isVar()) break block10;
                FirPropertyAccessor firPropertyAccessor2 = ((FirProperty)$this$isEffectivelyExternal).getSetter();
                if (firPropertyAccessor2 != null) {
                    FirMemberDeclaration $this$isExternal$iv3 = firPropertyAccessor2;
                    $i$f$isExternal = false;
                    bl = $this$isExternal$iv3.getStatus().isExternal();
                } else {
                    bl = false;
                }
                if (!bl) break block9;
            }
            return true;
        }
        return containingClass != null && DeclarationUtilsKt.isInsideExternalClass(containingClass, context2);
    }

    public static final boolean getCanHaveOpenMembers(@NotNull FirClass $this$canHaveOpenMembers) {
        Intrinsics.checkNotNullParameter($this$canHaveOpenMembers, "<this>");
        return FirHelpersKt.modality($this$canHaveOpenMembers) != Modality.FINAL || $this$canHaveOpenMembers.getClassKind() == ClassKind.ENUM_CLASS;
    }

    public static final boolean isLocalMember(@NotNull FirDeclaration $this$isLocalMember) {
        Intrinsics.checkNotNullParameter($this$isLocalMember, "<this>");
        return DeclarationUtilsKt.isLocalMember($this$isLocalMember.getSymbol());
    }

    public static final boolean isLocalMember(@NotNull FirBasedSymbol<?> $this$isLocalMember) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isLocalMember, "<this>");
        FirBasedSymbol<?> firBasedSymbol = $this$isLocalMember;
        if (firBasedSymbol instanceof FirPropertySymbol) {
            bl = ((FirPropertySymbol)$this$isLocalMember).isLocal();
        } else if (firBasedSymbol instanceof FirRegularClassSymbol) {
            FirClassLikeSymbol $this$isLocal$iv = (FirClassLikeSymbol)$this$isLocalMember;
            boolean $i$f$isLocal = false;
            bl = $this$isLocal$iv.getClassId().isLocal();
        } else if (firBasedSymbol instanceof FirNamedFunctionSymbol) {
            FirFunctionSymbol $this$isLocal$iv = (FirFunctionSymbol)$this$isLocalMember;
            boolean $i$f$isLocal = false;
            bl = Intrinsics.areEqual($this$isLocal$iv.getRawStatus().getVisibility(), Visibilities.Local.INSTANCE);
        } else {
            bl = firBasedSymbol instanceof FirAnonymousFunctionSymbol;
        }
        return bl;
    }

    public static final boolean isExtensionMember(@NotNull FirCallableSymbol<?> $this$isExtensionMember) {
        Intrinsics.checkNotNullParameter($this$isExtensionMember, "<this>");
        return $this$isExtensionMember.getResolvedReceiverTypeRef() != null && $this$isExtensionMember.getDispatchReceiverType() != null;
    }

    @Nullable
    public static final FirConstructorSymbol primaryConstructorSymbol(@NotNull FirClassSymbol<?> $this$primaryConstructorSymbol, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$primaryConstructorSymbol, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        return org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt.primaryConstructorIfAny((FirClass)$this$primaryConstructorSymbol.getFir(), session2);
    }

    public static final boolean needsMultiFieldValueClassFlattening(@NotNull FirTypeRef $this$needsMultiFieldValueClassFlattening, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$needsMultiFieldValueClassFlattening, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        return DeclarationUtilsKt.needsMultiFieldValueClassFlattening(FirTypeUtilsKt.getConeType($this$needsMultiFieldValueClassFlattening), session2);
    }

    public static final boolean needsMultiFieldValueClassFlattening(@NotNull ConeKotlinType $this$needsMultiFieldValueClassFlattening, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$needsMultiFieldValueClassFlattening, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        ConeInferenceContext $this$needsMultiFieldValueClassFlattening_u24lambda_u243 = TypeComponentsKt.getTypeContext(session2);
        boolean bl = false;
        return $this$needsMultiFieldValueClassFlattening_u24lambda_u243.isMultiFieldValueClass($this$needsMultiFieldValueClassFlattening_u24lambda_u243.typeConstructor($this$needsMultiFieldValueClassFlattening)) && !ConeTypeUtilsKt.isMarkedNullable(TypeExpansionUtilsKt.fullyExpandedType$default($this$needsMultiFieldValueClassFlattening, session2, null, 2, null));
    }

    public static final boolean getHasExplicitReturnType(@NotNull FirCallableSymbol<?> $this$hasExplicitReturnType) {
        Intrinsics.checkNotNullParameter($this$hasExplicitReturnType, "<this>");
        FirResolvedTypeRef returnTypeRef = $this$hasExplicitReturnType.getResolvedReturnTypeRef();
        return returnTypeRef.getDelegatedTypeRef() != null || returnTypeRef instanceof FirImplicitUnitTypeRef;
    }

    public static final void checkValueParameterNamesWith(@NotNull FirNamedFunctionSymbol $this$checkValueParameterNamesWith, @NotNull FirNamedFunctionSymbol otherFunctionSymbol, @NotNull Function3<? super FirValueParameterSymbol, ? super FirValueParameterSymbol, ? super Integer, Unit> reportAction) {
        Intrinsics.checkNotNullParameter($this$checkValueParameterNamesWith, "<this>");
        Intrinsics.checkNotNullParameter(otherFunctionSymbol, "otherFunctionSymbol");
        Intrinsics.checkNotNullParameter(reportAction, "reportAction");
        List valueParameterPairs = CollectionsKt.zip((Iterable)$this$checkValueParameterNamesWith.getValueParameterSymbols(), (Iterable)otherFunctionSymbol.getValueParameterSymbols());
        Iterator iterator2 = ((Iterable)valueParameterPairs).iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            int index = n2++;
            Pair valueParameterPair = (Pair)iterator2.next();
            FirValueParameterSymbol currentValueParameter = (FirValueParameterSymbol)valueParameterPair.component1();
            FirValueParameterSymbol otherValueParameter = (FirValueParameterSymbol)valueParameterPair.component2();
            if (Intrinsics.areEqual(currentValueParameter.getName(), otherValueParameter.getName())) continue;
            reportAction.invoke(currentValueParameter, otherValueParameter, (Integer)index);
        }
    }
}

