/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.expressions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.contracts.description.LogicOperationKind;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirEvaluatorResult;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirArgumentUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirArrayLiteral;
import org.jetbrains.kotlin.fir.expressions.FirBooleanOperatorExpression;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirClassReferenceExpression;
import org.jetbrains.kotlin.fir.expressions.FirComparisonExpression;
import org.jetbrains.kotlin.fir.expressions.FirConstChecksKt;
import org.jetbrains.kotlin.fir.expressions.FirEnumEntryDeserializedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirEqualityOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionEvaluatorKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirIntegerLiteralOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirLazyExpression;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirSpreadArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirStringConcatenationCall;
import org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.PrivateConstantEvaluatorAPI;
import org.jetbrains.kotlin.fir.expressions.builder.FirAnnotationArgumentMappingBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirAnnotationBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirArgumentListBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirArrayLiteralBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirFunctionCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirNamedArgumentExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirSpreadArgumentExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirVarargArgumentsExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeRigidType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001 B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ$\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\n\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eJ\u001a\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0016\u0010\u0017\u001a\u00020\u0018*\u0004\u0018\u00010\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u0019\u001a\u00020\n*\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0002J*\u0010\u001a\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b*\u0006\u0012\u0002\b\u00030\u00072\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001dH\u0082\b\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\u0018*\u0006\u0012\u0002\b\u00030\u0007H\u0002R,\u0010\u0004\u001a \u0012\u001c\u0012\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007`\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/fir/expressions/FirExpressionEvaluator;", "", "<init>", "()V", "visitedCallables", "Ljava/lang/ThreadLocal;", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "Lkotlin/collections/HashSet;", "evaluatePropertyInitializer", "Lorg/jetbrains/kotlin/fir/FirEvaluatorResult;", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "evaluateAnnotationArguments", "", "Lorg/jetbrains/kotlin/name/Name;", "annotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "evaluateExpression", "expression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "canBeEvaluated", "", "evaluate", "visit", "T", "block", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "wasVisited", "EvaluationVisitor", "providers"})
@SourceDebugExtension(value={"SMAP\nFirExpressionEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExpressionEvaluator.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionEvaluator\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,583:1\n54#2:584\n1761#3,3:585\n1252#3,4:590\n465#4:588\n415#4:589\n*S KotlinDebug\n*F\n+ 1 FirExpressionEvaluator.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionEvaluator\n*L\n68#1:584\n88#1:585,3\n92#1:590,4\n92#1:588\n92#1:589\n*E\n"})
public final class FirExpressionEvaluator {
    @NotNull
    public static final FirExpressionEvaluator INSTANCE = new FirExpressionEvaluator();
    @NotNull
    private static final ThreadLocal<HashSet<FirCallableSymbol<?>>> visitedCallables;

    private FirExpressionEvaluator() {
    }

    @Nullable
    public final FirEvaluatorResult evaluatePropertyInitializer(@NotNull FirProperty property2, @NotNull FirSession session2) {
        ConeKotlinType type2;
        Intrinsics.checkNotNullParameter(property2, "property");
        Intrinsics.checkNotNullParameter(session2, "session");
        FirMemberDeclaration $this$isConst$iv = property2;
        boolean $i$f$isConst = false;
        if (!$this$isConst$iv.getStatus().isConst()) {
            return null;
        }
        ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeTypeOrNull(property2.getReturnTypeRef());
        ConeKotlinType coneKotlinType2 = type2 = coneKotlinType != null ? TypeExpansionUtilsKt.fullyExpandedType$default(coneKotlinType, session2, null, 2, null) : null;
        if (type2 == null || type2 instanceof ConeErrorType || !FirConstChecksKt.canBeUsedForConstVal(type2)) {
            return null;
        }
        FirExpression initializer = property2.getInitializer();
        if (initializer == null || !this.canBeEvaluated(initializer, session2)) {
            return null;
        }
        return this.evaluate(initializer, session2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Map<Name, FirEvaluatorResult> evaluateAnnotationArguments(@NotNull FirAnnotation annotation, @NotNull FirSession session2) {
        void $this$mapValuesTo$iv$iv;
        boolean bl;
        Map<Name, FirExpression> argumentMapping2;
        block5: {
            Intrinsics.checkNotNullParameter(annotation, "annotation");
            Intrinsics.checkNotNullParameter(session2, "session");
            argumentMapping2 = annotation.getArgumentMapping().getMapping();
            Iterable $this$any$iv = argumentMapping2.values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirExpression expr = (FirExpression)element$iv;
                    boolean bl2 = false;
                    if (!(!INSTANCE.canBeEvaluated(expr, session2))) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        Map<Name, FirExpression> $this$mapValues$iv = argumentMapping2;
        boolean $i$f$mapValues = false;
        Map<Name, FirExpression> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl3 = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl4 = false;
            FirExpression expression2 = (FirExpression)entry2.getValue();
            FirEvaluatorResult firEvaluatorResult = INSTANCE.evaluate(expression2, session2);
            map3.put(k2, firEvaluatorResult);
        }
        return destination$iv$iv;
    }

    @PrivateConstantEvaluatorAPI
    @Nullable
    public final FirEvaluatorResult evaluateExpression(@NotNull FirExpression expression2, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(session2, "session");
        if (!this.canBeEvaluated(expression2, session2)) {
            return null;
        }
        return this.evaluate(expression2, session2);
    }

    private final boolean canBeEvaluated(FirExpression $this$canBeEvaluated, FirSession session2) {
        boolean intrinsicConstEvaluation = FirLanguageSettingsComponentKt.getLanguageVersionSettings(session2).supportsFeature(LanguageFeature.IntrinsicConstEvaluation);
        if ($this$canBeEvaluated == null || intrinsicConstEvaluation || $this$canBeEvaluated instanceof FirLazyExpression || !FirTypeUtilsKt.isResolved($this$canBeEvaluated)) {
            return false;
        }
        return FirConstChecksKt.canBeEvaluatedAtCompileTime($this$canBeEvaluated, session2, false, false);
    }

    private final FirEvaluatorResult evaluate(FirExpression $this$evaluate, FirSession session2) {
        EvaluationVisitor visitor2 = new EvaluationVisitor(session2);
        return visitor2.evaluate($this$evaluate);
    }

    private final boolean wasVisited(FirCallableSymbol<?> $this$wasVisited) {
        return visitedCallables.get().contains($this$wasVisited);
    }

    private static final HashSet<Object> visitedCallables$hashSetOf__proxy() {
        return new HashSet<Object>();
    }

    static {
        ThreadLocal<HashSet> threadLocal = ThreadLocal.withInitial(FirExpressionEvaluator::visitedCallables$hashSetOf__proxy);
        Intrinsics.checkNotNullExpressionValue(threadLocal, "withInitial(...)");
        visitedCallables = threadLocal;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00d8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u001a\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020%2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020(2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010)\u001a\u00020\u00022\u0006\u0010*\u001a\u00020+2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010,\u001a\u00020\u00022\u0006\u0010-\u001a\u00020.2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010/\u001a\u00020\u00022\u0006\u00100\u001a\u0002012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u0018\u00102\u001a\u00020\u00022\u0006\u00100\u001a\u0002012\u0006\u00103\u001a\u000204H\u0002J\u0010\u00105\u001a\u00020\u00022\u0006\u00106\u001a\u000201H\u0002J\u001a\u00107\u001a\u00020\u00022\u0006\u00108\u001a\u0002092\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010:\u001a\u00020\u00022\u0006\u0010;\u001a\u00020<2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010=\u001a\u00020\u00022\u0006\u0010>\u001a\u00020?2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010@\u001a\u00020\u00022\u0006\u0010A\u001a\u00020B2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010C\u001a\u00020\u00022\u0006\u0010D\u001a\u00020E2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010F\u001a\u00020\u00022\u0006\u0010G\u001a\u00020H2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010I\u001a\u00020\u00022\u0006\u0010J\u001a\u00020K2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010L\u001a\u00020\u00022\u0006\u0010M\u001a\u00020N2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010O\u001a\u00020\u00022\u0006\u0010P\u001a\u00020Q2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010R\u001a\u00020\u00022\u0006\u0010S\u001a\u00020T2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006U"}, d2={"Lorg/jetbrains/kotlin/fir/expressions/FirExpressionEvaluator$EvaluationVisitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "Lorg/jetbrains/kotlin/fir/FirEvaluatorResult;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "evaluate", "expression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "data", "visitLiteralExpression", "literalExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;", "visitResolvedNamedReference", "resolvedNamedReference", "Lorg/jetbrains/kotlin/fir/references/FirResolvedNamedReference;", "visitResolvedQualifier", "resolvedQualifier", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;", "visitGetClassCall", "getClassCall", "Lorg/jetbrains/kotlin/fir/expressions/FirGetClassCall;", "visitArgumentList", "argumentList", "Lorg/jetbrains/kotlin/fir/expressions/FirArgumentList;", "visitNamedArgumentExpression", "namedArgumentExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirNamedArgumentExpression;", "visitArrayLiteral", "arrayLiteral", "Lorg/jetbrains/kotlin/fir/expressions/FirArrayLiteral;", "visitVarargArgumentsExpression", "varargArgumentsExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirVarargArgumentsExpression;", "visitSpreadArgumentExpression", "spreadArgumentExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirSpreadArgumentExpression;", "visitPropertyAccessExpression", "propertyAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirPropertyAccessExpression;", "visitFunctionCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "visitNamedFunction", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "visitConstructorCall", "constructorCall", "visitIntegerLiteralOperatorCall", "integerLiteralOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirIntegerLiteralOperatorCall;", "visitComparisonExpression", "comparisonExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirComparisonExpression;", "visitEqualityOperatorCall", "equalityOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirEqualityOperatorCall;", "visitBooleanOperatorExpression", "booleanOperatorExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirBooleanOperatorExpression;", "visitStringConcatenationCall", "stringConcatenationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirStringConcatenationCall;", "visitTypeOperatorCall", "typeOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;", "visitEnumEntryDeserializedAccessExpression", "enumEntryDeserializedAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirEnumEntryDeserializedAccessExpression;", "visitClassReferenceExpression", "classReferenceExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirClassReferenceExpression;", "visitAnnotationCall", "annotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "visitAnnotation", "annotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "providers"})
    @SourceDebugExtension(value={"SMAP\nFirExpressionEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExpressionEvaluator.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionEvaluator$EvaluationVisitor\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FirEvaluatorResult.kt\norg/jetbrains/kotlin/fir/FirEvaluatorResultKt\n+ 5 FirArgumentListBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirArgumentListBuilderKt\n+ 6 FirNamedArgumentExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirNamedArgumentExpressionBuilderKt\n+ 7 FirArrayLiteralBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirArrayLiteralBuilderKt\n+ 8 FirVarargArgumentsExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirVarargArgumentsExpressionBuilderKt\n+ 9 FirSpreadArgumentExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirSpreadArgumentExpressionBuilderKt\n+ 10 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 11 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 12 FirFunctionCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirFunctionCallBuilderKt\n+ 13 FirAnnotationBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirAnnotationBuilderKt\n+ 14 FirAnnotationArgumentMappingBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirAnnotationArgumentMappingBuilderKt\n+ 15 FirExpressionEvaluator.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionEvaluator\n*L\n1#1,583:1\n426#2:584\n1252#3,2:585\n1255#3:591\n1563#3:593\n1634#3,2:594\n1636#3:600\n1563#3:612\n1634#3,2:613\n1636#3:619\n1563#3:630\n1634#3,2:631\n1636#3:637\n1563#3:658\n1634#3,2:659\n1636#3:665\n1563#3:678\n1634#3,2:679\n1636#3:685\n28#4,4:587\n28#4,4:596\n28#4,4:602\n28#4,4:607\n28#4,4:615\n28#4,4:621\n28#4,4:625\n28#4,4:633\n28#4,6:639\n28#4,6:647\n28#4,4:653\n28#4,4:661\n28#4,6:666\n28#4,6:672\n28#4,4:681\n28#4,6:687\n36#5:592\n57#6:601\n47#7:606\n49#8:611\n56#9:620\n43#10:629\n45#10:646\n43#10:657\n45#10:686\n1#11:638\n66#12:645\n69#13,7:693\n35#14:700\n113#15,11:701\n*S KotlinDebug\n*F\n+ 1 FirExpressionEvaluator.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionEvaluator$EvaluationVisitor\n*L\n157#1:584\n157#1:585,2\n157#1:591\n161#1:593\n161#1:594,2\n161#1:600\n192#1:612\n192#1:613,2\n192#1:619\n254#1:630\n254#1:631,2\n254#1:637\n320#1:658\n320#1:659,2\n320#1:665\n349#1:678\n349#1:679,2\n349#1:685\n157#1:587,4\n161#1:596,4\n170#1:602,4\n182#1:607,4\n192#1:615,4\n201#1:621,4\n227#1:625,4\n255#1:633,4\n277#1:639,6\n291#1:647,6\n307#1:653,4\n321#1:661,4\n338#1:666,6\n339#1:672,6\n350#1:681,4\n358#1:687,6\n159#1:592\n167#1:601\n178#1:606\n188#1:611\n198#1:620\n254#1:629\n290#1:646\n320#1:657\n358#1:686\n278#1:645\n393#1:693,7\n394#1:700\n213#1:701,11\n*E\n"})
    private static final class EvaluationVisitor
    extends FirVisitor {
        @NotNull
        private final FirSession session;

        public EvaluationVisitor(@NotNull FirSession session2) {
            Intrinsics.checkNotNullParameter(session2, "session");
            this.session = session2;
        }

        @NotNull
        public final FirSession getSession() {
            return this.session;
        }

        @NotNull
        public final FirEvaluatorResult evaluate(@Nullable FirExpression expression2) {
            Object object = expression2;
            if (object == null || (object = (FirEvaluatorResult)((FirExpression)object).accept(this, null)) == null) {
                object = FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            return object;
        }

        @NotNull
        public FirEvaluatorResult visitElement(@NotNull FirElement element, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(element, "element");
            throw new IllegalStateException(("FIR element \"" + Reflection.getOrCreateKotlinClass(element.getClass()) + "\" is not supported in constant evaluation").toString());
        }

        @NotNull
        public FirEvaluatorResult visitLiteralExpression(@NotNull FirLiteralExpression literalExpression, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(literalExpression, "literalExpression");
            return FirExpressionEvaluatorKt.access$wrap(literalExpression);
        }

        @NotNull
        public FirEvaluatorResult visitResolvedNamedReference(@NotNull FirResolvedNamedReference resolvedNamedReference, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(resolvedNamedReference, "resolvedNamedReference");
            return FirExpressionEvaluatorKt.access$wrap(resolvedNamedReference);
        }

        @NotNull
        public FirEvaluatorResult visitResolvedQualifier(@NotNull FirResolvedQualifier resolvedQualifier, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(resolvedQualifier, "resolvedQualifier");
            return FirExpressionEvaluatorKt.access$wrap(resolvedQualifier);
        }

        @NotNull
        public FirEvaluatorResult visitGetClassCall(@NotNull FirGetClassCall getClassCall, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(getClassCall, "getClassCall");
            return FirExpressionEvaluatorKt.access$wrap(getClassCall);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public FirEvaluatorResult visitArgumentList(@NotNull FirArgumentList argumentList, @Nullable Void data) {
            FirArgumentList firArgumentList;
            Intrinsics.checkNotNullParameter(argumentList, "argumentList");
            if (argumentList instanceof FirResolvedArgumentList) {
                void destination$iv;
                void $this$mapKeysTo$iv;
                Map map = ((FirResolvedArgumentList)argumentList).getMapping();
                Map map2 = new LinkedHashMap();
                FirArgumentList firArgumentList2 = ((FirResolvedArgumentList)argumentList).getOriginalArgumentList();
                boolean $i$f$mapKeysTo = false;
                Iterable $this$associateByTo$iv$iv = $this$mapKeysTo$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    void it$iv;
                    FirElement firElement;
                    FirExpression it;
                    Map.Entry entry = (Map.Entry)element$iv$iv;
                    void var24_35 = destination$iv;
                    boolean $i$a$-mapKeysTo-FirExpressionEvaluator$EvaluationVisitor$visitArgumentList$22 = false;
                    FirEvaluatorResult $this$unwrapOr$iv = this.evaluate((FirExpression)it.getKey());
                    boolean $i$f$unwrapOr = false;
                    FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
                    if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                        FirEvaluatorResult.CompileTimeException it2 = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                        boolean bl = false;
                        return it2;
                    }
                    if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                        FirElement firElement2 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                        if (!(firElement2 instanceof FirExpression)) {
                            firElement2 = null;
                        }
                        firElement = (FirExpression)firElement2;
                    } else {
                        firElement = null;
                    }
                    if ((FirExpression)firElement == null) {
                        return FirEvaluatorResult.NotEvaluated.INSTANCE;
                    }
                    Map.Entry entry2 = (Map.Entry)element$iv$iv;
                    void var18_31 = var24_35;
                    boolean bl = false;
                    Object $i$a$-mapKeysTo-FirExpressionEvaluator$EvaluationVisitor$visitArgumentList$22 = it$iv.getValue();
                    var18_31.put(it, $i$a$-mapKeysTo-FirExpressionEvaluator$EvaluationVisitor$visitArgumentList$22);
                }
                firArgumentList = FirArgumentUtilKt.buildResolvedArgumentList(firArgumentList2, (LinkedHashMap)destination$iv);
            } else {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                FirArgumentListBuilder firArgumentListBuilder;
                boolean $i$f$buildArgumentList = false;
                FirArgumentListBuilder $this$visitArgumentList_u24lambda_u244 = firArgumentListBuilder = new FirArgumentListBuilder();
                boolean bl = false;
                $this$visitArgumentList_u24lambda_u244.setSource(argumentList.getSource());
                Iterable $i$f$associateByTo = argumentList.getArguments();
                List<FirExpression> list = $this$visitArgumentList_u24lambda_u244.getArguments();
                boolean $i$f$map = false;
                void it = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    FirElement firElement;
                    FirExpression it2 = (FirExpression)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    FirEvaluatorResult $this$unwrapOr$iv = this.evaluate(it2);
                    boolean $i$f$unwrapOr = false;
                    FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
                    if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                        FirEvaluatorResult.CompileTimeException it3 = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                        boolean bl3 = false;
                        return it3;
                    }
                    if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                        FirElement firElement3 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                        if (!(firElement3 instanceof FirExpression)) {
                            firElement3 = null;
                        }
                        firElement = (FirExpression)firElement3;
                    } else {
                        firElement = null;
                    }
                    FirExpression firExpression = (FirExpression)firElement;
                    if (firExpression == null) {
                        return FirEvaluatorResult.NotEvaluated.INSTANCE;
                    }
                    collection.add(firExpression);
                }
                list.addAll((List)destination$iv$iv);
                firArgumentList = firArgumentListBuilder.build();
            }
            return FirExpressionEvaluatorKt.access$wrap(firArgumentList);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public FirEvaluatorResult visitNamedArgumentExpression(@NotNull FirNamedArgumentExpression namedArgumentExpression, @Nullable Void data) {
            FirElement firElement;
            FirNamedArgumentExpressionBuilder firNamedArgumentExpressionBuilder;
            Intrinsics.checkNotNullParameter(namedArgumentExpression, "namedArgumentExpression");
            boolean $i$f$buildNamedArgumentExpression = false;
            FirNamedArgumentExpressionBuilder $this$visitNamedArgumentExpression_u24lambda_u246 = firNamedArgumentExpressionBuilder = new FirNamedArgumentExpressionBuilder();
            boolean bl = false;
            $this$visitNamedArgumentExpression_u24lambda_u246.setSource(namedArgumentExpression.getSource());
            $this$visitNamedArgumentExpression_u24lambda_u246.getAnnotations().addAll((Collection<FirAnnotation>)namedArgumentExpression.getAnnotations());
            FirEvaluatorResult $this$unwrapOr$iv = this.evaluate(namedArgumentExpression.getExpression());
            boolean $i$f$unwrapOr = false;
            FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
            if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                void it;
                FirEvaluatorResult.CompileTimeException compileTimeException = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                boolean bl2 = false;
                return (FirEvaluatorResult)it;
            }
            if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                FirElement firElement2 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                if (!(firElement2 instanceof FirExpression)) {
                    firElement2 = null;
                }
                firElement = (FirExpression)firElement2;
            } else {
                firElement = null;
            }
            FirExpression firExpression = (FirExpression)firElement;
            if (firExpression == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            $this$visitNamedArgumentExpression_u24lambda_u246.setExpression(firExpression);
            $this$visitNamedArgumentExpression_u24lambda_u246.setSpread(namedArgumentExpression.isSpread());
            $this$visitNamedArgumentExpression_u24lambda_u246.setName(namedArgumentExpression.getName());
            return FirExpressionEvaluatorKt.access$wrap(firNamedArgumentExpressionBuilder.build());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public FirEvaluatorResult visitArrayLiteral(@NotNull FirArrayLiteral arrayLiteral, @Nullable Void data) {
            FirElement firElement;
            FirArrayLiteralBuilder firArrayLiteralBuilder;
            Intrinsics.checkNotNullParameter(arrayLiteral, "arrayLiteral");
            boolean $i$f$buildArrayLiteral = false;
            FirArrayLiteralBuilder $this$visitArrayLiteral_u24lambda_u248 = firArrayLiteralBuilder = new FirArrayLiteralBuilder();
            boolean bl = false;
            $this$visitArrayLiteral_u24lambda_u248.setSource(arrayLiteral.getSource());
            $this$visitArrayLiteral_u24lambda_u248.setConeTypeOrNull(arrayLiteral.getConeTypeOrNull());
            $this$visitArrayLiteral_u24lambda_u248.getAnnotations().addAll((Collection<FirAnnotation>)arrayLiteral.getAnnotations());
            FirEvaluatorResult $this$unwrapOr$iv = this.visitArgumentList(arrayLiteral.getArgumentList(), data);
            boolean $i$f$unwrapOr = false;
            FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
            if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                void it;
                FirEvaluatorResult.CompileTimeException compileTimeException = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                boolean bl2 = false;
                return (FirEvaluatorResult)it;
            }
            if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                FirElement firElement2 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                if (!(firElement2 instanceof FirArgumentList)) {
                    firElement2 = null;
                }
                firElement = (FirArgumentList)firElement2;
            } else {
                firElement = null;
            }
            FirArgumentList firArgumentList = (FirArgumentList)firElement;
            if (firArgumentList == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            $this$visitArrayLiteral_u24lambda_u248.setArgumentList(firArgumentList);
            return FirExpressionEvaluatorKt.access$wrap(firArrayLiteralBuilder.build());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public FirEvaluatorResult visitVarargArgumentsExpression(@NotNull FirVarargArgumentsExpression varargArgumentsExpression, @Nullable Void data) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            FirVarargArgumentsExpressionBuilder firVarargArgumentsExpressionBuilder;
            Intrinsics.checkNotNullParameter(varargArgumentsExpression, "varargArgumentsExpression");
            boolean $i$f$buildVarargArgumentsExpression = false;
            FirVarargArgumentsExpressionBuilder $this$visitVarargArgumentsExpression_u24lambda_u2411 = firVarargArgumentsExpressionBuilder = new FirVarargArgumentsExpressionBuilder();
            boolean bl = false;
            $this$visitVarargArgumentsExpression_u24lambda_u2411.setSource(varargArgumentsExpression.getSource());
            $this$visitVarargArgumentsExpression_u24lambda_u2411.setConeTypeOrNull(varargArgumentsExpression.getConeTypeOrNull());
            $this$visitVarargArgumentsExpression_u24lambda_u2411.getAnnotations().addAll((Collection<FirAnnotation>)varargArgumentsExpression.getAnnotations());
            Iterable iterable = varargArgumentsExpression.getArguments();
            List<FirExpression> list = $this$visitVarargArgumentsExpression_u24lambda_u2411.getArguments();
            boolean $i$f$map = false;
            void var10_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                FirElement firElement;
                void it;
                FirExpression firExpression = (FirExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                FirEvaluatorResult $this$unwrapOr$iv = this.evaluate((FirExpression)it);
                boolean $i$f$unwrapOr = false;
                FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
                if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                    FirEvaluatorResult.CompileTimeException it2 = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                    boolean bl3 = false;
                    return it2;
                }
                if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                    FirElement firElement2 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                    if (!(firElement2 instanceof FirExpression)) {
                        firElement2 = null;
                    }
                    firElement = (FirExpression)firElement2;
                } else {
                    firElement = null;
                }
                FirExpression firExpression2 = (FirExpression)firElement;
                if (firExpression2 == null) {
                    return FirEvaluatorResult.NotEvaluated.INSTANCE;
                }
                collection.add(firExpression2);
            }
            list.addAll((List)destination$iv$iv);
            $this$visitVarargArgumentsExpression_u24lambda_u2411.setConeElementTypeOrNull(varargArgumentsExpression.getConeElementTypeOrNull());
            return FirExpressionEvaluatorKt.access$wrap(firVarargArgumentsExpressionBuilder.build());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public FirEvaluatorResult visitSpreadArgumentExpression(@NotNull FirSpreadArgumentExpression spreadArgumentExpression, @Nullable Void data) {
            FirElement firElement;
            FirSpreadArgumentExpressionBuilder firSpreadArgumentExpressionBuilder;
            Intrinsics.checkNotNullParameter(spreadArgumentExpression, "spreadArgumentExpression");
            boolean $i$f$buildSpreadArgumentExpression = false;
            FirSpreadArgumentExpressionBuilder $this$visitSpreadArgumentExpression_u24lambda_u2413 = firSpreadArgumentExpressionBuilder = new FirSpreadArgumentExpressionBuilder();
            boolean bl = false;
            $this$visitSpreadArgumentExpression_u24lambda_u2413.setSource(spreadArgumentExpression.getSource());
            $this$visitSpreadArgumentExpression_u24lambda_u2413.getAnnotations().addAll((Collection<FirAnnotation>)spreadArgumentExpression.getAnnotations());
            FirEvaluatorResult $this$unwrapOr$iv = this.evaluate(spreadArgumentExpression.getExpression());
            boolean $i$f$unwrapOr = false;
            FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
            if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                void it;
                FirEvaluatorResult.CompileTimeException compileTimeException = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                boolean bl2 = false;
                return (FirEvaluatorResult)it;
            }
            if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                FirElement firElement2 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                if (!(firElement2 instanceof FirExpression)) {
                    firElement2 = null;
                }
                firElement = (FirExpression)firElement2;
            } else {
                firElement = null;
            }
            FirExpression firExpression = (FirExpression)firElement;
            if (firExpression == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            $this$visitSpreadArgumentExpression_u24lambda_u2413.setExpression(firExpression);
            return FirExpressionEvaluatorKt.access$wrap(firSpreadArgumentExpressionBuilder.build());
        }

        @NotNull
        public FirEvaluatorResult visitPropertyAccessExpression(@NotNull FirPropertyAccessExpression propertyAccessExpression, @Nullable Void data) {
            FirEvaluatorResult firEvaluatorResult;
            Intrinsics.checkNotNullParameter(propertyAccessExpression, "propertyAccessExpression");
            FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(propertyAccessExpression.getCalleeReference(), false, 1, null);
            if (firCallableSymbol == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            FirCallableSymbol propertySymbol = firCallableSymbol;
            if (INSTANCE.wasVisited(propertySymbol)) {
                return FirEvaluatorResult.RecursionInInitializer.INSTANCE;
            }
            FirCallableSymbol firCallableSymbol2 = propertySymbol;
            if (firCallableSymbol2 instanceof FirPropertySymbol) {
                if (FirExpressionEvaluatorKt.access$isStringLength(((FirPropertySymbol)propertySymbol).getCallableId()) || FirExpressionEvaluatorKt.access$isCharCode(((FirPropertySymbol)propertySymbol).getCallableId())) {
                    FirElement firElement;
                    FirEvaluatorResult receiver = this.evaluate(propertyAccessExpression.getExplicitReceiver());
                    boolean bl = false;
                    FirEvaluatorResult $this$unwrapOr$iv = receiver;
                    boolean $i$f$unwrapOr = false;
                    FirEvaluatorResult firEvaluatorResult2 = $this$unwrapOr$iv;
                    if (firEvaluatorResult2 instanceof FirEvaluatorResult.CompileTimeException) {
                        FirEvaluatorResult.CompileTimeException it = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                        boolean bl2 = false;
                        return it;
                    }
                    if (firEvaluatorResult2 instanceof FirEvaluatorResult.Evaluated) {
                        FirElement firElement2 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                        if (!(firElement2 instanceof FirExpression)) {
                            firElement2 = null;
                        }
                        firElement = (FirExpression)firElement2;
                    } else {
                        firElement = null;
                    }
                    FirExpression firExpression = (FirExpression)firElement;
                    if (firExpression == null) {
                        return FirEvaluatorResult.NotEvaluated.INSTANCE;
                    }
                    FirExpression unaryArg = firExpression;
                    firEvaluatorResult = FirExpressionEvaluatorKt.access$adjustTypeAndConvertToLiteral(FirExpressionEvaluatorKt.access$evaluateUnary(unaryArg, ((FirPropertySymbol)propertySymbol).getCallableId()), propertyAccessExpression);
                } else {
                    firEvaluatorResult = EvaluationVisitor.visitPropertyAccessExpression$evaluateOrCopy(propertySymbol, propertyAccessExpression, this, ((FirProperty)((FirPropertySymbol)propertySymbol).getFir()).getInitializer());
                }
            } else if (firCallableSymbol2 instanceof FirFieldSymbol) {
                firEvaluatorResult = EvaluationVisitor.visitPropertyAccessExpression$evaluateOrCopy(propertySymbol, propertyAccessExpression, this, ((FirField)((FirFieldSymbol)propertySymbol).getFir()).getInitializer());
            } else if (firCallableSymbol2 instanceof FirEnumEntrySymbol) {
                firEvaluatorResult = FirExpressionEvaluatorKt.access$wrap(propertyAccessExpression);
            } else {
                throw new IllegalStateException(("FIR symbol \"" + Reflection.getOrCreateKotlinClass(propertySymbol.getClass()) + "\" is not supported in constant evaluation").toString());
            }
            return firEvaluatorResult;
        }

        @NotNull
        public FirEvaluatorResult visitFunctionCall(@NotNull FirFunctionCall functionCall, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(functionCall, "functionCall");
            FirNamedReference calleeReference = functionCall.getCalleeReference();
            if (!(calleeReference instanceof FirResolvedNamedReference)) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            FirBasedSymbol<?> symbol = ((FirResolvedNamedReference)calleeReference).getResolvedSymbol();
            return symbol instanceof FirNamedFunctionSymbol ? this.visitNamedFunction(functionCall, (FirNamedFunctionSymbol)symbol) : (symbol instanceof FirConstructorSymbol ? this.visitConstructorCall(functionCall) : (FirEvaluatorResult)FirEvaluatorResult.NotEvaluated.INSTANCE);
        }

        /*
         * WARNING - void declaration
         */
        private final FirEvaluatorResult visitNamedFunction(FirFunctionCall functionCall, FirNamedFunctionSymbol symbol) {
            FirEvaluatorResult firEvaluatorResult;
            void $this$mapTo$iv$iv;
            FirExpression[] firExpressionArray = new FirExpression[]{functionCall.getDispatchReceiver(), functionCall.getExtensionReceiver()};
            List<FirExpression> receivers = CollectionsKt.listOfNotNull(firExpressionArray);
            FirCall $this$arguments$iv = functionCall;
            boolean $i$f$getArguments = false;
            Iterable $this$map$iv = CollectionsKt.plus((Collection)receivers, (Iterable)$this$arguments$iv.getArgumentList().getArguments());
            boolean $i$f$map22 = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                FirElement firElement;
                void it;
                FirExpression firExpression = (FirExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                FirEvaluatorResult $this$unwrapOr$iv = this.evaluate((FirExpression)it);
                boolean $i$f$unwrapOr = false;
                FirEvaluatorResult firEvaluatorResult2 = $this$unwrapOr$iv;
                if (firEvaluatorResult2 instanceof FirEvaluatorResult.CompileTimeException) {
                    FirEvaluatorResult.CompileTimeException it2 = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                    boolean bl2 = false;
                    return it2;
                }
                if (firEvaluatorResult2 instanceof FirEvaluatorResult.Evaluated) {
                    FirElement firElement2 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                    if (!(firElement2 instanceof FirLiteralExpression)) {
                        firElement2 = null;
                    }
                    firElement = (FirLiteralExpression)firElement2;
                } else {
                    firElement = null;
                }
                FirLiteralExpression firLiteralExpression = (FirLiteralExpression)firElement;
                if (firLiteralExpression == null) {
                    return FirEvaluatorResult.NotEvaluated.INSTANCE;
                }
                collection.add(firLiteralExpression);
            }
            List evaluatedArgs = (List)destination$iv$iv;
            FirLiteralExpression firLiteralExpression = (FirLiteralExpression)CollectionsKt.getOrNull(evaluatedArgs, 0);
            if (firLiteralExpression == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            FirLiteralExpression opr1 = firLiteralExpression;
            Object $i$f$map22 = FirExpressionEvaluatorKt.access$evaluateUnary(opr1, symbol.getCallableId());
            if ($i$f$map22 != null && (object = FirExpressionEvaluatorKt.access$adjustTypeAndConvertToLiteral($i$f$map22, functionCall)) != null) {
                Object it = object;
                boolean bl = false;
                return it;
            }
            FirLiteralExpression firLiteralExpression2 = (FirLiteralExpression)CollectionsKt.getOrNull(evaluatedArgs, 1);
            if (firLiteralExpression2 == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            FirLiteralExpression opr2 = firLiteralExpression2;
            object = FirExpressionEvaluatorKt.access$evaluateBinary(opr1, symbol.getCallableId(), opr2);
            if (object != null && (firEvaluatorResult = FirExpressionEvaluatorKt.access$adjustTypeAndConvertToLiteral(object, functionCall)) != null) {
                FirEvaluatorResult it = firEvaluatorResult;
                boolean bl = false;
                return it;
            }
            return FirEvaluatorResult.NotEvaluated.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private final FirEvaluatorResult visitConstructorCall(FirFunctionCall constructorCall) {
            ConeRigidType type2 = ConeTypeUtilsKt.lowerBoundIfFlexible(TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getResolvedType(constructorCall), this.session, null, 2, null));
            FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol(type2, this.session);
            if ((firRegularClassSymbol != null ? firRegularClassSymbol.getClassKind() : null) == ClassKind.ANNOTATION_CLASS) {
                FirElement firElement;
                FirFunctionCallBuilder $this$unwrapOr$iv;
                FirEvaluatorResult firEvaluatorResult = (FirEvaluatorResult)constructorCall.getArgumentList().accept(this, null);
                boolean $i$f$unwrapOr = false;
                FirFunctionCallBuilder firFunctionCallBuilder = $this$unwrapOr$iv;
                if (firFunctionCallBuilder instanceof FirEvaluatorResult.CompileTimeException) {
                    FirEvaluatorResult.CompileTimeException it = (FirEvaluatorResult.CompileTimeException)((Object)$this$unwrapOr$iv);
                    boolean bl = false;
                    return it;
                }
                if (firFunctionCallBuilder instanceof FirEvaluatorResult.Evaluated) {
                    FirElement firElement2 = ((FirEvaluatorResult.Evaluated)((Object)$this$unwrapOr$iv)).getResult();
                    if (!(firElement2 instanceof FirResolvedArgumentList)) {
                        firElement2 = null;
                    }
                    firElement = (FirResolvedArgumentList)firElement2;
                } else {
                    firElement = null;
                }
                FirResolvedArgumentList firResolvedArgumentList = (FirResolvedArgumentList)firElement;
                if (firResolvedArgumentList == null) {
                    return FirEvaluatorResult.NotEvaluated.INSTANCE;
                }
                FirResolvedArgumentList evaluatedArgs = firResolvedArgumentList;
                boolean $i$f$buildFunctionCall = false;
                FirFunctionCallBuilder $this$visitConstructorCall_u24lambda_u2422 = $this$unwrapOr$iv = new FirFunctionCallBuilder();
                boolean bl = false;
                $this$visitConstructorCall_u24lambda_u2422.setConeTypeOrNull(constructorCall.getConeTypeOrNull());
                $this$visitConstructorCall_u24lambda_u2422.getAnnotations().addAll((Collection<FirAnnotation>)constructorCall.getAnnotations());
                $this$visitConstructorCall_u24lambda_u2422.getTypeArguments().addAll((Collection<FirTypeProjection>)constructorCall.getTypeArguments());
                $this$visitConstructorCall_u24lambda_u2422.setSource(constructorCall.getSource());
                $this$visitConstructorCall_u24lambda_u2422.getNonFatalDiagnostics().addAll((Collection<ConeDiagnostic>)constructorCall.getNonFatalDiagnostics());
                $this$visitConstructorCall_u24lambda_u2422.setArgumentList(evaluatedArgs);
                $this$visitConstructorCall_u24lambda_u2422.setCalleeReference(constructorCall.getCalleeReference());
                $this$visitConstructorCall_u24lambda_u2422.setOrigin(constructorCall.getOrigin());
                return FirExpressionEvaluatorKt.access$wrap($this$unwrapOr$iv.build());
            }
            if (ConeBuiltinTypeUtilsKt.isUnsignedType(type2)) {
                Object object;
                FirElement firElement;
                void $this$unwrapOr$iv;
                Object $this$argument$iv = constructorCall;
                boolean $i$f$getArgument = false;
                $this$argument$iv = this.evaluate(CollectionsKt.first($this$argument$iv.getArgumentList().getArguments()));
                boolean $i$f$unwrapOr = false;
                void var7_10 = $this$unwrapOr$iv;
                if (var7_10 instanceof FirEvaluatorResult.CompileTimeException) {
                    FirEvaluatorResult.CompileTimeException it = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                    boolean bl = false;
                    return it;
                }
                if (var7_10 instanceof FirEvaluatorResult.Evaluated) {
                    FirElement firElement3 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                    if (!(firElement3 instanceof FirLiteralExpression)) {
                        firElement3 = null;
                    }
                    firElement = (FirLiteralExpression)firElement3;
                } else {
                    firElement = null;
                }
                FirLiteralExpression firLiteralExpression = (FirLiteralExpression)firElement;
                if (firLiteralExpression == null || (object = firLiteralExpression.getValue()) == null) {
                    return FirEvaluatorResult.NotEvaluated.INSTANCE;
                }
                Object argument = object;
                return FirExpressionEvaluatorKt.access$adjustTypeAndConvertToLiteral(argument, constructorCall);
            }
            return FirEvaluatorResult.NotEvaluated.INSTANCE;
        }

        @NotNull
        public FirEvaluatorResult visitIntegerLiteralOperatorCall(@NotNull FirIntegerLiteralOperatorCall integerLiteralOperatorCall, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(integerLiteralOperatorCall, "integerLiteralOperatorCall");
            return this.visitFunctionCall((FirFunctionCall)integerLiteralOperatorCall, data);
        }

        @NotNull
        public FirEvaluatorResult visitComparisonExpression(@NotNull FirComparisonExpression comparisonExpression, @Nullable Void data) {
            boolean bl;
            FirElement firElement;
            Intrinsics.checkNotNullParameter(comparisonExpression, "comparisonExpression");
            FirEvaluatorResult it = this.visitFunctionCall(comparisonExpression.getCompareToCall(), data);
            boolean bl2 = false;
            FirEvaluatorResult $this$unwrapOr$iv = it;
            boolean $i$f$unwrapOr = false;
            FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
            if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                FirEvaluatorResult.CompileTimeException it2 = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                boolean bl3 = false;
                return it2;
            }
            if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                FirElement firElement2 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                if (!(firElement2 instanceof FirLiteralExpression)) {
                    firElement2 = null;
                }
                firElement = (FirLiteralExpression)firElement2;
            } else {
                firElement = null;
            }
            FirLiteralExpression firLiteralExpression = (FirLiteralExpression)firElement;
            Object object = firLiteralExpression != null ? firLiteralExpression.getValue() : null;
            Integer n2 = object instanceof Integer ? (Integer)object : null;
            if (n2 == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            int intResult = n2;
            switch (WhenMappings.$EnumSwitchMapping$0[comparisonExpression.getOperation().ordinal()]) {
                case 1: {
                    if (intResult < 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 2: {
                    if (intResult <= 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 3: {
                    if (intResult > 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 4: {
                    if (intResult >= 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    throw new IllegalStateException(("Unsupported comparison operation type \"" + comparisonExpression.getOperation().name() + '\"').toString());
                }
            }
            boolean compareToResult = bl;
            return FirExpressionEvaluatorKt.access$adjustTypeAndConvertToLiteral(compareToResult, comparisonExpression);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public FirEvaluatorResult visitEqualityOperatorCall(@NotNull FirEqualityOperatorCall equalityOperatorCall, @Nullable Void data) {
            boolean bl;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(equalityOperatorCall, "equalityOperatorCall");
            Object $this$arguments$iv = equalityOperatorCall;
            boolean $i$f$getArguments = false;
            $this$arguments$iv = $this$arguments$iv.getArgumentList().getArguments();
            boolean $i$f$map = false;
            void var6_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                FirElement firElement;
                void it;
                FirExpression firExpression = (FirExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                FirEvaluatorResult $this$unwrapOr$iv = this.evaluate((FirExpression)it);
                boolean $i$f$unwrapOr = false;
                FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
                if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                    FirEvaluatorResult.CompileTimeException it2 = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                    boolean bl3 = false;
                    return it2;
                }
                if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                    FirElement firElement2 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                    if (!(firElement2 instanceof FirLiteralExpression)) {
                        firElement2 = null;
                    }
                    firElement = (FirLiteralExpression)firElement2;
                } else {
                    firElement = null;
                }
                FirLiteralExpression firLiteralExpression = (FirLiteralExpression)firElement;
                if (firLiteralExpression == null) {
                    return FirEvaluatorResult.NotEvaluated.INSTANCE;
                }
                collection.add(firLiteralExpression);
            }
            List evaluatedArgs = (List)destination$iv$iv;
            if (evaluatedArgs.size() != 2) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            switch (WhenMappings.$EnumSwitchMapping$0[equalityOperatorCall.getOperation().ordinal()]) {
                case 5: {
                    bl = Intrinsics.areEqual(((FirLiteralExpression)evaluatedArgs.get(0)).getValue(), ((FirLiteralExpression)evaluatedArgs.get(1)).getValue());
                    break;
                }
                case 6: {
                    if (!Intrinsics.areEqual(((FirLiteralExpression)evaluatedArgs.get(0)).getValue(), ((FirLiteralExpression)evaluatedArgs.get(1)).getValue())) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    throw new IllegalStateException(("Operation \"" + (Object)((Object)equalityOperatorCall.getOperation()) + "\" is not supported in compile time evaluation").toString());
                }
            }
            boolean result2 = bl;
            return FirExpressionEvaluatorKt.access$wrap(FirExpressionEvaluatorKt.access$toConstExpression(result2, ConstantValueKind.Boolean.INSTANCE, equalityOperatorCall));
        }

        @NotNull
        public FirEvaluatorResult visitBooleanOperatorExpression(@NotNull FirBooleanOperatorExpression booleanOperatorExpression, @Nullable Void data) {
            boolean bl;
            FirElement firElement;
            FirElement firElement2;
            Intrinsics.checkNotNullParameter(booleanOperatorExpression, "booleanOperatorExpression");
            FirEvaluatorResult left = this.evaluate(booleanOperatorExpression.getLeftOperand());
            FirEvaluatorResult right = this.evaluate(booleanOperatorExpression.getRightOperand());
            FirEvaluatorResult $this$unwrapOr$iv = left;
            boolean $i$f$unwrapOr = false;
            FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
            if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                FirEvaluatorResult.CompileTimeException it = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                boolean bl2 = false;
                return it;
            }
            if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                FirElement firElement3 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                if (!(firElement3 instanceof FirLiteralExpression)) {
                    firElement3 = null;
                }
                firElement2 = (FirLiteralExpression)firElement3;
            } else {
                firElement2 = null;
            }
            FirLiteralExpression firLiteralExpression = (FirLiteralExpression)firElement2;
            Object object = firLiteralExpression != null ? firLiteralExpression.getValue() : null;
            Boolean bl3 = object instanceof Boolean ? (Boolean)object : null;
            if (bl3 == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            boolean leftBoolean = bl3;
            FirEvaluatorResult $this$unwrapOr$iv2 = right;
            boolean $i$f$unwrapOr2 = false;
            FirEvaluatorResult firEvaluatorResult2 = $this$unwrapOr$iv2;
            if (firEvaluatorResult2 instanceof FirEvaluatorResult.CompileTimeException) {
                FirEvaluatorResult.CompileTimeException it = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv2;
                boolean bl4 = false;
                return it;
            }
            if (firEvaluatorResult2 instanceof FirEvaluatorResult.Evaluated) {
                FirElement firElement4 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv2).getResult();
                if (!(firElement4 instanceof FirLiteralExpression)) {
                    firElement4 = null;
                }
                firElement = (FirLiteralExpression)firElement4;
            } else {
                firElement = null;
            }
            FirLiteralExpression firLiteralExpression2 = (FirLiteralExpression)firElement;
            Object object2 = firLiteralExpression2 != null ? firLiteralExpression2.getValue() : null;
            Boolean bl5 = object2 instanceof Boolean ? (Boolean)object2 : null;
            if (bl5 == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            boolean rightBoolean = bl5;
            switch (WhenMappings.$EnumSwitchMapping$1[booleanOperatorExpression.getKind().ordinal()]) {
                case 1: {
                    if (leftBoolean && rightBoolean) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 2: {
                    if (leftBoolean || rightBoolean) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            boolean result2 = bl;
            return FirExpressionEvaluatorKt.access$wrap(FirExpressionEvaluatorKt.access$toConstExpression(result2, ConstantValueKind.Boolean.INSTANCE, booleanOperatorExpression));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public FirEvaluatorResult visitStringConcatenationCall(@NotNull FirStringConcatenationCall stringConcatenationCall, @Nullable Void data) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(stringConcatenationCall, "stringConcatenationCall");
            Iterable $this$map$iv = stringConcatenationCall.getArgumentList().getArguments();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                FirElement firElement;
                void it;
                FirExpression firExpression = (FirExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                FirEvaluatorResult $this$unwrapOr$iv = this.evaluate((FirExpression)it);
                boolean $i$f$unwrapOr = false;
                FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
                if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                    FirEvaluatorResult.CompileTimeException it2 = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                    boolean bl2 = false;
                    return it2;
                }
                if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                    FirElement firElement2 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                    if (!(firElement2 instanceof FirLiteralExpression)) {
                        firElement2 = null;
                    }
                    firElement = (FirLiteralExpression)firElement2;
                } else {
                    firElement = null;
                }
                FirLiteralExpression firLiteralExpression = (FirLiteralExpression)firElement;
                if (firLiteralExpression == null) {
                    return FirEvaluatorResult.NotEvaluated.INSTANCE;
                }
                collection.add(firLiteralExpression);
            }
            List strings2 = (List)destination$iv$iv;
            String result2 = CollectionsKt.joinToString$default(strings2, "", null, null, 0, null, EvaluationVisitor::visitStringConcatenationCall$lambda$32, 30, null);
            return FirExpressionEvaluatorKt.access$wrap(FirExpressionEvaluatorKt.access$toConstExpression(result2, ConstantValueKind.String.INSTANCE, stringConcatenationCall));
        }

        @NotNull
        public FirEvaluatorResult visitTypeOperatorCall(@NotNull FirTypeOperatorCall typeOperatorCall, @Nullable Void data) {
            FirElement firElement;
            Intrinsics.checkNotNullParameter(typeOperatorCall, "typeOperatorCall");
            if (typeOperatorCall.getOperation() != FirOperation.AS) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            FirCall $this$argument$iv = typeOperatorCall;
            boolean $i$f$getArgument = false;
            FirEvaluatorResult $this$unwrapOr$iv = this.evaluate(CollectionsKt.first($this$argument$iv.getArgumentList().getArguments()));
            boolean $i$f$unwrapOr = false;
            FirEvaluatorResult firEvaluatorResult = $this$unwrapOr$iv;
            if (firEvaluatorResult instanceof FirEvaluatorResult.CompileTimeException) {
                FirEvaluatorResult.CompileTimeException it = (FirEvaluatorResult.CompileTimeException)$this$unwrapOr$iv;
                boolean bl = false;
                return it;
            }
            if (firEvaluatorResult instanceof FirEvaluatorResult.Evaluated) {
                FirElement firElement2 = ((FirEvaluatorResult.Evaluated)$this$unwrapOr$iv).getResult();
                if (!(firElement2 instanceof FirLiteralExpression)) {
                    firElement2 = null;
                }
                firElement = (FirLiteralExpression)firElement2;
            } else {
                firElement = null;
            }
            FirLiteralExpression firLiteralExpression = (FirLiteralExpression)firElement;
            if (firLiteralExpression == null) {
                return FirEvaluatorResult.NotEvaluated.INSTANCE;
            }
            FirLiteralExpression result2 = firLiteralExpression;
            if (TypeUtilsKt.isSubtypeOf$default(FirTypeUtilsKt.getResolvedType(result2), FirTypeUtilsKt.getResolvedType(typeOperatorCall), this.session, false, 4, null)) {
                return FirExpressionEvaluatorKt.access$wrap(result2);
            }
            return FirExpressionEvaluatorKt.access$wrap(typeOperatorCall);
        }

        @NotNull
        public FirEvaluatorResult visitEnumEntryDeserializedAccessExpression(@NotNull FirEnumEntryDeserializedAccessExpression enumEntryDeserializedAccessExpression, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(enumEntryDeserializedAccessExpression, "enumEntryDeserializedAccessExpression");
            return FirExpressionEvaluatorKt.access$wrap(enumEntryDeserializedAccessExpression);
        }

        @NotNull
        public FirEvaluatorResult visitClassReferenceExpression(@NotNull FirClassReferenceExpression classReferenceExpression, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(classReferenceExpression, "classReferenceExpression");
            return FirExpressionEvaluatorKt.access$wrap(classReferenceExpression);
        }

        @NotNull
        public FirEvaluatorResult visitAnnotationCall(@NotNull FirAnnotationCall annotationCall, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(annotationCall, "annotationCall");
            return this.visitAnnotation((FirAnnotation)annotationCall, data);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public FirEvaluatorResult visitAnnotation(@NotNull FirAnnotation annotation, @Nullable Void data) {
            void $this$visitAnnotation_u24lambda_u2435_u24lambda_u2434;
            FirAnnotationBuilder firAnnotationBuilder;
            Object object;
            Intrinsics.checkNotNullParameter(annotation, "annotation");
            Map<Name, FirExpression> mapping = annotation.getArgumentMapping().getMapping();
            if (mapping.isEmpty()) {
                return FirExpressionEvaluatorKt.access$wrap(annotation);
            }
            Map evaluatedMapping = new LinkedHashMap();
            for (Map.Entry<Name, FirExpression> entry : mapping.entrySet()) {
                Name name2 = entry.getKey();
                FirExpression expression2 = entry.getValue();
                FirEvaluatorResult evaluatedExpression = this.evaluate(expression2);
                if (evaluatedExpression instanceof FirEvaluatorResult.Evaluated) {
                    Map map = evaluatedMapping;
                    FirElement firElement = ((FirEvaluatorResult.Evaluated)evaluatedExpression).getResult();
                    Intrinsics.checkNotNull(firElement, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                    object = (FirExpression)firElement;
                    map.put(name2, object);
                    continue;
                }
                return evaluatedExpression;
            }
            boolean $i$f$buildAnnotationCopy = false;
            FirAnnotationBuilder copyBuilder$iv = new FirAnnotationBuilder();
            copyBuilder$iv.setSource(annotation.getSource());
            copyBuilder$iv.setUseSiteTarget(annotation.getUseSiteTarget());
            copyBuilder$iv.setAnnotationTypeRef(annotation.getAnnotationTypeRef());
            copyBuilder$iv.setArgumentMapping(annotation.getArgumentMapping());
            copyBuilder$iv.getTypeArguments().addAll((Collection<FirTypeProjection>)annotation.getTypeArguments());
            FirAnnotationBuilder $this$visitAnnotation_u24lambda_u2435 = firAnnotationBuilder = copyBuilder$iv;
            boolean bl = false;
            boolean $i$f$buildAnnotationArgumentMapping = false;
            Object object2 = object = new FirAnnotationArgumentMappingBuilder();
            FirAnnotationBuilder firAnnotationBuilder2 = $this$visitAnnotation_u24lambda_u2435;
            boolean bl2 = false;
            $this$visitAnnotation_u24lambda_u2435_u24lambda_u2434.getMapping().putAll(evaluatedMapping);
            firAnnotationBuilder2.setArgumentMapping(((FirAnnotationArgumentMappingBuilder)object).build());
            return FirExpressionEvaluatorKt.access$wrap(firAnnotationBuilder.build());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final FirEvaluatorResult visitPropertyAccessExpression$evaluateOrCopy(FirCallableSymbol<?> propertySymbol, FirPropertyAccessExpression $propertyAccessExpression, EvaluationVisitor this$0, FirExpression initializer) {
            FirEvaluatorResult firEvaluatorResult;
            FirExpressionEvaluator firExpressionEvaluator = INSTANCE;
            FirCallableSymbol<?> $this$visit$iv = propertySymbol;
            boolean $i$f$visit = false;
            HashSet visited$iv = (HashSet)visitedCallables.get();
            visited$iv.add($this$visit$iv);
            try {
                boolean bl = false;
                firEvaluatorResult = initializer instanceof FirLiteralExpression ? FirExpressionEvaluatorKt.access$wrap(FirExpressionEvaluatorKt.access$copy((FirLiteralExpression)initializer, $propertyAccessExpression)) : this$0.evaluate(initializer);
            }
            finally {
                visited$iv.remove($this$visit$iv);
                if (visited$iv.isEmpty()) {
                    visitedCallables.remove();
                }
            }
            return firEvaluatorResult;
        }

        private static final CharSequence visitStringConcatenationCall$lambda$32(FirLiteralExpression it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return String.valueOf(it.getValue());
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[FirOperation.values().length];
                try {
                    nArray[FirOperation.LT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FirOperation.LT_EQ.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FirOperation.GT.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FirOperation.GT_EQ.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FirOperation.EQ.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FirOperation.NOT_EQ.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[LogicOperationKind.values().length];
                try {
                    nArray[LogicOperationKind.AND.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LogicOperationKind.OR.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }
}

