/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.dirtyFiles;

import java.io.File;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.ICReporter;
import org.jetbrains.kotlin.incremental.ChangedFiles;
import org.jetbrains.kotlin.incremental.IncrementalCachesManager;
import org.jetbrains.kotlin.incremental.dirtyFiles.DirtyFilesCachedHistory;
import org.jetbrains.kotlin.incremental.dirtyFiles.DirtyFilesContainer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/incremental/dirtyFiles/DirtyFilesProvider;", "", "workingDir", "Ljava/io/File;", "kotlinSourceFileExtensions", "", "", "reporter", "Lorg/jetbrains/kotlin/build/report/ICReporter;", "<init>", "(Ljava/io/File;Ljava/util/Set;Lorg/jetbrains/kotlin/build/report/ICReporter;)V", "cachedHistory", "Lorg/jetbrains/kotlin/incremental/dirtyFiles/DirtyFilesCachedHistory;", "getCachedHistory", "()Lorg/jetbrains/kotlin/incremental/dirtyFiles/DirtyFilesCachedHistory;", "getInitializedDirtyFiles", "Lorg/jetbrains/kotlin/incremental/dirtyFiles/DirtyFilesContainer;", "caches", "Lorg/jetbrains/kotlin/incremental/IncrementalCachesManager;", "changedFiles", "Lorg/jetbrains/kotlin/incremental/ChangedFiles$DeterminableFiles$Known;", "incremental-compilation-impl"})
public final class DirtyFilesProvider {
    @NotNull
    private final Set<String> kotlinSourceFileExtensions;
    @NotNull
    private final ICReporter reporter;
    @NotNull
    private final DirtyFilesCachedHistory cachedHistory;

    public DirtyFilesProvider(@NotNull File workingDir, @NotNull Set<String> kotlinSourceFileExtensions, @NotNull ICReporter reporter) {
        Intrinsics.checkNotNullParameter(workingDir, "workingDir");
        Intrinsics.checkNotNullParameter(kotlinSourceFileExtensions, "kotlinSourceFileExtensions");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        this.kotlinSourceFileExtensions = kotlinSourceFileExtensions;
        this.reporter = reporter;
        this.cachedHistory = new DirtyFilesCachedHistory(workingDir);
    }

    @NotNull
    public final DirtyFilesCachedHistory getCachedHistory() {
        return this.cachedHistory;
    }

    @NotNull
    public final DirtyFilesContainer getInitializedDirtyFiles(@NotNull IncrementalCachesManager<?> caches, @NotNull ChangedFiles.DeterminableFiles.Known changedFiles) {
        Intrinsics.checkNotNullParameter(caches, "caches");
        Intrinsics.checkNotNullParameter(changedFiles, "changedFiles");
        DirtyFilesContainer dirtyFiles = new DirtyFilesContainer(caches, this.reporter, this.kotlinSourceFileExtensions);
        dirtyFiles.add((Iterable<? extends File>)changedFiles.getModified(), "was modified since last time");
        dirtyFiles.add((Iterable<? extends File>)changedFiles.getRemoved(), "was removed since last time");
        dirtyFiles.add((Iterable<? extends File>)this.cachedHistory.read(), "was not compiled last time");
        return dirtyFiles;
    }
}

