/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.javaInterop;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.BuildReporter;
import org.jetbrains.kotlin.build.report.ICReporterKt;
import org.jetbrains.kotlin.build.report.metrics.BuildAttribute;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildTime;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.FilteringMessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.incremental.ChangedFiles;
import org.jetbrains.kotlin.incremental.ChangesEither;
import org.jetbrains.kotlin.incremental.FileUtilsKt;
import org.jetbrains.kotlin.incremental.IncrementalCompilerRunner;
import org.jetbrains.kotlin.incremental.IncrementalJvmCache;
import org.jetbrains.kotlin.incremental.IncrementalJvmCachesManager;
import org.jetbrains.kotlin.incremental.IncrementalJvmCompilerRunner;
import org.jetbrains.kotlin.incremental.JavaClassesTrackerImpl;
import org.jetbrains.kotlin.incremental.LookupSymbol;
import org.jetbrains.kotlin.incremental.dirtyFiles.DirtyFilesContainer;
import org.jetbrains.kotlin.incremental.javaInterop.ChangedJavaFilesProcessor;
import org.jetbrains.kotlin.incremental.javaInterop.JavaInteropCoordinator;
import org.jetbrains.kotlin.load.java.JavaClassesTracker;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0089\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0017\b\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u000f\u001a\u00020\u0003J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000eH\u0002J\u0018\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'J\u0010\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020,J \u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020#2\u0006\u0010/\u001a\u000200R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/incremental/javaInterop/JavaInteropCoordinator;", "", "usePreciseJavaTracking", "", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "reporter", "Lorg/jetbrains/kotlin/build/report/BuildReporter;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildTime;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildPerformanceMetric;", "<init>", "(ZLorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Lorg/jetbrains/kotlin/build/report/BuildReporter;)V", "changedUntrackedJavaClasses", "", "Lorg/jetbrains/kotlin/name/ClassId;", "hasChangedUntrackedJavaClasses", "compilerConfiguration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "getCompilerConfiguration", "()Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "compilerConfiguration$delegate", "Lkotlin/Lazy;", "psiFileProvider", "org/jetbrains/kotlin/incremental/javaInterop/JavaInteropCoordinator$psiFileProvider$1", "Lorg/jetbrains/kotlin/incremental/javaInterop/JavaInteropCoordinator$psiFileProvider$1;", "javaFilesProcessor", "Lorg/jetbrains/kotlin/incremental/javaInterop/ChangedJavaFilesProcessor;", "processChangedUntrackedJavaClass", "", "psiClass", "Lcom/intellij/psi/PsiClass;", "classId", "processChangedJava", "Lorg/jetbrains/kotlin/build/report/metrics/BuildAttribute;", "changedFiles", "Lorg/jetbrains/kotlin/incremental/ChangedFiles$DeterminableFiles$Known;", "caches", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCachesManager;", "getAdditionalDirtyLookupSymbols", "", "Lorg/jetbrains/kotlin/incremental/LookupSymbol;", "makeJavaClassesTracker", "Lorg/jetbrains/kotlin/load/java/JavaClassesTracker;", "platformCache", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;", "analyzeChangesInJavaSources", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilerRunner$CompilationMode$Rebuild;", "mutableDirtyFiles", "Lorg/jetbrains/kotlin/incremental/dirtyFiles/DirtyFilesContainer;", "incremental-compilation-impl"})
@SourceDebugExtension(value={"SMAP\nJavaInteropCoordinator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaInteropCoordinator.kt\norg/jetbrains/kotlin/incremental/javaInterop/JavaInteropCoordinator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,163:1\n774#2:164\n865#2,2:165\n*S KotlinDebug\n*F\n+ 1 JavaInteropCoordinator.kt\norg/jetbrains/kotlin/incremental/javaInterop/JavaInteropCoordinator\n*L\n96#1:164\n96#1:165,2\n*E\n"})
public final class JavaInteropCoordinator {
    private final boolean usePreciseJavaTracking;
    @NotNull
    private final BuildReporter<GradleBuildTime, GradleBuildPerformanceMetric> reporter;
    @NotNull
    private final Set<ClassId> changedUntrackedJavaClasses;
    @NotNull
    private final Lazy compilerConfiguration$delegate;
    @NotNull
    private final psiFileProvider.1 psiFileProvider;
    @Nullable
    private ChangedJavaFilesProcessor javaFilesProcessor;

    public JavaInteropCoordinator(boolean usePreciseJavaTracking, @NotNull MessageCollector messageCollector, @NotNull BuildReporter<GradleBuildTime, GradleBuildPerformanceMetric> reporter) {
        Intrinsics.checkNotNullParameter(messageCollector, "messageCollector");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        this.usePreciseJavaTracking = usePreciseJavaTracking;
        this.reporter = reporter;
        this.changedUntrackedJavaClasses = new LinkedHashSet();
        this.compilerConfiguration$delegate = LazyKt.lazy(() -> JavaInteropCoordinator.compilerConfiguration_delegate$lambda$2(messageCollector));
        this.psiFileProvider = new Object(this){
            private final Lazy psiFileFactory$delegate;
            {
                this.psiFileFactory$delegate = LazyKt.lazy(() -> psiFileProvider.1.psiFileFactory_delegate$lambda$0($receiver));
            }

            public final PsiFile javaFile(File file2) {
                Intrinsics.checkNotNullParameter(file2, "file");
                return this.getPsiFileFactory().createFileFromText(FilesKt.getNameWithoutExtension(file2), JavaLanguage.INSTANCE, (CharSequence)FilesKt.readText$default(file2, null, 1, null));
            }

            private final PsiFileFactory getPsiFileFactory() {
                Lazy lazy = this.psiFileFactory$delegate;
                T t2 = lazy.getValue();
                Intrinsics.checkNotNullExpressionValue(t2, "getValue(...)");
                return (PsiFileFactory)t2;
            }

            private static final PsiFileFactory psiFileFactory_delegate$lambda$0(JavaInteropCoordinator this$0) {
                Disposable disposable = Disposer.newDisposable("Disposable for PSI file factory of " + Reflection.getOrCreateKotlinClass(IncrementalJvmCompilerRunner.class).getSimpleName());
                Intrinsics.checkNotNullExpressionValue(disposable, "newDisposable(...)");
                Disposable rootDisposable = disposable;
                CompilerConfiguration configuration2 = JavaInteropCoordinator.access$getCompilerConfiguration(this$0);
                KotlinCoreEnvironment environment = KotlinCoreEnvironment.Companion.createForProduction(rootDisposable, configuration2, EnvironmentConfigFiles.JVM_CONFIG_FILES);
                Project project = environment.getProject();
                return PsiFileFactory.getInstance(project);
            }
        };
        this.javaFilesProcessor = !this.usePreciseJavaTracking ? new ChangedJavaFilesProcessor(this.reporter, arg_0 -> JavaInteropCoordinator.javaFilesProcessor$lambda$3(this, arg_0)) : null;
    }

    public final boolean hasChangedUntrackedJavaClasses() {
        return !((Collection)this.changedUntrackedJavaClasses).isEmpty();
    }

    private final CompilerConfiguration getCompilerConfiguration() {
        Lazy lazy = this.compilerConfiguration$delegate;
        return (CompilerConfiguration)lazy.getValue();
    }

    private final void processChangedUntrackedJavaClass(PsiClass psiClass, ClassId classId) {
        this.changedUntrackedJavaClasses.add(classId);
        for (PsiClass innerClass : psiClass.getInnerClasses()) {
            String name2;
            if (innerClass.getName() == null) continue;
            Intrinsics.checkNotNull(innerClass);
            Name name3 = Name.identifier(name2);
            Intrinsics.checkNotNullExpressionValue(name3, "identifier(...)");
            this.processChangedUntrackedJavaClass(innerClass, classId.createNestedClassId(name3));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final BuildAttribute processChangedJava(@NotNull ChangedFiles.DeterminableFiles.Known changedFiles, @NotNull IncrementalJvmCachesManager caches) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(changedFiles, "changedFiles");
        Intrinsics.checkNotNullParameter(caches, "caches");
        Iterable $this$filter$iv = CollectionsKt.plus((Collection)changedFiles.getModified(), (Iterable)changedFiles.getRemoved());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File p0 = (File)element$iv$iv;
            boolean bl = false;
            if (!FileUtilsKt.isJavaFile(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List javaFiles = (List)destination$iv$iv;
        for (File javaFile : javaFiles) {
            if (caches.getPlatformCache().isTrackedFile(javaFile)) continue;
            if (!javaFile.exists()) {
                ICReporterKt.info(this.reporter, () -> JavaInteropCoordinator.processChangedJava$lambda$4(javaFile));
                return BuildAttribute.JAVA_CHANGE_UNTRACKED_FILE_IS_REMOVED;
            }
            PsiFile psiFile = this.psiFileProvider.javaFile(javaFile);
            if (!(psiFile instanceof PsiJavaFile)) {
                ICReporterKt.info(this.reporter, () -> JavaInteropCoordinator.processChangedJava$lambda$5(psiFile));
                return BuildAttribute.JAVA_CHANGE_UNEXPECTED_PSI;
            }
            for (PsiClass psiClass : ((PsiJavaFile)psiFile).getClasses()) {
                String qualifiedName = psiClass.getQualifiedName();
                if (qualifiedName == null) {
                    ICReporterKt.info(this.reporter, () -> JavaInteropCoordinator.processChangedJava$lambda$6(javaFile));
                    return BuildAttribute.JAVA_CHANGE_UNKNOWN_QUALIFIER;
                }
                Intrinsics.checkNotNull(psiClass);
                this.processChangedUntrackedJavaClass(psiClass, ClassId.Companion.topLevel(new FqName(qualifiedName)));
            }
        }
        caches.getPlatformCache().markDirty((Collection)javaFiles);
        return null;
    }

    @NotNull
    public final Iterable<LookupSymbol> getAdditionalDirtyLookupSymbols() {
        Object object = this.javaFilesProcessor;
        return object != null && (object = ((ChangedJavaFilesProcessor)object).getAllChangedSymbols()) != null ? (Iterable)object : (Iterable)CollectionsKt.emptyList();
    }

    @Nullable
    public final JavaClassesTracker makeJavaClassesTracker(@NotNull IncrementalJvmCache platformCache) {
        Intrinsics.checkNotNullParameter(platformCache, "platformCache");
        if (!this.usePreciseJavaTracking) {
            return null;
        }
        JavaClassesTrackerImpl changesTracker = new JavaClassesTrackerImpl(platformCache, CollectionsKt.toSet((Iterable)this.changedUntrackedJavaClasses), CommonConfigurationKeysKt.getLanguageVersionSettings(this.getCompilerConfiguration()));
        this.changedUntrackedJavaClasses.clear();
        return changesTracker;
    }

    @Nullable
    public final IncrementalCompilerRunner.CompilationMode.Rebuild analyzeChangesInJavaSources(@NotNull IncrementalJvmCachesManager caches, @NotNull ChangedFiles.DeterminableFiles.Known changedFiles, @NotNull DirtyFilesContainer mutableDirtyFiles) {
        Intrinsics.checkNotNullParameter(caches, "caches");
        Intrinsics.checkNotNullParameter(changedFiles, "changedFiles");
        Intrinsics.checkNotNullParameter(mutableDirtyFiles, "mutableDirtyFiles");
        if (!this.usePreciseJavaTracking) {
            ChangesEither javaFilesChanges;
            ChangedJavaFilesProcessor changedJavaFilesProcessor = this.javaFilesProcessor;
            Intrinsics.checkNotNull(changedJavaFilesProcessor);
            ChangesEither changesEither = javaFilesChanges = changedJavaFilesProcessor.process(changedFiles);
            if (!(changesEither instanceof ChangesEither.Known)) {
                if (changesEither instanceof ChangesEither.Unknown) {
                    return new IncrementalCompilerRunner.CompilationMode.Rebuild(((ChangesEither.Unknown)javaFilesChanges).getReason());
                }
                throw new NoWhenBranchMatchedException();
            }
            Collection<LookupSymbol> affectedJavaSymbols = ((ChangesEither.Known)javaFilesChanges).getLookupSymbols();
            mutableDirtyFiles.addByDirtySymbols(affectedJavaSymbols);
        } else {
            BuildAttribute rebuildReason = this.processChangedJava(changedFiles, caches);
            if (rebuildReason != null) {
                return new IncrementalCompilerRunner.CompilationMode.Rebuild(rebuildReason);
            }
        }
        return null;
    }

    private static final boolean compilerConfiguration_delegate$lambda$2$lambda$0(CompilerMessageSeverity it) {
        return !it.isError();
    }

    private static final CompilerConfiguration compilerConfiguration_delegate$lambda$2(MessageCollector $messageCollector) {
        CompilerConfiguration compilerConfiguration;
        FilteringMessageCollector filterMessageCollector = new FilteringMessageCollector($messageCollector, JavaInteropCoordinator::compilerConfiguration_delegate$lambda$2$lambda$0);
        CompilerConfiguration $this$compilerConfiguration_delegate_u24lambda_u242_u24lambda_u241 = compilerConfiguration = new CompilerConfiguration();
        boolean bl = false;
        CommonConfigurationKeysKt.setMessageCollector($this$compilerConfiguration_delegate_u24lambda_u242_u24lambda_u241, filterMessageCollector);
        JvmContentRootsKt.configureJdkClasspathRoots($this$compilerConfiguration_delegate_u24lambda_u242_u24lambda_u241);
        return compilerConfiguration;
    }

    private static final PsiFile javaFilesProcessor$lambda$3(JavaInteropCoordinator this$0, File it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.psiFileProvider.javaFile(it);
    }

    private static final String processChangedJava$lambda$4(File $javaFile) {
        return "Could not get changed for untracked removed java file " + $javaFile;
    }

    private static final String processChangedJava$lambda$5(PsiFile $psiFile) {
        PsiFile psiFile = $psiFile;
        return "[Precise Java tracking] Expected PsiJavaFile, got " + (psiFile != null ? psiFile.getClass() : null);
    }

    private static final String processChangedJava$lambda$6(File $javaFile) {
        return "[Precise Java tracking] Class with unknown qualified name in " + $javaFile;
    }

    public static final /* synthetic */ CompilerConfiguration access$getCompilerConfiguration(JavaInteropCoordinator $this) {
        return $this.getCompilerConfiguration();
    }
}

