/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrPossiblyExternalDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.js.config.RuntimeDiagnostic;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/BooleanPropertyInExternalLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "ExternalBooleanPropertyProcessor", "backend.js"})
public final class BooleanPropertyInExternalLowering
implements BodyLoweringPass {
    @NotNull
    private final JsIrBackendContext context;

    public BooleanPropertyInExternalLowering(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter(irBody, "irBody");
        Intrinsics.checkNotNullParameter(container, "container");
        if (!this.context.getSafeExternalBoolean() && this.context.getSafeExternalBooleanDiagnostic() == null) {
            return;
        }
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, new ExternalBooleanPropertyProcessor(this.context));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/BooleanPropertyInExternalLowering$ExternalBooleanPropertyProcessor;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "safeExternalBoolean", "", "getSafeExternalBoolean", "()Z", "safeExternalBooleanDiagnostic", "Lorg/jetbrains/kotlin/js/config/RuntimeDiagnostic;", "getSafeExternalBooleanDiagnostic", "()Lorg/jetbrains/kotlin/js/config/RuntimeDiagnostic;", "booleanType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getBooleanType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "diagnosticMethod", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "backend.js"})
    @SourceDebugExtension(value={"SMAP\nBooleanPropertyInExternalLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BooleanPropertyInExternalLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/BooleanPropertyInExternalLowering$ExternalBooleanPropertyProcessor\n+ 2 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 3 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n*L\n1#1,112:1\n388#2,13:113\n134#3,2:126\n*S KotlinDebug\n*F\n+ 1 BooleanPropertyInExternalLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/BooleanPropertyInExternalLowering$ExternalBooleanPropertyProcessor\n*L\n81#1:113,13\n81#1:126,2\n*E\n"})
    private static final class ExternalBooleanPropertyProcessor
    extends IrElementTransformerVoid {
        @NotNull
        private final JsIrBackendContext context;

        public ExternalBooleanPropertyProcessor(@NotNull JsIrBackendContext context2) {
            Intrinsics.checkNotNullParameter(context2, "context");
            this.context = context2;
        }

        private final boolean getSafeExternalBoolean() {
            return this.context.getSafeExternalBoolean();
        }

        private final RuntimeDiagnostic getSafeExternalBooleanDiagnostic() {
            return this.context.getSafeExternalBooleanDiagnostic();
        }

        private final IrType getBooleanType() {
            return this.context.getIrBuiltIns().getBooleanType();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public IrExpression visitCall(@NotNull IrCall expression2) {
            IrDeclarationReference irDeclarationReference;
            IrCall irCall;
            void this_$iv$iv;
            IrSimpleFunctionSymbol function2;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
            IrSimpleFunctionSymbol symbol = expression2.getSymbol();
            IrSimpleFunction callee = (IrSimpleFunction)symbol.getOwner();
            Object object = callee.getCorrespondingPropertySymbol();
            if (object == null || (object = (IrProperty)object.getOwner()) == null) {
                return expression2;
            }
            Object property2 = object;
            if (!IrUtilsKt.isEffectivelyExternal((IrPossiblyExternalDeclaration)property2)) {
                return expression2;
            }
            if (!Intrinsics.areEqual(callee, ((IrProperty)property2).getGetter())) {
                return expression2;
            }
            if (!Intrinsics.areEqual(callee.getReturnType(), this.getBooleanType())) {
                return expression2;
            }
            RuntimeDiagnostic runtimeDiagnostic = this.getSafeExternalBooleanDiagnostic();
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = function2 = runtimeDiagnostic != null ? this.diagnosticMethod(runtimeDiagnostic) : null;
            if (!this.getSafeExternalBoolean() && function2 == null) {
                return expression2;
            }
            if (this.getSafeExternalBoolean() && function2 == null) {
                IrCall irCall2;
                IrCall $this$visitCall_u24lambda_u240 = irCall2 = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.context.getIntrinsics().getJsNativeBoolean(), null, null, null, null, 0, 0, 126, null);
                boolean bl = false;
                $this$visitCall_u24lambda_u240.putValueArgument(0, expression2);
                return irCall2;
            }
            IrBuilderWithScope $this$irBlock_u24default$iv = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)symbol, 0, 0, 6, null);
            int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
            IrStatementOrigin origin$iv = null;
            IrType resultType$iv = null;
            boolean $i$f$irBlock = false;
            IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
            boolean $i$f$block = false;
            void $this$visitCall_u24lambda_u243 = this_$iv$iv;
            boolean bl = false;
            IrVariable tmp = IrBuilderKt.createTmpVariable$default((IrStatementsBuilder)$this$visitCall_u24lambda_u243, (IrExpression)expression2, null, false, null, null, 30, null);
            IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = function2;
            Intrinsics.checkNotNull(irSimpleFunctionSymbol2);
            IrCall $this$visitCall_u24lambda_u243_u24lambda_u241 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, irSimpleFunctionSymbol2, null, null, null, null, 0, 0, 126, null);
            boolean bl2 = false;
            FqName fqName = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)property2);
            $this$visitCall_u24lambda_u243_u24lambda_u241.putValueArgument(0, IrUtilsKt.toIrConst$default(fqName != null ? fqName.asString() : null, $this$visitCall_u24lambda_u243.getContext().getIrBuiltIns().getStringType(), 0, 0, 6, null));
            $this$visitCall_u24lambda_u243_u24lambda_u241.putValueArgument(1, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$visitCall_u24lambda_u243, tmp));
            IrCall call2 = irCall;
            $this$visitCall_u24lambda_u243.unaryPlus(call2);
            if (this.getSafeExternalBoolean()) {
                IrCall irCall3;
                IrCall $this$visitCall_u24lambda_u243_u24lambda_u242 = irCall3 = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.context.getIntrinsics().getJsNativeBoolean(), null, null, null, null, 0, 0, 126, null);
                boolean bl3 = false;
                $this$visitCall_u24lambda_u243_u24lambda_u242.putValueArgument(0, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$visitCall_u24lambda_u243, tmp));
                irDeclarationReference = irCall3;
            } else {
                irDeclarationReference = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$visitCall_u24lambda_u243, tmp);
            }
            IrDeclarationReference newBooleanGet = irDeclarationReference;
            $this$visitCall_u24lambda_u243.unaryPlus(newBooleanGet);
            return (IrExpression)this_$iv$iv.doBuild();
        }

        private final IrSimpleFunctionSymbol diagnosticMethod(RuntimeDiagnostic $this$diagnosticMethod) {
            IrSimpleFunctionSymbol irSimpleFunctionSymbol;
            switch (WhenMappings.$EnumSwitchMapping$0[$this$diagnosticMethod.ordinal()]) {
                case 1: {
                    irSimpleFunctionSymbol = this.context.getIntrinsics().getJsBooleanInExternalLog();
                    break;
                }
                case 2: {
                    irSimpleFunctionSymbol = this.context.getIntrinsics().getJsBooleanInExternalException();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return irSimpleFunctionSymbol;
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[RuntimeDiagnostic.values().length];
                try {
                    nArray[RuntimeDiagnostic.LOG.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[RuntimeDiagnostic.EXCEPTION.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

