/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.Deque;
import java.util.LinkedList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTable;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.symbols.IrReturnTargetSymbol;
import org.jetbrains.kotlin.ir.symbols.IrReturnableBlockSymbol;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\nH\u0016J\u0018\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020\nH\u0002J\u0018\u0010(\u001a\u00020\u00132\u0006\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020\rH\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/LocalNameGenerator;", "Lorg/jetbrains/kotlin/ir/visitors/IrVisitorVoid;", "variableNames", "Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTable;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTable;)V", "getVariableNames", "()Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTable;", "localLoopNames", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "getLocalLoopNames", "localReturnableBlockNames", "Lorg/jetbrains/kotlin/ir/expressions/IrReturnableBlock;", "getLocalReturnableBlockNames", "jumpableDeque", "Ljava/util/Deque;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "visitElement", "", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitDeclaration", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "visitBreak", "jump", "Lorg/jetbrains/kotlin/ir/expressions/IrBreak;", "visitContinue", "Lorg/jetbrains/kotlin/ir/expressions/IrContinue;", "visitReturn", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "visitWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "visitLoop", "loop", "persistLoopName", "label", "", "persistReturnableBlockName", "backend.js"})
public final class LocalNameGenerator
extends IrVisitorVoid {
    @NotNull
    private final NameTable<IrDeclaration> variableNames;
    @NotNull
    private final NameTable<IrLoop> localLoopNames;
    @NotNull
    private final NameTable<IrReturnableBlock> localReturnableBlockNames;
    @NotNull
    private final Deque<IrExpression> jumpableDeque;

    public LocalNameGenerator(@NotNull NameTable<IrDeclaration> variableNames) {
        Intrinsics.checkNotNullParameter(variableNames, "variableNames");
        this.variableNames = variableNames;
        this.localLoopNames = new NameTable(null, null, 3, null);
        this.localReturnableBlockNames = new NameTable(null, null, 3, null);
        this.jumpableDeque = new LinkedList();
    }

    @NotNull
    public final NameTable<IrDeclaration> getVariableNames() {
        return this.variableNames;
    }

    @NotNull
    public final NameTable<IrLoop> getLocalLoopNames() {
        return this.localLoopNames;
    }

    @NotNull
    public final NameTable<IrReturnableBlock> getLocalReturnableBlockNames() {
        return this.localReturnableBlockNames;
    }

    @Override
    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        IrVisitorsKt.acceptChildrenVoid(element, this);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclarationBase declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        super.visitDeclaration(declaration);
        if (declaration instanceof IrDeclarationWithName) {
            String string2 = ((IrDeclarationWithName)((Object)declaration)).getName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
            this.variableNames.declareFreshName(declaration, string2);
        }
    }

    @Override
    public void visitBreak(@NotNull IrBreak jump) {
        Intrinsics.checkNotNullParameter(jump, "jump");
        IrLoop loop = jump.getLoop();
        if (loop.getLabel() == null && !Intrinsics.areEqual(loop, CollectionsKt.firstOrNull((Iterable)this.jumpableDeque))) {
            this.persistLoopName("$l$loop", loop);
        }
        super.visitBreak(jump);
    }

    @Override
    public void visitContinue(@NotNull IrContinue jump) {
        Intrinsics.checkNotNullParameter(jump, "jump");
        IrLoop loop = jump.getLoop();
        if (loop.getLabel() == null && !Intrinsics.areEqual(loop, CollectionsKt.firstOrNull((Iterable)this.jumpableDeque))) {
            this.persistLoopName("$l$loop", loop);
        }
        super.visitContinue(jump);
    }

    @Override
    public void visitReturn(@NotNull IrReturn expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrReturnTargetSymbol targetSymbol = expression2.getReturnTargetSymbol();
        if (targetSymbol instanceof IrReturnableBlockSymbol && !IrJsUtilsKt.isTheLastReturnStatementIn(expression2, (IrReturnableBlockSymbol)targetSymbol)) {
            this.persistReturnableBlockName("$l$block", (IrReturnableBlock)((IrReturnableBlockSymbol)targetSymbol).getOwner());
        }
        super.visitReturn(expression2);
    }

    @Override
    public void visitWhen(@NotNull IrWhen expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        this.jumpableDeque.push(expression2);
        super.visitWhen(expression2);
        this.jumpableDeque.pop();
    }

    @Override
    public void visitLoop(@NotNull IrLoop loop) {
        Intrinsics.checkNotNullParameter(loop, "loop");
        this.jumpableDeque.push(loop);
        super.visitLoop(loop);
        this.jumpableDeque.pop();
        String label = loop.getLabel();
        if (label != null) {
            this.persistLoopName(label, loop);
        }
    }

    private final void persistLoopName(String label, IrLoop loop) {
        this.localLoopNames.declareFreshName(loop, label);
    }

    private final void persistReturnableBlockName(String label, IrReturnableBlock loop) {
        this.localReturnableBlockNames.declareFreshName(loop, label);
    }
}

