/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter;

import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.interpreter.CallInterceptor;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.exceptions.ExceptionUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.proxy.ProxyKt;
import org.jetbrains.kotlin.ir.interpreter.stack.CallStack;
import org.jetbrains.kotlin.ir.interpreter.state.Common;
import org.jetbrains.kotlin.ir.interpreter.state.Primitive;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.StateKt;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.SimpleTypeNullability;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeBuilder;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImplKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.ReferencedSymbolRemapper;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u00f0\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0000\u001a\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0000\u001a\u0014\u0010\u0013\u001a\u00020\u0014*\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0001\u001a\u0012\u0010\u0017\u001a\u00020\u0018*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0001\u001a\u000e\u0010\u0019\u001a\u0004\u0018\u00010\t*\u00020\u0015H\u0000\u001a \u0010\u001a\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u0014H\u0000\u001a\n\u0010\u001f\u001a\u00020 *\u00020 \u001a\n\u0010!\u001a\u00020 *\u00020 \u001a\u001c\u0010\"\u001a\u00020\u0011*\n\u0012\u0006\u0012\u0004\u0018\u00010$0#2\u0006\u0010%\u001a\u00020\u001dH\u0000\u001a\u0014\u0010&\u001a\u0004\u0018\u00010\u001d*\u00020\u000f2\u0006\u0010'\u001a\u00020(\u001a\f\u0010)\u001a\u00020\t*\u00020 H\u0000\u001a\f\u0010*\u001a\u00020\u0014*\u00020+H\u0000\u001a\f\u0010,\u001a\u00020\u0014*\u00020\u001dH\u0000\u001a\f\u0010-\u001a\u00020\u0014*\u00020\u001dH\u0000\u001a\f\u0010.\u001a\u00020\t*\u00020+H\u0000\u001a\u0016\u0010/\u001a\u00020\u0014*\u0004\u0018\u00010 2\u0006\u00100\u001a\u000201H\u0000\u001a2\u00102\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010$0#*\u00020 2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\f\u00107\u001a\b\u0012\u0004\u0012\u0002080#H\u0000\u001a\f\u00109\u001a\u00020\t*\u00020\u001dH\u0000\u001a\f\u0010:\u001a\u00020\t*\u00020\u001dH\u0000\u001a\f\u0010;\u001a\u00020\u0014*\u00020<H\u0000\u001a\u0014\u0010=\u001a\u00020>*\u00020+2\u0006\u0010?\u001a\u00020\tH\u0000\u001a\f\u0010@\u001a\u00020 *\u00020\u000fH\u0000\u001a&\u0010A\u001a\u0004\u0018\u00010B*\u00020C2\u0006\u0010D\u001a\u00020 2\u000e\u0010E\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010F0#H\u0000\u001a\u0014\u0010G\u001a\u00020\u001d*\u00020\u001d2\u0006\u0010H\u001a\u00020IH\u0000\u001a \u0010G\u001a\u00020\u001d*\u00020\u001d2\u0012\u0010J\u001a\u000e\u0012\u0004\u0012\u00020L\u0012\u0004\u0012\u00020\u001d0KH\u0000\u001a \u0010M\u001a\u000e\u0012\u0004\u0012\u00020O\u0012\u0004\u0012\u00020P0N*\u0002012\u0006\u0010Q\u001a\u00020\u000fH\u0000\u001a\f\u0010R\u001a\u00020\u0014*\u00020 H\u0000\u001a\f\u0010S\u001a\u00020 *\u00020+H\u0000\u001a\u000e\u0010T\u001a\u00020\u0014*\u0004\u0018\u00010BH\u0000\u001a\f\u0010U\u001a\u00020\u0014*\u00020 H\u0000\u001a\f\u0010V\u001a\u00020\t*\u000208H\u0000\u001a\u0014\u0010W\u001a\u00020X*\u00020Y2\u0006\u0010Z\u001a\u00020[H\u0000\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\"\u0018\u0010\b\u001a\u00020\t*\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u001a\u0010\\\u001a\u0004\u0018\u00010>*\u00020 8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b]\u0010^\"\u001a\u0010\\\u001a\u0004\u0018\u00010>*\u00020_8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b]\u0010`\"\u001a\u0010a\u001a\u0004\u0018\u00010>*\u00020b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bc\u0010d\"\u001a\u0010e\u001a\u00020\u0014*\u0004\u0018\u00010>8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\be\u0010f\u00a8\u0006g"}, d2={"intrinsicConstEvaluationAnnotation", "Lorg/jetbrains/kotlin/name/FqName;", "getIntrinsicConstEvaluationAnnotation", "()Lorg/jetbrains/kotlin/name/FqName;", "compileTimeAnnotation", "getCompileTimeAnnotation", "evaluateIntrinsicAnnotation", "getEvaluateIntrinsicAnnotation", "fqName", "", "Lorg/jetbrains/kotlin/ir/IrElement;", "getFqName", "(Lorg/jetbrains/kotlin/ir/IrElement;)Ljava/lang/String;", "getThisReceiver", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "toPrimitive", "Lorg/jetbrains/kotlin/ir/interpreter/state/Primitive;", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "hasAnnotation", "", "Lorg/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;", "annotation", "getAnnotation", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "getEvaluateIntrinsicValue", "getPrimitiveClass", "Ljava/lang/Class;", "irType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "asObject", "getFirstNonInterfaceOverridden", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getLastOverridden", "toPrimitiveStateArray", "", "", "type", "getVarargType", "index", "", "getCapitalizedFileName", "isSubclassOfThrowable", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "isUnsignedArray", "isPrimitiveArray", "internalName", "checkCast", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "getArgsForMethodInvocation", "callInterceptor", "Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "methodType", "Ljava/lang/invoke/MethodType;", "args", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "fqNameWithNullability", "getOnlyName", "accessesTopLevelOrObjectField", "Lorg/jetbrains/kotlin/ir/expressions/IrFieldAccessExpression;", "getOriginalPropertyByName", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "name", "getFunctionThatContainsDefaults", "getDefaultWithActualParameters", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "newParent", "actualParameters", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "getTypeIfReified", "callStack", "Lorg/jetbrains/kotlin/ir/interpreter/stack/CallStack;", "getType", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "loadReifiedTypeArguments", "", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/KTypeState;", "expression", "hasFunInterfaceParent", "getSingleAbstractMethod", "isAccessToNotNullableObject", "isAccessorOfPropertyWithBackingField", "unsignedToString", "toState", "Lorg/jetbrains/kotlin/ir/interpreter/state/Common;", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "property", "getProperty", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "(Lorg/jetbrains/kotlin/ir/declarations/IrField;)Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "correspondingProperty", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "getCorrespondingProperty", "(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "isConst", "(Lorg/jetbrains/kotlin/ir/declarations/IrProperty;)Z", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\norg/jetbrains/kotlin/ir/interpreter/UtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 IrSimpleTypeImpl.kt\norg/jetbrains/kotlin/ir/types/impl/IrSimpleTypeImplKt\n+ 7 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt\n+ 8 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt$deepCopyWithSymbols$1\n*L\n1#1,356:1\n1761#2,3:357\n295#2,2:360\n230#2,2:362\n230#2,2:388\n1563#2:408\n1634#2,3:409\n774#2:413\n865#2,2:414\n1563#2:416\n1634#2,3:417\n808#2,11:420\n626#2,12:431\n808#2,11:443\n808#2,11:454\n1869#2,2:465\n1563#2:467\n1634#2,3:468\n1563#2:471\n1634#2,3:472\n1617#2,9:475\n1869#2:484\n1870#2:486\n1626#2:487\n669#2,11:488\n1563#2:499\n1634#2,3:500\n127#3,2:364\n1255#3,2:372\n1321#3,2:374\n350#3,12:376\n37#4:366\n36#4,3:367\n1#5:370\n1#5:485\n169#6:371\n169#6:412\n17#7,16:390\n33#7:407\n19#8:406\n*S KotlinDebug\n*F\n+ 1 Utils.kt\norg/jetbrains/kotlin/ir/interpreter/UtilsKt\n*L\n56#1:357,3\n62#1:360,2\n63#1:362,2\n241#1:388,2\n276#1:408\n276#1:409,3\n288#1:413\n288#1:414,2\n288#1:416\n288#1:417,3\n299#1:420,11\n299#1:431,12\n330#1:443,11\n338#1:454,11\n338#1:465,2\n92#1:467\n92#1:468,3\n103#1:471\n103#1:472,3\n137#1:475,9\n137#1:484\n137#1:486\n137#1:487\n137#1:488,11\n236#1:499\n236#1:500,3\n93#1:364,2\n138#1:372,2\n154#1:374,2\n225#1:376,12\n116#1:366\n116#1:367,3\n137#1:485\n124#1:371\n282#1:412\n260#1:390,16\n260#1:407\n260#1:406\n*E\n"})
public final class UtilsKt {
    @NotNull
    private static final FqName intrinsicConstEvaluationAnnotation = new FqName("kotlin.internal.IntrinsicConstEvaluation");
    @NotNull
    private static final FqName compileTimeAnnotation = new FqName("kotlin.CompileTimeCalculation");
    @NotNull
    private static final FqName evaluateIntrinsicAnnotation = new FqName("kotlin.EvaluateIntrinsic");

    @NotNull
    public static final FqName getIntrinsicConstEvaluationAnnotation() {
        return intrinsicConstEvaluationAnnotation;
    }

    @NotNull
    public static final FqName getCompileTimeAnnotation() {
        return compileTimeAnnotation;
    }

    @NotNull
    public static final FqName getEvaluateIntrinsicAnnotation() {
        return evaluateIntrinsicAnnotation;
    }

    @NotNull
    public static final String getFqName(@NotNull IrElement $this$fqName) {
        Intrinsics.checkNotNullParameter($this$fqName, "<this>");
        Object object = $this$fqName instanceof IrDeclarationWithName ? (IrDeclarationWithName)$this$fqName : null;
        if (object == null || (object = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)object)) == null || (object = ((FqName)object).asString()) == null) {
            object = "";
        }
        return object;
    }

    @NotNull
    public static final IrValueSymbol getThisReceiver(@NotNull IrFunctionAccessExpression $this$getThisReceiver) {
        Intrinsics.checkNotNullParameter($this$getThisReceiver, "<this>");
        IrValueParameter irValueParameter = IrUtilsKt.getParentAsClass(((IrFunctionSymbol)$this$getThisReceiver.getSymbol()).getOwner()).getThisReceiver();
        Intrinsics.checkNotNull(irValueParameter);
        return irValueParameter.getSymbol();
    }

    @NotNull
    public static final Primitive toPrimitive(@NotNull IrConst $this$toPrimitive) {
        Primitive primitive;
        Intrinsics.checkNotNullParameter($this$toPrimitive, "<this>");
        if (IrTypePredicatesKt.isByte($this$toPrimitive.getType())) {
            Object object = $this$toPrimitive.getValue();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Number");
            primitive = new Primitive(((Number)object).byteValue(), $this$toPrimitive.getType());
        } else if (IrTypePredicatesKt.isShort($this$toPrimitive.getType())) {
            Object object = $this$toPrimitive.getValue();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Number");
            primitive = new Primitive(((Number)object).shortValue(), $this$toPrimitive.getType());
        } else {
            primitive = new Primitive($this$toPrimitive.getValue(), $this$toPrimitive.getType());
        }
        return primitive;
    }

    public static final boolean hasAnnotation(@Nullable IrAnnotationContainer $this$hasAnnotation, @NotNull FqName annotation) {
        Intrinsics.checkNotNullParameter(annotation, "annotation");
        if ($this$hasAnnotation == null) {
            return false;
        }
        if (!((Collection)$this$hasAnnotation.getAnnotations()).isEmpty()) {
            boolean bl;
            block5: {
                Iterable $this$any$iv = $this$hasAnnotation.getAnnotations();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        IrConstructorCall it = (IrConstructorCall)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(IrUtilsKt.getFqNameWhenAvailable(IrUtilsKt.getParentAsClass((IrDeclaration)it.getSymbol().getOwner())), annotation)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        return false;
    }

    @NotNull
    public static final IrConstructorCall getAnnotation(@NotNull IrAnnotationContainer $this$getAnnotation, @NotNull FqName annotation) {
        IrConstructorCall irConstructorCall;
        Object v0;
        IrConstructorCall it;
        block3: {
            Intrinsics.checkNotNullParameter($this$getAnnotation, "<this>");
            Intrinsics.checkNotNullParameter(annotation, "annotation");
            Iterable $this$firstOrNull$iv = $this$getAnnotation.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv2 : $this$firstOrNull$iv) {
                it = (IrConstructorCall)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual(IrUtilsKt.getFqNameWhenAvailable(IrUtilsKt.getParentAsClass((IrDeclaration)it.getSymbol().getOwner())), annotation)) continue;
                v0 = element$iv2;
                break block3;
            }
            v0 = null;
        }
        if ((irConstructorCall = (IrConstructorCall)v0) == null) {
            Object element$iv2;
            block4: {
                IrDeclarationParent irDeclarationParent = ((IrFunction)$this$getAnnotation).getParent();
                Intrinsics.checkNotNull(irDeclarationParent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                Iterable $this$first$iv = ((IrClass)irDeclarationParent).getAnnotations();
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    it = (IrConstructorCall)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(IrUtilsKt.getFqNameWhenAvailable(IrUtilsKt.getParentAsClass((IrDeclaration)it.getSymbol().getOwner())), annotation)) continue;
                    break block4;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            irConstructorCall = (IrConstructorCall)element$iv2;
        }
        return irConstructorCall;
    }

    @Nullable
    public static final String getEvaluateIntrinsicValue(@NotNull IrAnnotationContainer $this$getEvaluateIntrinsicValue) {
        Intrinsics.checkNotNullParameter($this$getEvaluateIntrinsicValue, "<this>");
        if ($this$getEvaluateIntrinsicValue instanceof IrClass && StringsKt.startsWith$default(UtilsKt.getFqName((IrElement)((Object)$this$getEvaluateIntrinsicValue)), "java", false, 2, null)) {
            return UtilsKt.getFqName((IrElement)((Object)$this$getEvaluateIntrinsicValue));
        }
        if (!UtilsKt.hasAnnotation($this$getEvaluateIntrinsicValue, evaluateIntrinsicAnnotation)) {
            return null;
        }
        Object e2 = UtilsKt.getAnnotation($this$getEvaluateIntrinsicValue, evaluateIntrinsicAnnotation).getArguments().get(0);
        Intrinsics.checkNotNull(e2, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConst");
        return String.valueOf(((IrConst)e2).getValue());
    }

    @Nullable
    public static final Class<?> getPrimitiveClass(@NotNull IrType irType, boolean asObject) {
        Class clazz;
        Intrinsics.checkNotNullParameter(irType, "irType");
        PrimitiveType primitiveType = IrTypePredicatesKt.getPrimitiveType(irType);
        switch (primitiveType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[primitiveType.ordinal()]) {
            case 1: {
                if (asObject) {
                    clazz = Boolean.class;
                    break;
                }
                clazz = Boolean.TYPE;
                break;
            }
            case 2: {
                if (asObject) {
                    clazz = Character.class;
                    break;
                }
                clazz = Character.TYPE;
                break;
            }
            case 3: {
                if (asObject) {
                    clazz = Byte.class;
                    break;
                }
                clazz = Byte.TYPE;
                break;
            }
            case 4: {
                if (asObject) {
                    clazz = Short.class;
                    break;
                }
                clazz = Short.TYPE;
                break;
            }
            case 5: {
                if (asObject) {
                    clazz = Integer.class;
                    break;
                }
                clazz = Integer.TYPE;
                break;
            }
            case 6: {
                if (asObject) {
                    clazz = Float.class;
                    break;
                }
                clazz = Float.TYPE;
                break;
            }
            case 7: {
                if (asObject) {
                    clazz = Long.class;
                    break;
                }
                clazz = Long.TYPE;
                break;
            }
            case 8: {
                if (asObject) {
                    clazz = Double.class;
                    break;
                }
                clazz = Double.TYPE;
                break;
            }
            default: {
                clazz = IrTypePredicatesKt.isString(irType) ? String.class : null;
            }
        }
        return clazz;
    }

    public static /* synthetic */ Class getPrimitiveClass$default(IrType irType, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return UtilsKt.getPrimitiveClass(irType, bl);
    }

    @NotNull
    public static final IrFunction getFirstNonInterfaceOverridden(@NotNull IrFunction $this$getFirstNonInterfaceOverridden) {
        Object element$iv;
        block4: {
            Intrinsics.checkNotNullParameter($this$getFirstNonInterfaceOverridden, "<this>");
            if (!($this$getFirstNonInterfaceOverridden instanceof IrSimpleFunction)) {
                return $this$getFirstNonInterfaceOverridden;
            }
            Sequence $this$first$iv = SequencesKt.flattenSequenceOfIterable(SequencesKt.generateSequence(CollectionsKt.listOf($this$getFirstNonInterfaceOverridden), UtilsKt::getFirstNonInterfaceOverridden$lambda$4));
            boolean $i$f$first = false;
            Iterator iterator2 = $this$first$iv.iterator();
            while (iterator2.hasNext()) {
                boolean bl;
                element$iv = iterator2.next();
                IrSimpleFunction overriddenFunction = (IrSimpleFunction)element$iv;
                boolean bl2 = false;
                if (overriddenFunction.isFakeOverride()) {
                    bl = false;
                } else {
                    IrClass irClass = IrUtilsKt.getParentClassOrNull(overriddenFunction);
                    ClassKind kind = irClass != null ? irClass.getKind() : null;
                    bl = kind != ClassKind.INTERFACE;
                }
                if (!bl) continue;
                break block4;
            }
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        return (IrFunction)element$iv;
    }

    @NotNull
    public static final IrFunction getLastOverridden(@NotNull IrFunction $this$getLastOverridden) {
        Intrinsics.checkNotNullParameter($this$getLastOverridden, "<this>");
        if (!($this$getLastOverridden instanceof IrSimpleFunction)) {
            return $this$getLastOverridden;
        }
        return (IrFunction)SequencesKt.last(SequencesKt.flattenSequenceOfIterable(SequencesKt.generateSequence(CollectionsKt.listOf($this$getLastOverridden), UtilsKt::getLastOverridden$lambda$7)));
    }

    @NotNull
    public static final Primitive toPrimitiveStateArray(@NotNull List<? extends Object> $this$toPrimitiveStateArray, @NotNull IrType type2) {
        Primitive primitive;
        Intrinsics.checkNotNullParameter($this$toPrimitiveStateArray, "<this>");
        Intrinsics.checkNotNullParameter(type2, "type");
        if (IrTypePredicatesKt.isByteArray(type2)) {
            int n2 = 0;
            int n3 = $this$toPrimitiveStateArray.size();
            byte[] byArray = new byte[n3];
            while (n2 < n3) {
                int n4 = n2++;
                Object object = $this$toPrimitiveStateArray.get(n4);
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Number");
                byArray[n4] = ((Number)object).byteValue();
            }
            IrType irType = type2;
            byte[] byArray2 = byArray;
            primitive = new Primitive(byArray2, irType);
        } else if (IrTypePredicatesKt.isCharArray(type2)) {
            int n5 = 0;
            int n6 = $this$toPrimitiveStateArray.size();
            char[] cArray = new char[n6];
            while (n5 < n6) {
                int n7 = n5++;
                Object object = $this$toPrimitiveStateArray.get(n7);
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Char");
                cArray[n7] = ((Character)object).charValue();
            }
            IrType irType = type2;
            char[] cArray2 = cArray;
            primitive = new Primitive(cArray2, irType);
        } else if (IrTypePredicatesKt.isShortArray(type2)) {
            int n8 = 0;
            int n9 = $this$toPrimitiveStateArray.size();
            short[] sArray = new short[n9];
            while (n8 < n9) {
                int n10 = n8++;
                Object object = $this$toPrimitiveStateArray.get(n10);
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Number");
                sArray[n10] = ((Number)object).shortValue();
            }
            IrType irType = type2;
            short[] sArray2 = sArray;
            primitive = new Primitive(sArray2, irType);
        } else if (IrTypePredicatesKt.isIntArray(type2)) {
            int n11 = 0;
            int n12 = $this$toPrimitiveStateArray.size();
            int[] nArray = new int[n12];
            while (n11 < n12) {
                int n13 = n11++;
                Object object = $this$toPrimitiveStateArray.get(n13);
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Number");
                nArray[n13] = ((Number)object).intValue();
            }
            IrType irType = type2;
            int[] nArray2 = nArray;
            primitive = new Primitive(nArray2, irType);
        } else if (IrTypePredicatesKt.isLongArray(type2)) {
            int n14 = 0;
            int n15 = $this$toPrimitiveStateArray.size();
            long[] lArray = new long[n15];
            while (n14 < n15) {
                int n16 = n14++;
                Object object = $this$toPrimitiveStateArray.get(n16);
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Number");
                lArray[n16] = ((Number)object).longValue();
            }
            IrType irType = type2;
            long[] lArray2 = lArray;
            primitive = new Primitive(lArray2, irType);
        } else if (IrTypePredicatesKt.isFloatArray(type2)) {
            int n17 = 0;
            int n18 = $this$toPrimitiveStateArray.size();
            float[] fArray = new float[n18];
            while (n17 < n18) {
                int n19 = n17++;
                Object object = $this$toPrimitiveStateArray.get(n19);
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Number");
                fArray[n19] = ((Number)object).floatValue();
            }
            IrType irType = type2;
            float[] fArray2 = fArray;
            primitive = new Primitive(fArray2, irType);
        } else if (IrTypePredicatesKt.isDoubleArray(type2)) {
            int n20 = 0;
            int n21 = $this$toPrimitiveStateArray.size();
            double[] dArray = new double[n21];
            while (n20 < n21) {
                int n22 = n20++;
                Object object = $this$toPrimitiveStateArray.get(n22);
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Number");
                dArray[n22] = ((Number)object).doubleValue();
            }
            IrType irType = type2;
            double[] dArray2 = dArray;
            primitive = new Primitive(dArray2, irType);
        } else if (IrTypePredicatesKt.isBooleanArray(type2)) {
            int n23 = 0;
            int n24 = $this$toPrimitiveStateArray.size();
            boolean[] blArray = new boolean[n24];
            while (n23 < n24) {
                int n25 = n23++;
                Object object = $this$toPrimitiveStateArray.get(n25);
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Boolean");
                blArray[n25] = (Boolean)object;
            }
            IrType irType = type2;
            boolean[] blArray2 = blArray;
            primitive = new Primitive(blArray2, irType);
        } else {
            Collection $this$toTypedArray$iv = $this$toPrimitiveStateArray;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Primitive primitive2 = new Primitive(thisCollection$iv.toArray(new Object[0]), type2);
            primitive = primitive2;
        }
        return primitive;
    }

    @Nullable
    public static final IrType getVarargType(@NotNull IrFunctionAccessExpression $this$getVarargType, int index) {
        IrSimpleTypeBuilder irSimpleTypeBuilder;
        IrSimpleType type2;
        Intrinsics.checkNotNullParameter($this$getVarargType, "<this>");
        IrType irType = ((IrFunctionSymbol)$this$getVarargType.getSymbol()).getOwner().getParameters().get(index).getVarargElementType();
        if (irType == null) {
            return null;
        }
        IrType varargType = irType;
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(varargType);
        if (irClassSymbol != null) {
            IrClassSymbol it = irClassSymbol;
            boolean bl = false;
            return ((IrFunctionSymbol)$this$getVarargType.getSymbol()).getOwner().getParameters().get(index).getType();
        }
        IrType it = ((IrFunctionSymbol)$this$getVarargType.getSymbol()).getOwner().getParameters().get(index).getType();
        IrSimpleType irSimpleType = it instanceof IrSimpleType ? (IrSimpleType)it : null;
        if (irSimpleType == null) {
            return null;
        }
        IrSimpleType $this$buildSimpleType$iv = type2 = irSimpleType;
        boolean $i$f$buildSimpleType = false;
        IrSimpleTypeBuilder $this$getVarargType_u24lambda_u249 = irSimpleTypeBuilder = IrSimpleTypeImplKt.toBuilder($this$buildSimpleType$iv);
        boolean bl = false;
        IrSymbolOwner irSymbolOwner = IrTypesKt.getClassifierOrFail(varargType).getOwner();
        Intrinsics.checkNotNull(irSymbolOwner, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrTypeParameter");
        IrTypeParameter typeParameter = (IrTypeParameter)irSymbolOwner;
        IrType irType2 = $this$getVarargType.getTypeArguments().get(typeParameter.getIndex());
        Intrinsics.checkNotNull(irType2);
        $this$getVarargType_u24lambda_u249.setArguments(CollectionsKt.listOf(IrSimpleTypeImplKt.makeTypeProjection(irType2, Variance.OUT_VARIANCE)));
        return IrSimpleTypeImplKt.buildSimpleType(irSimpleTypeBuilder);
    }

    @NotNull
    public static final String getCapitalizedFileName(@NotNull IrFunction $this$getCapitalizedFileName) {
        Intrinsics.checkNotNullParameter($this$getCapitalizedFileName, "<this>");
        Object object = IrUtilsKt.getFileOrNull($this$getCapitalizedFileName);
        if (object == null || (object = IrDeclarationsKt.getName((IrFile)object)) == null || (object = StringsKt.replace$default((String)object, ".kt", "Kt", false, 4, null)) == null || (object = CapitalizeDecapitalizeKt.capitalizeAsciiOnly((String)object)) == null) {
            object = "<UNKNOWN>";
        }
        return object;
    }

    public static final boolean isSubclassOfThrowable(@NotNull IrClass $this$isSubclassOfThrowable) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter($this$isSubclassOfThrowable, "<this>");
            Sequence<IrClass> $this$any$iv = SequencesKt.generateSequence($this$isSubclassOfThrowable, UtilsKt::isSubclassOfThrowable$lambda$12);
            boolean $i$f$any = false;
            Iterator<IrClass> iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                IrClass element$iv;
                IrClass it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!IrTypeUtilsKt.isThrowable(IrUtilsKt.getDefaultType(it))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public static final boolean isUnsignedArray(@NotNull IrType $this$isUnsignedArray) {
        Intrinsics.checkNotNullParameter($this$isUnsignedArray, "<this>");
        if (!($this$isUnsignedArray instanceof IrSimpleType) || !(((IrSimpleType)$this$isUnsignedArray).getClassifier() instanceof IrClassSymbol)) {
            return false;
        }
        String[] stringArray = new String[]{"kotlin.UByteArray", "kotlin.UShortArray", "kotlin.UIntArray", "kotlin.ULongArray"};
        return SetsKt.setOf(stringArray).contains(UtilsKt.getFqName(((IrSimpleType)$this$isUnsignedArray).getClassifier().getOwner()));
    }

    public static final boolean isPrimitiveArray(@NotNull IrType $this$isPrimitiveArray) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isPrimitiveArray, "<this>");
        Object object = IrTypesKt.getClass($this$isPrimitiveArray);
        if (object != null && (object = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)object)) != null && (object = ((FqName)object).toUnsafe()) != null) {
            Object it = object;
            boolean bl2 = false;
            bl = StandardNames.isPrimitiveArray((FqNameUnsafe)it);
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final String internalName(@NotNull IrClass $this$internalName) {
        Intrinsics.checkNotNullParameter($this$internalName, "<this>");
        StringBuilder internalName = new StringBuilder($this$internalName.getName().asString());
        Sequence<IrDeclarationParent> $this$forEach$iv = SequencesKt.drop(SequencesKt.generateSequence($this$internalName instanceof IrDeclarationParent ? (IrDeclarationParent)$this$internalName : null, UtilsKt::internalName$lambda$15), 1);
        boolean $i$f$forEach = false;
        Iterator<IrDeclarationParent> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            String string2;
            IrDeclarationParent element$iv;
            IrDeclarationParent it = element$iv = iterator2.next();
            boolean bl = false;
            IrDeclarationParent irDeclarationParent = it;
            if (irDeclarationParent instanceof IrClass) {
                internalName.insert(0, ((IrClass)it).getName().asString() + '$');
                continue;
            }
            if (!(irDeclarationParent instanceof IrPackageFragment)) continue;
            String it2 = string2 = ((IrPackageFragment)it).getPackageFqName().asString();
            boolean bl2 = false;
            String string3 = ((CharSequence)it2).length() > 0 ? string2 : null;
            if (string3 == null) continue;
            it2 = string3;
            boolean bl3 = false;
            internalName.insert(0, it2 + '.');
        }
        String string4 = internalName.toString();
        Intrinsics.checkNotNullExpressionValue(string4, "toString(...)");
        return string4;
    }

    public static final boolean checkCast(@Nullable IrFunction $this$checkCast, @NotNull IrInterpreterEnvironment environment) {
        Intrinsics.checkNotNullParameter(environment, "environment");
        if ($this$checkCast == null) {
            return true;
        }
        IrType actualType = $this$checkCast.getReturnType();
        if (!(IrTypesKt.getClassifierOrNull(actualType) instanceof IrTypeParameterSymbol)) {
            return true;
        }
        State state = environment.getCallStack$ir_interpreter().loadState($this$checkCast.getSymbol());
        Object object = state instanceof KTypeState ? (KTypeState)state : null;
        if (object == null || (object = ((KTypeState)object).getIrType()) == null) {
            return true;
        }
        Object expectedType = object;
        if (IrTypesKt.getClassifierOrFail((IrType)expectedType) instanceof IrTypeParameterSymbol) {
            return true;
        }
        State state2 = environment.getCallStack$ir_interpreter().peekState();
        if (state2 == null) {
            return true;
        }
        State actualState = state2;
        if (actualState instanceof Primitive && ((Primitive)actualState).getValue() == null) {
            return true;
        }
        if (!StateKt.isSubtypeOf(actualState, (IrType)expectedType)) {
            String convertibleClassName = UtilsKt.getFqName(environment.getCallStack$ir_interpreter().popState().getIrClass());
            environment.getCallStack$ir_interpreter().dropFrame();
            ExceptionUtilsKt.handleUserException(new ClassCastException(convertibleClassName + " cannot be cast to " + RenderIrElementKt.render$default((IrType)expectedType, null, 1, null)), environment);
            return false;
        }
        return true;
    }

    @NotNull
    public static final List<Object> getArgsForMethodInvocation(@NotNull IrFunction $this$getArgsForMethodInvocation, @NotNull CallInterceptor callInterceptor, @NotNull MethodType methodType, @NotNull List<? extends State> args) {
        Intrinsics.checkNotNullParameter($this$getArgsForMethodInvocation, "<this>");
        Intrinsics.checkNotNullParameter(callInterceptor, "callInterceptor");
        Intrinsics.checkNotNullParameter(methodType, "methodType");
        Intrinsics.checkNotNullParameter(args, "args");
        List<Object> argsValues = CollectionsKt.toMutableList((Collection)ProxyKt.wrap(args, callInterceptor, $this$getArgsForMethodInvocation, methodType));
        IrValueParameter irValueParameter = CollectionsKt.lastOrNull($this$getArgsForMethodInvocation.getParameters());
        if ((irValueParameter != null ? irValueParameter.getVarargElementType() : null) != null) {
            Object varargValue = CollectionsKt.last(argsValues);
            argsValues.remove(argsValues.size() - 1);
            Collection collection = argsValues;
            Intrinsics.checkNotNull(varargValue, "null cannot be cast to non-null type kotlin.Array<out kotlin.Any?>");
            CollectionsKt.addAll(collection, (Object[])varargValue);
        }
        return argsValues;
    }

    @NotNull
    public static final String fqNameWithNullability(@NotNull IrType $this$fqNameWithNullability) {
        Intrinsics.checkNotNullParameter($this$fqNameWithNullability, "<this>");
        Object object = IrTypesKt.getClassFqName($this$fqNameWithNullability);
        if (object == null || (object = ((FqName)object).toString()) == null) {
            IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$fqNameWithNullability);
            IrSymbolOwner irSymbolOwner = irClassifierSymbol != null ? irClassifierSymbol.getOwner() : null;
            Object object2 = irSymbolOwner instanceof IrDeclarationWithName ? (IrDeclarationWithName)irSymbolOwner : null;
            if ((object2 != null && (object2 = object2.getName()) != null ? ((Name)object2).asString() : (object = null)) == null) {
                object = RenderIrElementKt.render$default($this$fqNameWithNullability, null, 1, null);
            }
        }
        Object fqName = object;
        String nullability = $this$fqNameWithNullability instanceof IrSimpleType && ((IrSimpleType)$this$fqNameWithNullability).getNullability() == SimpleTypeNullability.MARKED_NULLABLE ? "?" : "";
        return (String)fqName + nullability;
    }

    @NotNull
    public static final String getOnlyName(@NotNull IrType $this$getOnlyName) {
        String string2;
        Intrinsics.checkNotNullParameter($this$getOnlyName, "<this>");
        if (!($this$getOnlyName instanceof IrSimpleType)) {
            return RenderIrElementKt.render$default($this$getOnlyName, null, 1, null);
        }
        StringBuilder stringBuilder = new StringBuilder();
        IrSymbolOwner irSymbolOwner = IrTypesKt.getClassifierOrFail($this$getOnlyName).getOwner();
        Intrinsics.checkNotNull(irSymbolOwner, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName");
        StringBuilder stringBuilder2 = stringBuilder.append(((IrDeclarationWithName)irSymbolOwner).getName().asString());
        switch (WhenMappings.$EnumSwitchMapping$1[((IrSimpleType)$this$getOnlyName).getNullability().ordinal()]) {
            case 1: {
                string2 = "?";
                break;
            }
            case 2: {
                string2 = "";
                break;
            }
            case 3: {
                if (IrTypesKt.getClassifierOrNull($this$getOnlyName) instanceof IrTypeParameterSymbol) {
                    string2 = " & Any";
                    break;
                }
                string2 = "";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return stringBuilder2.append(string2).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean accessesTopLevelOrObjectField(@NotNull IrFieldAccessExpression $this$accessesTopLevelOrObjectField) {
        Intrinsics.checkNotNullParameter($this$accessesTopLevelOrObjectField, "<this>");
        if ($this$accessesTopLevelOrObjectField.getReceiver() == null) return true;
        Object object = $this$accessesTopLevelOrObjectField.getReceiver();
        IrSymbolOwner irSymbolOwner = object != null && (object = ((IrExpression)object).getType()) != null && (object = IrTypesKt.getClassifierOrNull((IrType)object)) != null ? object.getOwner() : null;
        if (!(irSymbolOwner instanceof IrClass)) return false;
        IrClass irClass = (IrClass)irSymbolOwner;
        if (irClass == null) return false;
        if (!IrUtilsKt.isObject(irClass)) return false;
        return true;
    }

    @NotNull
    public static final IrProperty getOriginalPropertyByName(@NotNull IrClass $this$getOriginalPropertyByName, @NotNull String name2) {
        Intrinsics.checkNotNullParameter($this$getOriginalPropertyByName, "<this>");
        Intrinsics.checkNotNullParameter(name2, "name");
        Sequence<IrProperty> $this$single$iv = IrUtilsKt.getProperties($this$getOriginalPropertyByName);
        boolean $i$f$single = false;
        IrProperty single$iv = null;
        boolean found$iv = false;
        Iterator<IrProperty> iterator2 = $this$single$iv.iterator();
        while (iterator2.hasNext()) {
            IrProperty element$iv;
            IrProperty it = element$iv = iterator2.next();
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getName().asString(), name2)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrProperty property2 = single$iv;
        IrSimpleFunction irSimpleFunction = property2.getGetter();
        Intrinsics.checkNotNull(irSimpleFunction);
        IrProperty irProperty = UtilsKt.getProperty(UtilsKt.getLastOverridden(irSimpleFunction));
        Intrinsics.checkNotNull(irProperty);
        return irProperty;
    }

    @NotNull
    public static final IrFunction getFunctionThatContainsDefaults(@NotNull IrFunctionAccessExpression $this$getFunctionThatContainsDefaults) {
        Object element$iv2;
        IrFunction irFunction;
        block2: {
            Intrinsics.checkNotNullParameter($this$getFunctionThatContainsDefaults, "<this>");
            irFunction = ((IrFunctionSymbol)$this$getFunctionThatContainsDefaults.getSymbol()).getOwner();
            Iterable $this$first$iv = CollectionsKt.zip((Iterable)$this$getFunctionThatContainsDefaults.getArguments(), (Iterable)irFunction.getParameters());
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                Pair pair = (Pair)element$iv2;
                boolean bl = false;
                IrExpression arg = (IrExpression)pair.component1();
                if (!(arg == null)) continue;
                break block2;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Pair pair = (Pair)element$iv2;
        boolean bl = false;
        IrValueParameter param = (IrValueParameter)pair.component2();
        IrFunction irFunction2 = UtilsKt.getFunctionThatContainsDefaults$lookup(param);
        if (irFunction2 == null) {
            irFunction2 = irFunction;
        }
        return irFunction2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final IrExpression getDefaultWithActualParameters(@NotNull IrValueParameter $this$getDefaultWithActualParameters, @NotNull IrFunction newParent, @NotNull List<? extends IrValueDeclaration> actualParameters) {
        IrExpression expression2;
        Intrinsics.checkNotNullParameter($this$getDefaultWithActualParameters, "<this>");
        Intrinsics.checkNotNullParameter(newParent, "newParent");
        Intrinsics.checkNotNullParameter(actualParameters, "actualParameters");
        IrExpressionBody irExpressionBody = $this$getDefaultWithActualParameters.getDefaultValue();
        IrExpression irExpression = expression2 = irExpressionBody != null ? irExpressionBody.getExpression() : null;
        if (expression2 instanceof IrConst) {
            return expression2;
        }
        IrDeclarationParent irDeclarationParent = $this$getDefaultWithActualParameters.getParent();
        Intrinsics.checkNotNull(irDeclarationParent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFunction");
        IrFunction parameterOwner = (IrFunction)irDeclarationParent;
        IrElementTransformerVoid transformer2 = new IrElementTransformerVoid(parameterOwner, actualParameters){
            final /* synthetic */ IrFunction $parameterOwner;
            final /* synthetic */ List<IrValueDeclaration> $actualParameters;
            {
                this.$parameterOwner = $parameterOwner;
                this.$actualParameters = $actualParameters;
            }

            public IrExpression visitGetValue(IrGetValue expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrValueDeclaration irValueDeclaration = expression2.getSymbol().getOwner();
                IrValueParameter irValueParameter = irValueDeclaration instanceof IrValueParameter ? (IrValueParameter)irValueDeclaration : null;
                if (irValueParameter == null) {
                    return super.visitGetValue(expression2);
                }
                IrValueParameter parameter = irValueParameter;
                if (!Intrinsics.areEqual(parameter.getParent(), this.$parameterOwner)) {
                    return super.visitGetValue(expression2);
                }
                IrValueDeclaration newParameter = this.$actualParameters.get(parameter.getIndexInParameters());
                int n2 = expression2.getStartOffset();
                int n3 = expression2.getEndOffset();
                IrType irType = expression2.getType();
                IrValueDeclaration irValueDeclaration2 = newParameter;
                Intrinsics.checkNotNull(irValueDeclaration2);
                return BuildersKt.IrGetValueImpl$default(n2, n3, irType, irValueDeclaration2.getSymbol(), null, 16, null);
            }
        };
        IrExpression irExpression2 = expression2;
        IrExpression irExpression3 = irExpression2;
        if (irExpression2 == null) return null;
        IrElement $this$deepCopyWithSymbols_u24default$iv = irExpression3;
        boolean $i$f$deepCopyWithSymbols = false;
        IrElement $this$deepCopyImpl$iv$iv = $this$deepCopyWithSymbols_u24default$iv;
        boolean $i$f$deepCopyImpl = false;
        DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
        IrVisitorsKt.acceptVoid($this$deepCopyImpl$iv$iv, symbolRemapper$iv$iv);
        DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper$iv$iv;
        boolean bl = false;
        ReferencedSymbolRemapper p0 = deepCopySymbolRemapper;
        TypeRemapper typeRemapper$iv$iv = new DeepCopyTypeRemapper(p0);
        IrElement irElement = $this$deepCopyImpl$iv$iv.transform(new DeepCopyIrTreeWithSymbols(symbolRemapper$iv$iv, typeRemapper$iv$iv), null);
        if (irElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
        }
        IrExpression irExpression4 = (IrExpression)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)((IrExpression)irElement), newParent);
        irExpression3 = irExpression4;
        if (irExpression4 == null) return null;
        IrElement irElement2 = irExpression3.transform((IrElementTransformer)transformer2, (Object)null);
        return irElement2;
    }

    @NotNull
    public static final IrType getTypeIfReified(@NotNull IrType $this$getTypeIfReified, @NotNull CallStack callStack) {
        Intrinsics.checkNotNullParameter($this$getTypeIfReified, "<this>");
        Intrinsics.checkNotNullParameter(callStack, "callStack");
        return UtilsKt.getTypeIfReified($this$getTypeIfReified, arg_0 -> UtilsKt.getTypeIfReified$lambda$25(callStack, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IrType getTypeIfReified(@NotNull IrType $this$getTypeIfReified, @NotNull Function1<? super IrClassifierSymbol, ? extends IrType> getType) {
        void $this$mapTo$iv$iv;
        IrSymbolOwner owner;
        Intrinsics.checkNotNullParameter($this$getTypeIfReified, "<this>");
        Intrinsics.checkNotNullParameter(getType, "getType");
        if (!($this$getTypeIfReified instanceof IrSimpleType)) {
            return $this$getTypeIfReified;
        }
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$getTypeIfReified);
        IrSymbolOwner irSymbolOwner = owner = irClassifierSymbol != null ? irClassifierSymbol.getOwner() : null;
        if (owner instanceof IrTypeParameter && ((IrTypeParameter)owner).isReified()) {
            IrType irType = getType.invoke(((IrTypeParameter)owner).getSymbol());
            Intrinsics.checkNotNull(irType, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
            return IrTypesKt.mergeNullability((IrSimpleType)irType, $this$getTypeIfReified);
        }
        Iterable $this$map$iv = ((IrSimpleType)$this$getTypeIfReified).getArguments();
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrTypeArgument irTypeArgument;
            void it;
            IrTypeArgument irTypeArgument2 = (IrTypeArgument)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (IrTypesKt.getTypeOrNull((IrTypeArgument)it) == null) {
                irTypeArgument = it;
            } else {
                IrSymbolOwner typeOwner;
                IrType type2;
                IrClassifierSymbol irClassifierSymbol2 = IrTypesKt.getClassifierOrNull(type2);
                IrSymbolOwner irSymbolOwner2 = typeOwner = irClassifierSymbol2 != null ? irClassifierSymbol2.getOwner() : null;
                if (typeOwner instanceof IrTypeParameter && !((IrTypeParameter)typeOwner).isReified()) {
                    irTypeArgument = it;
                } else {
                    IrType irType = UtilsKt.getTypeIfReified(type2, getType);
                    Intrinsics.checkNotNull(irType, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrTypeArgument");
                    irTypeArgument = irType;
                }
            }
            collection.add(irTypeArgument);
        }
        List newArguments2 = (List)destination$iv$iv;
        IrSimpleType $this$buildSimpleType$iv = (IrSimpleType)$this$getTypeIfReified;
        boolean $i$f$buildSimpleType = false;
        Object $this$getTypeIfReified_u24lambda_u2427 = object = IrSimpleTypeImplKt.toBuilder($this$buildSimpleType$iv);
        boolean bl = false;
        ((IrSimpleTypeBuilder)$this$getTypeIfReified_u24lambda_u2427).setArguments(newArguments2);
        return IrSimpleTypeImplKt.buildSimpleType((IrSimpleTypeBuilder)object);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<IrTypeParameterSymbol, KTypeState> loadReifiedTypeArguments(@NotNull IrInterpreterEnvironment $this$loadReifiedTypeArguments, @NotNull IrFunctionAccessExpression expression2) {
        void $this$mapTo$iv$iv;
        IrTypeParameter it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$loadReifiedTypeArguments, "<this>");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Iterable $this$filter$iv = ((IrFunctionSymbol)expression2.getSymbol()).getOwner().getTypeParameters();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IrTypeParameter)element$iv$iv;
            boolean bl = false;
            if (!it.isReified()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IrTypeParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSymbol());
        }
        return org.jetbrains.kotlin.utils.CollectionsKt.keysToMap((List)destination$iv$iv, arg_0 -> UtilsKt.loadReifiedTypeArguments$lambda$30(expression2, $this$loadReifiedTypeArguments, arg_0));
    }

    public static final boolean hasFunInterfaceParent(@NotNull IrFunction $this$hasFunInterfaceParent) {
        Intrinsics.checkNotNullParameter($this$hasFunInterfaceParent, "<this>");
        IrClass irClass = IrUtilsKt.getParentClassOrNull($this$hasFunInterfaceParent);
        return irClass != null ? irClass.isFun() : false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IrFunction getSingleAbstractMethod(@NotNull IrClass $this$getSingleAbstractMethod) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$getSingleAbstractMethod, "<this>");
        Iterable $this$filterIsInstance$iv = $this$getSingleAbstractMethod.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$single$iv = (List)destination$iv$iv;
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv;
            boolean bl = false;
            if (!(it.getModality() == Modality.ABSTRACT)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return (IrFunction)((Object)iterable);
    }

    public static final boolean isAccessToNotNullableObject(@Nullable IrExpression $this$isAccessToNotNullableObject) {
        boolean bl;
        IrExpression irExpression = $this$isAccessToNotNullableObject;
        if (irExpression instanceof IrGetObjectValue) {
            bl = !IrTypeUtilsKt.isNullable(((IrGetObjectValue)$this$isAccessToNotNullableObject).getType());
        } else if (irExpression instanceof IrGetValue) {
            IrClass expectedClass;
            IrValueDeclaration owner = ((IrGetValue)$this$isAccessToNotNullableObject).getSymbol().getOwner();
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(((IrGetValue)$this$isAccessToNotNullableObject).getType());
            IrClass irClass = expectedClass = irClassSymbol != null ? (IrClass)irClassSymbol.getOwner() : null;
            if (expectedClass == null || !IrUtilsKt.isObject(expectedClass) || IrTypeUtilsKt.isNullable(((IrGetValue)$this$isAccessToNotNullableObject).getType())) {
                return false;
            }
            bl = Intrinsics.areEqual(owner.getOrigin(), IrDeclarationOrigin.Companion.getINSTANCE_RECEIVER()) || Intrinsics.areEqual(owner.getName().asString(), "<this>");
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isAccessorOfPropertyWithBackingField(@NotNull IrFunction $this$isAccessorOfPropertyWithBackingField) {
        Intrinsics.checkNotNullParameter($this$isAccessorOfPropertyWithBackingField, "<this>");
        IrDeclarationBase irDeclarationBase = UtilsKt.getProperty($this$isAccessorOfPropertyWithBackingField);
        return (irDeclarationBase != null && (irDeclarationBase = ((IrProperty)irDeclarationBase).getBackingField()) != null ? ((IrField)irDeclarationBase).getInitializer() : null) != null;
    }

    @NotNull
    public static final String unsignedToString(@NotNull State $this$unsignedToString) {
        String string2;
        Intrinsics.checkNotNullParameter($this$unsignedToString, "<this>");
        Object t2 = CollectionsKt.single((Iterable)$this$unsignedToString.getFields().values());
        Intrinsics.checkNotNull(t2, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Primitive");
        Object value2 = ((Primitive)t2).getValue();
        if (value2 instanceof Byte) {
            string2 = UByte.toString-impl(UByte.constructor-impl(((Number)value2).byteValue()));
        } else if (value2 instanceof Short) {
            string2 = UShort.toString-impl(UShort.constructor-impl(((Number)value2).shortValue()));
        } else if (value2 instanceof Integer) {
            string2 = Integer.toUnsignedString(UInt.constructor-impl(((Number)value2).intValue()));
        } else {
            Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type kotlin.Number");
            string2 = Long.toUnsignedString(ULong.constructor-impl(((Number)value2).longValue()));
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Common toState(@NotNull IrEnumEntry $this$toState, @NotNull IrBuiltIns irBuiltIns) {
        Primitive[] $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toState, "<this>");
        Intrinsics.checkNotNullParameter(irBuiltIns, "irBuiltIns");
        IrClass enumClass = IrUtilsKt.getParentAsClass((IrDeclaration)$this$toState.getSymbol().getOwner());
        Iterable $this$filterIsInstance$iv = enumClass.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo22 = false;
        for (Object t2 : $this$filterIsInstanceTo$iv$iv) {
            if (!(t2 instanceof IrEnumEntry)) continue;
            destination$iv$iv.add(t2);
        }
        List enumEntries = (List)destination$iv$iv;
        IrClass irClass = $this$toState.getCorrespondingClass();
        if (irClass == null) {
            irClass = enumClass;
        }
        Common enumClassObject = new Common(irClass);
        if (!((Collection)enumEntries).isEmpty()) {
            void $this$filterIsInstanceTo$iv$iv2;
            $this$filterIsInstanceTo$iv$iv = new Primitive[]{new Primitive($this$toState.getName().asString(), irBuiltIns.getStringType()), new Primitive(enumEntries.indexOf($this$toState), irBuiltIns.getIntType())};
            List<Primitive> valueArguments = CollectionsKt.listOf($this$filterIsInstanceTo$iv$iv);
            Iterable $this$filterIsInstance$iv2 = ((IrClass)irBuiltIns.getEnumClass().getOwner()).getDeclarations();
            boolean $i$f$filterIsInstance2 = false;
            Iterable $i$f$filterIsInstanceTo22 = $this$filterIsInstance$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean bl = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
                if (!(element$iv$iv instanceof IrProperty)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)((List)destination$iv$iv2), (Iterable)valueArguments);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl2 = false;
                IrProperty property2 = (IrProperty)pair.component1();
                Primitive argument = (Primitive)pair.component2();
                enumClassObject.setField(property2.getSymbol(), argument);
            }
        }
        return enumClassObject;
    }

    @Nullable
    public static final IrProperty getProperty(@NotNull IrFunction $this$property) {
        Intrinsics.checkNotNullParameter($this$property, "<this>");
        Object object = $this$property instanceof IrSimpleFunction ? (IrSimpleFunction)$this$property : null;
        return object != null && (object = ((IrSimpleFunction)object).getCorrespondingPropertySymbol()) != null ? (IrProperty)object.getOwner() : null;
    }

    @Nullable
    public static final IrProperty getProperty(@NotNull IrField $this$property) {
        Intrinsics.checkNotNullParameter($this$property, "<this>");
        IrPropertySymbol irPropertySymbol = $this$property.getCorrespondingPropertySymbol();
        return irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
    }

    @Nullable
    public static final IrProperty getCorrespondingProperty(@NotNull IrCall $this$correspondingProperty) {
        Intrinsics.checkNotNullParameter($this$correspondingProperty, "<this>");
        IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)$this$correspondingProperty.getSymbol().getOwner()).getCorrespondingPropertySymbol();
        return irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
    }

    public static final boolean isConst(@Nullable IrProperty $this$isConst) {
        IrProperty irProperty = $this$isConst;
        return irProperty != null ? irProperty.isConst() : false;
    }

    /*
     * WARNING - void declaration
     */
    private static final List getFirstNonInterfaceOverridden$lambda$4(List it) {
        List list;
        Intrinsics.checkNotNullParameter(it, "it");
        Object object = (IrSimpleFunction)CollectionsKt.firstOrNull(it);
        if (object != null && (object = ((IrSimpleFunction)object).getOverriddenSymbols()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void overriddenSymbol;
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = (IrSimpleFunctionSymbol)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((IrSimpleFunction)overriddenSymbol.getOwner());
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private static final List getLastOverridden$lambda$7(List it) {
        List list;
        Intrinsics.checkNotNullParameter(it, "it");
        Object object = (IrSimpleFunction)CollectionsKt.firstOrNull(it);
        if (object != null && (object = ((IrSimpleFunction)object).getOverriddenSymbols()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = (IrSimpleFunctionSymbol)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((IrSimpleFunction)it2.getOwner());
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private static final IrClass isSubclassOfThrowable$lambda$12(IrClass irClass) {
        Iterable iterable;
        block4: {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter(irClass, "irClass");
            if (IrTypePredicatesKt.isAny(IrUtilsKt.getDefaultType(irClass))) {
                return null;
            }
            Iterable $this$mapNotNull$iv = irClass.getSuperTypes();
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                IrClass it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                IrType it = (IrType)element$iv$iv;
                boolean bl2 = false;
                IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(it);
                if ((irClassSymbol != null ? (IrClass)irClassSymbol.getOwner() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$singleOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                IrClass it = (IrClass)element$iv;
                boolean bl = false;
                if (!IrUtilsKt.isClass(it)) continue;
                if (found$iv) {
                    iterable = null;
                    break block4;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            iterable = !found$iv ? null : iterable2;
        }
        return (IrClass)((Object)iterable);
    }

    private static final IrDeclarationParent internalName$lambda$15(IrDeclarationParent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        IrDeclaration irDeclaration2 = it instanceof IrDeclaration ? (IrDeclaration)((Object)it) : null;
        return irDeclaration2 != null ? irDeclaration2.getParent() : null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static final IrFunction getFunctionThatContainsDefaults$lookup(IrValueParameter $this$getFunctionThatContainsDefaults_u24lookup) {
        IrValueParameter it;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List<IrSimpleFunctionSymbol> list;
        IrFunction irFunction;
        IrExpressionBody irExpressionBody = $this$getFunctionThatContainsDefaults_u24lookup.getDefaultValue();
        if (irExpressionBody != null) {
            IrExpressionBody it2 = irExpressionBody;
            boolean bl = false;
            IrDeclarationParent irDeclarationParent = $this$getFunctionThatContainsDefaults_u24lookup.getParent();
            Intrinsics.checkNotNull(irDeclarationParent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFunction");
            IrFunction irFunction2 = (IrFunction)irDeclarationParent;
            if (irFunction2 != null) {
                irFunction = irFunction2;
                return irFunction;
            }
        }
        if (!((list = $this$getFunctionThatContainsDefaults_u24lookup.getParent()) instanceof IrSimpleFunction)) return null;
        IrSimpleFunction irSimpleFunction = (IrSimpleFunction)((Object)list);
        IrSimpleFunction irSimpleFunction2 = irSimpleFunction;
        if (irSimpleFunction2 == null) return null;
        list = irSimpleFunction2.getOverriddenSymbols();
        if (list == null) return null;
        Iterable iterable = list;
        boolean $i$f$map = false;
        IrFunction irFunction3 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = (IrSimpleFunctionSymbol)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((IrSimpleFunction)it3.getOwner()).getParameters().get($this$getFunctionThatContainsDefaults_u24lookup.getIndexInParameters()));
        }
        Iterator iterator2 = ((Iterable)((List)destination$iv$iv)).iterator();
        do {
            if (!iterator2.hasNext()) {
                return null;
            }
            it = (IrValueParameter)iterator2.next();
            boolean bl = false;
        } while ((irFunction3 = UtilsKt.getFunctionThatContainsDefaults$lookup(it)) == null);
        irFunction = irFunction3;
        return irFunction;
    }

    private static final IrType getTypeIfReified$lambda$25(CallStack $callStack, IrClassifierSymbol it) {
        Intrinsics.checkNotNullParameter(it, "it");
        State state = $callStack.loadState(it);
        Intrinsics.checkNotNull(state, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState");
        return ((KTypeState)state).getIrType();
    }

    private static final KTypeState loadReifiedTypeArguments$lambda$30(IrFunctionAccessExpression $expression, IrInterpreterEnvironment $this_loadReifiedTypeArguments, IrTypeParameterSymbol it) {
        Intrinsics.checkNotNullParameter(it, "it");
        IrType irType = $expression.getTypeArguments().get(((IrTypeParameter)it.getOwner()).getIndex());
        Intrinsics.checkNotNull(irType);
        IrType reifiedType = UtilsKt.getTypeIfReified(irType, $this_loadReifiedTypeArguments.getCallStack$ir_interpreter());
        return new KTypeState(reifiedType, (IrClass)$this_loadReifiedTypeArguments.getKTypeClass$ir_interpreter().getOwner());
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PrimitiveType.values().length];
            try {
                nArray[PrimitiveType.BOOLEAN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.CHAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.BYTE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.SHORT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.INT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.FLOAT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.LONG.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.DOUBLE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SimpleTypeNullability.values().length];
            try {
                nArray[SimpleTypeNullability.MARKED_NULLABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SimpleTypeNullability.NOT_SPECIFIED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SimpleTypeNullability.DEFINITELY_NOT_NULL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

