/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.konan.library;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.konan.file.FileKt;
import org.jetbrains.kotlin.konan.library.KonanLibrary;
import org.jetbrains.kotlin.konan.library.SearchPathResolverWithTarget;
import org.jetbrains.kotlin.konan.library.impl.KonanLibraryImplKt;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryProperResolverWithAttributes;
import org.jetbrains.kotlin.library.UnresolvedLibrary;
import org.jetbrains.kotlin.util.Logger;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B5\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u000bH\u0016J\u0018\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/konan/library/KonanLibraryProperResolver;", "Lorg/jetbrains/kotlin/library/KotlinLibraryProperResolverWithAttributes;", "Lorg/jetbrains/kotlin/konan/library/KonanLibrary;", "Lorg/jetbrains/kotlin/konan/library/SearchPathResolverWithTarget;", "directLibs", "", "", "target", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "distributionKlib", "skipCurrentDir", "", "logger", "Lorg/jetbrains/kotlin/util/Logger;", "(Ljava/util/List;Lorg/jetbrains/kotlin/konan/target/KonanTarget;Ljava/lang/String;ZLorg/jetbrains/kotlin/util/Logger;)V", "distPlatformHead", "Lorg/jetbrains/kotlin/konan/file/File;", "getDistPlatformHead", "()Lorg/jetbrains/kotlin/konan/file/File;", "getLogger", "()Lorg/jetbrains/kotlin/util/Logger;", "getTarget", "()Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "libraryComponentBuilder", "file", "isDefault", "libraryMatch", "candidate", "unresolved", "Lorg/jetbrains/kotlin/library/UnresolvedLibrary;", "kotlin-native-utils"})
public final class KonanLibraryProperResolver
extends KotlinLibraryProperResolverWithAttributes<KonanLibrary>
implements SearchPathResolverWithTarget<KonanLibrary> {
    @NotNull
    private final KonanTarget target;
    @NotNull
    private final Logger logger;

    public KonanLibraryProperResolver(@NotNull List<String> directLibs, @NotNull KonanTarget target, @Nullable String distributionKlib, boolean skipCurrentDir, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter(directLibs, "directLibs");
        Intrinsics.checkNotNullParameter(target, "target");
        Intrinsics.checkNotNullParameter(logger, "logger");
        super(directLibs, distributionKlib, skipCurrentDir, logger, CollectionsKt.listOf("kotlin.native.cinterop"));
        this.target = target;
        this.logger = logger;
    }

    @Override
    @NotNull
    public KonanTarget getTarget() {
        return this.target;
    }

    @Override
    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    @NotNull
    public List<KonanLibrary> libraryComponentBuilder(@NotNull File file2, boolean isDefault) {
        Intrinsics.checkNotNullParameter(file2, "file");
        return KonanLibraryImplKt.createKonanLibraryComponents(file2, this.getTarget(), isDefault);
    }

    @Override
    @Nullable
    public File getDistPlatformHead() {
        Object object = this.getDistributionKlib();
        return object != null && (object = FileKt.File((String)object)) != null && (object = ((File)object).child("platform")) != null ? ((File)object).child(this.getTarget().getVisibleName()) : null;
    }

    @Override
    public boolean libraryMatch(@NotNull KonanLibrary candidate2, @NotNull UnresolvedLibrary unresolved) {
        Intrinsics.checkNotNullParameter(candidate2, "candidate");
        Intrinsics.checkNotNullParameter(unresolved, "unresolved");
        KonanTarget resolverTarget = this.getTarget();
        String candidatePath = candidate2.getLibraryFile().getAbsolutePath();
        if (!candidate2.getTargetList().contains(resolverTarget.getVisibleName())) {
            this.getLogger().strongWarning("KLIB resolver: Skipping '" + candidatePath + "'. The target doesn't match. Expected '" + resolverTarget + "', found " + candidate2.getTargetList() + '.');
            return false;
        }
        return super.libraryMatch((KotlinLibrary)candidate2, unresolved);
    }
}

