/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.library.impl.ReadBuffer;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0005\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B&\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0017\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\r0\f2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000bJ\u001b\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\t\u001a&\u0012\u0004\u0012\u00020\u000b\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\r0\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/library/impl/IrMultiTableReader;", "K", "", "buffer", "Lorg/jetbrains/kotlin/library/impl/ReadBuffer;", "keyReader", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/kotlin/library/impl/ReadBuffer;Lkotlin/jvm/functions/Function1;)V", "indexToIndexMap", "", "", "", "Lkotlin/Pair;", "indexToOffset", "", "readIndexMap", "position", "readOffsets", "tableItemBytes", "", "idx", "row", "id", "(ILjava/lang/Object;)[B", "kotlin-util-klib"})
@SourceDebugExtension(value={"SMAP\nIrFileReaders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrFileReaders.kt\norg/jetbrains/kotlin/library/impl/IrMultiTableReader\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,233:1\n384#2,7:234\n*S KotlinDebug\n*F\n+ 1 IrFileReaders.kt\norg/jetbrains/kotlin/library/impl/IrMultiTableReader\n*L\n172#1:234,7\n*E\n"})
public abstract class IrMultiTableReader<K> {
    @NotNull
    private final ReadBuffer buffer;
    @NotNull
    private final Function1<ReadBuffer, K> keyReader;
    @NotNull
    private final int[] indexToOffset;
    @NotNull
    private final Map<Integer, Map<K, Pair<Integer, Integer>>> indexToIndexMap;

    public IrMultiTableReader(@NotNull ReadBuffer buffer, @NotNull Function1<? super ReadBuffer, ? extends K> keyReader) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        Intrinsics.checkNotNullParameter(keyReader, "keyReader");
        this.buffer = buffer;
        this.keyReader = keyReader;
        this.indexToIndexMap = new LinkedHashMap();
        this.indexToOffset = this.readOffsets(0);
    }

    private final int[] readOffsets(int position) {
        this.buffer.setPosition(position);
        int count = this.buffer.getInt();
        int[] result2 = new int[count + 1];
        result2[0] = 4 * (count + 1);
        for (int i2 = 0; i2 < count; ++i2) {
            int size = this.buffer.getInt();
            result2[i2 + 1] = result2[i2] + size;
        }
        return result2;
    }

    private final Map<K, Pair<Integer, Integer>> readIndexMap(int position) {
        this.buffer.setPosition(position);
        Map result2 = new LinkedHashMap();
        int count = this.buffer.getInt();
        for (int i2 = 0; i2 < count; ++i2) {
            K key = this.keyReader.invoke(this.buffer);
            int offset = this.buffer.getInt();
            int size = this.buffer.getInt();
            result2.put(key, TuplesKt.to(offset, size));
        }
        return result2;
    }

    @NotNull
    public final byte[] tableItemBytes(int idx) {
        int rowOffset = this.indexToOffset[idx];
        int nextOffset = this.indexToOffset[idx + 1];
        int size = nextOffset - rowOffset;
        byte[] result2 = new byte[size];
        this.buffer.setPosition(rowOffset);
        this.buffer.get(result2, 0, size);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] tableItemBytes(int row, K id) {
        Object object;
        void $this$getOrPut$iv;
        int rowOffset = this.indexToOffset[row];
        Map<Integer, Map<K, Pair<Integer, Integer>>> map = this.indexToIndexMap;
        Integer key$iv = row;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Map<K, Pair<Integer, Integer>> answer$iv = this.readIndexMap(rowOffset);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Map indexToMap = (Map)object;
        Pair pair = (Pair)indexToMap.get(id);
        if (pair == null) {
            throw new IllegalStateException(("No coordinates found for " + id).toString());
        }
        Pair coordinates = pair;
        int offset = ((Number)coordinates.getFirst()).intValue();
        int size = ((Number)coordinates.getSecond()).intValue();
        byte[] result2 = new byte[size];
        this.buffer.setPosition(rowOffset + offset);
        this.buffer.get(result2, 0, size);
        return result2;
    }
}

