/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes.receivers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.ChainedMemberScope;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScopeImpl;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassValueReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassifierQualifier;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.utils.Printer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0018B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/receivers/TypeAliasQualifier;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ClassifierQualifier;", "referenceExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)V", "getReferenceExpression", "()Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "getDescriptor", "()Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "getClassDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "classValueReceiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ClassValueReceiver;", "getClassValueReceiver", "()Lorg/jetbrains/kotlin/resolve/scopes/receivers/ClassValueReceiver;", "staticScope", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "getStaticScope", "()Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "EnumEntriesScope", "frontend"})
public final class TypeAliasQualifier
implements ClassifierQualifier {
    @NotNull
    private final KtSimpleNameExpression referenceExpression;
    @NotNull
    private final TypeAliasDescriptor descriptor;
    @NotNull
    private final ClassDescriptor classDescriptor;

    public TypeAliasQualifier(@NotNull KtSimpleNameExpression referenceExpression, @NotNull TypeAliasDescriptor descriptor, @NotNull ClassDescriptor classDescriptor) {
        Intrinsics.checkNotNullParameter(referenceExpression, "referenceExpression");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        Intrinsics.checkNotNullParameter(classDescriptor, "classDescriptor");
        this.referenceExpression = referenceExpression;
        this.descriptor = descriptor;
        this.classDescriptor = classDescriptor;
    }

    @Override
    @NotNull
    public KtSimpleNameExpression getReferenceExpression() {
        return this.referenceExpression;
    }

    @Override
    @NotNull
    public TypeAliasDescriptor getDescriptor() {
        return this.descriptor;
    }

    @NotNull
    public final ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    @Override
    @Nullable
    public ClassValueReceiver getClassValueReceiver() {
        ClassValueReceiver classValueReceiver;
        KotlinType kotlinType = DescriptorUtilsKt.getClassValueType(this.classDescriptor);
        if (kotlinType != null) {
            KotlinType it = kotlinType;
            boolean bl = false;
            classValueReceiver = new ClassValueReceiver(this, it, null, 4, null);
        } else {
            classValueReceiver = null;
        }
        return classValueReceiver;
    }

    @Override
    @NotNull
    public MemberScope getStaticScope() {
        MemberScope memberScope2;
        if (DescriptorUtils.isEnumClass(this.classDescriptor)) {
            MemberScope[] memberScopeArray = new MemberScope[]{this.classDescriptor.getStaticScope(), new EnumEntriesScope()};
            memberScope2 = ChainedMemberScope.Companion.create("Static scope for typealias " + this.getDescriptor().getName(), memberScopeArray);
        } else {
            MemberScope memberScope3 = this.classDescriptor.getStaticScope();
            memberScope2 = memberScope3;
            Intrinsics.checkNotNullExpressionValue(memberScope3, "getStaticScope(...)");
        }
        return memberScope2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/receivers/TypeAliasQualifier$EnumEntriesScope;", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScopeImpl;", "<init>", "(Lorg/jetbrains/kotlin/resolve/scopes/receivers/TypeAliasQualifier;)V", "getContributedDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "kindFilter", "Lorg/jetbrains/kotlin/resolve/scopes/DescriptorKindFilter;", "nameFilter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/Name;", "", "getContributedClassifier", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "name", "location", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "printScopeStructure", "", "p", "Lorg/jetbrains/kotlin/utils/Printer;", "frontend"})
    @SourceDebugExtension(value={"SMAP\nQualifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Qualifier.kt\norg/jetbrains/kotlin/resolve/scopes/receivers/TypeAliasQualifier$EnumEntriesScope\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n774#2:156\n865#2,2:157\n1#3:159\n*S KotlinDebug\n*F\n+ 1 Qualifier.kt\norg/jetbrains/kotlin/resolve/scopes/receivers/TypeAliasQualifier$EnumEntriesScope\n*L\n122#1:156\n122#1:157,2\n*E\n"})
    private final class EnumEntriesScope
    extends MemberScopeImpl {
        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getContributedDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, Boolean> nameFilter) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(kindFilter, "kindFilter");
            Intrinsics.checkNotNullParameter(nameFilter, "nameFilter");
            Iterable $this$filter$iv = TypeAliasQualifier.this.getClassDescriptor().getUnsubstitutedInnerClassesScope().getContributedDescriptors(kindFilter, nameFilter);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                DeclarationDescriptor it = (DeclarationDescriptor)element$iv$iv;
                boolean bl = false;
                if (!DescriptorUtils.isEnumEntry(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @Override
        @Nullable
        public ClassifierDescriptor getContributedClassifier(@NotNull Name name2, @NotNull LookupLocation location) {
            ClassifierDescriptor classifierDescriptor;
            Intrinsics.checkNotNullParameter(name2, "name");
            Intrinsics.checkNotNullParameter(location, "location");
            ClassifierDescriptor classifierDescriptor2 = TypeAliasQualifier.this.getClassDescriptor().getUnsubstitutedInnerClassesScope().getContributedClassifier(name2, location);
            if (classifierDescriptor2 != null) {
                ClassifierDescriptor classifierDescriptor3;
                ClassifierDescriptor it = classifierDescriptor3 = classifierDescriptor2;
                boolean bl = false;
                classifierDescriptor = DescriptorUtils.isEnumEntry(it) ? classifierDescriptor3 : null;
            } else {
                classifierDescriptor = null;
            }
            return classifierDescriptor;
        }

        @Override
        public void printScopeStructure(@NotNull Printer p2) {
            Intrinsics.checkNotNullParameter(p2, "p");
            Object[] objectArray = new Object[]{this.getClass().getSimpleName(), " {"};
            p2.println(objectArray);
            p2.pushIndent();
            objectArray = new Object[]{"descriptor = ", TypeAliasQualifier.this.getDescriptor()};
            p2.println(objectArray);
            p2.popIndent();
            objectArray = new Object[]{"}"};
            p2.println(objectArray);
        }
    }
}

