/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.org.objectweb.asm.commons;

import org.jetbrains.org.objectweb.asm.ConstantDynamic;
import org.jetbrains.org.objectweb.asm.Handle;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.SignatureRemapper;
import org.jetbrains.org.objectweb.asm.signature.SignatureReader;
import org.jetbrains.org.objectweb.asm.signature.SignatureVisitor;
import org.jetbrains.org.objectweb.asm.signature.SignatureWriter;

public abstract class Remapper {
    public String mapDesc(String descriptor) {
        return this.mapType(Type.getType(descriptor)).getDescriptor();
    }

    private Type mapType(Type type2) {
        switch (type2.getSort()) {
            case 9: {
                StringBuilder remappedDescriptor = new StringBuilder();
                for (int i2 = 0; i2 < type2.getDimensions(); ++i2) {
                    remappedDescriptor.append('[');
                }
                remappedDescriptor.append(this.mapType(type2.getElementType()).getDescriptor());
                return Type.getType(remappedDescriptor.toString());
            }
            case 10: {
                String remappedInternalName = this.map(type2.getInternalName());
                return remappedInternalName != null ? Type.getObjectType(remappedInternalName) : type2;
            }
            case 11: {
                return Type.getMethodType(this.mapMethodDesc(type2.getDescriptor()));
            }
        }
        return type2;
    }

    public String mapType(String internalName) {
        if (internalName == null) {
            return null;
        }
        return this.mapType(Type.getObjectType(internalName)).getInternalName();
    }

    public String[] mapTypes(String[] internalNames) {
        String[] remappedInternalNames = null;
        for (int i2 = 0; i2 < internalNames.length; ++i2) {
            String internalName = internalNames[i2];
            String remappedInternalName = this.mapType(internalName);
            if (remappedInternalName == null) continue;
            if (remappedInternalNames == null) {
                remappedInternalNames = (String[])internalNames.clone();
            }
            remappedInternalNames[i2] = remappedInternalName;
        }
        return remappedInternalNames != null ? remappedInternalNames : internalNames;
    }

    public String mapMethodDesc(String methodDescriptor) {
        if ("()V".equals(methodDescriptor)) {
            return methodDescriptor;
        }
        StringBuilder stringBuilder = new StringBuilder("(");
        for (Type argumentType : Type.getArgumentTypes(methodDescriptor)) {
            stringBuilder.append(this.mapType(argumentType).getDescriptor());
        }
        Type returnType = Type.getReturnType(methodDescriptor);
        if (returnType == Type.VOID_TYPE) {
            stringBuilder.append(")V");
        } else {
            stringBuilder.append(')').append(this.mapType(returnType).getDescriptor());
        }
        return stringBuilder.toString();
    }

    public Object mapValue(Object value2) {
        if (value2 instanceof Type) {
            return this.mapType((Type)value2);
        }
        if (value2 instanceof Handle) {
            Handle handle = (Handle)value2;
            boolean isFieldHandle = handle.getTag() <= 4;
            return new Handle(handle.getTag(), this.mapType(handle.getOwner()), isFieldHandle ? this.mapFieldName(handle.getOwner(), handle.getName(), handle.getDesc()) : this.mapMethodName(handle.getOwner(), handle.getName(), handle.getDesc()), isFieldHandle ? this.mapDesc(handle.getDesc()) : this.mapMethodDesc(handle.getDesc()), handle.isInterface());
        }
        if (value2 instanceof ConstantDynamic) {
            ConstantDynamic constantDynamic = (ConstantDynamic)value2;
            int bootstrapMethodArgumentCount = constantDynamic.getBootstrapMethodArgumentCount();
            Object[] remappedBootstrapMethodArguments = new Object[bootstrapMethodArgumentCount];
            for (int i2 = 0; i2 < bootstrapMethodArgumentCount; ++i2) {
                remappedBootstrapMethodArguments[i2] = this.mapValue(constantDynamic.getBootstrapMethodArgument(i2));
            }
            String descriptor = constantDynamic.getDescriptor();
            return new ConstantDynamic(this.mapInvokeDynamicMethodName(constantDynamic.getName(), descriptor), this.mapDesc(descriptor), (Handle)this.mapValue(constantDynamic.getBootstrapMethod()), remappedBootstrapMethodArguments);
        }
        return value2;
    }

    public String mapSignature(String signature, boolean typeSignature) {
        if (signature == null) {
            return null;
        }
        SignatureReader signatureReader = new SignatureReader(signature);
        SignatureWriter signatureWriter = new SignatureWriter();
        SignatureVisitor signatureRemapper = this.createSignatureRemapper(signatureWriter);
        if (typeSignature) {
            signatureReader.acceptType(signatureRemapper);
        } else {
            signatureReader.accept(signatureRemapper);
        }
        return signatureWriter.toString();
    }

    @Deprecated
    protected SignatureVisitor createRemappingSignatureAdapter(SignatureVisitor signatureVisitor) {
        return this.createSignatureRemapper(signatureVisitor);
    }

    protected SignatureVisitor createSignatureRemapper(SignatureVisitor signatureVisitor) {
        return new SignatureRemapper(signatureVisitor, this);
    }

    public String mapAnnotationAttributeName(String descriptor, String name2) {
        return name2;
    }

    public String mapInnerClassName(String name2, String ownerName, String innerName) {
        String remappedInnerName = this.mapType(name2);
        if (remappedInnerName.equals(name2)) {
            return innerName;
        }
        int originSplit = name2.lastIndexOf(47);
        int remappedSplit = remappedInnerName.lastIndexOf(47);
        if (originSplit != -1 && remappedSplit != -1 && name2.substring(originSplit).equals(remappedInnerName.substring(remappedSplit))) {
            return innerName;
        }
        if (remappedInnerName.contains("$")) {
            int index;
            for (index = remappedInnerName.lastIndexOf(36) + 1; index < remappedInnerName.length() && Character.isDigit(remappedInnerName.charAt(index)); ++index) {
            }
            return remappedInnerName.substring(index);
        }
        return innerName;
    }

    public String mapMethodName(String owner, String name2, String descriptor) {
        return name2;
    }

    public String mapInvokeDynamicMethodName(String name2, String descriptor) {
        return name2;
    }

    public String mapRecordComponentName(String owner, String name2, String descriptor) {
        return name2;
    }

    public String mapFieldName(String owner, String name2, String descriptor) {
        return name2;
    }

    public String mapPackageName(String name2) {
        return name2;
    }

    public String mapModuleName(String name2) {
        return name2;
    }

    public String map(String internalName) {
        return internalName;
    }
}

