/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl;

import java.io.EOFException;
import java.io.IOError;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.function.IntSupplier;
import org.jline.terminal.MouseEvent;
import org.jline.terminal.Terminal;
import org.jline.utils.InfoCmp;
import org.jline.utils.InputStreamReader;

public class MouseSupport {
    public static boolean hasMouseSupport(Terminal terminal) {
        return terminal.getStringCapability(InfoCmp.Capability.key_mouse) != null;
    }

    public static boolean trackMouse(Terminal terminal, Terminal.MouseTracking tracking) {
        if (MouseSupport.hasMouseSupport(terminal)) {
            switch (tracking) {
                case Off: {
                    terminal.writer().write("\u001b[?1000l");
                    break;
                }
                case Normal: {
                    terminal.writer().write("\u001b[?1005h\u001b[?1000h");
                    break;
                }
                case Button: {
                    terminal.writer().write("\u001b[?1005h\u001b[?1002h");
                    break;
                }
                case Any: {
                    terminal.writer().write("\u001b[?1005h\u001b[?1003h");
                }
            }
            terminal.flush();
            return true;
        }
        return false;
    }

    public static MouseEvent readMouse(Terminal terminal, MouseEvent last) {
        return MouseSupport.readMouse(() -> MouseSupport.readExt(terminal), last);
    }

    public static MouseEvent readMouse(IntSupplier reader, MouseEvent last) {
        MouseEvent.Button button;
        MouseEvent.Type type2;
        int cb = reader.getAsInt() - 32;
        int cx = reader.getAsInt() - 32 - 1;
        int cy = reader.getAsInt() - 32 - 1;
        EnumSet<MouseEvent.Modifier> modifiers = EnumSet.noneOf(MouseEvent.Modifier.class);
        if ((cb & 4) == 4) {
            modifiers.add(MouseEvent.Modifier.Shift);
        }
        if ((cb & 8) == 8) {
            modifiers.add(MouseEvent.Modifier.Alt);
        }
        if ((cb & 0x10) == 16) {
            modifiers.add(MouseEvent.Modifier.Control);
        }
        if ((cb & 0x40) == 64) {
            type2 = MouseEvent.Type.Wheel;
            button = (cb & 1) == 1 ? MouseEvent.Button.WheelDown : MouseEvent.Button.WheelUp;
        } else {
            int b2 = cb & 3;
            switch (b2) {
                case 0: {
                    button = MouseEvent.Button.Button1;
                    if (last.getButton() == button && (last.getType() == MouseEvent.Type.Pressed || last.getType() == MouseEvent.Type.Dragged)) {
                        type2 = MouseEvent.Type.Dragged;
                        break;
                    }
                    type2 = MouseEvent.Type.Pressed;
                    break;
                }
                case 1: {
                    button = MouseEvent.Button.Button2;
                    if (last.getButton() == button && (last.getType() == MouseEvent.Type.Pressed || last.getType() == MouseEvent.Type.Dragged)) {
                        type2 = MouseEvent.Type.Dragged;
                        break;
                    }
                    type2 = MouseEvent.Type.Pressed;
                    break;
                }
                case 2: {
                    button = MouseEvent.Button.Button3;
                    if (last.getButton() == button && (last.getType() == MouseEvent.Type.Pressed || last.getType() == MouseEvent.Type.Dragged)) {
                        type2 = MouseEvent.Type.Dragged;
                        break;
                    }
                    type2 = MouseEvent.Type.Pressed;
                    break;
                }
                default: {
                    if (last.getType() == MouseEvent.Type.Pressed || last.getType() == MouseEvent.Type.Dragged) {
                        button = last.getButton();
                        type2 = MouseEvent.Type.Released;
                        break;
                    }
                    button = MouseEvent.Button.NoButton;
                    type2 = MouseEvent.Type.Moved;
                }
            }
        }
        return new MouseEvent(type2, button, modifiers, cx, cy);
    }

    private static int readExt(Terminal terminal) {
        try {
            int c2 = terminal.encoding() != StandardCharsets.UTF_8 ? new InputStreamReader(terminal.input(), StandardCharsets.UTF_8).read() : terminal.reader().read();
            if (c2 < 0) {
                throw new EOFException();
            }
            return c2;
        }
        catch (IOException e2) {
            throw new IOError(e2);
        }
    }
}

