/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.debug.util;

import com.intellij.kotlin.jupyter.core.debug.util.CellUtilKt;
import com.intellij.kotlin.jupyter.core.logging.KotlinNotebookLoggerFactory;
import com.intellij.kotlin.jupyter.core.util.UtilKt;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterPsiCell;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u0000 (2\u00020\u0001:\u0001(B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J%\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\t2\b\u0010\u001f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010 \u001a\u00020\u000b\u00a2\u0006\u0002\u0010!J\u0006\u0010\"\u001a\u00020\u001dJ\u0006\u0010#\u001a\u00020\u001dJ\u0010\u0010$\u001a\u0004\u0018\u00010\t2\u0006\u0010%\u001a\u00020\bJ\u0010\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\u0003H\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\f0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\"\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R(\u0010\u0018\u001a\u0004\u0018\u00010\u00032\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u0005\u00a8\u0006)"}, d2={"Lcom/intellij/kotlin/jupyter/core/debug/util/ExecutedPresentCellInfo;", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "<init>", "(Lcom/intellij/psi/PsiFile;)V", "knownCellClasses", "", "", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterPsiCell;", "cellOrdinalToClassName", "", "", "getCellOrdinalToClassName", "()Ljava/util/Map;", "classNameToCellOrdinal", "getClassNameToCellOrdinal", "cells", "", "getCells", "()Ljava/util/List;", "setCells", "(Ljava/util/List;)V", "value", "jupyterFile", "getJupyterFile", "()Lcom/intellij/psi/PsiFile;", "setJupyterFile", "updateInfoBeforeCellExecution", "", "cell", "ordinal", "nextCompiledClassNumber", "(Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterPsiCell;Ljava/lang/Integer;I)V", "clear", "structureChanged", "correspondingCellToClass", "cellClassName", "updateCellsByFile", "file", "Companion", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\ncellUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 cellUtil.kt\ncom/intellij/kotlin/jupyter/core/debug/util/ExecutedPresentCellInfo\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 KotlinNotebookLoggerFactory.kt\ncom/intellij/kotlin/jupyter/core/logging/KotlinNotebookLoggerFactoryKt\n*L\n1#1,103:1\n216#2:104\n217#2:108\n1863#3:105\n1864#3:107\n1#4:106\n13#5:109\n*S KotlinDebug\n*F\n+ 1 cellUtil.kt\ncom/intellij/kotlin/jupyter/core/debug/util/ExecutedPresentCellInfo\n*L\n54#1:104\n54#1:108\n55#1:105\n55#1:107\n79#1:109\n*E\n"})
public final class ExecutedPresentCellInfo {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Map<String, JupyterPsiCell> knownCellClasses = new LinkedHashMap();
    @NotNull
    private final Map<Integer, Set<String>> cellOrdinalToClassName = new LinkedHashMap();
    @NotNull
    private final Map<String, Integer> classNameToCellOrdinal = new LinkedHashMap();
    @Nullable
    private List<? extends JupyterPsiCell> cells;
    @Nullable
    private PsiFile jupyterFile;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Key<Pair<String, String>> NOTEBOOK_CELL_INTERNAL_INFO_KEY;

    public ExecutedPresentCellInfo(@Nullable PsiFile psiFile) {
        this.jupyterFile = psiFile;
    }

    @NotNull
    public final Map<Integer, Set<String>> getCellOrdinalToClassName() {
        return this.cellOrdinalToClassName;
    }

    @NotNull
    public final Map<String, Integer> getClassNameToCellOrdinal() {
        return this.classNameToCellOrdinal;
    }

    @Nullable
    public final List<JupyterPsiCell> getCells() {
        return this.cells;
    }

    public final void setCells(@Nullable List<? extends JupyterPsiCell> list) {
        this.cells = list;
    }

    @Nullable
    public final PsiFile getJupyterFile() {
        return this.jupyterFile;
    }

    public final void setJupyterFile(@Nullable PsiFile value) {
        this.jupyterFile = value;
        if (value != null) {
            this.updateCellsByFile(value);
        } else {
            this.cells = null;
        }
        this.knownCellClasses.clear();
    }

    public final void updateInfoBeforeCellExecution(@NotNull JupyterPsiCell cell, @Nullable Integer ordinal, int nextCompiledClassNumber) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        String was = Companion.updateCellInjectedInfo(cell, nextCompiledClassNumber);
        Integer n = ordinal;
        if (n == null) {
            List<? extends JupyterPsiCell> list = this.cells;
            n = list != null ? Integer.valueOf(list.indexOf(cell)) : null;
        }
        Integer cellOrdinal = n;
        String compiledName = CellUtilKt.toCompiledCellSnippedName(nextCompiledClassNumber);
        if (was != null && !Intrinsics.areEqual((Object)was, (Object)CellUtilKt.toCompiledCellSnippedName(nextCompiledClassNumber))) {
            this.knownCellClasses.remove(was);
        }
        this.knownCellClasses.put(compiledName, cell);
        if (cellOrdinal != null) {
            this.classNameToCellOrdinal.put(compiledName, cellOrdinal);
        }
    }

    public final void clear() {
        this.cellOrdinalToClassName.clear();
        this.classNameToCellOrdinal.clear();
        this.knownCellClasses.clear();
    }

    public final void structureChanged() {
        this.classNameToCellOrdinal.clear();
        this.knownCellClasses.clear();
        Map<Integer, Set<String>> $this$forEach$iv = this.cellOrdinalToClassName;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Integer, Set<String>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, Set<String>> element$iv;
            Map.Entry<Integer, Set<String>> entry = element$iv = iterator.next();
            boolean bl = false;
            int ind = ((Number)entry.getKey()).intValue();
            Set<String> classes = entry.getValue();
            Iterable $this$forEach$iv2 = classes;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String it = (String)element$iv2;
                boolean bl2 = false;
                Integer n = ind;
                this.classNameToCellOrdinal.put(it, n);
                JupyterPsiCell jupyterPsiCell = this.cells;
                if (jupyterPsiCell == null || (jupyterPsiCell = (JupyterPsiCell)CollectionsKt.getOrNull(jupyterPsiCell, (int)ind)) == null) continue;
                JupyterPsiCell psiCell = jupyterPsiCell;
                boolean bl3 = false;
                this.knownCellClasses.put(it, psiCell);
            }
        }
    }

    @Nullable
    public final JupyterPsiCell correspondingCellToClass(@NotNull String cellClassName) {
        Integer n;
        block7: {
            String properName;
            block6: {
                Intrinsics.checkNotNullParameter((Object)cellClassName, (String)"cellClassName");
                CharSequence charSequence = cellClassName;
                if (new Regex(".+\\..+").matches(charSequence)) {
                    charSequence = cellClassName;
                    Regex regex2 = new Regex("\\.");
                    int n2 = 0;
                    List it = regex2.split(charSequence, n2);
                    boolean bl = false;
                    v0 = Intrinsics.areEqual(it.get(1), (Object)"jupyter") ? it.get(0) + "_" + it.get(1) : (String)CollectionsKt.first((List)it);
                } else {
                    v0 = properName = cellClassName;
                }
                if ((n = this.classNameToCellOrdinal.get(properName)) == null) break block6;
                int it = ((Number)n).intValue();
                boolean bl = false;
                PsiFile file = this.jupyterFile;
                if (this.cells == null && file != null) {
                    this.updateCellsByFile(file);
                }
                List<? extends JupyterPsiCell> list = this.cells;
                JupyterPsiCell jupyterPsiCell = list != null ? (JupyterPsiCell)CollectionsKt.getOrNull(list, (int)it) : null;
                n = jupyterPsiCell;
                if (jupyterPsiCell != null) break block7;
            }
            n = this.knownCellClasses.get(properName);
        }
        return n;
    }

    private final void updateCellsByFile(PsiFile file) {
        this.cells = (List)ActionsKt.runReadAction(() -> ExecutedPresentCellInfo.updateCellsByFile$lambda$5(file));
    }

    private static final List updateCellsByFile$lambda$5(PsiFile $file) {
        return UtilKt.getNotebookCells($file);
    }

    static {
        Companion $this$notebookLogger$iv = Companion = new Companion(null);
        boolean $i$f$notebookLogger = false;
        LOG = KotlinNotebookLoggerFactory.INSTANCE.getInstance(Reflection.getOrCreateKotlinClass(Companion.class));
        Key key = Key.create((String)"NOTEBOOK_CELL_INTERNAL_INFO_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        NOTEBOOK_CELL_INTERNAL_INFO_KEY = key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R@\u0010\u0006\u001a1\u0012(\u0012&\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t \n*\u0012\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lcom/intellij/kotlin/jupyter/core/debug/util/ExecutedPresentCellInfo$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "NOTEBOOK_CELL_INTERNAL_INFO_KEY", "Lcom/intellij/openapi/util/Key;", "Lkotlin/Pair;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getNOTEBOOK_CELL_INTERNAL_INFO_KEY", "()Lcom/intellij/openapi/util/Key;", "updateCellInjectedInfo", "cell", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterPsiCell;", "execNum", "", "intellij.kotlin.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Pair<String, String>> getNOTEBOOK_CELL_INTERNAL_INFO_KEY() {
            return NOTEBOOK_CELL_INTERNAL_INFO_KEY;
        }

        @Nullable
        public final String updateCellInjectedInfo(@NotNull JupyterPsiCell cell, int execNum) {
            Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
            Pair was = (Pair)cell.getUserData(this.getNOTEBOOK_CELL_INTERNAL_INFO_KEY());
            String snippedName = CellUtilKt.toCompiledCellSnippedName(execNum);
            Pair pair2 = was;
            if (Intrinsics.areEqual((Object)(pair2 != null ? (String)pair2.getFirst() : null), (Object)snippedName)) {
                return (String)was.getFirst();
            }
            Pair pair3 = was;
            cell.putUserData(this.getNOTEBOOK_CELL_INTERNAL_INFO_KEY(), (Object)new Pair((Object)snippedName, (Object)(pair3 != null ? (String)pair3.getFirst() : null)));
            LOG.debug("Putting into cell: \n " + cell.getText() + "\n info: Line_" + execNum + "_jupyter; was: " + was);
            Pair pair4 = was;
            return pair4 != null ? (String)pair4.getFirst() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

