/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.dnd;

import com.intellij.jupyter.core.editor.handlers.DataframeVariableNameSuggester;
import com.intellij.kotlin.jupyter.core.editor.dnd.NameUtilKt;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/dnd/KotlinDataframeVariableNameSuggester;", "Lcom/intellij/jupyter/core/editor/handlers/DataframeVariableNameSuggester;", "<init>", "()V", "suggestVariableName", "", "fileNameWithoutExtension", "namesValidator", "Lcom/intellij/lang/refactoring/NamesValidator;", "onlyLatinRegex", "Lkotlin/text/Regex;", "isValidIdentifier", "", "name", "project", "Lcom/intellij/openapi/project/Project;", "intellij.kotlin.jupyter.core"})
public final class KotlinDataframeVariableNameSuggester
implements DataframeVariableNameSuggester {
    @NotNull
    public static final KotlinDataframeVariableNameSuggester INSTANCE = new KotlinDataframeVariableNameSuggester();
    @NotNull
    private static final NamesValidator namesValidator;
    @NotNull
    private static final Regex onlyLatinRegex;

    private KotlinDataframeVariableNameSuggester() {
    }

    @NotNull
    public String suggestVariableName(@NotNull String fileNameWithoutExtension) {
        Intrinsics.checkNotNullParameter((Object)fileNameWithoutExtension, (String)"fileNameWithoutExtension");
        return NameUtilKt.toCamelCase$default(fileNameWithoutExtension, null, 1, null);
    }

    public boolean isValidIdentifier(@NotNull String name, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return onlyLatinRegex.matches((CharSequence)name) && namesValidator.isIdentifier(name, project);
    }

    static {
        NamesValidator namesValidator = LanguageNamesValidation.INSTANCE.forLanguage((Language)KotlinLanguage.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)namesValidator, (String)"forLanguage(...)");
        KotlinDataframeVariableNameSuggester.namesValidator = namesValidator;
        onlyLatinRegex = new Regex("[a-zA-Z0-9_]+");
    }
}

