/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.highlighting.service;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSession;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterExecutionState;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterRuntimeService;
import com.intellij.kotlin.jupyter.core.editor.highlighting.events.ExecutionCallbackRegistered;
import com.intellij.kotlin.jupyter.core.editor.highlighting.events.ExecutionCallbackUnregistered;
import com.intellij.kotlin.jupyter.core.editor.highlighting.events.NotebookExecutionRelatedEventsProcessor;
import com.intellij.kotlin.jupyter.core.editor.highlighting.service.NotebookHighlightingManager;
import com.intellij.kotlin.jupyter.core.editor.highlighting.service.NotebookHighlightingService;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.events.NotebookSessionEventListener;
import com.intellij.kotlin.jupyter.core.logging.KotlinNotebookLoggerFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 *2\u00020\u0001:\u0001*B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0016J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0016H\u0002J0\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00132\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00162\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J&\u0010\u001e\u001a\u00020\u001c2\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00162\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020 2\u0006\u0010\"\u001a\u00020%H\u0016J\u000e\u0010&\u001a\u00020\u001c*\u0004\u0018\u00010\tH\u0002J \u0010'\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/highlighting/service/NotebookCellExecutionHighlightingHelper;", "Lcom/intellij/kotlin/jupyter/core/editor/highlighting/events/NotebookExecutionRelatedEventsProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "notebookFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;)V", "jupyterNotebookSession", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterNotebookSession;", "getJupyterNotebookSession", "()Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterNotebookSession;", "dataLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "executionState", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/kotlin/jupyter/core/editor/highlighting/service/NotebookCellExecutionHighlightingHelper$Companion$ExecutionState;", "kotlin.jvm.PlatformType", "lastExecutedIndexes", "", "", "getLastExecutedCellsBatch", "", "reduceAfterExecutionTargets", "completedElements", "expandAfterExecutionTargets", "currentToHLQueue", "isCanModifyRequestData", "", "scriptingStateFlag", "daemonFinished", "onSessionRestarted", "", "registerNewCallback", "event", "Lcom/intellij/kotlin/jupyter/core/editor/highlighting/events/ExecutionCallbackRegistered;", "unregisterCallback", "Lcom/intellij/kotlin/jupyter/core/editor/highlighting/events/ExecutionCallbackUnregistered;", "isKernelBusy", "queueCurrentCell", "file", "index", "Companion", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nNotebookCellExecutionHighlightingHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookCellExecutionHighlightingHelper.kt\ncom/intellij/kotlin/jupyter/core/editor/highlighting/service/NotebookCellExecutionHighlightingHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 collections.kt\norg/jetbrains/kotlin/utils/CollectionsKt\n+ 4 sync.kt\ncom/intellij/kotlin/jupyter/core/util/SyncKt\n+ 5 KotlinNotebookLoggerFactory.kt\ncom/intellij/kotlin/jupyter/core/logging/KotlinNotebookLoggerFactoryKt\n*L\n1#1,143:1\n1#2:144\n58#3:145\n36#4,2:146\n28#4,2:148\n36#4,2:150\n36#4,2:152\n13#5:154\n*S KotlinDebug\n*F\n+ 1 NotebookCellExecutionHighlightingHelper.kt\ncom/intellij/kotlin/jupyter/core/editor/highlighting/service/NotebookCellExecutionHighlightingHelper\n*L\n56#1:145\n65#1:146,2\n72#1:148,2\n75#1:150,2\n106#1:152,2\n26#1:154\n*E\n"})
public final class NotebookCellExecutionHighlightingHelper
implements NotebookExecutionRelatedEventsProcessor {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Project project;
    @NotNull
    private final BackedNotebookVirtualFile notebookFile;
    @NotNull
    private final ReentrantReadWriteLock dataLock;
    @NotNull
    private final AtomicReference<Companion.ExecutionState> executionState;
    @NotNull
    private final Set<Integer> lastExecutedIndexes;
    @NotNull
    private static final Logger LOG;
    private static final int cellToHighlightLimit;

    public NotebookCellExecutionHighlightingHelper(@NotNull Project project, @NotNull BackedNotebookVirtualFile notebookFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
        this.project = project;
        this.notebookFile = notebookFile;
        NotebookHighlightingService parentDisposable = NotebookHighlightingService.Companion.getInstance(this.project);
        this.project.getMessageBus().connect((Disposable)parentDisposable).subscribe(NotebookSessionEventListener.Companion.getTOPIC(), (Object)new NotebookSessionEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Override
            public void sessionStarted(BackedNotebookVirtualFile virtualFile, boolean isAfterRestart) {
                void $this$withWriteLock$iv;
                Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
                ReentrantReadWriteLock reentrantReadWriteLock = dataLock;
                NotebookCellExecutionHighlightingHelper notebookCellExecutionHighlightingHelper = this;
                boolean $i$f$withWriteLock = false;
                void var6_6 = $this$withWriteLock$iv;
                ReentrantReadWriteLock.ReadLock readLock = var6_6.readLock();
                int n = var6_6.getWriteHoldCount() == 0 ? var6_6.getReadHoldCount() : 0;
                for (int i = 0; i < n; ++i) {
                    readLock.unlock();
                }
                ReentrantReadWriteLock.WriteLock writeLock = var6_6.writeLock();
                writeLock.lock();
                try {
                    boolean bl = false;
                    boolean bl2 = false;
                    notebookCellExecutionHighlightingHelper.lastExecutedIndexes.clear();
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    for (int i = 0; i < n; ++i) {
                        readLock.lock();
                    }
                    writeLock.unlock();
                }
            }
        });
        this.dataLock = new ReentrantReadWriteLock();
        this.executionState = new AtomicReference<Companion.ExecutionState>(Companion.ExecutionState.IDLE);
        this.lastExecutedIndexes = new LinkedHashSet();
    }

    private final JupyterNotebookSession getJupyterNotebookSession() {
        return JupyterRuntimeService.Companion.getInstance(this.project).getNotebookSession(this.notebookFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Set<Integer> getLastExecutedCellsBatch() {
        Set set;
        ReentrantReadWriteLock.ReadLock readLock = this.dataLock.readLock();
        readLock.lock();
        try {
            Set set2;
            boolean bl = false;
            Set indexes = this.lastExecutedIndexes;
            boolean bl2 = false;
            Collection $this$ifEmpty$iv = indexes;
            boolean $i$f$ifEmpty = false;
            if ($this$ifEmpty$iv.isEmpty()) {
                boolean bl3 = false;
                set2 = new LinkedHashSet();
            } else {
                set2 = indexes.size() < cellToHighlightLimit ? indexes : CollectionsKt.toSet((Iterable)CollectionsKt.take((Iterable)indexes, (int)cellToHighlightLimit));
            }
            set = set2;
        }
        finally {
            readLock.unlock();
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Set<Integer> reduceAfterExecutionTargets(Set<Integer> completedElements) {
        Set<Integer> set;
        ReentrantReadWriteLock $this$withWriteLock$iv = this.dataLock;
        boolean $i$f$withWriteLock = false;
        ReentrantReadWriteLock reentrantReadWriteLock = $this$withWriteLock$iv;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            boolean bl2 = false;
            this.lastExecutedIndexes.removeIf(arg_0 -> NotebookCellExecutionHighlightingHelper.reduceAfterExecutionTargets$lambda$5$lambda$4(arg_0 -> NotebookCellExecutionHighlightingHelper.reduceAfterExecutionTargets$lambda$5$lambda$3(completedElements, arg_0), arg_0));
            set = this.lastExecutedIndexes;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Set<Integer> expandAfterExecutionTargets(Set<Integer> completedElements, Set<Integer> currentToHLQueue) {
        Set<Integer> set;
        Set<Integer> $i$a$-read-SyncKt$withReadLock$1$iv22;
        ReentrantReadWriteLock $this$withReadLock$iv = this.dataLock;
        boolean $i$f$withReadLock = false;
        ReentrantReadWriteLock.ReadLock readLock = $this$withReadLock$iv.readLock();
        readLock.lock();
        try {
            boolean $i$a$-read-SyncKt$withReadLock$1$iv22 = false;
            boolean bl = false;
            $i$a$-read-SyncKt$withReadLock$1$iv22 = this.lastExecutedIndexes;
        }
        finally {
            readLock.unlock();
        }
        Set<Integer> currentTargets = $i$a$-read-SyncKt$withReadLock$1$iv22;
        Set<Integer> set2 = currentToHLQueue;
        if (set2 != null) {
            set2.removeIf(arg_0 -> NotebookCellExecutionHighlightingHelper.expandAfterExecutionTargets$lambda$8(arg_0 -> NotebookCellExecutionHighlightingHelper.expandAfterExecutionTargets$lambda$7(currentTargets, arg_0), arg_0));
        }
        Set<Integer> set3 = completedElements;
        if (set3 != null) {
            Set<Integer> it = set3;
            boolean bl = false;
            ReentrantReadWriteLock $this$withWriteLock$iv = this.dataLock;
            boolean $i$f$withWriteLock = false;
            ReentrantReadWriteLock reentrantReadWriteLock = $this$withWriteLock$iv;
            ReentrantReadWriteLock.ReadLock readLock2 = reentrantReadWriteLock.readLock();
            int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            for (int i = 0; i < n; ++i) {
                readLock2.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl2 = false;
                boolean bl3 = false;
                this.lastExecutedIndexes.addAll((Collection<Integer>)completedElements);
                Set<Integer> set4 = this.lastExecutedIndexes;
                set = set4;
            }
            finally {
                for (int i = 0; i < n; ++i) {
                    readLock2.lock();
                }
                writeLock.unlock();
            }
        } else {
            set = null;
        }
        Set<Integer> updated = set;
        LOG.debug("Completed elements: " + completedElements + ", after execution data: " + updated);
        return updated;
    }

    private final boolean isCanModifyRequestData(boolean scriptingStateFlag) {
        boolean bl;
        if (this.getJupyterNotebookSession() == null) {
            this.executionState.set(Companion.ExecutionState.IDLE);
            bl = true;
        } else {
            bl = scriptingStateFlag && !this.isKernelBusy(this.getJupyterNotebookSession()) && this.executionState.get() != Companion.ExecutionState.PENDING_REQUEST;
        }
        return bl;
    }

    public final boolean daemonFinished(@Nullable Set<Integer> completedElements, @Nullable Set<Integer> currentToHLQueue) {
        Set<Integer> remainingData;
        Set<Integer> set = remainingData = this.reduceAfterExecutionTargets(completedElements);
        if (set != null) {
            Set<Integer> it = set;
            boolean bl = false;
            Set<Integer> set2 = currentToHLQueue;
            if (set2 != null) {
                set2.addAll((Collection<Integer>)it);
            }
        }
        Collection collection = remainingData;
        return collection == null || collection.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSessionRestarted() {
        ReentrantReadWriteLock $this$withWriteLock$iv = this.dataLock;
        boolean $i$f$withWriteLock = false;
        ReentrantReadWriteLock reentrantReadWriteLock = $this$withWriteLock$iv;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            boolean bl2 = false;
            this.lastExecutedIndexes.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    @Override
    public void registerNewCallback(@NotNull ExecutionCallbackRegistered event) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Integer n = event.getCellOrd();
            if (n == null) break block1;
            int it = ((Number)n).intValue();
            boolean bl = false;
            if (this.executionState.compareAndSet(Companion.ExecutionState.IDLE, Companion.ExecutionState.PENDING_REQUEST)) {
                LOG.info("Set execution state to PENDING_REQUEST");
            }
            this.lastExecutedIndexes.add(it);
        }
    }

    @Override
    public void unregisterCallback(@NotNull ExecutionCallbackUnregistered event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        int size = event.getRemainingExecutions().size();
        if (!(size <= 0 || event.isAfterSeriesOfRuns() && size <= cellToHighlightLimit)) {
            this.queueCurrentCell(this.project, this.notebookFile, event.getCellOrd());
        }
        if (size == 0) {
            this.executionState.set(Companion.ExecutionState.IDLE);
            LOG.info("Set execution state to IDLE");
        }
    }

    private final boolean isKernelBusy(JupyterNotebookSession $this$isKernelBusy) {
        JupyterNotebookSession jupyterNotebookSession = $this$isKernelBusy;
        return jupyterNotebookSession == null ? false : jupyterNotebookSession.getKernelClient().getExecutionState() == JupyterExecutionState.BUSY;
    }

    private final void queueCurrentCell(Project project, BackedNotebookVirtualFile file, int index) {
        NotebookHighlightingManager highlightingManager = NotebookHighlightingService.Companion.getForFile(project, file);
        Integer n = highlightingManager.getCompleteRangeInd();
        int n2 = index;
        if (n != null && n == n2) {
            this.lastExecutedIndexes.add(index);
        }
    }

    private static final boolean reduceAfterExecutionTargets$lambda$5$lambda$3(Set $completedElements, Integer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Set set = $completedElements;
        return set != null ? set.contains(it) : false;
    }

    private static final boolean reduceAfterExecutionTargets$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean expandAfterExecutionTargets$lambda$7(Set $currentTargets, Integer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !$currentTargets.contains(it);
    }

    private static final boolean expandAfterExecutionTargets$lambda$8(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Companion $this$notebookLogger$iv = Companion = new Companion(null);
        boolean $i$f$notebookLogger = false;
        LOG = KotlinNotebookLoggerFactory.INSTANCE.getInstance(Reflection.getOrCreateKotlinClass(Companion.class));
        cellToHighlightLimit = Runtime.getRuntime().availableProcessors() / 2 - 1;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/highlighting/service/NotebookCellExecutionHighlightingHelper$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "cellToHighlightLimit", "", "ExecutionState", "intellij.kotlin.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/highlighting/service/NotebookCellExecutionHighlightingHelper$Companion$ExecutionState;", "", "<init>", "(Ljava/lang/String;I)V", "PENDING_REQUEST", "IDLE", "intellij.kotlin.jupyter.core"})
        private static final class ExecutionState
        extends Enum<ExecutionState> {
            public static final /* enum */ ExecutionState PENDING_REQUEST = new ExecutionState();
            public static final /* enum */ ExecutionState IDLE = new ExecutionState();
            private static final /* synthetic */ ExecutionState[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static ExecutionState[] values() {
                return (ExecutionState[])$VALUES.clone();
            }

            public static ExecutionState valueOf(String value) {
                return Enum.valueOf(ExecutionState.class, value);
            }

            @NotNull
            public static EnumEntries<ExecutionState> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = executionStateArray = new ExecutionState[]{ExecutionState.PENDING_REQUEST, ExecutionState.IDLE};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }
}

