/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.highlighting.service.components;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.kotlin.jupyter.core.editor.highlighting.service.markup.MarkupModelListenerPluginAwareProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.Disposer;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ+\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0\n2\b\u0010 \u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010!J\u0006\u0010\"\u001a\u00020\u0019J\b\u0010#\u001a\u00020\u0019H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rRC\u0010\u000e\u001a2\u0012\u000e\u0012\f0\u000b\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u0010 \u0012*\u0017\u0012\u000e\u0012\f0\u000b\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u00100\u0011\u00a2\u0006\u0002\b\u000f0\n\u00a2\u0006\u0002\b\u000f\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/highlighting/service/components/ErrorHighlightersProcessor;", "Lcom/intellij/openapi/Disposable;", "parentDisposable", "sharedLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "<init>", "(Lcom/intellij/openapi/Disposable;Lcom/intellij/openapi/diagnostic/Logger;)V", "fileIndexesToErrors", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "getFileIndexesToErrors", "()Ljava/util/concurrent/ConcurrentHashMap;", "targetErrorHighlighters", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "kotlin.jvm.PlatformType", "getTargetErrorHighlighters", "()Ljava/util/Set;", "Ljava/util/Set;", "activeMarkupModelListener", "Lcom/intellij/openapi/editor/impl/event/MarkupModelListener;", "addMarkupListener", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "determineFilesWithLeftErrors", "markupModel", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "finishedFilesIndexes", "completeIndexTarget", "(Lcom/intellij/openapi/editor/ex/MarkupModelEx;Ljava/util/Set;Ljava/lang/Integer;)V", "clear", "dispose", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nErrorHighlightersProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ErrorHighlightersProcessor.kt\ncom/intellij/kotlin/jupyter/core/editor/highlighting/service/components/ErrorHighlightersProcessor\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n487#2,7:95\n535#2:106\n520#2,6:107\n216#3,2:102\n1863#4,2:104\n*S KotlinDebug\n*F\n+ 1 ErrorHighlightersProcessor.kt\ncom/intellij/kotlin/jupyter/core/editor/highlighting/service/components/ErrorHighlightersProcessor\n*L\n59#1:95,7\n75#1:106\n75#1:107,6\n61#1:102,2\n72#1:104,2\n*E\n"})
public final class ErrorHighlightersProcessor
implements Disposable {
    @NotNull
    private final Logger sharedLogger;
    @NotNull
    private final ConcurrentHashMap<Integer, Set<RangeHighlighter>> fileIndexesToErrors;
    @NotNull
    private final Set<RangeHighlighter> targetErrorHighlighters;
    private MarkupModelListener activeMarkupModelListener;

    public ErrorHighlightersProcessor(@NotNull Disposable parentDisposable, @NotNull Logger sharedLogger) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)sharedLogger, (String)"sharedLogger");
        this.sharedLogger = sharedLogger;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.fileIndexesToErrors = new ConcurrentHashMap();
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this.targetErrorHighlighters = set;
    }

    @NotNull
    public final ConcurrentHashMap<Integer, Set<RangeHighlighter>> getFileIndexesToErrors() {
        return this.fileIndexesToErrors;
    }

    @NotNull
    public final Set<RangeHighlighter> getTargetErrorHighlighters() {
        return this.targetErrorHighlighters;
    }

    public final void addMarkupListener(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.activeMarkupModelListener = MarkupModelListenerPluginAwareProvider.INSTANCE.provideListener(this.targetErrorHighlighters);
        EditorEx editorEx = editor instanceof EditorEx ? (EditorEx)editor : null;
        if (editorEx == null) {
            return;
        }
        EditorEx editorEx2 = editorEx;
        Editor editor2 = editor;
        EditorImpl editorImpl = editor2 instanceof EditorImpl ? (EditorImpl)editor2 : null;
        if (editorImpl == null || (editorImpl = editorImpl.getDisposable()) == null) {
            editorImpl = this;
        }
        EditorImpl suitableParent = editorImpl;
        MarkupModelEx markupModelEx = editorEx2.getFilteredDocumentMarkupModel();
        MarkupModelListener markupModelListener = this.activeMarkupModelListener;
        if (markupModelListener == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activeMarkupModelListener");
            markupModelListener = null;
        }
        markupModelEx.addMarkupModelListener((Disposable)suitableParent, markupModelListener);
    }

    public final void determineFilesWithLeftErrors(@NotNull MarkupModelEx markupModel, @NotNull Set<Integer> finishedFilesIndexes, @Nullable Integer completeIndexTarget) {
        Set set;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)markupModel, (String)"markupModel");
        Intrinsics.checkNotNullParameter(finishedFilesIndexes, (String)"finishedFilesIndexes");
        Map $this$filterKeys$iv = this.fileIndexesToErrors;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterKeys$iv.entrySet()) {
            int it = ((Number)entry.getKey()).intValue();
            bl = false;
            Integer n = completeIndexTarget;
            if (!(n == null || it != n)) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        Map keys = result$iv;
        Set toRemove = new LinkedHashSet();
        Object $this$forEach$iv = keys;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Set<RangeHighlighter> data;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            bl = false;
            Set<RangeHighlighter> set2 = data = this.fileIndexesToErrors.get(entry2.getKey());
            if (set2 != null) {
                set2.removeIf(arg_0 -> ErrorHighlightersProcessor.determineFilesWithLeftErrors$lambda$3$lambda$2(arg_0 -> ErrorHighlightersProcessor.determineFilesWithLeftErrors$lambda$3$lambda$1(markupModel, arg_0), arg_0));
            }
            Set<RangeHighlighter> set3 = data;
            boolean bl2 = set3 != null ? set3.isEmpty() : false;
            if (!bl2) continue;
            toRemove.add(entry2.getKey());
        }
        Integer n = completeIndexTarget;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl3 = false;
            Set<RangeHighlighter> set4 = this.fileIndexesToErrors.get(it);
            if (set4 != null) {
                set4.addAll((Collection<RangeHighlighter>)this.targetErrorHighlighters);
            }
        }
        $this$forEach$iv = toRemove;
        $i$f$forEach = false;
        Iterator bl3 = $this$forEach$iv.iterator();
        while (bl3.hasNext()) {
            Object t = bl3.next();
            int it = ((Number)t).intValue();
            boolean bl32 = false;
            this.fileIndexesToErrors.remove(it);
        }
        boolean targetPassed = CollectionsKt.contains((Iterable)finishedFilesIndexes, (Object)completeIndexTarget);
        Map $this$filter$iv = this.fileIndexesToErrors;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl4 = false;
            Integer n2 = completeIndexTarget;
            boolean bl5 = n2 == null || ((Number)it.getKey()).intValue() != n2.intValue() ? !((Collection)it.getValue()).isEmpty() : !targetPassed;
            if (!bl5) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Set it = set = destination$iv$iv.keySet();
        boolean bl6 = false;
        if (!((Collection)it).isEmpty()) {
            finishedFilesIndexes.removeAll(it);
            this.sharedLogger.debug("Daemon finished, knownErrorInd: " + this.fileIndexesToErrors.keySet() + ", recycled errors in ind: " + toRemove + ", remaining: " + it);
        }
    }

    public final void clear() {
        this.targetErrorHighlighters.clear();
        this.fileIndexesToErrors.clear();
    }

    public void dispose() {
        this.clear();
    }

    private static final boolean determineFilesWithLeftErrors$lambda$3$lambda$1(MarkupModelEx $markupModel, RangeHighlighter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getLayer() == -1 || !it.isValid() || !$markupModel.containsHighlighter(it);
    }

    private static final boolean determineFilesWithLeftErrors$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

