/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.typing;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.InlayHintsPassFactoryInternal;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.kotlin.jupyter.core.editor.highlighting.events.NotebookCaretMovementEvent;
import com.intellij.kotlin.jupyter.core.editor.highlighting.service.NotebookHighlightingManager;
import com.intellij.kotlin.jupyter.core.editor.highlighting.service.NotebookHighlightingService;
import com.intellij.kotlin.jupyter.core.editor.highlighting.service.NotebookPerFileHighlightingMetaDataController;
import com.intellij.kotlin.jupyter.core.editor.typing.NotebookCaretListener;
import com.intellij.kotlin.jupyter.core.editor.typing.NotebookCellHighlightingTrigger;
import com.intellij.kotlin.jupyter.core.editor.typing.daemon.NotebookHighlightingDaemonListener;
import com.intellij.kotlin.jupyter.core.editor.typing.state.NotebookCaretStateProcessor;
import com.intellij.kotlin.jupyter.core.logging.KotlinNotebookLoggerFactory;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookProjectOptionsProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiFile;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 %2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001%B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001aH\u0016J \u0010\u001e\u001a\u00020\u001a2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u0006\u0010$\u001a\u00020\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/typing/NotebookCaretListener;", "Lcom/intellij/openapi/editor/event/CaretListener;", "Lcom/intellij/kotlin/jupyter/core/editor/typing/NotebookCellHighlightingTrigger;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "vFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "parentDisposable", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/Disposable;)V", "projectOptionsProvider", "Lcom/intellij/kotlin/jupyter/core/settings/KotlinNotebookProjectOptionsProvider;", "codeAnalyzer", "Lcom/intellij/codeInsight/daemon/DaemonCodeAnalyzer;", "kotlin.jvm.PlatformType", "Lcom/intellij/codeInsight/daemon/DaemonCodeAnalyzer;", "notebookHighlightingManager", "Lcom/intellij/kotlin/jupyter/core/editor/highlighting/service/NotebookHighlightingManager;", "dataController", "Lcom/intellij/kotlin/jupyter/core/editor/highlighting/service/NotebookPerFileHighlightingMetaDataController;", "caretStateProcessor", "Lcom/intellij/kotlin/jupyter/core/editor/typing/state/NotebookCaretStateProcessor;", "caretPositionChanged", "", "event", "Lcom/intellij/openapi/editor/event/CaretEvent;", "dispose", "performRangedUpdate", "reducedIndexes", "", "", "context", "Lkotlinx/coroutines/CoroutineScope;", "resetState", "Companion", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nNotebookCaretListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookCaretListener.kt\ncom/intellij/kotlin/jupyter/core/editor/typing/NotebookCaretListener\n+ 2 KotlinNotebookLoggerFactory.kt\ncom/intellij/kotlin/jupyter/core/logging/KotlinNotebookLoggerFactoryKt\n*L\n1#1,92:1\n13#2:93\n*S KotlinDebug\n*F\n+ 1 NotebookCaretListener.kt\ncom/intellij/kotlin/jupyter/core/editor/typing/NotebookCaretListener\n*L\n36#1:93\n*E\n"})
public final class NotebookCaretListener
implements CaretListener,
NotebookCellHighlightingTrigger,
Disposable {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Project project;
    @NotNull
    private final Editor editor;
    @NotNull
    private final KotlinNotebookProjectOptionsProvider projectOptionsProvider;
    private final DaemonCodeAnalyzer codeAnalyzer;
    @Nullable
    private final NotebookHighlightingManager notebookHighlightingManager;
    @Nullable
    private final NotebookPerFileHighlightingMetaDataController dataController;
    @NotNull
    private final NotebookCaretStateProcessor caretStateProcessor;
    @NotNull
    private static final Logger LOG;

    public NotebookCaretListener(@NotNull Project project, @NotNull BackedNotebookVirtualFile vFile, @NotNull Editor editor, @NotNull Disposable parentDisposable) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.project = project;
        this.editor = editor;
        this.projectOptionsProvider = KotlinNotebookProjectOptionsProvider.Companion.getInstance(this.project);
        this.codeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)this.project);
        NotebookHighlightingManager notebookHighlightingManager = this.notebookHighlightingManager = NotebookHighlightingService.Companion.getHighlightingManagerForFile(vFile.getFile(), this.project);
        this.dataController = notebookHighlightingManager != null ? notebookHighlightingManager.getDataController() : null;
        this.caretStateProcessor = new NotebookCaretStateProcessor(this.editor, this.project, this.notebookHighlightingManager, this);
        boolean bl2 = bl = this.notebookHighlightingManager != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        if (this.dataController == null) {
            LOG.warn("Data controller is null during init, manager: " + this.notebookHighlightingManager);
        }
        NotebookHighlightingManager notebookHighlightingManager2 = this.notebookHighlightingManager;
        if (notebookHighlightingManager2 != null) {
            notebookHighlightingManager2.associateWithNewCaretListener(this, this.editor);
        }
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"DAEMON_EVENT_TOPIC");
        messageBusConnection.subscribe(topic, (Object)new NotebookHighlightingDaemonListener(this.caretStateProcessor));
    }

    public void caretPositionChanged(@NotNull CaretEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        NotebookCaretStateProcessor $this$caretPositionChanged_u24lambda_u240 = this.caretStateProcessor;
        boolean bl = false;
        $this$caretPositionChanged_u24lambda_u240.onEventHappened(new NotebookCaretMovementEvent(event, $this$caretPositionChanged_u24lambda_u240.getCellOrdinal(event)));
    }

    public void dispose() {
        block0: {
            NotebookHighlightingManager notebookHighlightingManager = this.notebookHighlightingManager;
            if (notebookHighlightingManager == null) break block0;
            notebookHighlightingManager.editorPotentiallyDisposed();
        }
    }

    @Override
    public void performRangedUpdate(@NotNull Collection<Integer> reducedIndexes, @Nullable CoroutineScope context) {
        NotebookHighlightingManager notebookHighlightingManager;
        Intrinsics.checkNotNullParameter(reducedIndexes, (String)"reducedIndexes");
        NotebookPerFileHighlightingMetaDataController notebookPerFileHighlightingMetaDataController = this.dataController;
        if (notebookPerFileHighlightingMetaDataController != null) {
            notebookPerFileHighlightingMetaDataController.update((Function1<? super NotebookPerFileHighlightingMetaDataController.NotebookHighlightingMetaDataConfigurator, Unit>)((Function1)arg_0 -> NotebookCaretListener.performRangedUpdate$lambda$1(reducedIndexes, arg_0)));
        }
        if ((notebookHighlightingManager = this.notebookHighlightingManager) != null && (notebookHighlightingManager = notebookHighlightingManager.getJupyterPsiFile()) != null) {
            NotebookHighlightingManager it = notebookHighlightingManager;
            boolean bl = false;
            if (this.projectOptionsProvider.getShouldLimitTypeHintsByActiveCell()) {
                InlayHintsPassFactoryInternal.Companion.clearModificationStamp(this.editor);
            }
            if ((v2 = context) == null || (v2 = BuildersKt.launch$default((CoroutineScope)v2, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, (PsiFile)it, null){
                int label;
                final /* synthetic */ NotebookCaretListener this$0;
                final /* synthetic */ PsiFile $it;
                {
                    this.this$0 = $receiver;
                    this.$it = $it;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = CoroutinesKt.readAction(() -> performRangedUpdate.2.1.invokeSuspend$lambda$0(this.this$0, this.$it), (Continuation)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final Unit invokeSuspend$lambda$0(NotebookCaretListener this$0, PsiFile $it) {
                    NotebookCaretListener.access$getCodeAnalyzer$p(this$0).restart($it);
                    return Unit.INSTANCE;
                }
            }), (int)3, null)) == null) {
                this.codeAnalyzer.restart((PsiFile)it);
                v2 = Unit.INSTANCE;
            }
        } else {
            v2 = null;
        }
    }

    public final void resetState() {
        this.caretStateProcessor.resetState();
    }

    private static final Unit performRangedUpdate$lambda$1(Collection $reducedIndexes, NotebookPerFileHighlightingMetaDataController.NotebookHighlightingMetaDataConfigurator $this$update) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
            $this$update.setNotebookDocumentTargetRanges($reducedIndexes);
            $this$update.setNotebookChangedCellIndex((Integer)CollectionsKt.last((Iterable)$reducedIndexes));
            Set<Integer> set = $this$update.getNotebookRangesQueuedForHL();
            if (set == null) break block0;
            set.addAll($reducedIndexes);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ DaemonCodeAnalyzer access$getCodeAnalyzer$p(NotebookCaretListener $this) {
        return $this.codeAnalyzer;
    }

    static {
        Companion $this$notebookLogger$iv = Companion = new Companion(null);
        boolean $i$f$notebookLogger = false;
        LOG = KotlinNotebookLoggerFactory.INSTANCE.getInstance(Reflection.getOrCreateKotlinClass(Companion.class));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/typing/NotebookCaretListener$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.kotlin.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

