/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.jupyter.actions;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.connections.action.JupyterConnectionActionExtensionsKt;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterNotebookOfflineSettings;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterNotebookRuntimeSettings;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterNotebookSessionSettings;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.ManagedJupyterServerNotebookSessionSettings;
import com.intellij.jupyter.core.jupyter.connections.server.JupyterServer;
import com.intellij.jupyter.core.jupyter.connections.server.JupyterServerUtils;
import com.intellij.jupyter.core.jupyter.helper.JupyterAnActionEventExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterDataContextExtensionsKt;
import com.intellij.kotlin.jupyter.core.jupyter.actions.JupyterNotebookDependencies;
import com.intellij.kotlin.jupyter.core.util.IsKotlinNotebookKt;
import com.intellij.notebooks.jupyter.core.icons.JupyterCoreIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.BadgeDotProvider;
import com.intellij.ui.BadgeIcon;
import com.intellij.ui.BadgeShapeProvider;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Paint;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\t0\u0010H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/kotlin/jupyter/core/jupyter/actions/JupyterKotlinRestartKernelActionUpdater;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "badgeDotProvider", "Lcom/intellij/ui/BadgeDotProvider;", "checkKernelAvailable", "callback", "Lkotlin/Function1;", "", "intellij.kotlin.jupyter.core"})
public final class JupyterKotlinRestartKernelActionUpdater {
    @NotNull
    public static final JupyterKotlinRestartKernelActionUpdater INSTANCE = new JupyterKotlinRestartKernelActionUpdater();
    @NotNull
    private static final Logger LOG;

    private JupyterKotlinRestartKernelActionUpdater() {
    }

    @NotNull
    public final Logger getLOG() {
        return LOG;
    }

    public final void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(true);
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterDataContextExtensionsKt.getJupyterNotebookFile((DataContext)dataContext);
        if (!(backedNotebookVirtualFile != null ? IsKotlinNotebookKt.isKotlinNotebook(backedNotebookVirtualFile) : false)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        this.checkKernelAvailable(e);
        e.getPresentation().setIcon(JupyterCoreIcons.RestartKernel);
        if (!e.getPresentation().isEnabled()) {
            return;
        }
        FileEditor fileEditor = (FileEditor)e.getData(PlatformDataKeys.FILE_EDITOR);
        if (fileEditor == null) {
            return;
        }
        FileEditor fileEditor2 = fileEditor;
        JupyterNotebookDependencies.Status dependenciesStatus = JupyterNotebookDependencies.INSTANCE.getStatus(fileEditor2);
        if (Intrinsics.areEqual((Object)dependenciesStatus, (Object)JupyterNotebookDependencies.Status.UpToDate.INSTANCE)) {
            return;
        }
        if (!(dependenciesStatus instanceof JupyterNotebookDependencies.Status.NotUpToDate)) {
            throw new NoWhenBranchMatchedException();
        }
        Presentation presentation = e.getPresentation();
        Icon icon = JupyterCoreIcons.RestartKernel;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"RestartKernel");
        Color color = JBUI.CurrentTheme.IconBadge.INFORMATION;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"INFORMATION");
        presentation.setIcon((Icon)new BadgeIcon(icon, (Paint)color, (BadgeShapeProvider)this.badgeDotProvider()));
        e.getPresentation().setText(JupyterBundle.message((String)"action.JupyterRestartKernelAction.text", (Object[])new Object[0]) + "<br><br>" + ((JupyterNotebookDependencies.Status.NotUpToDate)dependenciesStatus).getMessage());
    }

    private final BadgeDotProvider badgeDotProvider() {
        double defaultX = new BadgeDotProvider(0.0, 0.0, 0.0, 0.0, 15, null).getX();
        return new BadgeDotProvider(1.0 - defaultX, 0.0, 0.0, 0.0, 14, null);
    }

    private final void checkKernelAvailable(AnActionEvent e) {
        this.checkKernelAvailable(e, (Function1<? super Boolean, Unit>)((Function1)arg_0 -> JupyterKotlinRestartKernelActionUpdater.checkKernelAvailable$lambda$0(e, arg_0)));
    }

    private final void checkKernelAvailable(AnActionEvent e, Function1<? super Boolean, Unit> callback) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterAnActionEventExtensionsKt.getNotebookFile((AnActionEvent)e);
        if (backedNotebookVirtualFile == null || (backedNotebookVirtualFile = backedNotebookVirtualFile.getFile()) == null) {
            return;
        }
        BackedNotebookVirtualFile virtualFile = backedNotebookVirtualFile;
        JupyterNotebookRuntimeSettings runtimeSettings = JupyterConnectionActionExtensionsKt.getJupyterNotebookRuntimeSettings((AnActionEvent)e);
        if (runtimeSettings == null) {
            JupyterServer jupyterServer = JupyterServerUtils.INSTANCE.getJupyterServer(project2, (VirtualFile)virtualFile);
            List kernelSpecs = jupyterServer != null ? jupyterServer.getKernels() : null;
            Collection collection = kernelSpecs;
            callback.invoke((Object)(!(collection == null || collection.isEmpty()) ? 1 : 0));
        } else {
            JupyterNotebookRuntimeSettings jupyterNotebookRuntimeSettings = runtimeSettings;
            if (jupyterNotebookRuntimeSettings instanceof JupyterNotebookOfflineSettings) {
                JupyterKotlinRestartKernelActionUpdater.checkKernelAvailable$serverIsOffline(callback);
            } else if (jupyterNotebookRuntimeSettings instanceof JupyterNotebookSessionSettings) {
                JupyterKotlinRestartKernelActionUpdater.checkKernelAvailable$serverIsOnline(callback);
            } else if (jupyterNotebookRuntimeSettings instanceof ManagedJupyterServerNotebookSessionSettings) {
                if (((ManagedJupyterServerNotebookSessionSettings)runtimeSettings).getJupyterServerExecution().getState().isStarted()) {
                    JupyterKotlinRestartKernelActionUpdater.checkKernelAvailable$serverIsOnline(callback);
                } else {
                    JupyterKotlinRestartKernelActionUpdater.checkKernelAvailable$serverIsOffline(callback);
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private static final Unit checkKernelAvailable$lambda$0(AnActionEvent $e, boolean it) {
        $e.getPresentation().setEnabled(it);
        if (Intrinsics.areEqual((Object)$e.getPlace(), (Object)"ProjectViewPopup")) {
            $e.getPresentation().setVisible(it);
        }
        return Unit.INSTANCE;
    }

    private static final void checkKernelAvailable$serverIsOffline(Function1<? super Boolean, Unit> $callback) {
        $callback.invoke((Object)false);
    }

    private static final void checkKernelAvailable$serverIsOnline(Function1<? super Boolean, Unit> $callback) {
        $callback.invoke((Object)true);
    }

    static {
        Logger logger = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

