/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.jupyter.actions;

import com.intellij.icons.AllIcons;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.connections.action.JupyterShutdownNotebookActionKt;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterRuntimeService;
import com.intellij.jupyter.core.jupyter.helper.JupyterAnActionEventExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterDataContextExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.kotlin.jupyter.core.resources.i18n.KotlinNotebookBundle;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookSessionRunMode;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookSessionRunModeKt;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookSettingsKt;
import com.intellij.kotlin.jupyter.core.settings.actions.SessionShutdownPromptKt;
import com.intellij.kotlin.jupyter.core.util.IsKotlinNotebookKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.util.ThrowableRunnable;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0003\u000f\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/kotlin/jupyter/core/jupyter/actions/KotlinNotebookChangeSessionModeAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "mode", "Lcom/intellij/kotlin/jupyter/core/settings/KotlinNotebookSessionRunMode;", "<init>", "(Lcom/intellij/kotlin/jupyter/core/settings/KotlinNotebookSessionRunMode;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getKotlinNotebook", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "actionPerformed", "Lcom/intellij/kotlin/jupyter/core/jupyter/actions/KotlinNotebookEnableAttachedProcessMode;", "Lcom/intellij/kotlin/jupyter/core/jupyter/actions/KotlinNotebookEnableIdeProcessMode;", "Lcom/intellij/kotlin/jupyter/core/jupyter/actions/KotlinNotebookEnableSeparateProcessMode;", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nKotlinNotebookChangeSessionModeAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNotebookChangeSessionModeAction.kt\ncom/intellij/kotlin/jupyter/core/jupyter/actions/KotlinNotebookChangeSessionModeAction\n+ 2 SessionShutdownPrompt.kt\ncom/intellij/kotlin/jupyter/core/settings/actions/SessionShutdownPromptKt\n*L\n1#1,56:1\n27#2,12:57\n53#2,2:69\n*S KotlinDebug\n*F\n+ 1 KotlinNotebookChangeSessionModeAction.kt\ncom/intellij/kotlin/jupyter/core/jupyter/actions/KotlinNotebookChangeSessionModeAction\n*L\n41#1:57,12\n41#1:69,2\n*E\n"})
public abstract class KotlinNotebookChangeSessionModeAction
extends DumbAwareAction {
    @NotNull
    private final KotlinNotebookSessionRunMode mode;

    private KotlinNotebookChangeSessionModeAction(KotlinNotebookSessionRunMode mode) {
        this.mode = mode;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        JupyterNotebook notebook = this.getKotlinNotebook(event);
        boolean isAvailable = KotlinNotebookSessionRunModeKt.isAvailable(this.mode) && notebook != null;
        event.getPresentation().setEnabledAndVisible(isAvailable);
        if (isAvailable && KotlinNotebookSettingsKt.getSessionRunMode(notebook) == this.mode) {
            event.getPresentation().setIcon(AllIcons.Actions.Checked);
        }
    }

    private final JupyterNotebook getKotlinNotebook(AnActionEvent $this$getKotlinNotebook) {
        DataContext dataContext = $this$getKotlinNotebook.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterDataContextExtensionsKt.getNotebookFile((DataContext)dataContext);
        if (backedNotebookVirtualFile == null) {
            return null;
        }
        BackedNotebookVirtualFile notebookFile = backedNotebookVirtualFile;
        return IsKotlinNotebookKt.isKotlinNotebook(notebookFile) ? notebookFile.getNotebookOrNull() : null;
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        JupyterNotebook jupyterNotebook = JupyterDataContextExtensionsKt.getNotebook((DataContext)dataContext);
        if (jupyterNotebook == null) {
            return;
        }
        JupyterNotebook notebook = jupyterNotebook;
        if (KotlinNotebookSettingsKt.getSessionRunMode(notebook) == this.mode) {
            return;
        }
        KClass kClass = Reflection.getOrCreateKotlinClass(KotlinNotebookChangeSessionModeAction.class);
        Editor editor = JupyterAnActionEventExtensionsKt.getEditor((AnActionEvent)event);
        if (editor == null) {
            return;
        }
        Editor notebookEditor$iv = editor;
        boolean $i$f$promptSessionShutdownIfNeeded = false;
        BackedNotebookVirtualFile notebookFile$iv = JupyterEditorExtensionsKt.getNotebookFile((Editor)notebookEditor$iv);
        Project project$iv = notebookEditor$iv.getProject();
        if (IsKotlinNotebookKt.isKotlinNotebook(notebookFile$iv) && project$iv != null) {
            if (!JupyterRuntimeService.Companion.getInstance(project$iv).hasActiveSession(notebookFile$iv.getFile())) {
                boolean bl = false;
                if (KotlinNotebookSettingsKt.getSessionRunMode(notebook) != this.mode) {
                    WriteAction.run((ThrowableRunnable)new ThrowableRunnable(notebook, this){
                        final /* synthetic */ JupyterNotebook $notebook;
                        final /* synthetic */ KotlinNotebookChangeSessionModeAction this$0;
                        {
                            this.$notebook = $notebook;
                            this.this$0 = $receiver;
                        }

                        public final void run() {
                            KotlinNotebookSettingsKt.setSessionRunMode(this.$notebook, KotlinNotebookChangeSessionModeAction.access$getMode$p(this.this$0));
                        }
                    });
                }
            } else {
                void classForLogging$iv;
                ComponentsKt.dialog$default((String)KotlinNotebookBundle.message("dialog.title.session.shutdown.prompt", new Object[0]), (JComponent)((JComponent)BuilderKt.panel((Function1)SessionShutdownPromptKt.promptSessionShutdownIfNeeded.1.INSTANCE)), (boolean)false, null, (boolean)false, null, null, null, null, null, (Function0)((Function0)new Function0<List<? extends ValidationInfo>>((KClass)classForLogging$iv, notebookEditor$iv, notebook, this){
                    final /* synthetic */ KClass $classForLogging;
                    final /* synthetic */ Editor $notebookEditor;
                    final /* synthetic */ JupyterNotebook $notebook$inlined;
                    final /* synthetic */ KotlinNotebookChangeSessionModeAction this$0;
                    {
                        this.$classForLogging = $classForLogging;
                        this.$notebookEditor = $notebookEditor;
                        this.$notebook$inlined = jupyterNotebook;
                        this.this$0 = kotlinNotebookChangeSessionModeAction;
                    }

                    public final List<ValidationInfo> invoke() {
                        boolean bl = false;
                        if (KotlinNotebookSettingsKt.getSessionRunMode(this.$notebook$inlined) != KotlinNotebookChangeSessionModeAction.access$getMode$p(this.this$0)) {
                            WriteAction.run((ThrowableRunnable)new /* invalid duplicate definition of identical inner class */);
                        }
                        JupyterShutdownNotebookActionKt.shutdownNotebook((KClass)this.$classForLogging, (Project)this.$notebookEditor.getProject(), (List)CollectionsKt.listOf((Object)this.$notebookEditor), (List)CollectionsKt.emptyList());
                        return null;
                    }
                }), (int)1020, null).show();
            }
        }
    }

    public /* synthetic */ KotlinNotebookChangeSessionModeAction(KotlinNotebookSessionRunMode mode, DefaultConstructorMarker $constructor_marker) {
        this(mode);
    }
}

