/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.logging;

import com.intellij.kotlin.jupyter.core.logging.KotlinNotebookLogger;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nJ\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rJ\u0012\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/kotlin/jupyter/core/logging/KotlinNotebookLoggerFactory;", "", "<init>", "()V", "isUnitTestMode", "Ljava/util/concurrent/atomic/AtomicBoolean;", "logs", "", "Lcom/intellij/kotlin/jupyter/core/logging/KotlinNotebookLogger$LogEntry;", "enableUnitTestMode", "", "disableUnitTestMode", "getTrackedLogs", "", "getInstance", "Lcom/intellij/openapi/diagnostic/Logger;", "type", "Lkotlin/reflect/KClass;", "intellij.kotlin.jupyter.core"})
public final class KotlinNotebookLoggerFactory {
    @NotNull
    public static final KotlinNotebookLoggerFactory INSTANCE = new KotlinNotebookLoggerFactory();
    @NotNull
    private static final AtomicBoolean isUnitTestMode = new AtomicBoolean(false);
    @NotNull
    private static final List<KotlinNotebookLogger.LogEntry> logs = new ArrayList();

    private KotlinNotebookLoggerFactory() {
    }

    public final void enableUnitTestMode() {
        isUnitTestMode.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disableUnitTestMode() {
        isUnitTestMode.set(false);
        List<KotlinNotebookLogger.LogEntry> list = logs;
        synchronized (list) {
            boolean bl = false;
            logs.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public final List<KotlinNotebookLogger.LogEntry> getTrackedLogs() {
        return CollectionsKt.toList((Iterable)logs);
    }

    @NotNull
    public final Logger getInstance(@NotNull KClass<?> type2) {
        Intrinsics.checkNotNullParameter(type2, (String)"type");
        Logger logger = Logger.getInstance((Class)JvmClassMappingKt.getJavaClass(type2));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Logger systemLogger = logger;
        return isUnitTestMode.get() ? (Logger)new KotlinNotebookLogger(systemLogger, (Function1<? super KotlinNotebookLogger.LogEntry, Unit>)((Function1)KotlinNotebookLoggerFactory::getInstance$lambda$2)) : systemLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit getInstance$lambda$2(KotlinNotebookLogger.LogEntry logEntry) {
        Intrinsics.checkNotNullParameter((Object)logEntry, (String)"logEntry");
        List<KotlinNotebookLogger.LogEntry> list = logs;
        synchronized (list) {
            boolean bl = false;
            logs.add(logEntry);
            Unit unit = Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }
}

