/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.projectWizard.common;

import com.intellij.kotlin.jupyter.core.projectWizard.DefaultKotlinNotebookProject;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookApplicationOptions;
import com.intellij.kotlin.jupyter.core.settings.recents.RecentNotebook;
import com.intellij.kotlin.jupyter.core.settings.recents.RecentNotebooksSettingsUpdatingKt;
import com.intellij.kotlin.jupyter.core.statistics.fus.KotlinNotebookFeatureUsagesCollector;
import com.intellij.kotlin.jupyter.core.statistics.fus.WelcomeScreenIdeEntryType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"openNotebook", "", "notebook", "Lcom/intellij/kotlin/jupyter/core/settings/recents/RecentNotebook;", "intellij.kotlin.jupyter.core"})
public final class ActionUtilKt {
    public static final void openNotebook(@NotNull RecentNotebook notebook) {
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        KotlinNotebookFeatureUsagesCollector.Companion.registerIdeEntryFromKotlinNotebookWelcomeScreen(WelcomeScreenIdeEntryType.OPEN_RECENT_NOTEBOOK);
        Path path2 = notebook.getProjectPath().toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toNioPath(...)");
        Path projectPath = path2;
        Project project = DefaultKotlinNotebookProject.INSTANCE.getProjectWithModalProgress(projectPath);
        RecentNotebooksSettingsUpdatingKt.addRecentNotebook(KotlinNotebookApplicationOptions.INSTANCE, notebook);
        FileEditorManager.getInstance((Project)project).openFile(notebook.getPath(), true);
    }
}

