/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.tables;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookApplicationOptions;
import com.intellij.kotlin.jupyter.tables.KotlinDataFrameProvider;
import com.intellij.kotlin.jupyter.tables.KotlinDataframeParser;
import com.intellij.kotlin.jupyter.tables.KotlinDataframeParsing;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.scientific.tables.api.DSTableDataProvider;
import com.intellij.scientific.tables.api.DSTableDataType;
import com.intellij.scientific.tables.api.DSTableText;
import com.intellij.scientific.tables.api.TableDataProviderFactory;
import com.intellij.scientific.tables.api.TableDataTypeDetector;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\"\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u0016\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014\u00a8\u0006\u0016"}, d2={"Lcom/intellij/kotlin/jupyter/tables/KotlinDataframeTableDataProvider;", "Lcom/intellij/scientific/tables/api/TableDataProviderFactory;", "Lcom/intellij/scientific/tables/api/TableDataTypeDetector;", "<init>", "()V", "getTableDataProvider", "Lcom/intellij/scientific/tables/api/DSTableDataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "type", "Lcom/intellij/scientific/tables/api/DSTableDataType;", "text", "Lcom/intellij/scientific/tables/api/DSTableText;", "detectTableType", "dataObject", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "hasOutputInCurrentSession", "", "isFormatSupported", "serializedData", "", "getDataProviderCapableToParseData", "intellij.kotlin.jupyter.tables"})
public final class KotlinDataframeTableDataProvider
implements TableDataProviderFactory,
TableDataTypeDetector {
    @Nullable
    public DSTableDataProvider getTableDataProvider(@NotNull Project project, @NotNull DSTableDataType type2, @NotNull DSTableText text2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        if (type2 != DSTableDataType.EXTERNAL) {
            return null;
        }
        String plainText = text2.getPlainText();
        return this.getDataProviderCapableToParseData(project, plainText);
    }

    @Nullable
    public DSTableDataType detectTableType(@NotNull ObjectNode dataObject, boolean hasOutputInCurrentSession) {
        Intrinsics.checkNotNullParameter((Object)dataObject, (String)"dataObject");
        return this.isFormatSupported(dataObject.toString()) ? DSTableDataType.EXTERNAL : null;
    }

    private final boolean isFormatSupported(String serializedData) {
        return KotlinNotebookApplicationOptions.INSTANCE.get().getShowDataFrameAsSwing() && serializedData != null && KotlinDataframeParsing.INSTANCE.isFormatSupported(serializedData);
    }

    @NotNull
    public final DSTableDataProvider getDataProviderCapableToParseData(@NotNull Project project, @NotNull String serializedData) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)serializedData, (String)"serializedData");
        JsonFactory jsonFactory = new JsonFactory();
        jsonFactory.setStreamReadConstraints(StreamReadConstraints.builder().maxStringLength(Registry.Companion.intValue("jupyter.notebook.json.maxStringLength", 100000000)).build());
        ObjectMapper mapper = new ObjectMapper(jsonFactory);
        JsonParser.Feature[] featureArray = new JsonParser.Feature[]{JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS.mappedFeature()};
        mapper.enable(featureArray);
        KotlinDataframeParser parser2 = KotlinDataframeParsing.INSTANCE.createParserForData(serializedData, mapper);
        int columnsLimitFromRegistry = Registry.Companion.intValue("grid.tables.columns.limit", 2000);
        return (DSTableDataProvider)new KotlinDataFrameProvider(project, parser2, columnsLimitFromRegistry);
    }
}

