/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value.css2;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.AbstractValueManager;
import org.apache.batik.css.engine.value.ListValue;
import org.apache.batik.css.engine.value.URIValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class CursorManager
extends AbstractValueManager {
    protected static final Object2ObjectOpenHashMap<String, Value> values = new Object2ObjectOpenHashMap();

    @Override
    public boolean isInheritedProperty() {
        return true;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 21;
    }

    @Override
    public String getPropertyName() {
        return "cursor";
    }

    @Override
    public Value getDefaultValue() {
        return ValueConstants.AUTO_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lu, CSSEngine engine2) throws DOMException {
        ListValue result2 = new ListValue();
        switch (lu.getLexicalUnitType()) {
            case 12: {
                return ValueConstants.INHERIT_VALUE;
            }
            case 24: {
                do {
                    result2.append(new URIValue(lu.getStringValue(), CursorManager.resolveURI(engine2.getCSSBaseURI(), lu.getStringValue())));
                    lu = lu.getNextLexicalUnit();
                    if (lu == null) {
                        throw this.createMalformedLexicalUnitDOMException();
                    }
                    if (lu.getLexicalUnitType() != 0) {
                        throw this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
                    }
                    if ((lu = lu.getNextLexicalUnit()) != null) continue;
                    throw this.createMalformedLexicalUnitDOMException();
                } while (lu.getLexicalUnitType() == 24);
                if (lu.getLexicalUnitType() != 35) {
                    throw this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
                }
            }
            case 35: {
                String s = lu.getStringValue().toLowerCase();
                Object v = values.get((Object)s);
                if (v == null) {
                    throw this.createInvalidIdentifierDOMException(lu.getStringValue());
                }
                result2.append((Value)v);
                lu = lu.getNextLexicalUnit();
            }
        }
        if (lu != null) {
            throw this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
        }
        return result2;
    }

    @Override
    public Value computeValue(CSSStylableElement elt, String pseudo, CSSEngine engine2, int idx, StyleMap sm, Value value) {
        if (value.getCssValueType() == 2) {
            ListValue lv = (ListValue)value;
            int len = lv.getLength();
            ListValue result2 = new ListValue(' ');
            for (int i = 0; i < len; ++i) {
                Value v = lv.item(0);
                if (v.getPrimitiveType() == 20) {
                    result2.append(new URIValue(v.getStringValue(), v.getStringValue()));
                    continue;
                }
                result2.append(v);
            }
            return result2;
        }
        return super.computeValue(elt, pseudo, engine2, idx, sm, value);
    }

    static {
        values.put((Object)"auto", (Object)ValueConstants.AUTO_VALUE);
        values.put((Object)"crosshair", (Object)ValueConstants.CROSSHAIR_VALUE);
        values.put((Object)"default", (Object)ValueConstants.DEFAULT_VALUE);
        values.put((Object)"e-resize", (Object)ValueConstants.E_RESIZE_VALUE);
        values.put((Object)"help", (Object)ValueConstants.HELP_VALUE);
        values.put((Object)"move", (Object)ValueConstants.MOVE_VALUE);
        values.put((Object)"n-resize", (Object)ValueConstants.N_RESIZE_VALUE);
        values.put((Object)"ne-resize", (Object)ValueConstants.NE_RESIZE_VALUE);
        values.put((Object)"nw-resize", (Object)ValueConstants.NW_RESIZE_VALUE);
        values.put((Object)"pointer", (Object)ValueConstants.POINTER_VALUE);
        values.put((Object)"s-resize", (Object)ValueConstants.S_RESIZE_VALUE);
        values.put((Object)"se-resize", (Object)ValueConstants.SE_RESIZE_VALUE);
        values.put((Object)"sw-resize", (Object)ValueConstants.SW_RESIZE_VALUE);
        values.put((Object)"text", (Object)ValueConstants.TEXT_VALUE);
        values.put((Object)"w-resize", (Object)ValueConstants.W_RESIZE_VALUE);
        values.put((Object)"wait", (Object)ValueConstants.WAIT_VALUE);
    }
}

