/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import java.lang.reflect.InvocationTargetException;
import org.apache.batik.css.engine.CSSContext;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.value.ShorthandManager;
import org.apache.batik.css.engine.value.ValueManager;
import org.apache.batik.css.parser.ExtendedParser;
import org.apache.batik.css.parser.ExtendedParserWrapper;
import org.apache.batik.dom.AbstractDOMImplementation;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractStylableDocument;
import org.apache.batik.dom.GenericDocumentType;
import org.apache.batik.dom.GenericElement;
import org.apache.batik.dom.GenericElementNS;
import org.apache.batik.dom.StyleSheetFactory;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.util.DoublyIndexedTable;
import org.apache.batik.util.XMLResourceDescriptor;
import org.apache.batik.xml.XMLUtilities;
import org.w3c.css.sac.Parser;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.css.DOMImplementationCSS;
import org.w3c.dom.css.ViewCSS;

public abstract class ExtensibleDOMImplementation
extends AbstractDOMImplementation
implements DOMImplementationCSS,
StyleSheetFactory {
    protected DoublyIndexedTable customFactories;

    public CSSEngine createCSSEngine(AbstractStylableDocument doc, CSSContext ctx) {
        Parser p;
        String pn = XMLResourceDescriptor.getCSSParserClassName();
        try {
            p = (Parser)Class.forName(pn).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new DOMException(15, this.formatMessage("css.parser.class", new Object[]{pn}));
        }
        catch (InstantiationException e) {
            throw new DOMException(15, this.formatMessage("css.parser.creation", new Object[]{pn}));
        }
        catch (IllegalAccessException e) {
            throw new DOMException(15, this.formatMessage("css.parser.access", new Object[]{pn}));
        }
        catch (NoSuchMethodException e) {
            throw new DOMException(15, this.formatMessage("css.parser.access", new Object[]{pn}));
        }
        catch (InvocationTargetException e) {
            throw new DOMException(15, this.formatMessage("css.parser.access", new Object[]{pn}));
        }
        ExtendedParser ep = ExtendedParserWrapper.wrap(p);
        ValueManager[] vms = new ValueManager[]{};
        ShorthandManager[] sms = new ShorthandManager[]{};
        CSSEngine result2 = this.createCSSEngine(doc, ctx, ep, vms, sms);
        doc.setCSSEngine(result2);
        return result2;
    }

    public abstract CSSEngine createCSSEngine(AbstractStylableDocument var1, CSSContext var2, ExtendedParser var3, ValueManager[] var4, ShorthandManager[] var5);

    public abstract ViewCSS createViewCSS(AbstractStylableDocument var1);

    public Element createElementNS(AbstractDocument document, String namespaceURI, String qualifiedName) {
        String name;
        ElementFactory cef;
        if (namespaceURI != null && namespaceURI.length() == 0) {
            namespaceURI = null;
        }
        if (namespaceURI == null) {
            return new GenericElement(qualifiedName, document);
        }
        if (this.customFactories != null && (cef = (ElementFactory)this.customFactories.get(namespaceURI, name = DOMUtilities.getLocalName(qualifiedName))) != null) {
            return cef.create(DOMUtilities.getPrefix(qualifiedName), document);
        }
        return new GenericElementNS(namespaceURI, qualifiedName, document);
    }

    @Override
    public DocumentType createDocumentType(String qualifiedName, String publicId, String systemId) {
        int test;
        if (qualifiedName == null) {
            qualifiedName = "";
        }
        if (((test = XMLUtilities.testXMLQName(qualifiedName)) & 1) == 0) {
            throw new DOMException(5, this.formatMessage("xml.name", new Object[]{qualifiedName}));
        }
        if ((test & 2) == 0) {
            throw new DOMException(5, this.formatMessage("invalid.qname", new Object[]{qualifiedName}));
        }
        return new GenericDocumentType(qualifiedName, publicId, systemId);
    }

    public static interface ElementFactory {
        public Element create(String var1, Document var2);
    }
}

