/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.spi;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.apache.batik.ext.awt.image.URLImageCache;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.ProfileRable;
import org.apache.batik.ext.awt.image.renderable.RedRable;
import org.apache.batik.ext.awt.image.rendered.BufferedImageCachableRed;
import org.apache.batik.ext.awt.image.spi.BrokenLinkProvider;
import org.apache.batik.ext.awt.image.spi.DefaultBrokenLinkProvider;
import org.apache.batik.ext.awt.image.spi.JDKRegistryEntry;
import org.apache.batik.ext.awt.image.spi.MagicNumberRegistryEntry;
import org.apache.batik.ext.awt.image.spi.RegistryEntry;
import org.apache.batik.ext.awt.image.spi.StreamRegistryEntry;
import org.apache.batik.ext.awt.image.spi.URLRegistryEntry;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.Service;
import org.apache.xmlgraphics.java2d.color.ICCColorSpaceWithIntent;

public final class ImageTagRegistry {
    private final List<RegistryEntry> entries = new LinkedList<RegistryEntry>();
    private List<String> mimeTypes = null;
    private final URLImageCache rawCache;
    private final URLImageCache imgCache;
    private static ImageTagRegistry registry = null;
    private static final BrokenLinkProvider defaultProvider = new DefaultBrokenLinkProvider();
    private static BrokenLinkProvider brokenLinkProvider = null;

    private ImageTagRegistry() {
        this(null, null);
    }

    private ImageTagRegistry(URLImageCache rawCache, URLImageCache imgCache) {
        if (rawCache == null) {
            rawCache = new URLImageCache();
        }
        if (imgCache == null) {
            imgCache = new URLImageCache();
        }
        this.rawCache = rawCache;
        this.imgCache = imgCache;
    }

    public Filter checkCache(ParsedURL purl, ICCColorSpaceWithIntent colorSpace) {
        boolean needRawData = colorSpace != null;
        URLImageCache cache = needRawData ? this.rawCache : this.imgCache;
        Filter ret = cache.request(purl);
        if (ret == null) {
            cache.clear(purl);
            return null;
        }
        if (colorSpace != null) {
            ret = new ProfileRable(ret, colorSpace);
        }
        return ret;
    }

    public Filter readUrl(ParsedURL purl) {
        return this.readUrl(null, purl, null, true, true);
    }

    public Filter readUrl(InputStream is, ParsedURL purl, ICCColorSpaceWithIntent colorSpace, boolean allowOpenStream, boolean returnBrokenLink) {
        if (is != null && !is.markSupported()) {
            is = new BufferedInputStream(is);
        }
        boolean needRawData = colorSpace != null;
        Filter result2 = null;
        URLImageCache cache = null;
        if (purl != null && (result2 = (cache = needRawData ? this.rawCache : this.imgCache).request(purl)) != null) {
            if (colorSpace != null) {
                result2 = new ProfileRable(result2, colorSpace);
            }
            return result2;
        }
        boolean openFailed = false;
        List<String> mimeTypes = this.getRegisteredMimeTypes();
        for (RegistryEntry re : this.entries) {
            if (re instanceof URLRegistryEntry) {
                URLRegistryEntry ure;
                if (purl == null || !allowOpenStream || !(ure = (URLRegistryEntry)re).isCompatibleURL(purl) || (result2 = ure.handleURL(purl, needRawData)) == null) continue;
                break;
            }
            if (!(re instanceof StreamRegistryEntry)) continue;
            StreamRegistryEntry sre = (StreamRegistryEntry)re;
            if (openFailed) continue;
            try {
                if (is == null) {
                    if (purl == null || !allowOpenStream) break;
                    try {
                        is = purl.openStream(mimeTypes.iterator());
                    }
                    catch (IOException ioe) {
                        openFailed = true;
                        continue;
                    }
                    if (!is.markSupported()) {
                        is = new BufferedInputStream(is);
                    }
                }
                if (!sre.isCompatibleStream(is) || (result2 = sre.handleStream(is, purl, needRawData)) == null) continue;
                break;
            }
            catch (StreamCorruptedException sce) {
                is = null;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (cache != null) {
            cache.put(purl, result2);
        }
        if (result2 == null) {
            if (!returnBrokenLink) {
                return null;
            }
            if (openFailed) {
                return ImageTagRegistry.getBrokenLinkImage(this, "url.unreachable", null);
            }
            return ImageTagRegistry.getBrokenLinkImage(this, "url.uninterpretable", null);
        }
        if (BrokenLinkProvider.hasBrokenLinkProperty(result2)) {
            return returnBrokenLink ? result2 : null;
        }
        if (colorSpace != null) {
            result2 = new ProfileRable(result2, colorSpace);
        }
        return result2;
    }

    public synchronized void register(RegistryEntry newRE) {
        float priority = newRE.getPriority();
        ListIterator<RegistryEntry> li = this.entries.listIterator();
        while (li.hasNext()) {
            RegistryEntry re = li.next();
            if (!(re.getPriority() > priority)) continue;
            li.previous();
            break;
        }
        li.add(newRE);
        this.mimeTypes = null;
    }

    public synchronized List<String> getRegisteredMimeTypes() {
        if (this.mimeTypes != null) {
            return this.mimeTypes;
        }
        this.mimeTypes = new LinkedList<String>();
        for (RegistryEntry entry : this.entries) {
            this.mimeTypes.addAll(entry.getMimeTypes());
        }
        this.mimeTypes = Collections.unmodifiableList(this.mimeTypes);
        return this.mimeTypes;
    }

    public static synchronized ImageTagRegistry getRegistry() {
        if (registry != null) {
            return registry;
        }
        registry = new ImageTagRegistry();
        registry.register(new PNGRegistryEntry());
        registry.register(new JPEGRegistryEntry());
        registry.register(new JDKRegistryEntry());
        Iterator iter = Service.providers(RegistryEntry.class);
        while (iter.hasNext()) {
            RegistryEntry re = (RegistryEntry)iter.next();
            registry.register(re);
        }
        return registry;
    }

    public static synchronized Filter getBrokenLinkImage(Object base, String code, Object[] params) {
        Filter ret = null;
        if (brokenLinkProvider != null) {
            ret = brokenLinkProvider.getBrokenLinkImage(base, code, params);
        }
        if (ret == null) {
            ret = defaultProvider.getBrokenLinkImage(base, code, params);
        }
        return ret;
    }

    public static synchronized void setBrokenLinkProvider(BrokenLinkProvider provider) {
        brokenLinkProvider = provider;
    }

    private static RedRable readImage(String format, InputStream stream) throws IOException {
        ImageReader reader = ImageIO.getImageReadersByFormatName(format).next();
        try {
            RedRable redRable;
            try (MemoryCacheImageInputStream imageInputStream = new MemoryCacheImageInputStream(stream);){
                reader.setInput(imageInputStream, true, true);
                BufferedImage original = reader.read(0, null);
                BufferedImage img = new BufferedImage(original.getWidth(), original.getHeight(), 2);
                Graphics g = img.getGraphics();
                g.drawImage(original, 0, 0, null);
                redRable = new RedRable(new BufferedImageCachableRed(img));
            }
            return redRable;
        }
        finally {
            reader.dispose();
        }
    }

    private static final class JPEGRegistryEntry
    extends MagicNumberRegistryEntry {
        private static final byte[] signature = new byte[]{-1, -40, -1};

        JPEGRegistryEntry() {
            super("JPEG", "jpg", "image/jpeg", 0, signature);
        }

        @Override
        public Filter handleStream(InputStream stream, ParsedURL origURL, boolean needRawData) throws IOException {
            return ImageTagRegistry.readImage("jpeg", stream);
        }
    }

    private static final class PNGRegistryEntry
    extends MagicNumberRegistryEntry {
        private static final byte[] signature = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};

        PNGRegistryEntry() {
            super("PNG", "png", "image/png", 0, signature);
        }

        @Override
        public Filter handleStream(InputStream stream, ParsedURL origURL, boolean needRawData) throws IOException {
            return ImageTagRegistry.readImage("png", stream);
        }
    }
}

