/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.libraries;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.api.KernelLoggerFactory;
import org.jetbrains.kotlinx.jupyter.api.KernelLoggerFactoryKt;
import org.jetbrains.kotlinx.jupyter.api.KotlinKernelHost;
import org.jetbrains.kotlinx.jupyter.api.LibraryLoader;
import org.jetbrains.kotlinx.jupyter.api.Notebook;
import org.jetbrains.kotlinx.jupyter.api.exceptions.ReplException;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibrariesDefinitionDeclaration;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibrariesInstantiable;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibrariesProducerDeclaration;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibrariesScanResult;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryDefinition;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryDefinitionProducer;
import org.jetbrains.kotlinx.jupyter.config.LoggingKt;
import org.jetbrains.kotlinx.jupyter.util.AcceptanceRule;
import org.jetbrains.kotlinx.jupyter.util.AcceptanceRulesKt;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JF\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u000e\"\f\b\u0000\u0010\u000f*\u0006\u0012\u0002\b\u00030\u0010*\b\u0012\u0004\u0012\u0002H\u000f0\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0016\u0010\u0014\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u00060\nj\u0002`\u000b0\u00150\u0011H\u0002JN\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0014\b\u0002\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u001d2\u0018\b\u0002\u0010\u0014\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u00060\nj\u0002`\u000b0\u00150\u000eJ<\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0016J2\u0010!\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0018\b\u0002\u0010\u0014\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u00060\nj\u0002`\u000b0\u00150\u000eH\u0002J:\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u001dH\u0002J9\u0010$\u001a\u0004\u0018\u0001H%\"\u0004\b\u0000\u0010%2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H%0\u00102\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u000eH\u0002\u00a2\u0006\u0002\u0010)J\u001e\u0010$\u001a\u00020(*\u0006\u0012\u0002\b\u00030*2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u000eH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\f\u0012\b\u0012\u00060\nj\u0002`\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\f\u0012\b\u0012\u00060\nj\u0002`\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlinx/jupyter/libraries/LibrariesScanner;", "Lorg/jetbrains/kotlinx/jupyter/api/LibraryLoader;", "loggerFactory", "Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;", "<init>", "(Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;)V", "logger", "Lorg/slf4j/Logger;", "processedFQNs", "", "", "Lorg/jetbrains/kotlinx/jupyter/api/TypeName;", "discardedFQNs", "filterNamesToLoad", "", "I", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibrariesInstantiable;", "", "host", "Lorg/jetbrains/kotlinx/jupyter/api/KotlinKernelHost;", "integrationTypeNameRules", "Lorg/jetbrains/kotlinx/jupyter/util/AcceptanceRule;", "addLibrariesFromClassLoader", "", "classLoader", "Ljava/lang/ClassLoader;", "notebook", "Lorg/jetbrains/kotlinx/jupyter/api/Notebook;", "libraryOptions", "", "addLibrariesByScanResult", "scanResult", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibrariesScanResult;", "scanForLibraries", "instantiateLibraries", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryDefinition;", "instantiate", "T", "data", "arguments", "", "(Ljava/lang/ClassLoader;Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibrariesInstantiable;Ljava/util/List;)Ljava/lang/Object;", "Ljava/lang/Class;", "shared-compiler"})
@SourceDebugExtension(value={"SMAP\nLibrariesScanner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibrariesScanner.kt\norg/jetbrains/kotlinx/jupyter/libraries/LibrariesScanner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 4 Json.kt\nkotlinx/serialization/json/Json\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 7 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,203:1\n774#2:204\n865#2,2:205\n1563#2:208\n1634#2,2:209\n1636#2:212\n1625#2:213\n1869#2:214\n1870#2:216\n1626#2:217\n1869#2,2:218\n1740#2,3:221\n1869#2,2:226\n113#3:207\n147#4:211\n1#5:215\n6590#6:220\n37#7,2:224\n*S KotlinDebug\n*F\n+ 1 LibrariesScanner.kt\norg/jetbrains/kotlinx/jupyter/libraries/LibrariesScanner\n*L\n36#1:204\n36#1:205,2\n88#1:208\n88#1:209,2\n88#1:212\n131#1:213\n131#1:214\n131#1:216\n131#1:217\n137#1:218,2\n184#1:221,3\n140#1:226,2\n63#1:207\n90#1:211\n131#1:215\n171#1:220\n190#1:224,2\n*E\n"})
public final class LibrariesScanner
implements LibraryLoader {
    @NotNull
    private final Logger logger;
    @NotNull
    private final Set<String> processedFQNs;
    @NotNull
    private final Set<String> discardedFQNs;

    public LibrariesScanner(@NotNull KernelLoggerFactory loggerFactory) {
        Intrinsics.checkNotNullParameter((Object)loggerFactory, (String)"loggerFactory");
        this.logger = KernelLoggerFactoryKt.getLogger(loggerFactory, Reflection.getOrCreateKotlinClass(this.getClass()));
        this.processedFQNs = new LinkedHashSet();
        this.discardedFQNs = new LinkedHashSet();
    }

    /*
     * WARNING - void declaration
     */
    private final <I extends LibrariesInstantiable<?>> List<I> filterNamesToLoad(Iterable<? extends I> $this$filterNamesToLoad, KotlinKernelHost host2, Iterable<? extends AcceptanceRule<String>> integrationTypeNameRules) {
        void $this$filterTo$iv$iv;
        Iterable<? extends I> $this$filter$iv = $this$filterNamesToLoad;
        boolean $i$f$filter = false;
        Iterable<? extends I> iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            LibrariesInstantiable it = (LibrariesInstantiable)element$iv$iv;
            boolean bl2 = false;
            String typeName = it.getFqn();
            Object object = new Boolean[]{host2.acceptsIntegrationTypeName(typeName), AcceptanceRulesKt.accepts(integrationTypeNameRules, typeName)};
            Boolean acceptance = AcceptanceRulesKt.unionAcceptance(object);
            this.logger.debug("Acceptance result for " + typeName + ": " + acceptance);
            object = acceptance;
            if (Intrinsics.areEqual((Object)object, (Object)true)) {
                bl = this.processedFQNs.add(typeName);
            } else if (Intrinsics.areEqual((Object)object, (Object)false)) {
                this.discardedFQNs.add(typeName);
                bl = false;
            } else if (object == null) {
                bl = !this.discardedFQNs.contains(typeName) && this.processedFQNs.add(typeName);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final void addLibrariesFromClassLoader(@NotNull ClassLoader classLoader, @NotNull KotlinKernelHost host2, @NotNull Notebook notebook, @NotNull Map<String, String> libraryOptions, @NotNull List<? extends AcceptanceRule<String>> integrationTypeNameRules) {
        void $this$encodeToString$iv;
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        Intrinsics.checkNotNullParameter(libraryOptions, (String)"libraryOptions");
        Intrinsics.checkNotNullParameter(integrationTypeNameRules, (String)"integrationTypeNameRules");
        LibrariesScanResult scanResult = this.scanForLibraries(classLoader, host2, integrationTypeNameRules);
        StringFormat stringFormat = (StringFormat)Json.Default;
        LibrariesScanResult value$iv = scanResult;
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        this.logger.debug("Scanning for libraries is done. Detected FQNs: " + $this$encodeToString$iv.encodeToString((SerializationStrategy)LibrariesScanResult.Companion.serializer(), (Object)value$iv));
        List<LibraryDefinition> libraries = this.instantiateLibraries(classLoader, scanResult, notebook, libraryOptions);
        this.logger.debug("Number of detected definitions: " + libraries.size());
        host2.addLibraries((Collection<? extends LibraryDefinition>)libraries);
    }

    public static /* synthetic */ void addLibrariesFromClassLoader$default(LibrariesScanner librariesScanner, ClassLoader classLoader, KotlinKernelHost kotlinKernelHost, Notebook notebook, Map map, List list, int n, Object object) {
        if ((n & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        librariesScanner.addLibrariesFromClassLoader(classLoader, kotlinKernelHost, notebook, map, list);
    }

    @Override
    public void addLibrariesByScanResult(@NotNull KotlinKernelHost host2, @NotNull Notebook notebook, @NotNull ClassLoader classLoader, @NotNull Map<String, String> libraryOptions, @NotNull LibrariesScanResult scanResult) {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Intrinsics.checkNotNullParameter(libraryOptions, (String)"libraryOptions");
        Intrinsics.checkNotNullParameter((Object)scanResult, (String)"scanResult");
        host2.scheduleExecution(arg_0 -> LibrariesScanner.addLibrariesByScanResult$lambda$1(this, classLoader, scanResult, notebook, libraryOptions, host2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final LibrariesScanResult scanForLibraries(ClassLoader classLoader, KotlinKernelHost host2, List<? extends AcceptanceRule<String>> integrationTypeNameRules) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Enumeration<URL> enumeration = classLoader.getResources("META-INF/kotlin-jupyter-libraries/libraries.json");
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getResources(...)");
        ArrayList<URL> arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
        Iterable iterable = arrayList;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void this_$iv;
            void url;
            URL uRL = (URL)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)url);
            Json json = url;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = TextStreamsKt.readBytes((URL)json);
            String contents = new String(byArray, charset);
            json = (Json)Json.Default;
            String string$iv = contents;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            collection.add((LibrariesScanResult)this_$iv.decodeFromString((DeserializationStrategy)LibrariesScanResult.Companion.serializer(), string$iv));
        }
        List results = (List)destination$iv$iv;
        List definitions = new ArrayList();
        List producers = new ArrayList();
        for (LibrariesScanResult result2 : results) {
            definitions.addAll((Collection)result2.getDefinitions());
            producers.addAll((Collection)result2.getProducers());
        }
        return new LibrariesScanResult(LibrariesScanner.scanForLibraries$filterNames(definitions, this, host2, integrationTypeNameRules), LibrariesScanner.scanForLibraries$filterNames(producers, this, host2, integrationTypeNameRules));
    }

    static /* synthetic */ LibrariesScanResult scanForLibraries$default(LibrariesScanner librariesScanner, ClassLoader classLoader, KotlinKernelHost kotlinKernelHost, List list, int n, Object object) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        return librariesScanner.scanForLibraries(classLoader, kotlinKernelHost, list);
    }

    /*
     * WARNING - void declaration
     */
    private final List<LibraryDefinition> instantiateLibraries(ClassLoader classLoader, LibrariesScanResult scanResult, Notebook notebook, Map<String, String> libraryOptions) {
        void $this$mapNotNullTo$iv;
        List definitions = new ArrayList();
        Object object = new Object[]{notebook, libraryOptions};
        List arguments = CollectionsKt.listOf((Object[])object);
        object = scanResult.getDefinitions();
        Collection destination$iv = definitions;
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            LibraryDefinition it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            LibrariesDefinitionDeclaration declaration = (LibrariesDefinitionDeclaration)element$iv;
            boolean bl2 = false;
            if ((LibraryDefinition)LibrariesScanner.instantiateLibraries$withErrorsHandling(this, declaration, () -> LibrariesScanner.instantiateLibraries$lambda$4$lambda$3(this, classLoader, declaration, arguments)) == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        Iterable $this$forEach$iv = scanResult.getProducers();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            LibrariesProducerDeclaration declaration = (LibrariesProducerDeclaration)element$iv;
            boolean bl = false;
            LibrariesScanner.instantiateLibraries$withErrorsHandling(this, declaration, () -> LibrariesScanner.instantiateLibraries$lambda$8$lambda$7(this, classLoader, declaration, arguments, notebook, definitions));
        }
        return definitions;
    }

    private final <T> T instantiate(ClassLoader classLoader, LibrariesInstantiable<T> data, List<? extends Object> arguments) {
        Class<?> clazz = classLoader.loadClass(data.getFqn());
        if (clazz == null) {
            this.logger.warn("Library " + data.getFqn() + " wasn't found in classloader " + classLoader);
            return null;
        }
        return (T)this.instantiate(clazz, arguments);
    }

    /*
     * WARNING - void declaration
     */
    private final Object instantiate(Class<?> $this$instantiate, List<? extends Object> arguments) {
        void $this$sortedByDescending$iv;
        Object obj;
        Object object = obj = JvmClassMappingKt.getKotlinClass($this$instantiate).getObjectInstance();
        if (object != null) {
            return object;
        }
        int argsCount = arguments.size();
        Constructor<?>[] constructorArray = $this$instantiate.getConstructors();
        Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"getConstructors(...)");
        Object[] objectArray = constructorArray;
        boolean $i$f$sortedByDescending = false;
        List myConstructors = ArraysKt.sortedWith((Object[])$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Constructor it = (Constructor)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getParameterCount());
                it = (Constructor)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getParameterCount()));
            }
        });
        StringBuilder errorStringBuilder = new StringBuilder();
        for (Constructor constructor : myConstructors) {
            boolean isSuitable;
            int parameterCount;
            block7: {
                boolean bl;
                void $this$all$iv;
                parameterCount = constructor.getParameterCount();
                if (parameterCount > argsCount) {
                    errorStringBuilder.append("\t" + constructor + ": more than " + argsCount + " parameters").append('\n');
                    continue;
                }
                Class<?>[] classArray = constructor.getParameterTypes();
                Intrinsics.checkNotNullExpressionValue(classArray, (String)"getParameterTypes(...)");
                Iterable iterable = ArraysKt.zip((Object[])classArray, (Iterable)arguments);
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Object arg;
                        Pair pair2 = (Pair)element$iv;
                        boolean bl2 = false;
                        Class paramType = (Class)pair2.component1();
                        if (paramType.isInstance(arg = pair2.component2())) continue;
                        bl = false;
                        break block7;
                    }
                    bl = isSuitable = true;
                }
            }
            if (!isSuitable) {
                errorStringBuilder.append("\t" + constructor + ": wrong parameter types").append('\n');
                continue;
            }
            Collection $this$toTypedArray$iv = CollectionsKt.take((Iterable)arguments, (int)parameterCount);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray2 = thisCollection$iv.toArray(new Object[0]);
            Object t = constructor.newInstance(Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkNotNullExpressionValue(t, (String)"newInstance(...)");
            return t;
        }
        Object notFoundReason = myConstructors.isEmpty() ? "no single constructor found" : "no single constructor is applicable\n" + errorStringBuilder;
        throw new ReplException("No suitable constructor found. Reason: " + (String)notFoundReason, null, 2, null);
    }

    private static final Unit addLibrariesByScanResult$lambda$1(LibrariesScanner this$0, ClassLoader $classLoader, LibrariesScanResult $scanResult, Notebook $notebook, Map $libraryOptions, KotlinKernelHost $host, KotlinKernelHost $this$scheduleExecution) {
        Intrinsics.checkNotNullParameter((Object)$this$scheduleExecution, (String)"$this$scheduleExecution");
        List<LibraryDefinition> libraries = this$0.instantiateLibraries($classLoader, $scanResult, $notebook, $libraryOptions);
        $host.addLibraries((Collection<? extends LibraryDefinition>)libraries);
        return Unit.INSTANCE;
    }

    private static final <I extends LibrariesInstantiable<?>> List<I> scanForLibraries$filterNames(Iterable<? extends I> $this$scanForLibraries_u24filterNames, LibrariesScanner this$0, KotlinKernelHost $host, List<? extends AcceptanceRule<String>> $integrationTypeNameRules) {
        return this$0.filterNamesToLoad($this$scanForLibraries_u24filterNames, $host, (Iterable<? extends AcceptanceRule<String>>)$integrationTypeNameRules);
    }

    private static final <T> T instantiateLibraries$withErrorsHandling(LibrariesScanner this$0, LibrariesInstantiable<?> declaration, Function0<? extends T> action) {
        Object object;
        try {
            object = action.invoke();
        }
        catch (Throwable e) {
            String errorMessage = "Failed to load library integration class '" + declaration.getFqn() + "'";
            LoggingKt.errorForUser$default(this$0.logger, null, errorMessage, e, 1, null);
            throw new ReplException(errorMessage, e);
        }
        return (T)object;
    }

    private static final LibraryDefinition instantiateLibraries$lambda$4$lambda$3(LibrariesScanner this$0, ClassLoader $classLoader, LibrariesDefinitionDeclaration $declaration, List $arguments) {
        return (LibraryDefinition)this$0.instantiate($classLoader, $declaration, $arguments);
    }

    private static final Unit instantiateLibraries$lambda$8$lambda$7(LibrariesScanner this$0, ClassLoader $classLoader, LibrariesProducerDeclaration $declaration, List $arguments, Notebook $notebook, List $definitions) {
        block1: {
            LibraryDefinitionProducer libraryDefinitionProducer;
            LibraryDefinitionProducer libraryDefinitionProducer2 = (LibraryDefinitionProducer)this$0.instantiate($classLoader, $declaration, $arguments);
            if (libraryDefinitionProducer2 == null) break block1;
            LibraryDefinitionProducer $this$instantiateLibraries_u24lambda_u248_u24lambda_u247_u24lambda_u246 = libraryDefinitionProducer = libraryDefinitionProducer2;
            boolean bl = false;
            Iterable $this$forEach$iv = $this$instantiateLibraries_u24lambda_u248_u24lambda_u247_u24lambda_u246.getDefinitions($notebook);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LibraryDefinition it = (LibraryDefinition)element$iv;
                boolean bl2 = false;
                $definitions.add(it);
            }
        }
        return Unit.INSTANCE;
    }
}

