/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.libraries;

import java.io.File;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.api.KernelLoggerFactory;
import org.jetbrains.kotlinx.jupyter.api.KernelLoggerFactoryKt;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryResolutionInfo;
import org.jetbrains.kotlinx.jupyter.common.HttpUtilKt;
import org.jetbrains.kotlinx.jupyter.common.ResponseKt;
import org.jetbrains.kotlinx.jupyter.common.ResponseWrapper;
import org.jetbrains.kotlinx.jupyter.libraries.AbstractLibraryResolutionInfo;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryHttpUtil;
import org.jetbrains.kotlinx.jupyter.libraries.ResolutionInfoProvider;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u0012H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001a\u001a\u00020\u0012H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlinx/jupyter/libraries/StandardResolutionInfoProvider;", "Lorg/jetbrains/kotlinx/jupyter/libraries/ResolutionInfoProvider;", "loggerFactory", "Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;", "fallback", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryResolutionInfo;", "httpUtil", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryHttpUtil;", "<init>", "(Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryResolutionInfo;Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryHttpUtil;)V", "getFallback", "()Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryResolutionInfo;", "setFallback", "(Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryResolutionInfo;)V", "logger", "Lorg/slf4j/Logger;", "get", "string", "", "tryGetAsRef", "ref", "tryGetAsDir", "dirName", "tryGetAsFile", "fileName", "tryGetAsURL", "url", "shared-compiler"})
public final class StandardResolutionInfoProvider
implements ResolutionInfoProvider {
    @NotNull
    private LibraryResolutionInfo fallback;
    @NotNull
    private final LibraryHttpUtil httpUtil;
    @NotNull
    private final Logger logger;

    public StandardResolutionInfoProvider(@NotNull KernelLoggerFactory loggerFactory, @NotNull LibraryResolutionInfo fallback, @NotNull LibraryHttpUtil httpUtil) {
        Intrinsics.checkNotNullParameter((Object)loggerFactory, (String)"loggerFactory");
        Intrinsics.checkNotNullParameter((Object)fallback, (String)"fallback");
        Intrinsics.checkNotNullParameter((Object)httpUtil, (String)"httpUtil");
        this.fallback = fallback;
        this.httpUtil = httpUtil;
        this.logger = KernelLoggerFactoryKt.getLogger(loggerFactory, Reflection.getOrCreateKotlinClass(this.getClass()));
    }

    @Override
    @NotNull
    public LibraryResolutionInfo getFallback() {
        return this.fallback;
    }

    @Override
    public void setFallback(@NotNull LibraryResolutionInfo libraryResolutionInfo) {
        Intrinsics.checkNotNullParameter((Object)libraryResolutionInfo, (String)"<set-?>");
        this.fallback = libraryResolutionInfo;
    }

    @Override
    @NotNull
    public LibraryResolutionInfo get(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        if (((CharSequence)string).length() == 0) {
            return this.getFallback();
        }
        LibraryResolutionInfo libraryResolutionInfo = this.tryGetAsRef(string);
        if (libraryResolutionInfo == null && (libraryResolutionInfo = this.tryGetAsDir(string)) == null && (libraryResolutionInfo = this.tryGetAsFile(string)) == null && (libraryResolutionInfo = this.tryGetAsURL(string)) == null) {
            libraryResolutionInfo = this.getFallback();
        }
        return libraryResolutionInfo;
    }

    private final LibraryResolutionInfo tryGetAsRef(String ref) {
        return this.httpUtil.getLibraryDescriptorsManager().checkRefExistence(ref) ? (LibraryResolutionInfo)this.httpUtil.getLibraryInfoCache().getLibraryInfoByRef(ref) : null;
    }

    private final LibraryResolutionInfo tryGetAsDir(String dirName) {
        File file = new File(dirName);
        return file.isDirectory() ? (LibraryResolutionInfo)new AbstractLibraryResolutionInfo.ByDir(file) : null;
    }

    private final LibraryResolutionInfo tryGetAsFile(String fileName) {
        File file = new File(fileName);
        return file.isFile() ? (LibraryResolutionInfo)new AbstractLibraryResolutionInfo.ByFile(file) : null;
    }

    private final LibraryResolutionInfo tryGetAsURL(String url) {
        ResponseWrapper responseWrapper;
        try {
            responseWrapper = HttpUtilKt.getHttp(this.httpUtil.getHttpClient(), url);
        }
        catch (Throwable e) {
            this.logger.warn("Unable to load library by URL " + url, e);
            return null;
        }
        ResponseWrapper response2 = responseWrapper;
        return ResponseKt.getSuccessful(response2.getStatus()) ? (LibraryResolutionInfo)new AbstractLibraryResolutionInfo.ByURL(new URL(url)) : null;
    }
}

