/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.messaging;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.api.DisplayResult;
import org.jetbrains.kotlinx.jupyter.api.exceptions.ReplException;
import org.jetbrains.kotlinx.jupyter.exceptions.ReplInterruptedException;
import org.jetbrains.kotlinx.jupyter.messaging.AbortJupyterResponse;
import org.jetbrains.kotlinx.jupyter.messaging.ErrorJupyterResponse;
import org.jetbrains.kotlinx.jupyter.messaging.ExecuteAbortReply;
import org.jetbrains.kotlinx.jupyter.messaging.ExecuteErrorReply;
import org.jetbrains.kotlinx.jupyter.messaging.ExecuteReplyMetadata;
import org.jetbrains.kotlinx.jupyter.messaging.ExecuteResult;
import org.jetbrains.kotlinx.jupyter.messaging.ExecuteSuccessReply;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterCommunicationFacility;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterCommunicationFacilityKt;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterConnectionInternalKt;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterOutType;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterResponse;
import org.jetbrains.kotlinx.jupyter.messaging.Message;
import org.jetbrains.kotlinx.jupyter.messaging.MessageContent;
import org.jetbrains.kotlinx.jupyter.messaging.MessageFactory;
import org.jetbrains.kotlinx.jupyter.messaging.MessageFactoryKt;
import org.jetbrains.kotlinx.jupyter.messaging.MessageStatus;
import org.jetbrains.kotlinx.jupyter.messaging.MessageType;
import org.jetbrains.kotlinx.jupyter.messaging.OkJupyterResponse;
import org.jetbrains.kotlinx.jupyter.protocol.JupyterSocketBase;
import org.jetbrains.kotlinx.jupyter.protocol.RawMessageImplKt;
import org.jetbrains.kotlinx.jupyter.repl.EvaluatedSnippetMetadata;
import org.jetbrains.kotlinx.jupyter.util.SerializersKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a)\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001\u00a2\u0006\u0004\b\n\u0010\u000b\u001a#\u0010\f\u001a\u00020\u0003*\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a)\u0010\u0011\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0012\u0010\u000b\u001a\u0016\u0010\u0013\u001a\u00020\u0006*\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u001a\u0019\u0010\u0017\u001a\u00020\u0018*\u00020\u00192\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u001a\u0010\u001b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"EXECUTION_INTERRUPTED_MESSAGE", "", "sendResponse", "", "Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterCommunicationFacility;", "response", "Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterResponse;", "executionCount", "Lorg/jetbrains/kotlinx/jupyter/messaging/ExecutionCount;", "startedTime", "sendResponse-zEAq3HY", "(Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterCommunicationFacility;Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterResponse;ILjava/lang/String;)V", "sendExecuteResult", "result", "Lorg/jetbrains/kotlinx/jupyter/api/DisplayResult;", "sendExecuteResult-Qdt-JXo", "(Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterCommunicationFacility;Lorg/jetbrains/kotlinx/jupyter/api/DisplayResult;I)V", "sendExecuteReply", "sendExecuteReply-zEAq3HY", "toErrorJupyterResponse", "", "metadata", "Lorg/jetbrains/kotlinx/jupyter/repl/EvaluatedSnippetMetadata;", "toExecuteErrorReply", "Lorg/jetbrains/kotlinx/jupyter/messaging/ExecuteErrorReply;", "Lorg/jetbrains/kotlinx/jupyter/api/exceptions/ReplException;", "toExecuteErrorReply-wNURfNM", "(Lorg/jetbrains/kotlinx/jupyter/api/exceptions/ReplException;I)Lorg/jetbrains/kotlinx/jupyter/messaging/ExecuteErrorReply;", "shared-compiler"})
@SourceDebugExtension(value={"SMAP\nJupyterResponse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterResponse.kt\norg/jetbrains/kotlinx/jupyter/messaging/JupyterResponseKt\n+ 2 Json.kt\nkotlinx/serialization/json/JsonKt\n*L\n1#1,166:1\n298#2:167\n*S KotlinDebug\n*F\n+ 1 JupyterResponse.kt\norg/jetbrains/kotlinx/jupyter/messaging/JupyterResponseKt\n*L\n139#1:167\n*E\n"})
public final class JupyterResponseKt {
    @NotNull
    public static final String EXECUTION_INTERRUPTED_MESSAGE = "The execution was interrupted";

    public static final void sendResponse-zEAq3HY(@NotNull JupyterCommunicationFacility $this$sendResponse_u2dzEAq3HY, @NotNull JupyterResponse response2, int n, @NotNull String startedTime) {
        Intrinsics.checkNotNullParameter((Object)$this$sendResponse_u2dzEAq3HY, (String)"$this$sendResponse");
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Intrinsics.checkNotNullParameter((Object)startedTime, (String)"startedTime");
        JupyterResponse jupyterResponse = response2;
        if (jupyterResponse instanceof AbortJupyterResponse) {
            String string = ((AbortJupyterResponse)response2).getStdErr();
            Intrinsics.checkNotNull((Object)string);
            String errorMessage = string;
            JupyterCommunicationFacilityKt.sendOut($this$sendResponse_u2dzEAq3HY, JupyterOutType.STDERR, errorMessage);
        } else if (jupyterResponse instanceof ErrorJupyterResponse) {
            JupyterCommunicationFacilityKt.sendError-zEAq3HY($this$sendResponse_u2dzEAq3HY, response2, n, startedTime);
        } else if (jupyterResponse instanceof OkJupyterResponse) {
            JupyterResponseKt.sendExecuteResult-Qdt-JXo($this$sendResponse_u2dzEAq3HY, ((OkJupyterResponse)response2).getDisplayResult(), n);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        JupyterResponseKt.sendExecuteReply-zEAq3HY($this$sendResponse_u2dzEAq3HY, response2, n, startedTime);
    }

    public static final void sendExecuteResult-Qdt-JXo(@NotNull JupyterCommunicationFacility $this$sendExecuteResult_u2dQdt_u2dJXo, @Nullable DisplayResult result2, int n) {
        Intrinsics.checkNotNullParameter((Object)$this$sendExecuteResult_u2dQdt_u2dJXo, (String)"$this$sendExecuteResult");
        if (result2 == null) {
            return;
        }
        JsonObject resultJson = result2.toJson(SerializersKt.getEMPTY((Json)Json.Default), null);
        JupyterSocketBase jupyterSocketBase = $this$sendExecuteResult_u2dQdt_u2dJXo.getSocketManager().getIopub();
        MessageFactory messageFactory = $this$sendExecuteResult_u2dQdt_u2dJXo.getMessageFactory();
        Object object = resultJson.get((Object)"data");
        Intrinsics.checkNotNull((Object)object);
        JsonElement jsonElement = (JsonElement)object;
        Object object2 = resultJson.get((Object)"metadata");
        Intrinsics.checkNotNull((Object)object2);
        JsonElement jsonElement2 = (JsonElement)object2;
        JupyterConnectionInternalKt.sendMessage(jupyterSocketBase, MessageFactoryKt.makeReplyMessage$default(messageFactory, MessageType.EXECUTE_RESULT, null, null, null, null, new ExecuteResult(jsonElement, jsonElement2, n, null), 30, null));
    }

    /*
     * WARNING - void declaration
     */
    public static final void sendExecuteReply-zEAq3HY(@NotNull JupyterCommunicationFacility $this$sendExecuteReply_u2dzEAq3HY, @NotNull JupyterResponse response2, int n, @NotNull String startedTime) {
        void $this$encodeToJsonElement$iv;
        MessageContent messageContent;
        Intrinsics.checkNotNullParameter((Object)$this$sendExecuteReply_u2dzEAq3HY, (String)"$this$sendExecuteReply");
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Intrinsics.checkNotNullParameter((Object)startedTime, (String)"startedTime");
        ExecuteReplyMetadata replyMetadata = new ExecuteReplyMetadata(true, $this$sendExecuteReply_u2dzEAq3HY.getMessageFactory().getSessionId(), response2.getStatus(), startedTime, response2.getMetadata());
        Object object = response2.getException();
        if (object != null && (object = JupyterResponseKt.toExecuteErrorReply-wNURfNM((ReplException)object, n)) != null) {
            messageContent = (MessageContent)object;
        } else {
            switch (WhenMappings.$EnumSwitchMapping$0[response2.getStatus().ordinal()]) {
                case 1: {
                    messageContent = new ExecuteAbortReply();
                    break;
                }
                case 2: {
                    messageContent = JupyterResponseKt.toExecuteErrorReply-wNURfNM(new ReplInterruptedException(response2.getStdErr()), n);
                    break;
                }
                case 3: {
                    messageContent = new ExecuteSuccessReply(n, null, null, null, 14, null);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        MessageContent replyContent = messageContent;
        MessageFactory messageFactory = $this$sendExecuteReply_u2dzEAq3HY.getMessageFactory();
        MessageType messageType = MessageType.EXECUTE_REPLY;
        Json json = RawMessageImplKt.getMessageFormat();
        ExecuteReplyMetadata value$iv = replyMetadata;
        boolean $i$f$encodeToJsonElement = false;
        $this$encodeToJsonElement$iv.getSerializersModule();
        JsonElement jsonElement = $this$encodeToJsonElement$iv.encodeToJsonElement((SerializationStrategy)ExecuteReplyMetadata.Companion.serializer(), (Object)value$iv);
        Message reply = MessageFactoryKt.makeReplyMessage$default(messageFactory, messageType, null, null, null, jsonElement, replyContent, 14, null);
        switch (WhenMappings.$EnumSwitchMapping$0[response2.getStatus().ordinal()]) {
            case 2: {
                System.err.println("Sending error: " + reply);
                break;
            }
            case 1: {
                System.err.println("Sending abort: " + reply);
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        JupyterConnectionInternalKt.sendMessage($this$sendExecuteReply_u2dzEAq3HY.getSocketManager().getShell(), reply);
    }

    @NotNull
    public static final JupyterResponse toErrorJupyterResponse(@NotNull Throwable $this$toErrorJupyterResponse, @Nullable EvaluatedSnippetMetadata metadata2) {
        Intrinsics.checkNotNullParameter((Object)$this$toErrorJupyterResponse, (String)"<this>");
        Throwable exception = $this$toErrorJupyterResponse;
        if (!(exception instanceof ReplException)) {
            throw exception;
        }
        return new ErrorJupyterResponse(((ReplException)exception).render(), (ReplException)exception, metadata2);
    }

    public static /* synthetic */ JupyterResponse toErrorJupyterResponse$default(Throwable throwable, EvaluatedSnippetMetadata evaluatedSnippetMetadata, int n, Object object) {
        if ((n & 1) != 0) {
            evaluatedSnippetMetadata = null;
        }
        return JupyterResponseKt.toErrorJupyterResponse(throwable, evaluatedSnippetMetadata);
    }

    @NotNull
    public static final ExecuteErrorReply toExecuteErrorReply-wNURfNM(@NotNull ReplException $this$toExecuteErrorReply_u2dwNURfNM, int n) {
        Intrinsics.checkNotNullParameter((Object)$this$toExecuteErrorReply_u2dwNURfNM, (String)"$this$toExecuteErrorReply");
        String string = $this$toExecuteErrorReply_u2dwNURfNM.getJupyterException().getClass().getCanonicalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalName(...)");
        String string2 = $this$toExecuteErrorReply_u2dwNURfNM.getJupyterException().getMessage();
        if (string2 == null) {
            string2 = "";
        }
        List<String> list = $this$toExecuteErrorReply_u2dwNURfNM.getTraceback();
        JsonObject jsonObject = $this$toExecuteErrorReply_u2dwNURfNM.getAdditionalInfoJson();
        if (jsonObject == null) {
            jsonObject = SerializersKt.getEMPTY((Json)Json.Default);
        }
        return new ExecuteErrorReply(n, string, string2, list, jsonObject, null);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MessageStatus.values().length];
            try {
                nArray[MessageStatus.ABORT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageStatus.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageStatus.OK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

