/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.protocol;

import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.protocol.SocketWithCancellation;
import org.zeromq.SocketType;
import org.zeromq.ZMQ;
import org.zeromq.ZMQException;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\tH\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000bH\u0004J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000bH\u0004J\b\u0010\u0017\u001a\u00020\u0011H\u0004J\b\u0010\u0018\u001a\u00020\rH\u0002J\b\u0010\u0019\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlinx/jupyter/protocol/SocketWithCancellationBase;", "Lorg/jetbrains/kotlinx/jupyter/protocol/SocketWithCancellation;", "socket", "Lorg/zeromq/ZMQ$Socket;", "<init>", "(Lorg/zeromq/ZMQ$Socket;)V", "cancellationToken", "Lorg/zeromq/ZMQ$CancellationToken;", "recv", "", "recvString", "", "sendMore", "", "data", "send", "makeRelaxed", "", "subscribe", "topic", "bind", "address", "connect", "assertNotCancelled", "isCancelled", "close", "shared-compiler"})
public abstract class SocketWithCancellationBase
implements SocketWithCancellation {
    @NotNull
    private final ZMQ.Socket socket;
    @NotNull
    private final ZMQ.CancellationToken cancellationToken;

    public SocketWithCancellationBase(@NotNull ZMQ.Socket socket) {
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        this.socket = socket;
        ZMQ.CancellationToken cancellationToken = this.socket.createCancellationToken();
        Intrinsics.checkNotNullExpressionValue((Object)cancellationToken, (String)"createCancellationToken(...)");
        this.cancellationToken = cancellationToken;
    }

    @Override
    @NotNull
    public byte[] recv() {
        byte[] result2;
        byte[] byArray;
        this.assertNotCancelled();
        try {
            byArray = this.socket.recv(0, this.cancellationToken);
        }
        catch (ZMQException e) {
            if (e.getErrorCode() == ZMQ.Error.EINTR.getCode()) {
                throw new InterruptedException();
            }
            throw e;
        }
        if (result2 == null) {
            throw new ZMQException("Unable to receive message", this.socket.errno());
        }
        result2 = byArray;
        return result2;
    }

    @Override
    @NotNull
    public String recvString() {
        byte[] byArray = this.recv();
        Charset charset = ZMQ.CHARSET;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"CHARSET");
        Charset charset2 = charset;
        return new String(byArray, charset2);
    }

    @Override
    public boolean sendMore(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.assertNotCancelled();
        return this.socket.sendMore(data);
    }

    @Override
    public boolean sendMore(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.assertNotCancelled();
        return this.socket.sendMore(data);
    }

    @Override
    public boolean send(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.assertNotCancelled();
        return this.socket.send(data, 0, this.cancellationToken);
    }

    @Override
    public boolean send(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string = data;
        Charset charset = ZMQ.CHARSET;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"CHARSET");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return this.send(byArray);
    }

    @Override
    public void makeRelaxed() {
        this.socket.base().setSocketOpt(53, true);
    }

    @Override
    public boolean subscribe(@NotNull byte[] topic) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        return this.socket.subscribe(topic);
    }

    protected final boolean bind(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        boolean res = this.socket.bind(address);
        if (this.socket.getSocketType() == SocketType.PUB) {
            Thread.sleep(500L);
        }
        return res;
    }

    protected final boolean connect(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return this.socket.connect(address);
    }

    protected final void assertNotCancelled() {
        if (this.isCancelled()) {
            throw new InterruptedException();
        }
    }

    private final boolean isCancelled() {
        return this.cancellationToken.isCancellationRequested();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.cancellationToken.cancel();
        }
        finally {
            this.socket.close();
        }
    }
}

