/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.streams;

import java.io.Closeable;
import java.io.InputStream;
import java.io.PrintStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.api.StreamSubstitutionType;
import org.jetbrains.kotlinx.jupyter.streams.BlockingSubstitutionEngine;
import org.jetbrains.kotlinx.jupyter.streams.DataFlowComponents;
import org.jetbrains.kotlinx.jupyter.streams.KernelStreams;
import org.jetbrains.kotlinx.jupyter.streams.NonBlockingSubstitutionEngine;
import org.jetbrains.kotlinx.jupyter.streams.SubstitutionEngine;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u000e\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0006*+,-./B^\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0005\u0012'\u0010\u0007\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00028\u00000\b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012JZ\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u00172#\u0010\u001b\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00018\u0000\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00028\u00000\b2%\u0010\u001d\u001a!\u0012\u0015\u0012\u0013\u0018\u00018\u0000\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u001c\u0012\u0006\u0012\u0004\u0018\u00018\u00000\bH\u0002J\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00172\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017H\u0002J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u0017H\u0002J$\u0010!\u001a\u00020\"2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00172\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017H\u0002Jk\u0010$\u001a\u0002H%\"\u0004\b\u0001\u0010%2#\u0010&\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00018\u0000\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00028\u00000\b2%\u0010'\u001a!\u0012\u0015\u0012\u0013\u0018\u00018\u0000\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u001c\u0012\u0006\u0012\u0004\u0018\u00018\u00000\b2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H%0\t\u00a2\u0006\u0002\u0010)R/\u0010\u0007\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\f0\u0014R\b\u0012\u0004\u0012\u00028\u00000\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0015\u001a\f0\u0014R\b\u0012\u0004\u0012\u00028\u00000\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00170\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlinx/jupyter/streams/StreamSubstitutionManager;", "StreamT", "Ljava/io/Closeable;", "", "systemStreamProp", "Lkotlin/reflect/KMutableProperty0;", "kernelStreamProp", "delegatingStreamFactory", "Lkotlin/Function1;", "Lkotlin/Function0;", "Lkotlin/ParameterName;", "name", "delegateFactory", "substitutionEngineType", "Lorg/jetbrains/kotlinx/jupyter/api/StreamSubstitutionType;", "useThreadLocal", "", "<init>", "(Lkotlin/reflect/KMutableProperty0;Lkotlin/reflect/KMutableProperty0;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/kotlinx/jupyter/api/StreamSubstitutionType;Z)V", "localSystemStream", "Lorg/jetbrains/kotlinx/jupyter/streams/StreamSubstitutionManager$ThreadLocalStream;", "localKernelStream", "defaultStreams", "Lorg/jetbrains/kotlinx/jupyter/streams/StreamSubstitutionManager$Streams;", "engine", "Lorg/jetbrains/kotlinx/jupyter/streams/SubstitutionEngine;", "createStreams", "createSystemStream", "initial", "createKernelStream", "substituteStreams", "newStreams", "getStreamsFromProperties", "finalizeStreams", "", "oldStreams", "withSubstitutedStreams", "T", "systemStreamFactory", "kernelStreamFactory", "body", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Streams", "Box", "ThreadLocalStream", "StdOut", "StdErr", "StdIn", "shared-compiler"})
public abstract class StreamSubstitutionManager<StreamT extends Closeable> {
    @NotNull
    private final Function1<Function0<? extends StreamT>, StreamT> delegatingStreamFactory;
    @NotNull
    private final ThreadLocalStream localSystemStream;
    @NotNull
    private final ThreadLocalStream localKernelStream;
    @NotNull
    private final Streams<StreamT> defaultStreams;
    @NotNull
    private final SubstitutionEngine<Streams<StreamT>> engine;

    /*
     * WARNING - void declaration
     */
    public StreamSubstitutionManager(@NotNull KMutableProperty0<StreamT> systemStreamProp, @Nullable KMutableProperty0<StreamT> kernelStreamProp, @NotNull Function1<? super Function0<? extends StreamT>, ? extends StreamT> delegatingStreamFactory, @NotNull StreamSubstitutionType substitutionEngineType, boolean useThreadLocal) {
        SubstitutionEngine substitutionEngine;
        void $this$engine_u24lambda_u243;
        Intrinsics.checkNotNullParameter(systemStreamProp, (String)"systemStreamProp");
        Intrinsics.checkNotNullParameter(delegatingStreamFactory, (String)"delegatingStreamFactory");
        Intrinsics.checkNotNullParameter((Object)((Object)substitutionEngineType), (String)"substitutionEngineType");
        this.delegatingStreamFactory = delegatingStreamFactory;
        this.localSystemStream = new ThreadLocalStream(this, systemStreamProp, StreamSubstitutionManager::localSystemStream$lambda$0, null, useThreadLocal, 4, null);
        this.localKernelStream = new ThreadLocalStream(this, kernelStreamProp, StreamSubstitutionManager::localKernelStream$lambda$1, StreamSubstitutionManager::localKernelStream$lambda$2, useThreadLocal);
        this.defaultStreams = this.getStreamsFromProperties();
        StreamSubstitutionManager streamSubstitutionManager = this;
        StreamSubstitutionManager streamSubstitutionManager2 = this;
        boolean bl = false;
        DataFlowComponents<Streams<StreamT>> dataFlowComponents2 = new DataFlowComponents<Streams<StreamT>>($this$engine_u24lambda_u243.defaultStreams, (Function1)new Function1<Streams<StreamT>, Streams<StreamT>>($this$engine_u24lambda_u243){

            public final Streams<StreamT> invoke(Streams<StreamT> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return StreamSubstitutionManager.access$substituteStreams((StreamSubstitutionManager)this.receiver, p0);
            }
        }, (Function2)new Function2<Streams<StreamT>, Streams<StreamT>, Unit>($this$engine_u24lambda_u243){

            public final void invoke(Streams<StreamT> p0, Streams<StreamT> p1) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                StreamSubstitutionManager.access$finalizeStreams((StreamSubstitutionManager)this.receiver, p0, p1);
            }
        });
        switch (WhenMappings.$EnumSwitchMapping$0[substitutionEngineType.ordinal()]) {
            case 1: {
                substitutionEngine = new BlockingSubstitutionEngine<Streams<StreamT>>(dataFlowComponents2);
                break;
            }
            case 2: {
                substitutionEngine = new NonBlockingSubstitutionEngine<Streams<StreamT>>(dataFlowComponents2);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        streamSubstitutionManager2.engine = substitutionEngine;
    }

    private final Streams<StreamT> createStreams(Function1<? super StreamT, ? extends StreamT> createSystemStream, Function1<? super StreamT, ? extends StreamT> createKernelStream) {
        Streams<StreamT> myInitStreams = this.defaultStreams;
        Object StreamT = this.localSystemStream.create(myInitStreams, null, createSystemStream);
        Intrinsics.checkNotNull(StreamT);
        Object systemStream = StreamT;
        Object kernelStream = this.localKernelStream.create(myInitStreams, systemStream, createKernelStream);
        return new Streams(systemStream, kernelStream);
    }

    private final Streams<StreamT> substituteStreams(Streams<StreamT> newStreams) {
        Streams<StreamT> originalStreams = this.getStreamsFromProperties();
        this.localSystemStream.substitute(newStreams);
        this.localKernelStream.substitute(newStreams);
        return originalStreams;
    }

    private final Streams<StreamT> getStreamsFromProperties() {
        Object StreamT = this.localSystemStream.get();
        Intrinsics.checkNotNull(StreamT);
        Object systemStream = StreamT;
        Object kernelStream = this.localKernelStream.get();
        return new Streams(systemStream, kernelStream);
    }

    private final void finalizeStreams(Streams<StreamT> newStreams, Streams<StreamT> oldStreams) {
        this.localSystemStream.finalize(newStreams, oldStreams);
        this.localKernelStream.finalize(newStreams, oldStreams);
    }

    public final <T> T withSubstitutedStreams(@NotNull Function1<? super StreamT, ? extends StreamT> systemStreamFactory, @NotNull Function1<? super StreamT, ? extends StreamT> kernelStreamFactory, @NotNull Function0<? extends T> body) {
        Intrinsics.checkNotNullParameter(systemStreamFactory, (String)"systemStreamFactory");
        Intrinsics.checkNotNullParameter(kernelStreamFactory, (String)"kernelStreamFactory");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        return this.engine.withDataSubstitution(arg_0 -> StreamSubstitutionManager.withSubstitutedStreams$lambda$4(this, systemStreamFactory, kernelStreamFactory, arg_0), body);
    }

    private static final Closeable localSystemStream$lambda$0(Streams streams) {
        Intrinsics.checkNotNullParameter((Object)streams, (String)"streams");
        return streams.getSystemStream();
    }

    private static final Closeable localKernelStream$lambda$1(Streams streams) {
        Intrinsics.checkNotNullParameter((Object)streams, (String)"streams");
        return streams.getSystemStream();
    }

    private static final Closeable localKernelStream$lambda$2(Streams streams) {
        Intrinsics.checkNotNullParameter((Object)streams, (String)"streams");
        return streams.getKernelStream();
    }

    private static final Streams withSubstitutedStreams$lambda$4(StreamSubstitutionManager this$0, Function1 $systemStreamFactory, Function1 $kernelStreamFactory, Streams streams) {
        return this$0.createStreams($systemStreamFactory, $kernelStreamFactory);
    }

    public static final /* synthetic */ Streams access$substituteStreams(StreamSubstitutionManager $this, Streams newStreams) {
        return $this.substituteStreams(newStreams);
    }

    public static final /* synthetic */ void access$finalizeStreams(StreamSubstitutionManager $this, Streams newStreams, Streams oldStreams) {
        $this.finalizeStreams(newStreams, oldStreams);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0002:\u0002\f\rB\t\b\u0004\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0005\u001a\u0004\u0018\u00018\u0001H&\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00018\u0001H&\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\bH&\u0082\u0001\u0002\u000e\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlinx/jupyter/streams/StreamSubstitutionManager$Box;", "T", "", "<init>", "()V", "get", "()Ljava/lang/Object;", "set", "", "value", "(Ljava/lang/Object;)V", "remove", "ThreadLocalBox", "GlobalBox", "Lorg/jetbrains/kotlinx/jupyter/streams/StreamSubstitutionManager$Box$GlobalBox;", "Lorg/jetbrains/kotlinx/jupyter/streams/StreamSubstitutionManager$Box$ThreadLocalBox;", "shared-compiler"})
    private static abstract class Box<T> {
        private Box() {
        }

        @Nullable
        public abstract T get();

        public abstract void set(@Nullable T var1);

        public abstract void remove();

        public /* synthetic */ Box(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\b\u001a\u0004\u0018\u00018\u0002H\u0016\u00a2\u0006\u0002\u0010\tJ\u0017\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00018\u0002H\u0016\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000bH\u0016R\u0012\u0010\u0006\u001a\u0004\u0018\u00018\u0002X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlinx/jupyter/streams/StreamSubstitutionManager$Box$GlobalBox;", "T", "", "Lorg/jetbrains/kotlinx/jupyter/streams/StreamSubstitutionManager$Box;", "<init>", "()V", "property", "Ljava/lang/Object;", "get", "()Ljava/lang/Object;", "set", "", "value", "(Ljava/lang/Object;)V", "remove", "shared-compiler"})
        public static final class GlobalBox<T>
        extends Box<T> {
            @Nullable
            private T property;

            public GlobalBox() {
                super(null);
            }

            @Override
            @Nullable
            public T get() {
                return this.property;
            }

            @Override
            public void set(@Nullable T value) {
                this.property = value;
            }

            @Override
            public void remove() {
                this.property = null;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\b\u001a\u0004\u0018\u00018\u0002H\u0016\u00a2\u0006\u0002\u0010\tJ\u0017\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00018\u0002H\u0016\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000bH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlinx/jupyter/streams/StreamSubstitutionManager$Box$ThreadLocalBox;", "T", "", "Lorg/jetbrains/kotlinx/jupyter/streams/StreamSubstitutionManager$Box;", "<init>", "()V", "threadLocal", "Ljava/lang/ThreadLocal;", "get", "()Ljava/lang/Object;", "set", "", "value", "(Ljava/lang/Object;)V", "remove", "shared-compiler"})
        public static final class ThreadLocalBox<T>
        extends Box<T> {
            @NotNull
            private final ThreadLocal<T> threadLocal = new ThreadLocal();

            public ThreadLocalBox() {
                super(null);
            }

            @Override
            @Nullable
            public T get() {
                return this.threadLocal.get();
            }

            @Override
            public void set(@Nullable T value) {
                this.threadLocal.set(value);
            }

            @Override
            public void remove() {
                this.threadLocal.remove();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlinx/jupyter/streams/StreamSubstitutionManager$StdErr;", "Lorg/jetbrains/kotlinx/jupyter/streams/StreamSubstitutionManager;", "Ljava/io/PrintStream;", "substitutionEngineType", "Lorg/jetbrains/kotlinx/jupyter/api/StreamSubstitutionType;", "threadLocalStreamSubstitution", "", "<init>", "(Lorg/jetbrains/kotlinx/jupyter/api/StreamSubstitutionType;Z)V", "shared-compiler"})
    public static final class StdErr
    extends StreamSubstitutionManager<PrintStream> {
        public StdErr(@NotNull StreamSubstitutionType substitutionEngineType, boolean threadLocalStreamSubstitution) {
            Intrinsics.checkNotNullParameter((Object)((Object)substitutionEngineType), (String)"substitutionEngineType");
            super((KMutableProperty0)1.INSTANCE, (KMutableProperty0)new MutablePropertyReference0Impl(KernelStreams.INSTANCE){

                public Object get() {
                    return ((KernelStreams)this.receiver).getErr();
                }

                public void set(Object value) {
                    ((KernelStreams)this.receiver).setErr((PrintStream)value);
                }
            }, 3.INSTANCE, substitutionEngineType, threadLocalStreamSubstitution);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlinx/jupyter/streams/StreamSubstitutionManager$StdIn;", "Lorg/jetbrains/kotlinx/jupyter/streams/StreamSubstitutionManager;", "Ljava/io/InputStream;", "substitutionEngineType", "Lorg/jetbrains/kotlinx/jupyter/api/StreamSubstitutionType;", "threadLocalStreamSubstitution", "", "<init>", "(Lorg/jetbrains/kotlinx/jupyter/api/StreamSubstitutionType;Z)V", "shared-compiler"})
    public static final class StdIn
    extends StreamSubstitutionManager<InputStream> {
        public StdIn(@NotNull StreamSubstitutionType substitutionEngineType, boolean threadLocalStreamSubstitution) {
            Intrinsics.checkNotNullParameter((Object)((Object)substitutionEngineType), (String)"substitutionEngineType");
            super((KMutableProperty0)1.INSTANCE, null, 2.INSTANCE, substitutionEngineType, threadLocalStreamSubstitution);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlinx/jupyter/streams/StreamSubstitutionManager$StdOut;", "Lorg/jetbrains/kotlinx/jupyter/streams/StreamSubstitutionManager;", "Ljava/io/PrintStream;", "substitutionEngineType", "Lorg/jetbrains/kotlinx/jupyter/api/StreamSubstitutionType;", "threadLocalStreamSubstitution", "", "<init>", "(Lorg/jetbrains/kotlinx/jupyter/api/StreamSubstitutionType;Z)V", "shared-compiler"})
    public static final class StdOut
    extends StreamSubstitutionManager<PrintStream> {
        public StdOut(@NotNull StreamSubstitutionType substitutionEngineType, boolean threadLocalStreamSubstitution) {
            Intrinsics.checkNotNullParameter((Object)((Object)substitutionEngineType), (String)"substitutionEngineType");
            super((KMutableProperty0)1.INSTANCE, (KMutableProperty0)new MutablePropertyReference0Impl(KernelStreams.INSTANCE){

                public Object get() {
                    return ((KernelStreams)this.receiver).getOut();
                }

                public void set(Object value) {
                    ((KernelStreams)this.receiver).setOut((PrintStream)value);
                }
            }, 3.INSTANCE, substitutionEngineType, threadLocalStreamSubstitution);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0003B\u0019\u0012\u0006\u0010\u0004\u001a\u00028\u0001\u0012\b\u0010\u0005\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\r\u001a\u0004\u0018\u00018\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ*\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0004\u001a\u00028\u00012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00018\u0001H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0013\u0010\u0004\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0005\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlinx/jupyter/streams/StreamSubstitutionManager$Streams;", "StreamT", "Ljava/io/Closeable;", "", "systemStream", "kernelStream", "<init>", "(Ljava/io/Closeable;Ljava/io/Closeable;)V", "getSystemStream", "()Ljava/io/Closeable;", "Ljava/io/Closeable;", "getKernelStream", "component1", "component2", "copy", "(Ljava/io/Closeable;Ljava/io/Closeable;)Lorg/jetbrains/kotlinx/jupyter/streams/StreamSubstitutionManager$Streams;", "equals", "", "other", "hashCode", "", "toString", "", "shared-compiler"})
    private static final class Streams<StreamT extends Closeable> {
        @NotNull
        private final StreamT systemStream;
        @Nullable
        private final StreamT kernelStream;

        public Streams(@NotNull StreamT systemStream, @Nullable StreamT kernelStream) {
            Intrinsics.checkNotNullParameter(systemStream, (String)"systemStream");
            this.systemStream = systemStream;
            this.kernelStream = kernelStream;
        }

        @NotNull
        public final StreamT getSystemStream() {
            return this.systemStream;
        }

        @Nullable
        public final StreamT getKernelStream() {
            return this.kernelStream;
        }

        @NotNull
        public final StreamT component1() {
            return this.systemStream;
        }

        @Nullable
        public final StreamT component2() {
            return this.kernelStream;
        }

        @NotNull
        public final Streams<StreamT> copy(@NotNull StreamT systemStream, @Nullable StreamT kernelStream) {
            Intrinsics.checkNotNullParameter(systemStream, (String)"systemStream");
            return new Streams<StreamT>(systemStream, kernelStream);
        }

        public static /* synthetic */ Streams copy$default(Streams streams, Closeable closeable, Closeable closeable2, int n, Object object) {
            if ((n & 1) != 0) {
                closeable = streams.systemStream;
            }
            if ((n & 2) != 0) {
                closeable2 = streams.kernelStream;
            }
            return streams.copy(closeable, closeable2);
        }

        @NotNull
        public String toString() {
            return "Streams(systemStream=" + this.systemStream + ", kernelStream=" + this.kernelStream + ")";
        }

        public int hashCode() {
            int result2 = this.systemStream.hashCode();
            result2 = result2 * 31 + (this.kernelStream == null ? 0 : this.kernelStream.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Streams)) {
                return false;
            }
            Streams streams = (Streams)other;
            if (!Intrinsics.areEqual(this.systemStream, streams.systemStream)) {
                return false;
            }
            return Intrinsics.areEqual(this.kernelStream, streams.kernelStream);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001BW\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u001c\b\u0002\u0010\u0007\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\u0010\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0011JL\u0010\u0012\u001a\u0004\u0018\u00018\u00002\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\b\u0010\u0014\u001a\u0004\u0018\u00018\u00002%\u0010\u0015\u001a!\u0012\u0015\u0012\u0013\u0018\u00018\u0000\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0005\u00a2\u0006\u0002\u0010\u0019J\u0014\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006J\"\u0010\u001d\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006R\u0016\u0010\u0002\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0004\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0007\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlinx/jupyter/streams/StreamSubstitutionManager$ThreadLocalStream;", "", "streamProp", "Lkotlin/reflect/KMutableProperty0;", "yieldStreamFallback", "Lkotlin/Function1;", "Lorg/jetbrains/kotlinx/jupyter/streams/StreamSubstitutionManager$Streams;", "yieldStream", "useThreadLocal", "", "<init>", "(Lorg/jetbrains/kotlinx/jupyter/streams/StreamSubstitutionManager;Lkotlin/reflect/KMutableProperty0;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Z)V", "localStreamProp", "Lorg/jetbrains/kotlinx/jupyter/streams/StreamSubstitutionManager$Box;", "delegatingStream", "Ljava/io/Closeable;", "get", "()Ljava/io/Closeable;", "create", "defaultStreams", "fallbackStream", "factory", "Lkotlin/ParameterName;", "name", "initial", "(Lorg/jetbrains/kotlinx/jupyter/streams/StreamSubstitutionManager$Streams;Ljava/io/Closeable;Lkotlin/jvm/functions/Function1;)Ljava/io/Closeable;", "substitute", "", "newStreams", "finalize", "oldStreams", "shared-compiler"})
    private final class ThreadLocalStream {
        @Nullable
        private final KMutableProperty0<StreamT> streamProp;
        @NotNull
        private final Function1<Streams<StreamT>, StreamT> yieldStreamFallback;
        @NotNull
        private final Function1<Streams<StreamT>, StreamT> yieldStream;
        @NotNull
        private final Box<StreamT> localStreamProp;
        @NotNull
        private final StreamT delegatingStream;
        final /* synthetic */ StreamSubstitutionManager<StreamT> this$0;

        public ThreadLocalStream(@Nullable StreamSubstitutionManager this$0, @NotNull KMutableProperty0<StreamT> streamProp, @NotNull Function1<? super Streams<StreamT>, ? extends StreamT> yieldStreamFallback, Function1<? super Streams<StreamT>, ? extends StreamT> yieldStream, boolean useThreadLocal) {
            Intrinsics.checkNotNullParameter(yieldStreamFallback, (String)"yieldStreamFallback");
            Intrinsics.checkNotNullParameter(yieldStream, (String)"yieldStream");
            this.this$0 = this$0;
            this.streamProp = streamProp;
            this.yieldStreamFallback = yieldStreamFallback;
            this.yieldStream = yieldStream;
            this.localStreamProp = useThreadLocal ? (Box)new Box.ThreadLocalBox() : (Box)new Box.GlobalBox();
            this.delegatingStream = (Closeable)this.this$0.delegatingStreamFactory.invoke(() -> ThreadLocalStream.delegatingStream$lambda$0(this, this.this$0));
        }

        public /* synthetic */ ThreadLocalStream(StreamSubstitutionManager streamSubstitutionManager, KMutableProperty0 kMutableProperty0, Function1 function1, Function1 function12, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                function12 = function1;
            }
            this(streamSubstitutionManager, kMutableProperty0, function1, function12, bl);
        }

        @Nullable
        public final StreamT get() {
            KMutableProperty0 kMutableProperty0 = this.streamProp;
            return kMutableProperty0 != null ? (Closeable)kMutableProperty0.get() : null;
        }

        @Nullable
        public final StreamT create(@NotNull Streams<StreamT> defaultStreams, @Nullable StreamT fallbackStream, @NotNull Function1<? super StreamT, ? extends StreamT> factory) {
            Intrinsics.checkNotNullParameter(defaultStreams, (String)"defaultStreams");
            Intrinsics.checkNotNullParameter(factory, (String)"factory");
            Closeable value = (Closeable)factory.invoke(this.yieldStream.invoke(defaultStreams));
            Closeable closeable = value;
            if (closeable == null) {
                closeable = this.streamProp == null ? null : fallbackStream;
            }
            return closeable;
        }

        public final void substitute(@NotNull Streams<StreamT> newStreams) {
            Intrinsics.checkNotNullParameter(newStreams, (String)"newStreams");
            Closeable newStream = (Closeable)this.yieldStream.invoke(newStreams);
            if (newStream != null) {
                KMutableProperty0 kMutableProperty0 = this.streamProp;
                if (kMutableProperty0 != null) {
                    kMutableProperty0.set(this.delegatingStream);
                }
            }
            this.localStreamProp.set(newStream);
        }

        public final void finalize(@NotNull Streams<StreamT> newStreams, @NotNull Streams<StreamT> oldStreams) {
            block2: {
                Intrinsics.checkNotNullParameter(newStreams, (String)"newStreams");
                Intrinsics.checkNotNullParameter(oldStreams, (String)"oldStreams");
                Closeable oldStream = (Closeable)this.yieldStream.invoke(oldStreams);
                if (oldStream != null) {
                    KMutableProperty0 kMutableProperty0 = this.streamProp;
                    if (kMutableProperty0 != null) {
                        kMutableProperty0.set((Object)oldStream);
                    }
                }
                this.localStreamProp.remove();
                Closeable closeable = (Closeable)this.yieldStream.invoke(newStreams);
                if (closeable == null) break block2;
                closeable.close();
            }
        }

        private static final Closeable delegatingStream$lambda$0(ThreadLocalStream this$0, StreamSubstitutionManager this$1) {
            Closeable closeable = (Closeable)this$0.localStreamProp.get();
            if (closeable == null && (closeable = (Closeable)this$0.yieldStream.invoke((Object)this$1.defaultStreams)) == null) {
                closeable = (Closeable)this$0.yieldStreamFallback.invoke((Object)this$1.defaultStreams);
            }
            return closeable;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StreamSubstitutionType.values().length];
            try {
                nArray[StreamSubstitutionType.BLOCKING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StreamSubstitutionType.NON_BLOCKING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

