/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.JvmAnalysisFlags;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaPropertyDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.LanguageVersionSettingsProvider;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.jvm.checkers.JvmDefaultCheckerKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\"\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0019H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/InterfaceDefaultMethodCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "jvmTarget", "Lorg/jetbrains/kotlin/config/JvmTarget;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lorg/jetbrains/kotlin/config/JvmTarget;Lcom/intellij/openapi/project/Project;)V", "getJvmTarget", "()Lorg/jetbrains/kotlin/config/JvmTarget;", "ideService", "Lorg/jetbrains/kotlin/resolve/LanguageVersionSettingsProvider;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "findInterfaceMember", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "descriptorToSearch", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "startExpression", "Lorg/jetbrains/kotlin/psi/KtSuperExpression;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getSuperCallLabelTarget", "expression", "frontend.java"})
@SourceDebugExtension(value={"SMAP\nInterfaceDefaultMethodCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InterfaceDefaultMethodCallChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/InterfaceDefaultMethodCallChecker\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,105:1\n1292#2,3:106\n*S KotlinDebug\n*F\n+ 1 InterfaceDefaultMethodCallChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/InterfaceDefaultMethodCallChecker\n*L\n79#1:106,3\n*E\n"})
public final class InterfaceDefaultMethodCallChecker
implements CallChecker {
    @NotNull
    private final JvmTarget jvmTarget;
    @Nullable
    private final LanguageVersionSettingsProvider ideService;

    public InterfaceDefaultMethodCallChecker(@NotNull JvmTarget jvmTarget, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)jvmTarget, (String)"jvmTarget");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.jvmTarget = jvmTarget;
        this.ideService = LanguageVersionSettingsProvider.Companion.getInstance(project);
    }

    @NotNull
    public final JvmTarget getJvmTarget() {
        return this.jvmTarget;
    }

    public void check(@NotNull ResolvedCall<?> resolvedCall, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CallableDescriptor callableDescriptor = resolvedCall.getResultingDescriptor();
        CallableMemberDescriptor callableMemberDescriptor = callableDescriptor instanceof CallableMemberDescriptor ? (CallableMemberDescriptor)callableDescriptor : null;
        if (callableMemberDescriptor == null) {
            return;
        }
        CallableMemberDescriptor descriptor = callableMemberDescriptor;
        if (descriptor instanceof JavaPropertyDescriptor) {
            return;
        }
        Call call = resolvedCall.getCall();
        Intrinsics.checkNotNullExpressionValue((Object)call, (String)"getCall(...)");
        KtSuperExpression ktSuperExpression = CallResolverUtilKt.getSuperCallExpression((Call)call);
        if (ktSuperExpression == null) {
            return;
        }
        KtSuperExpression superCallExpression = ktSuperExpression;
        if (!DescriptorUtils.isInterface((DeclarationDescriptor)descriptor.getOriginal().getContainingDeclaration())) {
            return;
        }
        CallableMemberDescriptor callableMemberDescriptor2 = DescriptorUtils.unwrapFakeOverride((CallableMemberDescriptor)descriptor);
        Intrinsics.checkNotNullExpressionValue((Object)callableMemberDescriptor2, (String)"unwrapFakeOverride(...)");
        CallableMemberDescriptor realDescriptor = callableMemberDescriptor2;
        DeclarationDescriptor declarationDescriptor = realDescriptor.getContainingDeclaration();
        ClassDescriptor classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor realDescriptorOwner = classDescriptor;
        JvmDefaultMode jvmDefaultMode = context.getLanguageVersionSettings().getFlag(JvmAnalysisFlags.getJvmDefaultMode());
        if (DescriptorUtils.isInterface((DeclarationDescriptor)((DeclarationDescriptor)realDescriptorOwner)) && (realDescriptor instanceof JavaCallableMemberDescriptor || JvmDefaultCheckerKt.isCompiledToJvmDefaultWithProperMode(realDescriptor, this.ideService, jvmDefaultMode))) {
            BindingContext bindingContext = context.getTrace().getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
            BindingContext bindingContext2 = bindingContext;
            ClassDescriptor thisForSuperCall = this.getSuperCallLabelTarget(bindingContext2, superCallExpression);
            if (thisForSuperCall != null && DescriptorUtils.isInterface((DeclarationDescriptor)((DeclarationDescriptor)thisForSuperCall))) {
                CallableMemberDescriptor declarationWithCall;
                CallableMemberDescriptor callableMemberDescriptor3 = declarationWithCall = this.findInterfaceMember(thisForSuperCall, superCallExpression, bindingContext2);
                boolean bl = callableMemberDescriptor3 != null ? !JvmDefaultCheckerKt.isCompiledToJvmDefaultWithProperMode(callableMemberDescriptor3, this.ideService, jvmDefaultMode) : false;
                if (bl) {
                    context.getTrace().report((Diagnostic)ErrorsJvm.INTERFACE_CANT_CALL_DEFAULT_METHOD_VIA_SUPER.on(reportOn));
                    return;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final CallableMemberDescriptor findInterfaceMember(ClassDescriptor descriptorToSearch, KtSuperExpression startExpression, BindingContext bindingContext) {
        Sequence parents;
        Sequence $this$fold$iv = parents = SequencesKt.generateSequence(() -> InterfaceDefaultMethodCallChecker.findInterfaceMember$lambda$0(startExpression), InterfaceDefaultMethodCallChecker::findInterfaceMember$lambda$1);
        boolean $i$f$fold = false;
        KtSuperExpression accumulator$iv = startExpression;
        for (Object element$iv : $this$fold$iv) {
            void parent;
            PsiElement psiElement = (PsiElement)element$iv;
            PsiElement child = (PsiElement)accumulator$iv;
            boolean bl = false;
            if (parent instanceof KtClassBody && Intrinsics.areEqual((Object)descriptorToSearch, (Object)bindingContext.get((ReadOnlySlice)BindingContext.CLASS, (Object)((KtClassBody)parent).getParent()))) {
                Object object;
                PsiElement psiElement2 = child;
                return psiElement2 instanceof KtNamedFunction ? (CallableMemberDescriptor)bindingContext.get((ReadOnlySlice)BindingContext.FUNCTION, (Object)child) : (psiElement2 instanceof KtProperty ? (CallableMemberDescriptor)((object = bindingContext.get((ReadOnlySlice)BindingContext.VARIABLE, (Object)child)) instanceof PropertyDescriptor ? (PropertyDescriptor)object : null) : null);
            }
            accumulator$iv = parent;
        }
        return null;
    }

    private final ClassDescriptor getSuperCallLabelTarget(BindingContext bindingContext, KtSuperExpression expression) {
        KotlinType kotlinType = (KotlinType)bindingContext.get((ReadOnlySlice)BindingContext.THIS_TYPE_FOR_SUPER_EXPRESSION, (Object)expression);
        if (kotlinType == null) {
            return null;
        }
        KotlinType thisTypeForSuperCall = kotlinType;
        ClassifierDescriptor descriptor = thisTypeForSuperCall.getConstructor().getDeclarationDescriptor();
        return descriptor instanceof ClassDescriptor ? (ClassDescriptor)descriptor : null;
    }

    private static final PsiElement findInterfaceMember$lambda$0(KtSuperExpression $startExpression) {
        return $startExpression.getParent();
    }

    private static final PsiElement findInterfaceMember$lambda$1(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParent();
    }
}

