/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import java.io.File;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.util.BinaryClassFromKotlinFileMeasurement;
import org.jetbrains.kotlin.util.CodeAnalysisMeasurement;
import org.jetbrains.kotlin.util.CodeGenerationMeasurement;
import org.jetbrains.kotlin.util.CompilerInitializationMeasurement;
import org.jetbrains.kotlin.util.CounterMeasurement;
import org.jetbrains.kotlin.util.FindJavaClassMeasurement;
import org.jetbrains.kotlin.util.GarbageCollectionMeasurement;
import org.jetbrains.kotlin.util.IRMeasurement;
import org.jetbrains.kotlin.util.JitCompilationMeasurement;
import org.jetbrains.kotlin.util.PerformanceCounter;
import org.jetbrains.kotlin.util.PerformanceCounterMeasurement;
import org.jetbrains.kotlin.util.PerformanceMeasurement;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001:\u0001UB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0006\u0010/\u001a\u00020\u0003J\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000b01J\u0014\u00102\u001a\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u000b01J\u0006\u00105\u001a\u000203J\u000e\u00106\u001a\u0002032\u0006\u0010\u0018\u001a\u00020\u0013J\u0010\u00107\u001a\u00020\b2\u0006\u00108\u001a\u00020\bH\u0002J\b\u00109\u001a\u000203H\u0016J\b\u0010:\u001a\u000203H\u0016J\u0018\u0010;\u001a\u0002032\u0006\u0010%\u001a\u00020&2\u0006\u0010,\u001a\u00020&H\u0016J\b\u0010<\u001a\u000203H\u0016J\b\u0010=\u001a\u000203H\u0016J\b\u0010>\u001a\u000203H\u0016J\b\u0010?\u001a\u000203H\u0016J\b\u0010@\u001a\u000203H\u0016J\b\u0010A\u001a\u000203H\u0016J\b\u0010B\u001a\u000203H\u0016J\b\u0010C\u001a\u000203H\u0016J\b\u0010D\u001a\u000203H\u0016J\b\u0010E\u001a\u000203H\u0016J\u000e\u0010F\u001a\u0002032\u0006\u0010G\u001a\u00020HJ\u0006\u0010I\u001a\u00020\u0003J\b\u0010J\u001a\u000203H\u0002J\b\u0010K\u001a\u000203H\u0002J\b\u0010L\u001a\u000203H\u0002J/\u0010M\u001a\u0002HN\"\u0004\b\u0000\u0010N2\n\u0010O\u001a\u0006\u0012\u0002\b\u00030\u00102\f\u0010P\u001a\b\u0012\u0004\u0012\u0002HN0QH\u0000\u00a2\u0006\u0004\bR\u0010SJ\u0006\u0010T\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001d0\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010!\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010\u0005R\u001e\u0010%\u001a\u0004\u0018\u00010&X\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010+\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001e\u0010,\u001a\u0004\u0018\u00010&X\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010+\u001a\u0004\b-\u0010(\"\u0004\b.\u0010*\u00a8\u0006V"}, d2={"Lorg/jetbrains/kotlin/util/PerformanceManager;", "", "presentableName", "", "<init>", "(Ljava/lang/String;)V", "counterMeasurementsLock", "currentTime", "", "measurements", "", "Lorg/jetbrains/kotlin/util/PerformanceMeasurement;", "getMeasurements$annotations", "()V", "counterMeasurements", "", "Lkotlin/reflect/KClass;", "Lorg/jetbrains/kotlin/util/CounterMeasurement;", "value", "", "isEnabled", "()Z", "setEnabled", "(Z)V", "isK2", "initStartNanos", "analysisStart", "generationStart", "startGCData", "Lorg/jetbrains/kotlin/util/PerformanceManager$GCData;", "irTranslationStart", "irLoweringStart", "irGenerationStart", "targetDescription", "getTargetDescription", "()Ljava/lang/String;", "setTargetDescription", "files", "", "getFiles", "()Ljava/lang/Integer;", "setFiles", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "lines", "getLines", "setLines", "getTargetInfo", "getMeasurementResults", "", "addMeasurementResults", "", "newMeasurements", "clearMeasurementResults", "enableCollectingPerformanceStatistics", "deltaTime", "start", "notifyCompilerInitialized", "notifyCompilationFinished", "addSourcesStats", "notifyAnalysisStarted", "notifyAnalysisFinished", "notifyGenerationStarted", "notifyGenerationFinished", "notifyIRTranslationStarted", "notifyIRTranslationFinished", "notifyIRLoweringStarted", "notifyIRLoweringFinished", "notifyIRGenerationStarted", "notifyIRGenerationFinished", "dumpPerformanceReport", "destination", "Ljava/io/File;", "createPerformanceReport", "recordGcTime", "recordJitCompilationTime", "recordPerfCountersMeasurements", "measureTime", "T", "measurementClass", "block", "Lkotlin/Function0;", "measureTime$compiler_common", "(Lkotlin/reflect/KClass;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "renderCompilerPerformance", "GCData", "compiler.common"})
@SourceDebugExtension(value={"SMAP\nPerformanceManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerformanceManager.kt\norg/jetbrains/kotlin/util/PerformanceManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,232:1\n1267#2,4:233\n1563#2:237\n1634#2,3:238\n1869#2,2:241\n1869#2,2:243\n774#2:245\n865#2,2:246\n*S KotlinDebug\n*F\n+ 1 PerformanceManager.kt\norg/jetbrains/kotlin/util/PerformanceManager\n*L\n71#1:233,4\n160#1:237\n160#1:238,3\n160#1:241,2\n166#1:243,2\n217#1:245\n217#1:246,2\n*E\n"})
public abstract class PerformanceManager {
    @NotNull
    private final String presentableName;
    @NotNull
    private final Object counterMeasurementsLock;
    @NotNull
    private final List<PerformanceMeasurement> measurements;
    @NotNull
    private final Map<KClass<?>, CounterMeasurement> counterMeasurements;
    private boolean isEnabled;
    private boolean isK2;
    private long initStartNanos;
    private long analysisStart;
    private long generationStart;
    @NotNull
    private Map<String, GCData> startGCData;
    private long irTranslationStart;
    private long irLoweringStart;
    private long irGenerationStart;
    @Nullable
    private String targetDescription;
    @Nullable
    private Integer files;
    @Nullable
    private Integer lines;

    public PerformanceManager(@NotNull String presentableName2) {
        Intrinsics.checkNotNullParameter((Object)presentableName2, (String)"presentableName");
        this.presentableName = presentableName2;
        this.counterMeasurementsLock = new Object();
        this.measurements = new ArrayList();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(FindJavaClassMeasurement.class), (Object)new FindJavaClassMeasurement(0, 0L)), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(BinaryClassFromKotlinFileMeasurement.class), (Object)new BinaryClassFromKotlinFileMeasurement(0, 0L))};
        this.counterMeasurements = MapsKt.mutableMapOf((Pair[])pairArray);
        this.isK2 = true;
        this.initStartNanos = this.currentTime();
        this.startGCData = new LinkedHashMap();
    }

    private final long currentTime() {
        return System.nanoTime();
    }

    private static /* synthetic */ void getMeasurements$annotations() {
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    protected final void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    @Nullable
    public final String getTargetDescription() {
        return this.targetDescription;
    }

    public final void setTargetDescription(@Nullable String string2) {
        this.targetDescription = string2;
    }

    @Nullable
    protected final Integer getFiles() {
        return this.files;
    }

    protected final void setFiles(@Nullable Integer n) {
        this.files = n;
    }

    @Nullable
    protected final Integer getLines() {
        return this.lines;
    }

    protected final void setLines(@Nullable Integer n) {
        this.lines = n;
    }

    @NotNull
    public final String getTargetInfo() {
        return this.targetDescription + ", " + this.files + " files (" + this.lines + " lines)";
    }

    @NotNull
    public final List<PerformanceMeasurement> getMeasurementResults() {
        return CollectionsKt.plus((Collection)this.measurements, (Iterable)this.counterMeasurements.values());
    }

    public final void addMeasurementResults(@NotNull List<? extends PerformanceMeasurement> newMeasurements) {
        Intrinsics.checkNotNullParameter(newMeasurements, (String)"newMeasurements");
        CollectionsKt.addAll((Collection)this.measurements, (Iterable)newMeasurements);
    }

    public final void clearMeasurementResults() {
        this.measurements.clear();
    }

    /*
     * WARNING - void declaration
     */
    public final void enableCollectingPerformanceStatistics(boolean isK2) {
        void $this$associateTo$iv;
        this.isEnabled = true;
        this.isK2 = isK2;
        if (!isK2) {
            PerformanceCounter.Companion.setTimeCounterEnabled(true);
        }
        List<GarbageCollectorMXBean> list = ManagementFactory.getGarbageCollectorMXBeans();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getGarbageCollectorMXBeans(...)");
        Iterable iterable = list;
        Map<String, GCData> destination$iv = this.startGCData;
        boolean $i$f$associateTo = false;
        for (Object element$iv : $this$associateTo$iv) {
            Map<String, GCData> map = destination$iv;
            GarbageCollectorMXBean it = (GarbageCollectorMXBean)element$iv;
            boolean bl = false;
            String string2 = it.getName();
            Intrinsics.checkNotNull((Object)it);
            Pair pair = TuplesKt.to((Object)string2, (Object)new GCData(it));
            map.put((String)pair.getFirst(), (GCData)pair.getSecond());
        }
    }

    private final long deltaTime(long start) {
        return this.currentTime() - start;
    }

    public void notifyCompilerInitialized() {
        if (!this.isEnabled) {
            return;
        }
        long time = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.initStartNanos);
        ((Collection)this.measurements).add(new CompilerInitializationMeasurement(time));
    }

    public void notifyCompilationFinished() {
        if (!this.isEnabled) {
            return;
        }
        this.recordGcTime();
        this.recordJitCompilationTime();
        if (!this.isK2) {
            this.recordPerfCountersMeasurements();
        }
    }

    public void addSourcesStats(int files2, int lines) {
        if (!this.isEnabled) {
            return;
        }
        Integer n = this.files;
        this.files = n != null ? Integer.valueOf(n + files2) : Integer.valueOf(files2);
        Integer n2 = this.lines;
        this.lines = n2 != null ? Integer.valueOf(n2 + lines) : Integer.valueOf(lines);
    }

    public void notifyAnalysisStarted() {
        this.analysisStart = this.currentTime();
    }

    public void notifyAnalysisFinished() {
        long time = this.currentTime() - this.analysisStart;
        ((Collection)this.measurements).add(new CodeAnalysisMeasurement(this.lines, TimeUnit.NANOSECONDS.toMillis(time)));
    }

    public void notifyGenerationStarted() {
        this.generationStart = this.currentTime();
    }

    public void notifyGenerationFinished() {
        long time = this.currentTime() - this.generationStart;
        ((Collection)this.measurements).add(new CodeGenerationMeasurement(this.lines, TimeUnit.NANOSECONDS.toMillis(time)));
    }

    public void notifyIRTranslationStarted() {
        this.irTranslationStart = this.currentTime();
    }

    public void notifyIRTranslationFinished() {
        long time = this.deltaTime(this.irTranslationStart);
        ((Collection)this.measurements).add(new IRMeasurement(this.lines, TimeUnit.NANOSECONDS.toMillis(time), IRMeasurement.Kind.TRANSLATION));
    }

    public void notifyIRLoweringStarted() {
        this.irLoweringStart = this.currentTime();
    }

    public void notifyIRLoweringFinished() {
        long time = this.deltaTime(this.irLoweringStart);
        ((Collection)this.measurements).add(new IRMeasurement(this.lines, TimeUnit.NANOSECONDS.toMillis(time), IRMeasurement.Kind.LOWERING));
    }

    public void notifyIRGenerationStarted() {
        this.irGenerationStart = this.currentTime();
    }

    public void notifyIRGenerationFinished() {
        long time = this.deltaTime(this.irGenerationStart);
        ((Collection)this.measurements).add(new IRMeasurement(this.lines, TimeUnit.NANOSECONDS.toMillis(time), IRMeasurement.Kind.GENERATION));
    }

    public final void dumpPerformanceReport(@NotNull File destination) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        String string2 = this.createPerformanceReport();
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        FilesKt.writeBytes((File)destination, (byte[])byArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String createPerformanceReport() {
        void $this$mapTo$iv$iv;
        StringBuilder stringBuilder;
        StringBuilder $this$createPerformanceReport_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$createPerformanceReport_u24lambda_u243.append(this.presentableName + " performance report\n");
        Iterable $this$map$iv = this.getMeasurementResults();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PerformanceMeasurement performanceMeasurement = (PerformanceMeasurement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.render());
        }
        Iterable $this$forEach$iv = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl3 = false;
            $this$createPerformanceReport_u24lambda_u243.append(it + '\n');
        }
        return stringBuilder.toString();
    }

    private final void recordGcTime() {
        if (!this.isEnabled) {
            return;
        }
        List<GarbageCollectorMXBean> list = ManagementFactory.getGarbageCollectorMXBeans();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getGarbageCollectorMXBeans(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GCData startCounts;
            GarbageCollectorMXBean it = (GarbageCollectorMXBean)element$iv;
            boolean bl = false;
            GCData gCData = startCounts = this.startGCData.get(it.getName());
            long startCollectionTime = gCData != null ? gCData.getCollectionTime() : 0L;
            GCData gCData2 = startCounts;
            long startCollectionCount = gCData2 != null ? gCData2.getCollectionCount() : 0L;
            Collection collection = this.measurements;
            String string2 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            collection.add(new GarbageCollectionMeasurement(string2, it.getCollectionTime() - startCollectionTime, it.getCollectionCount() - startCollectionCount));
        }
    }

    private final void recordJitCompilationTime() {
        if (!this.isEnabled) {
            return;
        }
        CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
        if (compilationMXBean == null) {
            return;
        }
        CompilationMXBean bean = compilationMXBean;
        ((Collection)this.measurements).add(new JitCompilationMeasurement(bean.getTotalCompilationTime()));
    }

    private final void recordPerfCountersMeasurements() {
        PerformanceCounter.Companion.report((Function1<? super String, Unit>)((Function1)arg_0 -> PerformanceManager.recordPerfCountersMeasurements$lambda$5(this, arg_0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T measureTime$compiler_common(@NotNull KClass<?> measurementClass, @NotNull Function0<? extends T> block) {
        Object object;
        long elapsedMillis;
        Object object2;
        Intrinsics.checkNotNullParameter(measurementClass, (String)"measurementClass");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (!this.isEnabled) {
            block.invoke();
        }
        long startTime = this.currentTime();
        try {
            object2 = block.invoke();
            elapsedMillis = TimeUnit.NANOSECONDS.toMillis(this.currentTime() - startTime);
            object = this.counterMeasurementsLock;
        }
        catch (Throwable throwable) {
            long elapsedMillis2 = TimeUnit.NANOSECONDS.toMillis(this.currentTime() - startTime);
            Object object3 = this.counterMeasurementsLock;
            synchronized (object3) {
                CounterMeasurement counterMeasurement;
                boolean bl = false;
                CounterMeasurement counterMeasurement2 = this.counterMeasurements.get(measurementClass);
                if (counterMeasurement2 == null) {
                    throw new IllegalStateException(("No counter measurement initialized for " + measurementClass).toString());
                }
                CounterMeasurement currentMeasurement = counterMeasurement2;
                int newCount = currentMeasurement.getCount() + 1;
                long newElapsed = currentMeasurement.getMilliseconds() + elapsedMillis2;
                KClass<?> kClass = measurementClass;
                if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(FindJavaClassMeasurement.class))) {
                    counterMeasurement = new FindJavaClassMeasurement(newCount, newElapsed);
                } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(BinaryClassFromKotlinFileMeasurement.class))) {
                    counterMeasurement = new BinaryClassFromKotlinFileMeasurement(newCount, newElapsed);
                } else {
                    throw new IllegalStateException(("The measurement for " + measurementClass + " is not supported").toString());
                }
                CounterMeasurement newMeasurement = counterMeasurement;
                this.counterMeasurements.put(measurementClass, newMeasurement);
                Unit unit = Unit.INSTANCE;
            }
            throw throwable;
        }
        synchronized (object) {
            CounterMeasurement counterMeasurement;
            boolean bl = false;
            CounterMeasurement counterMeasurement3 = this.counterMeasurements.get(measurementClass);
            if (counterMeasurement3 == null) {
                throw new IllegalStateException(("No counter measurement initialized for " + measurementClass).toString());
            }
            CounterMeasurement currentMeasurement = counterMeasurement3;
            int newCount = currentMeasurement.getCount() + 1;
            long newElapsed = currentMeasurement.getMilliseconds() + elapsedMillis;
            KClass<?> kClass = measurementClass;
            if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(FindJavaClassMeasurement.class))) {
                counterMeasurement = new FindJavaClassMeasurement(newCount, newElapsed);
            } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(BinaryClassFromKotlinFileMeasurement.class))) {
                counterMeasurement = new BinaryClassFromKotlinFileMeasurement(newCount, newElapsed);
            } else {
                throw new IllegalStateException(("The measurement for " + measurementClass + " is not supported").toString());
            }
            CounterMeasurement newMeasurement = counterMeasurement;
            this.counterMeasurements.put(measurementClass, newMeasurement);
            Unit unit = Unit.INSTANCE;
        }
        return (T)object2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String renderCompilerPerformance() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getMeasurementResults();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PerformanceMeasurement it = (PerformanceMeasurement)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof CompilerInitializationMeasurement || it instanceof CodeAnalysisMeasurement || it instanceof CodeGenerationMeasurement || it instanceof PerformanceCounterMeasurement || it instanceof FindJavaClassMeasurement || it instanceof BinaryClassFromKotlinFileMeasurement)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List relevantMeasurements = (List)destination$iv$iv;
        return "Compiler perf stats:\n" + CollectionsKt.joinToString$default((Iterable)relevantMeasurements, (CharSequence)"\n", null, null, (int)0, null, PerformanceManager::renderCompilerPerformance$lambda$8, (int)30, null);
    }

    private static final Unit recordPerfCountersMeasurements$lambda$5(PerformanceManager this$0, String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        ((Collection)this$0.measurements).add(new PerformanceCounterMeasurement(s));
        return Unit.INSTANCE;
    }

    private static final CharSequence renderCompilerPerformance$lambda$8(PerformanceMeasurement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "  " + it.render();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/util/PerformanceManager$GCData;", "", "name", "", "collectionTime", "", "collectionCount", "<init>", "(Ljava/lang/String;JJ)V", "bean", "Ljava/lang/management/GarbageCollectorMXBean;", "(Ljava/lang/management/GarbageCollectorMXBean;)V", "getName", "()Ljava/lang/String;", "getCollectionTime", "()J", "getCollectionCount", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "compiler.common"})
    private static final class GCData {
        @NotNull
        private final String name;
        private final long collectionTime;
        private final long collectionCount;

        public GCData(@NotNull String name2, long collectionTime, long collectionCount) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            this.name = name2;
            this.collectionTime = collectionTime;
            this.collectionCount = collectionCount;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final long getCollectionTime() {
            return this.collectionTime;
        }

        public final long getCollectionCount() {
            return this.collectionCount;
        }

        public GCData(@NotNull GarbageCollectorMXBean bean) {
            Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
            String string2 = bean.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            this(string2, bean.getCollectionTime(), bean.getCollectionCount());
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final long component2() {
            return this.collectionTime;
        }

        public final long component3() {
            return this.collectionCount;
        }

        @NotNull
        public final GCData copy(@NotNull String name2, long collectionTime, long collectionCount) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            return new GCData(name2, collectionTime, collectionCount);
        }

        public static /* synthetic */ GCData copy$default(GCData gCData, String string2, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = gCData.name;
            }
            if ((n & 2) != 0) {
                l = gCData.collectionTime;
            }
            if ((n & 4) != 0) {
                l2 = gCData.collectionCount;
            }
            return gCData.copy(string2, l, l2);
        }

        @NotNull
        public String toString() {
            return "GCData(name=" + this.name + ", collectionTime=" + this.collectionTime + ", collectionCount=" + this.collectionCount + ')';
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.collectionTime);
            result2 = result2 * 31 + Long.hashCode(this.collectionCount);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GCData)) {
                return false;
            }
            GCData gCData = (GCData)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)gCData.name)) {
                return false;
            }
            if (this.collectionTime != gCData.collectionTime) {
                return false;
            }
            return this.collectionCount == gCData.collectionCount;
        }
    }
}

