/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.dynatrace.hash4j.hashing.HashSink;
import com.dynatrace.hash4j.hashing.HashStream64;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.FileCollectionFactory;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.jps.ProjectPaths;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetHashSupplier;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.java.ExcludedJavaSourceRootProvider;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.BuilderRegistry;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompilerEncodingConfiguration;
import org.jetbrains.jps.incremental.FileHashUtil;
import org.jetbrains.jps.incremental.JVMModuleBuildTarget;
import org.jetbrains.jps.incremental.JvmClassFileInstrumenter;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.incremental.storage.ProjectStamps;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaDependenciesEnumerator;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.LanguageLevel;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;
import org.jetbrains.jps.model.java.impl.JpsJavaDependenciesEnumeratorImpl;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleDependency;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.JpsTypedModuleSourceRoot;
import org.jetbrains.jps.service.JpsServiceManager;

@ApiStatus.NonExtendable
public class ModuleBuildTarget
extends JVMModuleBuildTarget<JavaSourceRootDescriptor>
implements BuildTargetHashSupplier {
    private static final Logger LOG = Logger.getInstance(ModuleBuildTarget.class);
    public static final Boolean REBUILD_ON_DEPENDENCY_CHANGE = Boolean.valueOf(System.getProperty("rebuild.on.dependency.change", "true"));
    private final JavaModuleBuildTargetType targetType;

    public ModuleBuildTarget(@NotNull JpsModule module, @NotNull JavaModuleBuildTargetType targetType) {
        if (module == null) {
            ModuleBuildTarget.$$$reportNull$$$0(0);
        }
        if (targetType == null) {
            ModuleBuildTarget.$$$reportNull$$$0(1);
        }
        super(targetType, module);
        this.targetType = targetType;
    }

    @Nullable
    public File getOutputDir() {
        return JpsJavaExtensionService.getInstance().getOutputDirectory(this.myModule, this.targetType.isTests());
    }

    @Override
    @NotNull
    public @Unmodifiable Collection<File> getOutputRoots(@NotNull CompileContext context) {
        File annotationOut;
        if (context == null) {
            ModuleBuildTarget.$$$reportNull$$$0(2);
        }
        File outputDir = this.getOutputDir();
        JpsModule module = this.getModule();
        JpsJavaCompilerConfiguration configuration = JpsJavaExtensionService.getInstance().getCompilerConfiguration(module.getProject());
        ProcessorConfigProfile profile = configuration.getAnnotationProcessingProfile(module);
        if (profile.isEnabled() && (annotationOut = ProjectPaths.getAnnotationProcessorGeneratedSourcesOutputDir(module, this.isTests(), profile)) != null) {
            List<File> list = outputDir == null ? List.of(annotationOut) : List.of(outputDir, annotationOut);
            if (list == null) {
                ModuleBuildTarget.$$$reportNull$$$0(3);
            }
            return list;
        }
        List<Object> list = outputDir == null ? List.of() : List.of(outputDir);
        if (list == null) {
            ModuleBuildTarget.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    public boolean isTests() {
        return this.targetType.isTests();
    }

    @Override
    @NotNull
    public @Unmodifiable Collection<BuildTarget<?>> computeDependencies(@NotNull BuildTargetRegistry targetRegistry, @NotNull TargetOutputIndex outputIndex) {
        if (targetRegistry == null) {
            ModuleBuildTarget.$$$reportNull$$$0(5);
        }
        if (outputIndex == null) {
            ModuleBuildTarget.$$$reportNull$$$0(6);
        }
        JpsJavaDependenciesEnumeratorImpl enumerator = (JpsJavaDependenciesEnumeratorImpl)JpsJavaExtensionService.dependencies((JpsModule)this.myModule).compileOnly();
        if (!this.isTests()) {
            enumerator.productionOnly();
        }
        ArrayList dependencies = new ArrayList();
        enumerator.processDependencies(dependencyElement -> {
            JpsModule depModule;
            if (dependencyElement instanceof JpsModuleDependency && (depModule = ((JpsModuleDependency)dependencyElement).getModule()) != null) {
                JavaModuleBuildTargetType targetType = this.targetType.equals(JavaModuleBuildTargetType.PRODUCTION) && enumerator.isProductionOnTests(dependencyElement) ? JavaModuleBuildTargetType.TEST : this.targetType;
                dependencies.add(new ModuleBuildTarget(depModule, targetType));
            }
            return true;
        });
        if (this.isTests()) {
            dependencies.add(new ModuleBuildTarget(this.myModule, JavaModuleBuildTargetType.PRODUCTION));
        }
        Collection<ModuleBasedTarget<?>> moduleBased = targetRegistry.getModuleBasedTargets(this.getModule(), this.isTests() ? BuildTargetRegistry.ModuleTargetSelector.TEST : BuildTargetRegistry.ModuleTargetSelector.PRODUCTION);
        for (ModuleBasedTarget<?> target : moduleBased) {
            if (target == this || !target.isCompiledBeforeModuleLevelBuilders()) continue;
            dependencies.add(target);
        }
        ArrayList arrayList = dependencies;
        if (arrayList == null) {
            ModuleBuildTarget.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public @Unmodifiable List<JavaSourceRootDescriptor> computeRootDescriptors(@NotNull JpsModel model, @NotNull ModuleExcludeIndex index, @NotNull IgnoredFileIndex ignoredFileIndex, @NotNull BuildDataPaths dataPaths) {
        if (model == null) {
            ModuleBuildTarget.$$$reportNull$$$0(8);
        }
        if (index == null) {
            ModuleBuildTarget.$$$reportNull$$$0(9);
        }
        if (ignoredFileIndex == null) {
            ModuleBuildTarget.$$$reportNull$$$0(10);
        }
        if (dataPaths == null) {
            ModuleBuildTarget.$$$reportNull$$$0(11);
        }
        ArrayList<JavaSourceRootDescriptor> roots = new ArrayList<JavaSourceRootDescriptor>();
        JavaSourceRootType type = this.isTests() ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE;
        Iterable excludedRootProviders = JpsServiceManager.getInstance().getExtensions(ExcludedJavaSourceRootProvider.class);
        JpsJavaCompilerConfiguration compilerConfig = JpsJavaExtensionService.getInstance().getCompilerConfiguration(this.myModule.getProject());
        block0: for (JpsTypedModuleSourceRoot sourceRoot : this.myModule.getSourceRoots((JpsModuleSourceRootType)type)) {
            File outputIoDir;
            if (index.isExcludedFromModule(sourceRoot.getFile(), this.myModule)) continue;
            for (ExcludedJavaSourceRootProvider provider : excludedRootProviders) {
                if (!provider.isExcludedFromCompilation(this.myModule, (JpsModuleSourceRoot)sourceRoot)) continue;
                continue block0;
            }
            String packagePrefix = ((JavaSourceRootProperties)sourceRoot.getProperties()).getPackagePrefix();
            Set excludes = this.computeRootExcludes(sourceRoot.getPath(), index);
            ProcessorConfigProfile profile = compilerConfig.getAnnotationProcessingProfile(this.myModule);
            if (profile.isEnabled() && (outputIoDir = ProjectPaths.getAnnotationProcessorGeneratedSourcesOutputDir(this.myModule, JavaSourceRootType.TEST_SOURCE == sourceRoot.getRootType(), profile)) != null) {
                Path outputDir = outputIoDir.toPath();
                if (sourceRoot.getPath().startsWith(outputDir)) {
                    excludes = FileCollectionFactory.createCanonicalPathSet(excludes);
                    excludes.add(outputDir);
                }
            }
            FileFilter filterForExcludedPatterns = index.getModuleFileFilterHonorExclusionPatterns(this.myModule);
            roots.add(JavaSourceRootDescriptor.createJavaSourceRootDescriptor(sourceRoot.getFile(), this, false, false, packagePrefix, excludes, filterForExcludedPatterns));
        }
        ArrayList<JavaSourceRootDescriptor> arrayList = roots;
        if (arrayList == null) {
            ModuleBuildTarget.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = "Module '" + this.getModule().getName() + "' " + (this.targetType.isTests() ? "tests" : "production");
        if (string == null) {
            ModuleBuildTarget.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    @ApiStatus.Internal
    public void computeConfigurationDigest(@NotNull ProjectDescriptor projectDescriptor, @NotNull HashSink hash) {
        String oldText;
        if (projectDescriptor == null) {
            ModuleBuildTarget.$$$reportNull$$$0(14);
        }
        if (hash == null) {
            ModuleBuildTarget.$$$reportNull$$$0(15);
        }
        JpsModule module = this.getModule();
        PathRelativizerService relativizer = projectDescriptor.dataManager.getRelativizer();
        StringBuilder logBuilder = LOG.isDebugEnabled() ? new StringBuilder() : null;
        this.getDependenciesFingerprint(logBuilder, relativizer, hash);
        List<JavaSourceRootDescriptor> roots = projectDescriptor.getBuildRootIndex().getTargetRoots(this, null);
        for (JavaSourceRootDescriptor root : roots) {
            String path = relativizer.toRelative(root.rootFile);
            if (logBuilder != null) {
                logBuilder.append(path).append('\n');
            }
            FileHashUtil.computePathHashCode(path, hash);
        }
        hash.putInt(roots.size());
        LanguageLevel level = JpsJavaExtensionService.getInstance().getLanguageLevel(module);
        if (level == null) {
            hash.putInt(0);
        } else {
            if (logBuilder != null) {
                logBuilder.append(level.name()).append("\n");
            }
            hash.putString(level.name());
        }
        JpsJavaCompilerConfiguration config = JpsJavaExtensionService.getInstance().getCompilerConfiguration(module.getProject());
        String bytecodeTarget = config.getByteCodeTargetLevel(module.getName());
        if (bytecodeTarget == null) {
            hash.putInt(0);
        } else {
            if (logBuilder != null) {
                logBuilder.append(bytecodeTarget).append('\n');
            }
            hash.putString(bytecodeTarget);
        }
        CompilerEncodingConfiguration encodingConfig = projectDescriptor.getEncodingConfiguration();
        String encoding = encodingConfig.getPreferredModuleEncoding(module);
        if (encoding == null) {
            hash.putInt(0);
        } else {
            if (logBuilder != null) {
                logBuilder.append(encoding).append("\n");
            }
            hash.putString(encoding);
        }
        if (SystemProperties.getBooleanProperty((String)"jps.rebuild.on.change.in.instrumenters", (boolean)true)) {
            for (JvmClassFileInstrumenter instrumenter : BuilderRegistry.getInstance().getClassFileInstrumenters()) {
                if (!instrumenter.isEnabled(projectDescriptor, module)) continue;
                hash.putString(instrumenter.getId());
                hash.putInt(instrumenter.getVersion());
                if (logBuilder == null) continue;
                logBuilder.append(instrumenter.getId()).append(":").append(instrumenter.getVersion()).append('\n');
            }
        }
        if (logBuilder == null) {
            return;
        }
        Path configurationTextFile = projectDescriptor.dataManager.getDataPaths().getTargetDataRootDir(this).resolve("config.dat.debug.txt");
        try {
            oldText = Files.readString(configurationTextFile);
        }
        catch (IOException e) {
            oldText = null;
        }
        String newText = logBuilder.toString();
        if (!newText.equals(oldText)) {
            if (oldText != null && hash instanceof HashStream64) {
                LOG.debug("Configuration differs from the last recorded one for " + this.getPresentableName() + ".\nRecorded configuration:\n" + oldText + "\nCurrent configuration (hash=" + ((HashStream64)hash).getAsLong() + "):\n" + newText);
            }
            try {
                Files.createDirectories(configurationTextFile.getParent(), new FileAttribute[0]);
                Files.writeString(configurationTextFile, (CharSequence)newText, new OpenOption[0]);
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
            }
        }
    }

    private void getDependenciesFingerprint(@Nullable StringBuilder logBuilder, @NotNull PathRelativizerService relativizer, @NotNull HashSink hash) {
        if (relativizer == null) {
            ModuleBuildTarget.$$$reportNull$$$0(16);
        }
        if (hash == null) {
            ModuleBuildTarget.$$$reportNull$$$0(17);
        }
        if (!REBUILD_ON_DEPENDENCY_CHANGE.booleanValue()) {
            hash.putInt(0);
            return;
        }
        JpsModule module = this.getModule();
        JpsJavaDependenciesEnumerator enumerator = JpsJavaExtensionService.dependencies((JpsModule)module).compileOnly().recursivelyExportedOnly();
        if (!this.isTests()) {
            enumerator = enumerator.productionOnly();
        }
        if (ProjectStamps.PORTABLE_CACHES) {
            enumerator = enumerator.withoutSdk();
        }
        if (JavaBuilderUtil.isTrackLibraryDependenciesEnabled()) {
            for (JpsLibrary library : enumerator.getLibraries()) {
                hash.putString(library.getName());
            }
            enumerator = enumerator.withoutLibraries();
        }
        Collection roots = enumerator.classes().getPaths();
        for (Path file : roots) {
            String path = relativizer.toRelative(file);
            ModuleBuildTarget.getContentHash(file, hash);
            if (logBuilder != null) {
                logBuilder.append(path);
                if (hash instanceof HashStream64) {
                    logBuilder.append(": ").append(((HashStream64)hash).getAsLong());
                }
                logBuilder.append("\n");
            }
            FileHashUtil.computePathHashCode(path, hash);
        }
        hash.putInt(roots.size());
    }

    private static void getContentHash(Path file, HashSink hash) {
        if (ProjectStamps.TRACK_LIBRARY_CONTENT) {
            try {
                if (Files.isRegularFile(file, new LinkOption[0]) && file.getFileName().endsWith(".jar")) {
                    FileHashUtil.getFileHash(file, hash);
                } else {
                    hash.putInt(0);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/ModuleBuildTarget";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRegistry";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputIndex";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredFileIndex";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPaths";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDescriptor";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/ModuleBuildTarget";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputRoots";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDependencies";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRootDescriptors";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOutputRoots";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 12: 
            case 13: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeDependencies";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "computeRootDescriptors";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "computeConfigurationDigest";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDependenciesFingerprint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

