/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.openapi.diagnostic.Logger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.storage.StorageManager;
import org.jetbrains.jps.incremental.storage.StoreErrorHandler;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u009d\u0001\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00070\u0005\"\b\b\u0000\u0010\u0006*\u00020\b\"\b\b\u0001\u0010\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00070\u000e2O\u0010\u000f\u001aK\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u0011\u0012\b\b\u000b\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0011\u0012\b\b\u000b\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0011\u0012\b\b\u000b\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00170\u0010j\u0002`\u0018H\u0002\u001aw\u0010\u0019\u001a\u00020\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u00152O\u0010\u000f\u001aK\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u0011\u0012\b\b\u000b\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0011\u0012\b\b\u000b\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0011\u0012\b\b\u000b\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00170\u0010j\u0002`\u00182\b\b\u0002\u0010\u001d\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001as\u0010\u001f\u001a\u00020\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00012O\u0010\u000f\u001aK\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u0011\u0012\b\b\u000b\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0011\u0012\b\b\u000b\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0011\u0012\b\b\u000b\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00170\u0010j\u0002`\u0018H\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000*\u0094\u0001\u0010 \"G\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u0011\u0012\b\b\u000b\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0011\u0012\b\b\u000b\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0011\u0012\b\b\u000b\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00170\u00102G\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u0011\u0012\b\b\u000b\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0011\u0012\b\b\u000b\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0011\u0012\b\b\u000b\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00170\u0010\u00a8\u0006!"}, d2={"MV_STORE_CACHE_SIZE_IN_MB", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "openOrResetMap", "Lorg/h2/mvstore/MVMap;", "K", "V", "", "store", "Lorg/h2/mvstore/MVStore;", "name", "", "mapBuilder", "Lorg/h2/mvstore/MVMap$Builder;", "logger", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "message", "", "error", "", "isWarn", "", "Lorg/jetbrains/jps/incremental/storage/StoreLogger;", "createOrResetMvStore", "file", "Ljava/nio/file/Path;", "readOnly", "autoCommitDelay", "getInvalidateMarkerFile", "tryOpenMvStore", "StoreLogger", "intellij.platform.jps.build"})
@SourceDebugExtension(value={"SMAP\nStorageManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StorageManager.kt\norg/jetbrains/jps/incremental/storage/StorageManagerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,231:1\n1#2:232\n15#3:233\n*S KotlinDebug\n*F\n+ 1 StorageManager.kt\norg/jetbrains/jps/incremental/storage/StorageManagerKt\n*L\n18#1:233\n*E\n"})
public final class StorageManagerKt {
    private static final int MV_STORE_CACHE_SIZE_IN_MB;
    @NotNull
    private static final Logger LOG;

    private static final <K, V> MVMap<K, V> openOrResetMap(MVStore store, String name, MVMap.Builder<K, V> mapBuilder, Function3<? super String, ? super Throwable, ? super Boolean, Unit> logger) {
        try {
            MVMap mVMap = store.openMap(name, (MVMap.MapBuilder)mapBuilder);
            Intrinsics.checkNotNullExpressionValue((Object)mVMap, (String)"openMap(...)");
            return mVMap;
        }
        catch (Throwable e) {
            logger.invoke((Object)("Cannot open map " + name + ", map will be removed"), (Object)e, (Object)true);
            try {
                store.removeMap(name);
            }
            catch (Throwable e2) {
                ExceptionsKt.addSuppressed((Throwable)e, (Throwable)e2);
            }
            MVMap mVMap = store.openMap(name, (MVMap.MapBuilder)mapBuilder);
            Intrinsics.checkNotNullExpressionValue((Object)mVMap, (String)"openMap(...)");
            return mVMap;
        }
    }

    private static final MVStore createOrResetMvStore(Path file, boolean readOnly, Function3<? super String, ? super Throwable, ? super Boolean, Unit> logger, int autoCommitDelay) {
        if (file == null || readOnly && Files.notExists(file, new LinkOption[0])) {
            return StorageManagerKt.tryOpenMvStore(null, readOnly, autoCommitDelay, logger);
        }
        Path markerFile = StorageManagerKt.getInvalidateMarkerFile(file);
        if (Files.exists(markerFile, new LinkOption[0])) {
            Files.deleteIfExists(file);
            Files.deleteIfExists(markerFile);
        }
        Path path = file.getParent();
        if (path != null) {
            Path it = path;
            boolean bl = false;
            Files.createDirectories(it, new FileAttribute[0]);
        }
        try {
            return StorageManagerKt.tryOpenMvStore(file, readOnly, autoCommitDelay, logger);
        }
        catch (Throwable e) {
            logger.invoke((Object)"Cannot open cache storage, will be recreated", (Object)e, (Object)true);
            Files.deleteIfExists(file);
            return StorageManagerKt.tryOpenMvStore(file, readOnly, autoCommitDelay, logger);
        }
    }

    static /* synthetic */ MVStore createOrResetMvStore$default(Path path, boolean bl, Function3 function3, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 8) != 0) {
            n = 60000;
        }
        return StorageManagerKt.createOrResetMvStore(path, bl, (Function3<? super String, ? super Throwable, ? super Boolean, Unit>)function3, n);
    }

    private static final Path getInvalidateMarkerFile(Path file) {
        Path path = file.resolveSibling(file.getFileName() + ".invalidated");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolveSibling(...)");
        return path;
    }

    @ApiStatus.Internal
    @NotNull
    public static final MVStore tryOpenMvStore(@Nullable Path file, boolean readOnly, int autoCommitDelay, @NotNull Function3<? super String, ? super Throwable, ? super Boolean, Unit> logger) {
        MVStore.Builder builder;
        Intrinsics.checkNotNullParameter(logger, (String)"logger");
        StoreErrorHandler storeErrorHandler = new StoreErrorHandler(file, logger);
        Path path = file;
        MVStore.Builder it = builder = new MVStore.Builder().fileName(path != null && (path = path.toAbsolutePath()) != null ? ((Object)path).toString() : null).backgroundExceptionHandler((Thread.UncaughtExceptionHandler)storeErrorHandler).cacheSize(MV_STORE_CACHE_SIZE_IN_MB);
        boolean bl = false;
        if (readOnly) {
            it.readOnly();
        }
        if (autoCommitDelay == 0) {
            it.autoCommitDisabled();
        }
        MVStore store = builder.autoCommitBufferSize(0).open();
        storeErrorHandler.isStoreOpened = true;
        store.setVersionsToKeep(0);
        if (autoCommitDelay != 0) {
            store.setAutoCommitDelay(autoCommitDelay);
        }
        Intrinsics.checkNotNull((Object)store);
        return store;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ MVMap access$openOrResetMap(MVStore store, String name, MVMap.Builder mapBuilder, Function3 logger) {
        return StorageManagerKt.openOrResetMap(store, name, mapBuilder, (Function3<? super String, ? super Throwable, ? super Boolean, Unit>)logger);
    }

    public static final /* synthetic */ int access$getMV_STORE_CACHE_SIZE_IN_MB$p() {
        return MV_STORE_CACHE_SIZE_IN_MB;
    }

    static {
        String string = System.getProperty("jps.new.storage.cache.size.mb", "64");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        MV_STORE_CACHE_SIZE_IN_MB = Integer.parseInt(string);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(StorageManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

