/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.grape;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.grape.GrapeRunner;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.runner.DefaultGroovyScriptRunner;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;

public final class GrabDependencies
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance(GrabDependencies.class);
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroupManager.getInstance().getNotificationGroup("Grape");
    public static final String GRAPE_RUNNER = "org.jetbrains.plugins.groovy.grape.GrapeRunner";

    @NotNull
    public String getText() {
        String string = GroovyBundle.message("grab.intention.name", new Object[0]);
        if (string == null) {
            GrabDependencies.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("grab.family.name", new Object[0]);
        if (string == null) {
            GrabDependencies.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            GrabDependencies.$$$reportNull$$$0(2);
        }
        if (!GrabDependencies.isCorrectModule(file)) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        GrAnnotation anno = (GrAnnotation)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, GrAnnotation.class, (boolean)false);
        if (anno != null && GrabDependencies.isGrabAnnotation(anno)) {
            return true;
        }
        PsiElement at = file.findElementAt(offset);
        return at != null && GrabDependencies.isUnresolvedRefName(at) && GrabDependencies.findGrab(file) != null;
    }

    private static PsiAnnotation findGrab(PsiFile file) {
        if (!(file instanceof GroovyFile)) {
            return null;
        }
        return (PsiAnnotation)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            PsiClass grab = JavaPsiFacade.getInstance((Project)file.getProject()).findClass("groovy.lang.Grab", file.getResolveScope());
            Ref result2 = Ref.create();
            if (grab != null) {
                ReferencesSearch.search((PsiElement)grab, (SearchScope)new LocalSearchScope((PsiElement)file)).forEach(reference -> {
                    PsiElement parent;
                    if (reference instanceof GrCodeReferenceElement && (parent = ((GrCodeReferenceElement)reference).getParent()) instanceof PsiAnnotation) {
                        result2.set((Object)((PsiAnnotation)parent));
                        return false;
                    }
                    return true;
                });
            }
            return CachedValueProvider.Result.create((Object)((PsiAnnotation)result2.get()), (Object[])new Object[]{file});
        });
    }

    private static boolean isUnresolvedRefName(@NotNull PsiElement at) {
        PsiElement parent;
        if (at == null) {
            GrabDependencies.$$$reportNull$$$0(3);
        }
        return (parent = at.getParent()) instanceof GrReferenceElement && ((GrReferenceElement)parent).getReferenceNameElement() == at && ((GrReferenceElement)parent).resolve() == null;
    }

    private static boolean isGrabAnnotation(@NotNull GrAnnotation anno) {
        String qname;
        if (anno == null) {
            GrabDependencies.$$$reportNull$$$0(4);
        }
        return (qname = anno.getQualifiedName()) != null && (qname.startsWith("groovy.lang.Grab") || "groovy.lang.Grapes".equals(qname));
    }

    private static boolean isCorrectModule(PsiFile file) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return false;
        }
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (sdk == null) {
            return false;
        }
        return file.getOriginalFile().getVirtualFile() != null && sdk.getSdkType() instanceof JavaSdkType;
    }

    public void invoke(final @NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            GrabDependencies.$$$reportNull$$$0(5);
        }
        final Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        assert (module != null);
        VirtualFile vfile = file.getOriginalFile().getVirtualFile();
        assert (vfile != null);
        if (JavaPsiFacade.getInstance((Project)project).findClass("org.apache.ivy.core.report.ResolveReport", file.getResolveScope()) == null) {
            Messages.showErrorDialog((String)GroovyBundle.message("grab.error.ivy.missing.message", new Object[0]), (String)GroovyBundle.message("grab.error.ivy.missing.title", new Object[0]));
            return;
        }
        Map<String, String> queries = GrabDependencies.prepareQueries(file);
        final HashMap<@NlsSafe String, GeneralCommandLine> lines = new HashMap<String, GeneralCommandLine>();
        for (String grabText : queries.keySet()) {
            JavaParameters javaParameters = GroovyScriptRunConfiguration.createJavaParametersWithSdk(module);
            try {
                DefaultGroovyScriptRunner.configureGenericGroovyRunner(javaParameters, module, GRAPE_RUNNER, false, true, true, false);
                javaParameters.getClassPath().add(PathUtil.getJarPathForClass(GrapeRunner.class));
                javaParameters.getProgramParametersList().add(queries.get(grabText));
                javaParameters.setUseDynamicClasspath(project);
                lines.put(grabText, javaParameters.toCommandLine());
            }
            catch (CantRunException e) {
                String title = GroovyBundle.message("grab.error.0.title", ExceptionUtil.getMessage((Throwable)e));
                NOTIFICATION_GROUP.createNotification(title, ExceptionUtil.getThrowableText((Throwable)e), NotificationType.ERROR).notify(project);
                return;
            }
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, GroovyBundle.message("grab.progress.title", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                int totalJarCount = 0;
                HtmlBuilder messages = new HtmlBuilder();
                for (Map.Entry entry : lines.entrySet()) {
                    String grabText = (String)entry.getKey();
                    indicator.setText2(grabText);
                    try {
                        GrapeProcessHandler handler = new GrapeProcessHandler((GeneralCommandLine)entry.getValue(), module);
                        handler.startNotify();
                        handler.waitFor();
                        int jarCount = handler.jarCount;
                        totalJarCount += jarCount;
                        messages.append((HtmlChunk)HtmlChunk.p().children(new HtmlChunk[]{HtmlChunk.raw((String)GroovyBundle.message("grab.jar.count", grabText, jarCount)), handler.messages}));
                    }
                    catch (ExecutionException e) {
                        LOG.error((Throwable)e);
                    }
                }
                String title = GroovyBundle.message("grab.result.title", totalJarCount);
                NOTIFICATION_GROUP.createNotification(title, messages.toString(), NotificationType.INFORMATION).notify(project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/groovy/grape/GrabDependencies$1", "run"));
            }
        });
    }

    static Map<@NlsSafe String, String> prepareQueries(PsiFile file) {
        final LinkedHashSet grabs = new LinkedHashSet();
        final HashSet excludes = new HashSet();
        final HashSet resolvers = new HashSet();
        file.acceptChildren((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (element instanceof GrAnnotation) {
                    GrAnnotation anno = (GrAnnotation)element;
                    String qname = anno.getQualifiedName();
                    if ("groovy.lang.Grab".equals(qname)) {
                        grabs.add(anno);
                    } else if ("groovy.lang.GrabExclude".equals(qname)) {
                        excludes.add(anno);
                    } else if ("groovy.lang.GrabResolver".equals(qname)) {
                        resolvers.add(anno);
                    }
                }
                super.visitElement(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/grape/GrabDependencies$2", "visitElement"));
            }
        });
        Function mapper = grAnnotation -> grAnnotation.getText();
        String common = StringUtil.join(excludes, (Function)mapper, (String)" ") + " " + StringUtil.join(resolvers, (Function)mapper, (String)" ");
        LinkedHashMap<@NlsSafe String, String> result2 = new LinkedHashMap<String, String>();
        for (GrAnnotation grab : grabs) {
            String grabText = grab.getText();
            result2.put(grabText, (grabText + " " + common).trim());
        }
        return result2;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    private static HtmlChunk processOutputChunk(@NlsSafe @NotNull String string) {
        if (string == null) {
            GrabDependencies.$$$reportNull$$$0(6);
        }
        if (string.isEmpty()) {
            HtmlChunk htmlChunk = HtmlChunk.empty();
            if (htmlChunk == null) {
                GrabDependencies.$$$reportNull$$$0(7);
            }
            return htmlChunk;
        }
        @NlsSafe Object[] lines = string.split("\n");
        HtmlChunk.Element element = new HtmlBuilder().appendWithSeparators((HtmlChunk)HtmlChunk.br(), (Iterable)ContainerUtil.map((Object[])lines, line -> HtmlChunk.text((String)line))).wrapWith("p");
        if (element == null) {
            GrabDependencies.$$$reportNull$$$0(8);
        }
        return element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/grape/GrabDependencies";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "at";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/grape/GrabDependencies";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "processOutputChunk";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isUnresolvedRefName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isGrabAnnotation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processOutputChunk";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }

    private static class GrapeProcessHandler
    extends OSProcessHandler {
        @NlsSafe
        private final StringBuilder myStdOut = new StringBuilder();
        @NlsSafe
        private final StringBuilder myStdErr = new StringBuilder();
        private final Module myModule;
        int jarCount;
        HtmlChunk messages = HtmlChunk.empty();

        GrapeProcessHandler(GeneralCommandLine commandLine, Module module) throws ExecutionException {
            super(commandLine);
            this.myModule = module;
        }

        public void notifyTextAvailable(@NotNull String text, @NotNull Key outputType) {
            if (text == null) {
                GrapeProcessHandler.$$$reportNull$$$0(0);
            }
            if (outputType == null) {
                GrapeProcessHandler.$$$reportNull$$$0(1);
            }
            text = StringUtil.convertLineSeparators((String)text);
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.valueOf(outputType) + text);
            }
            if (outputType == ProcessOutputTypes.STDOUT) {
                this.myStdOut.append(text);
            } else if (outputType == ProcessOutputTypes.STDERR) {
                this.myStdErr.append(text);
            }
        }

        private void addGrapeDependencies(List<VirtualFile> jars) {
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)this.myModule).getModifiableModel();
            LibraryTable.ModifiableModel tableModel = model.getModuleLibraryTable().getModifiableModel();
            for (VirtualFile jar : jars) {
                VirtualFile jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(jar);
                if (jarRoot == null) continue;
                OrderRootType rootType = OrderRootType.CLASSES;
                String libName = "Grab:" + jar.getName();
                for (String classifier : (String[])ContainerUtil.ar((Object[])new String[]{"sources", "source", "src"})) {
                    if (!libName.endsWith("-" + classifier + ".jar")) continue;
                    rootType = OrderRootType.SOURCES;
                    libName = StringUtil.trimEnd((String)libName, (String)("-" + classifier + ".jar")) + ".jar";
                }
                Library library = tableModel.getLibraryByName(libName);
                if (library == null) {
                    library = tableModel.createLibrary(libName);
                }
                Library.ModifiableModel libModel = library.getModifiableModel();
                for (String url : libModel.getUrls(rootType)) {
                    libModel.removeRoot(url, rootType);
                }
                libModel.addRoot(jarRoot, rootType);
                libModel.commit();
            }
            tableModel.commit();
            model.commit();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void notifyProcessTerminated(int exitCode) {
            try {
                ArrayList jars = new ArrayList();
                for (String line : this.myStdOut.toString().split("\n")) {
                    if (!line.startsWith("URL:")) continue;
                    try {
                        URL url = new URL(line.substring("URL:".length()));
                        File libFile = new File(url.toURI());
                        if (!libFile.exists() || !libFile.getName().endsWith(".jar")) continue;
                        ContainerUtil.addIfNotNull(jars, (Object)LocalFileSystem.getInstance().refreshAndFindFileByIoFile(libFile));
                    }
                    catch (MalformedURLException | URISyntaxException e) {
                        LOG.error((Throwable)e);
                    }
                }
                WriteAction.runAndWait(() -> {
                    this.jarCount = jars.size();
                    if (this.jarCount == 0) {
                        this.messages = new HtmlBuilder().append(GrabDependencies.processOutputChunk(this.myStdOut.toString())).append(GrabDependencies.processOutputChunk(this.myStdErr.toString())).toFragment();
                    }
                    if (!jars.isEmpty()) {
                        this.addGrapeDependencies(jars);
                    }
                });
            }
            finally {
                super.notifyProcessTerminated(exitCode);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outputType";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/groovy/grape/GrabDependencies$GrapeProcessHandler";
            objectArray[2] = "notifyTextAvailable";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

