/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.psi.PsiElement;
import com.intellij.psi.scope.DelegatingScopeProcessor;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.GrResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.processors.AccessorProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.DynamicMembersHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolveKind;
import org.jetbrains.plugins.groovy.lang.resolve.processors.KindsResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MultiProcessor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\n\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u00042\u00020\u00052\u00020\u0006B3\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\rH\u0016J\u001a\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u000fH\u0016J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00030\"2\u0006\u0010\u0017\u001a\u00020\rH\u0002R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030\"8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00030\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010(\u00a8\u0006,"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/processors/AccessorAwareProcessor;", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/KindsResolverProcessor;", "Lorg/jetbrains/plugins/groovy/lang/resolve/GrResolverProcessor;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "Lcom/intellij/psi/scope/ElementClassHint;", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/DynamicMembersHint;", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/MultiProcessor;", "name", "", "place", "Lcom/intellij/psi/PsiElement;", "kinds", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolveKind;", "accessorProcessors", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/AccessorProcessor;", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;Ljava/util/Set;Ljava/util/Collection;)V", "shouldProcessProperties", "", "shouldProcessMethods", "shouldProcess", "kind", "Lcom/intellij/psi/scope/ElementClassHint$DeclarationKind;", "handleEvent", "", "event", "Lcom/intellij/psi/scope/PsiScopeProcessor$Event;", "associated", "", "getProcessors", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "allProcessors", "", "accessorsNeeded", "getAccessorsNeeded", "()Z", "accessorCandidates", "getAccessorCandidates", "()Ljava/util/List;", "getCandidates", "results", "getResults", "intellij.groovy.psi"})
@SourceDebugExtension(value={"SMAP\nAccessorAwareProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccessorAwareProcessor.kt\norg/jetbrains/plugins/groovy/lang/resolve/processors/AccessorAwareProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n1755#2,3:99\n1734#2,3:102\n1368#2:105\n1454#2,5:106\n1#3:111\n*S KotlinDebug\n*F\n+ 1 AccessorAwareProcessor.kt\norg/jetbrains/plugins/groovy/lang/resolve/processors/AccessorAwareProcessor\n*L\n34#1:99,3\n51#1:102,3\n53#1:105\n53#1:106,5\n*E\n"})
public final class AccessorAwareProcessor
extends KindsResolverProcessor
implements GrResolverProcessor<GroovyResolveResult>,
ElementClassHint,
DynamicMembersHint,
MultiProcessor {
    @NotNull
    private final Collection<AccessorProcessor> accessorProcessors;
    @NotNull
    private final List<PsiScopeProcessor> allProcessors;

    public AccessorAwareProcessor(@NotNull String name, @NotNull PsiElement place, @NotNull Set<? extends GroovyResolveKind> kinds, @NotNull Collection<AccessorProcessor> accessorProcessors) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter(kinds, (String)"kinds");
        Intrinsics.checkNotNullParameter(accessorProcessors, (String)"accessorProcessors");
        super(name, place, kinds);
        this.accessorProcessors = accessorProcessors;
        this.hint(ElementClassHint.KEY, this);
        this.hint(DynamicMembersHint.KEY, this);
        this.allProcessors = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)new DelegatingScopeProcessor(this){}), (Iterable)this.accessorProcessors);
    }

    @Override
    public boolean shouldProcessProperties() {
        return true;
    }

    @Override
    public boolean shouldProcessMethods() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean shouldProcess(@NotNull ElementClassHint.DeclarationKind kind) {
        GroovyResolveKind it;
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        if (kind == ElementClassHint.DeclarationKind.METHOD) return false;
        Iterable $this$any$iv = this.getKinds();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (GroovyResolveKind)((Object)element$iv);
            boolean bl = false;
        } while (!it.declarationKinds.contains(kind));
        return true;
    }

    @Override
    public boolean shouldProcess(@NotNull GroovyResolveKind kind) {
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        return super.shouldProcess(kind) && (kind != GroovyResolveKind.PROPERTY || this.getAccessorsNeeded());
    }

    public void handleEvent(@NotNull PsiScopeProcessor.Event event, @Nullable Object associated) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        for (AccessorProcessor processor : this.accessorProcessors) {
            processor.handleEvent(event, associated);
        }
    }

    @NotNull
    public Collection<PsiScopeProcessor> getProcessors() {
        return this.allProcessors;
    }

    private final boolean getAccessorsNeeded() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = this.accessorProcessors;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    AccessorProcessor it = (AccessorProcessor)element$iv;
                    boolean bl2 = false;
                    if (it.getAcceptMore()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final List<GroovyResolveResult> getAccessorCandidates() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.accessorProcessors;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            AccessorProcessor it = (AccessorProcessor)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getResults();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<GroovyResolveResult> getCandidates(GroovyResolveKind kind) {
        Object object;
        block3: {
            block2: {
                object = this.getCandidate(kind);
                if (object == null) break block2;
                GroovyResolveResult p0 = object;
                boolean bl = false;
                List list = CollectionsKt.listOf((Object)p0);
                object = list;
                if (list != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        Object result2 = object;
        return kind == GroovyResolveKind.PROPERTY ? CollectionsKt.plus((Collection)((Collection)result2), (Iterable)this.getAccessorCandidates()) : result2;
    }

    @Override
    @NotNull
    public List<GroovyResolveResult> getResults() {
        List<GroovyResolveResult> fields;
        List<GroovyResolveResult> variables = this.getCandidates(GroovyResolveKind.VARIABLE);
        if (!((Collection)variables).isEmpty()) {
            return variables;
        }
        List<GroovyResolveResult> properties = ResolveUtilKt.singleOrValid(this.getCandidates(GroovyResolveKind.PROPERTY));
        if (!properties.isEmpty()) {
            GroovyResolveResult property = (GroovyResolveResult)CollectionsKt.singleOrNull(properties);
            if (property != null) {
                if (property.isStaticsOK()) {
                    return properties;
                }
            } else {
                return CollectionsKt.listOf((Object)properties.get(0));
            }
        }
        if (!(fields = this.getCandidates(GroovyResolveKind.FIELD)).isEmpty()) {
            return fields;
        }
        if (!((Collection)properties).isEmpty()) {
            return properties;
        }
        List<GroovyResolveResult> bindings = this.getCandidates(GroovyResolveKind.BINDING);
        if (!((Collection)bindings).isEmpty()) {
            return bindings;
        }
        Collection collection = this.getAllCandidates();
        GroovyResolveResult[] groovyResolveResultArray = ResolveUtil.filterSameSignatureCandidates((Collection<? extends GroovyResolveResult>)this.getAccessorCandidates());
        Intrinsics.checkNotNullExpressionValue((Object)groovyResolveResultArray, (String)"filterSameSignatureCandidates(...)");
        return CollectionsKt.plus((Collection)collection, (Object[])groovyResolveResultArray);
    }
}

