/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.typing;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\bJ\u0017\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0017\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/groovy/lang/typing/GenericsSearcher;", "Lcom/intellij/psi/PsiTypeVisitor;", "", "<init>", "()V", "visitClassType", "classType", "Lcom/intellij/psi/PsiClassType;", "(Lcom/intellij/psi/PsiClassType;)Ljava/lang/Boolean;", "visitArrayType", "arrayType", "Lcom/intellij/psi/PsiArrayType;", "(Lcom/intellij/psi/PsiArrayType;)Ljava/lang/Boolean;", "visitWildcardType", "wildcardType", "Lcom/intellij/psi/PsiWildcardType;", "(Lcom/intellij/psi/PsiWildcardType;)Ljava/lang/Boolean;", "intellij.groovy.psi"})
final class GenericsSearcher
extends PsiTypeVisitor<Boolean> {
    @NotNull
    public static final GenericsSearcher INSTANCE = new GenericsSearcher();

    private GenericsSearcher() {
    }

    @Nullable
    public Boolean visitClassType(@NotNull PsiClassType classType) {
        Intrinsics.checkNotNullParameter((Object)classType, (String)"classType");
        if (classType.resolve() instanceof PsiTypeParameter) {
            return true;
        }
        if (!classType.hasParameters()) {
            return null;
        }
        for (PsiType parameter : classType.getParameters()) {
            if (!Intrinsics.areEqual((Object)parameter.accept((PsiTypeVisitor)this), (Object)true)) continue;
            return true;
        }
        return null;
    }

    @Nullable
    public Boolean visitArrayType(@NotNull PsiArrayType arrayType) {
        Intrinsics.checkNotNullParameter((Object)arrayType, (String)"arrayType");
        return (Boolean)arrayType.getComponentType().accept((PsiTypeVisitor)this);
    }

    @Nullable
    public Boolean visitWildcardType(@NotNull PsiWildcardType wildcardType) {
        Intrinsics.checkNotNullParameter((Object)wildcardType, (String)"wildcardType");
        PsiType psiType = wildcardType.getBound();
        return psiType != null ? (Boolean)psiType.accept((PsiTypeVisitor)this) : null;
    }
}

