/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListModification;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class ChangeListManager
implements ChangeListModification {
    @NotNull
    public static ChangeListManager getInstance(@NotNull Project project2) {
        if (project2 == null) {
            ChangeListManager.$$$reportNull$$$0(0);
        }
        if (project2.isDefault()) {
            throw new IllegalArgumentException("Can't create ChangeListManager for default project");
        }
        ChangeListManager changeListManager = (ChangeListManager)project2.getService(ChangeListManager.class);
        if (changeListManager == null) {
            ChangeListManager.$$$reportNull$$$0(1);
        }
        return changeListManager;
    }

    public void invokeAfterUpdate(boolean callbackOnAwt, @NotNull Runnable afterUpdate) {
        if (afterUpdate == null) {
            ChangeListManager.$$$reportNull$$$0(2);
        }
        InvokeAfterUpdateMode mode = callbackOnAwt ? InvokeAfterUpdateMode.SILENT : InvokeAfterUpdateMode.SILENT_CALLBACK_POOLED;
        this.invokeAfterUpdate(afterUpdate, mode, null, null);
    }

    public void invokeAfterUpdateWithProgress(boolean cancellable, @Nullable @NlsContexts.ProgressTitle String title, @NotNull Runnable afterUpdate) {
        if (afterUpdate == null) {
            ChangeListManager.$$$reportNull$$$0(3);
        }
        InvokeAfterUpdateMode mode = cancellable ? InvokeAfterUpdateMode.BACKGROUND_CANCELLABLE : InvokeAfterUpdateMode.BACKGROUND_NOT_CANCELLABLE;
        this.invokeAfterUpdate(afterUpdate, mode, title, null);
    }

    public void invokeAfterUpdateWithModal(boolean cancellable, @Nullable @NlsContexts.DialogTitle String title, @NotNull Runnable afterUpdate) {
        if (afterUpdate == null) {
            ChangeListManager.$$$reportNull$$$0(4);
        }
        InvokeAfterUpdateMode mode = cancellable ? InvokeAfterUpdateMode.SYNCHRONOUS_CANCELLABLE : InvokeAfterUpdateMode.SYNCHRONOUS_NOT_CANCELLABLE;
        this.invokeAfterUpdate(afterUpdate, mode, title, null);
    }

    public abstract void invokeAfterUpdate(@NotNull Runnable var1, @NotNull InvokeAfterUpdateMode var2, @Nullable @Nls String var3, @Nullable ModalityState var4);

    public abstract boolean areChangeListsEnabled();

    public abstract int getChangeListsNumber();

    @Deprecated
    @NotNull
    public List<LocalChangeList> getChangeListsCopy() {
        List<LocalChangeList> list2 = this.getChangeLists();
        if (list2 == null) {
            ChangeListManager.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @NotNull
    public abstract @Unmodifiable List<LocalChangeList> getChangeLists();

    @NotNull
    public abstract Collection<Change> getAllChanges();

    @NotNull
    public abstract LocalChangeList getDefaultChangeList();

    @NotNull
    @NlsSafe
    public abstract String getDefaultListName();

    @NotNull
    public abstract List<File> getAffectedPaths();

    @NotNull
    public abstract List<VirtualFile> getAffectedFiles();

    public abstract boolean isFileAffected(@NotNull VirtualFile var1);

    @Nullable
    public abstract LocalChangeList findChangeList(@NlsSafe String var1);

    @Nullable
    public abstract LocalChangeList getChangeList(@Nullable @NonNls String var1);

    @NotNull
    public abstract List<LocalChangeList> getChangeLists(@NotNull Change var1);

    @NotNull
    public abstract List<LocalChangeList> getChangeLists(@NotNull VirtualFile var1);

    @Nullable
    public abstract LocalChangeList getChangeList(@NotNull Change var1);

    @Nullable
    public abstract LocalChangeList getChangeList(@NotNull VirtualFile var1);

    @Nullable
    @NlsSafe
    public abstract String getChangeListNameIfOnlyOne(Change[] var1);

    @Nullable
    public abstract Change getChange(@NotNull VirtualFile var1);

    @Nullable
    public abstract Change getChange(FilePath var1);

    @NotNull
    public abstract FileStatus getStatus(@NotNull FilePath var1);

    @NotNull
    public abstract FileStatus getStatus(@NotNull VirtualFile var1);

    public abstract boolean isUnversioned(@NotNull VirtualFile var1);

    @NotNull
    public abstract List<FilePath> getUnversionedFilesPaths();

    @NotNull
    public abstract Collection<Change> getChangesIn(@NotNull VirtualFile var1);

    @NotNull
    public abstract Collection<Change> getChangesIn(@NotNull FilePath var1);

    @NotNull
    public abstract ThreeState haveChangesUnder(@NotNull VirtualFile var1);

    public abstract void addChangeListListener(@NotNull ChangeListListener var1, @NotNull Disposable var2);

    public abstract void addChangeListListener(@NotNull ChangeListListener var1);

    public abstract void removeChangeListListener(@NotNull ChangeListListener var1);

    @Deprecated(forRemoval=true)
    public abstract void registerCommitExecutor(@NotNull CommitExecutor var1);

    @NotNull
    public abstract List<CommitExecutor> getRegisteredExecutors();

    public abstract void commitChanges(@NotNull LocalChangeList var1, @NotNull List<? extends Change> var2);

    public abstract void scheduleAutomaticEmptyChangeListDeletion(@NotNull LocalChangeList var1);

    public abstract void scheduleAutomaticEmptyChangeListDeletion(@NotNull LocalChangeList var1, boolean var2);

    @Deprecated(forRemoval=true)
    public abstract IgnoredFileBean @NotNull [] getFilesToIgnore();

    public abstract boolean isIgnoredFile(@NotNull VirtualFile var1);

    public abstract boolean isIgnoredFile(@NotNull FilePath var1);

    @NotNull
    public abstract List<FilePath> getIgnoredFilePaths();

    @Deprecated(forRemoval=true)
    public abstract void setFilesToIgnore(IgnoredFileBean ... var1);

    @Deprecated(forRemoval=true)
    public abstract void addDirectoryToIgnoreImplicitly(@NotNull @NlsSafe String var1);

    @NotNull
    public abstract List<VirtualFile> getModifiedWithoutEditing();

    @Nullable
    @NlsSafe
    public abstract String getSwitchedBranch(@NotNull VirtualFile var1);

    @Nullable
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public abstract String isFreezed();

    public abstract boolean isFreezedWithNotification(@NlsContexts.DialogTitle @Nullable String var1);

    @Deprecated(forRemoval=true)
    public abstract void reopenFiles(@NotNull List<? extends FilePath> var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangeListManager";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterUpdate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeListManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeListsCopy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invokeAfterUpdate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invokeAfterUpdateWithProgress";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invokeAfterUpdateWithModal";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 5 -> new IllegalStateException(string2);
        };
    }
}

