/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.DtdResolveUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlContentParticle;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.XmlElementDescriptor;

public class XmlContentParticleImpl
implements XmlContentParticle {
    private final XmlToken myToken;

    public XmlContentParticleImpl(XmlToken token) {
        this.myToken = token;
    }

    @Override
    public XmlContentParticle.Type getType() {
        return XmlContentParticle.Type.ELEMENT;
    }

    @Override
    public XmlContentParticle.Quantifier getQuantifier() {
        return XmlContentParticleImpl.getQuantifierImpl(this.myToken);
    }

    public static XmlContentParticle.Quantifier getQuantifierImpl(PsiElement element) {
        PsiElement nextSibling = element.getNextSibling();
        while (nextSibling instanceof PsiWhiteSpace) {
            nextSibling = nextSibling.getNextSibling();
        }
        if (nextSibling instanceof XmlToken) {
            IElementType tokenType = ((XmlToken)nextSibling).getTokenType();
            if (tokenType == XmlTokenType.XML_PLUS) {
                return XmlContentParticle.Quantifier.ONE_OR_MORE;
            }
            if (tokenType == XmlTokenType.XML_STAR) {
                return XmlContentParticle.Quantifier.ZERO_OR_MORE;
            }
            if (tokenType == XmlTokenType.XML_QUESTION) {
                return XmlContentParticle.Quantifier.OPTIONAL;
            }
        }
        return XmlContentParticle.Quantifier.REQUIRED;
    }

    @Override
    public XmlContentParticle[] getSubParticles() {
        return new XmlContentParticle[0];
    }

    @Override
    public XmlElementDescriptor getElementDescriptor() {
        return DtdResolveUtil.resolveElementReference(this.myToken.getText(), this.myToken);
    }
}

