/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchUtil;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.NoMatchFoundException;
import com.intellij.structuralsearch.PatternContextInfo;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.compiler.CompileContext;
import com.intellij.structuralsearch.impl.matcher.compiler.DeleteNodesAction;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.OptimizingSearchHelper;
import com.intellij.structuralsearch.impl.matcher.compiler.TestModeOptimizingSearchHelper;
import com.intellij.structuralsearch.impl.matcher.filters.LexicalNodesFilter;
import com.intellij.structuralsearch.impl.matcher.handlers.DelegatingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.predicates.AndPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.ContainsPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.NotPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.ReferencePredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.RegExpPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.ScriptPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.ScriptSupport;
import com.intellij.structuralsearch.impl.matcher.predicates.WithinPredicate;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import groovy.lang.Script;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class PatternCompiler {
    private static String ourLastSearchPlan;

    public static CompiledPattern compilePattern(Project project2, MatchOptions options, boolean checkForErrors, boolean optimizeScope) throws MalformedPatternException, NoMatchFoundException {
        return (CompiledPattern)ReadAction.compute(() -> PatternCompiler.doCompilePattern(project2, options, checkForErrors, optimizeScope));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static CompiledPattern doCompilePattern(@NotNull Project project2, @NotNull MatchOptions options, boolean checkForErrors, boolean optimizeScope) throws MalformedPatternException, NoMatchFoundException {
        StructuralSearchProfile profile;
        if (project2 == null) {
            PatternCompiler.$$$reportNull$$$0(0);
        }
        if (options == null) {
            PatternCompiler.$$$reportNull$$$0(1);
        }
        if ((profile = StructuralSearchUtil.getProfileByFileType(options.getFileType())) == null) {
            return null;
        }
        CompiledPattern result2 = profile.createCompiledPattern();
        String[] prefixes = result2.getTypedVarPrefixes();
        assert (prefixes.length > 0);
        CompileContext context = new CompileContext(result2, options, project2);
        try {
            List<PsiElement> elements = PatternCompiler.compileByAllPrefixes(project2, options, result2, context, prefixes, checkForErrors);
            if (elements.isEmpty()) {
                CompiledPattern compiledPattern = null;
                return compiledPattern;
            }
            CompiledPattern pattern = context.getPattern();
            PatternCompiler.collectVariableNodes(pattern, elements, checkForErrors);
            pattern.setNodes(elements);
            if (checkForErrors) {
                profile.checkSearchPattern(pattern);
            }
            if (optimizeScope) {
                PatternCompiler.optimizeScope(options, checkForErrors, context, result2);
            }
            CompiledPattern compiledPattern = result2;
            return compiledPattern;
        }
        finally {
            context.clear();
        }
    }

    private static void optimizeScope(MatchOptions options, boolean checkForErrors, CompileContext context, CompiledPattern result2) throws NoMatchFoundException {
        OptimizingSearchHelper searchHelper = context.getSearchHelper();
        if (searchHelper.doOptimizing() && searchHelper.isScannedSomething()) {
            Set<VirtualFile> filesToScan = searchHelper.getFilesSetToScan();
            GlobalSearchScope scope = (GlobalSearchScope)options.getScope();
            assert (scope != null);
            if (checkForErrors && filesToScan.isEmpty()) {
                throw new NoMatchFoundException(SSRBundle.message("ssr.will.not.find.anything", scope.getDisplayName()));
            }
            result2.setScope((SearchScope)(scope.isSearchInLibraries() ? GlobalSearchScope.filesWithLibrariesScope((Project)context.getProject(), filesToScan) : GlobalSearchScope.filesWithoutLibrariesScope((Project)context.getProject(), filesToScan)));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ourLastSearchPlan = ((TestModeOptimizingSearchHelper)searchHelper).getSearchPlan();
        }
    }

    private static void collectVariableNodes(final CompiledPattern pattern, List<? extends PsiElement> elements, boolean checkForErrors) throws MalformedPatternException {
        for (PsiElement psiElement : elements) {
            pattern.putVariableNode("__context__", psiElement);
            if (checkForErrors) {
                PatternCompiler.checkForUnknownVariables(pattern, psiElement);
            }
            psiElement.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.collectNode(element, (MatchingHandler)element.getUserData(CompiledPattern.HANDLER_KEY));
                    super.visitElement(element);
                    if (element instanceof LeafElement) {
                        this.collectNode(element, pattern.getHandler(pattern.getTypedVarString(element)));
                    }
                }

                private void collectNode(PsiElement element, MatchingHandler handler2) {
                    if (handler2 instanceof DelegatingHandler) {
                        handler2 = ((DelegatingHandler)((Object)handler2)).getDelegate();
                    }
                    if (handler2 instanceof SubstitutionHandler) {
                        pattern.putVariableNode(((SubstitutionHandler)handler2).getName(), element);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler$1", "visitElement"));
                }
            });
        }
    }

    private static void checkForUnknownVariables(final CompiledPattern pattern, PsiElement element) {
        element.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (element.getUserData(CompiledPattern.HANDLER_KEY) != null) {
                    return;
                }
                super.visitElement(element);
                if (!(element instanceof LeafElement)) {
                    return;
                }
                String text2 = element.getText();
                if (!pattern.isTypedVar(text2)) {
                    for (String prefix : pattern.getTypedVarPrefixes()) {
                        if (!text2.contains(prefix)) continue;
                        throw new MalformedPatternException();
                    }
                    return;
                }
                MatchingHandler handler2 = pattern.getHandler(pattern.getTypedVarString(element));
                if (handler2 == null) {
                    throw new MalformedPatternException();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler$2", "visitElement"));
            }
        });
    }

    @TestOnly
    public static String getLastSearchPlan() {
        return ourLastSearchPlan;
    }

    @NotNull
    private static List<PsiElement> compileByAllPrefixes(@NotNull Project project2, @NotNull MatchOptions options, @NotNull CompiledPattern pattern, @NotNull CompileContext context, String @NotNull [] applicablePrefixes, boolean checkForErrors) throws MalformedPatternException {
        if (project2 == null) {
            PatternCompiler.$$$reportNull$$$0(2);
        }
        if (options == null) {
            PatternCompiler.$$$reportNull$$$0(3);
        }
        if (pattern == null) {
            PatternCompiler.$$$reportNull$$$0(4);
        }
        if (context == null) {
            PatternCompiler.$$$reportNull$$$0(5);
        }
        if (applicablePrefixes == null) {
            PatternCompiler.$$$reportNull$$$0(6);
        }
        if (applicablePrefixes.length == 0) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                PatternCompiler.$$$reportNull$$$0(7);
            }
            return list2;
        }
        List<PsiElement> elements = PatternCompiler.doCompile(project2, options, pattern, new ConstantPrefixProvider(applicablePrefixes[0]), context, checkForErrors);
        if (elements.isEmpty()) {
            List<PsiElement> list3 = elements;
            if (list3 == null) {
                PatternCompiler.$$$reportNull$$$0(8);
            }
            return list3;
        }
        PsiFile file = elements.get(0).getContainingFile();
        if (file == null) {
            List<PsiElement> list4 = elements;
            if (list4 == null) {
                PatternCompiler.$$$reportNull$$$0(9);
            }
            return list4;
        }
        PsiElement last = elements.get(elements.size() - 1);
        Pattern[] patterns = new Pattern[applicablePrefixes.length];
        for (int i = 0; i < applicablePrefixes.length; ++i) {
            patterns[i] = Pattern.compile(MatchUtil.shieldRegExpMetaChars(applicablePrefixes[i]) + "\\w+\\b");
        }
        int[] varEndOffsets = PatternCompiler.findAllTypedVarOffsets(file, patterns);
        int patternEndOffset = last.getTextRange().getEndOffset();
        if (elements.isEmpty() || PatternCompiler.checkErrorElements((PsiElement)file, patternEndOffset, patternEndOffset, varEndOffsets, true) != Boolean.TRUE) {
            List<PsiElement> list5 = elements;
            if (list5 == null) {
                PatternCompiler.$$$reportNull$$$0(10);
            }
            return list5;
        }
        int varCount = varEndOffsets.length;
        Object[] prefixSequence = new String[varCount];
        Arrays.fill(prefixSequence, applicablePrefixes[0]);
        List<PsiElement> finalElements = PatternCompiler.compileByPrefixes(project2, options, pattern, context, applicablePrefixes, patterns, (String[])prefixSequence, 0, checkForErrors);
        return finalElements != null ? finalElements : PatternCompiler.doCompile(project2, options, pattern, new ConstantPrefixProvider(applicablePrefixes[0]), context, checkForErrors);
    }

    @Nullable
    private static List<PsiElement> compileByPrefixes(Project project2, MatchOptions options, CompiledPattern pattern, CompileContext context, String[] applicablePrefixes, Pattern[] substitutionPatterns, String[] prefixSequence, int index, boolean checkForErrors) throws MalformedPatternException {
        if (index >= prefixSequence.length) {
            List<PsiElement> elements = PatternCompiler.doCompile(project2, options, pattern, new ArrayPrefixProvider(prefixSequence), context, checkForErrors);
            if (elements.isEmpty()) {
                return elements;
            }
            PsiElement parent = elements.get(0).getParent();
            PsiElement last = elements.get(elements.size() - 1);
            int[] varEndOffsets = PatternCompiler.findAllTypedVarOffsets(parent.getContainingFile(), substitutionPatterns);
            int patternEndOffset = last.getTextRange().getEndOffset();
            return PatternCompiler.checkErrorElements(parent, patternEndOffset, patternEndOffset, varEndOffsets, false) != Boolean.TRUE ? elements : null;
        }
        String[] alternativeVariant = null;
        String[] stringArray = applicablePrefixes;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            List<PsiElement> finalElements;
            int patternEndOffset;
            String applicablePrefix;
            prefixSequence[index] = applicablePrefix = stringArray[i];
            List<PsiElement> elements = PatternCompiler.doCompile(project2, options, pattern, new ArrayPrefixProvider(prefixSequence), context, checkForErrors);
            if (elements.isEmpty()) {
                return elements;
            }
            PsiFile file = elements.get(0).getContainingFile();
            if (file == null) {
                return elements;
            }
            int[] varEndOffsets = PatternCompiler.findAllTypedVarOffsets(file, substitutionPatterns);
            int offset = varEndOffsets[index];
            Boolean result2 = PatternCompiler.checkErrorElements((PsiElement)file, offset, patternEndOffset = elements.get(elements.size() - 1).getTextRange().getEndOffset(), varEndOffsets, false);
            if (result2 == Boolean.TRUE || result2 != Boolean.FALSE && (result2 != null || alternativeVariant != null) || (finalElements = PatternCompiler.compileByPrefixes(project2, options, pattern, context, applicablePrefixes, substitutionPatterns, prefixSequence, index + 1, checkForErrors)) == null) continue;
            if (result2 == Boolean.FALSE) {
                return finalElements;
            }
            alternativeVariant = (String[])prefixSequence.clone();
        }
        return alternativeVariant != null ? PatternCompiler.compileByPrefixes(project2, options, pattern, context, applicablePrefixes, substitutionPatterns, alternativeVariant, index + 1, checkForErrors) : null;
    }

    private static int @NotNull [] findAllTypedVarOffsets(PsiFile file, final Pattern[] substitutionPatterns) {
        IntOpenHashSet result2 = new IntOpenHashSet();
        file.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor((IntSet)result2){
            final /* synthetic */ IntSet val$result;
            {
                this.val$result = intSet;
            }

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                super.visitElement(element);
                if (element instanceof LeafElement) {
                    String text2 = element.getText();
                    for (Pattern pattern : substitutionPatterns) {
                        Matcher matcher = pattern.matcher(text2);
                        while (matcher.find()) {
                            this.val$result.add(element.getTextRange().getStartOffset() + matcher.end());
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler$3", "visitElement"));
            }
        });
        int[] resultArray = result2.toIntArray();
        Arrays.sort(resultArray);
        if (resultArray == null) {
            PatternCompiler.$$$reportNull$$$0(11);
        }
        return resultArray;
    }

    @Nullable
    private static Boolean checkErrorElements(PsiElement element, int offset, int patternEndOffset, int[] varEndOffsets, final boolean strict) {
        IntArrayList errorOffsets = new IntArrayList();
        boolean[] containsErrorTail = new boolean[]{false};
        IntOpenHashSet varEndOffsetsSet = new IntOpenHashSet(varEndOffsets);
        element.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor((IntSet)varEndOffsetsSet, patternEndOffset, (IntList)errorOffsets, offset, containsErrorTail){
            final /* synthetic */ IntSet val$varEndOffsetsSet;
            final /* synthetic */ int val$patternEndOffset;
            final /* synthetic */ IntList val$errorOffsets;
            final /* synthetic */ int val$offset;
            final /* synthetic */ boolean[] val$containsErrorTail;
            {
                this.val$varEndOffsetsSet = intSet;
                this.val$patternEndOffset = n;
                this.val$errorOffsets = intList;
                this.val$offset = n2;
                this.val$containsErrorTail = blArray;
            }

            public void visitErrorElement(@NotNull PsiErrorElement element) {
                if (element == null) {
                    4.$$$reportNull$$$0(0);
                }
                super.visitErrorElement(element);
                int startOffset = element.getTextRange().getStartOffset();
                if ((strict || !this.val$varEndOffsetsSet.contains(startOffset)) && startOffset != this.val$patternEndOffset) {
                    this.val$errorOffsets.add(startOffset);
                }
                if (startOffset == this.val$offset) {
                    this.val$containsErrorTail[0] = true;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler$4", "visitErrorElement"));
            }
        });
        for (int i = 0; i < errorOffsets.size(); ++i) {
            int errorOffset = errorOffsets.getInt(i);
            if (errorOffset > offset) continue;
            return true;
        }
        return containsErrorTail[0] ? null : Boolean.valueOf(false);
    }

    @NotNull
    private static List<PsiElement> doCompile(@NotNull Project project2, @NotNull MatchOptions options, @NotNull CompiledPattern result2, @NotNull PrefixProvider prefixProvider, @NotNull CompileContext context, boolean checkForErrors) throws MalformedPatternException {
        GlobalCompilingVisitor compilingVisitor;
        SmartList elements;
        block41: {
            String patternElements;
            MatchVariableConstraint constraint;
            LanguageFileType fileType;
            int prevOffset;
            String text2;
            StringBuilder buf;
            block40: {
                if (project2 == null) {
                    PatternCompiler.$$$reportNull$$$0(12);
                }
                if (options == null) {
                    PatternCompiler.$$$reportNull$$$0(13);
                }
                if (result2 == null) {
                    PatternCompiler.$$$reportNull$$$0(14);
                }
                if (prefixProvider == null) {
                    PatternCompiler.$$$reportNull$$$0(15);
                }
                if (context == null) {
                    PatternCompiler.$$$reportNull$$$0(16);
                }
                result2.clearHandlers();
                buf = new StringBuilder();
                Template template = TemplateManager.getInstance((Project)project2).createTemplate("", "", options.getSearchPattern());
                int segmentsCount = template.getSegmentsCount();
                text2 = template.getTemplateText();
                prevOffset = 0;
                HashSet<String> variableNames = new HashSet<String>();
                fileType = options.getFileType();
                assert (fileType != null);
                for (int i = 0; i < segmentsCount; ++i) {
                    int offset;
                    block39: {
                        offset = template.getSegmentOffset(i);
                        String name = template.getSegmentName(i);
                        String prefix = prefixProvider.getPrefix(i);
                        if (prefix == null) {
                            if (checkForErrors) {
                                throw new MalformedPatternException();
                            }
                            List<PsiElement> list2 = Collections.emptyList();
                            if (list2 == null) {
                                PatternCompiler.$$$reportNull$$$0(17);
                            }
                            return list2;
                        }
                        String compiledName = prefix + name;
                        buf.append(text2, prevOffset, offset).append(compiledName);
                        int repeated = !variableNames.add(name) ? 1 : 0;
                        SubstitutionHandler existing = (SubstitutionHandler)result2.getHandler(compiledName);
                        if (existing != null) {
                            existing.setRepeatedVar(repeated != 0);
                        } else {
                            try {
                                MatchPredicate predicate;
                                MatchVariableConstraint constraint2 = options.getVariableConstraint(name);
                                if (constraint2 == null) {
                                    constraint2 = options.addNewVariableConstraint(name);
                                }
                                SubstitutionHandler handler2 = result2.createSubstitutionHandler(name, compiledName, constraint2.isPartOfSearchResults(), constraint2.getMinCount(), constraint2.getMaxCount(), constraint2.isGreedy());
                                handler2.setRepeatedVar(repeated != 0);
                                if (constraint2.isWithinHierarchy()) {
                                    handler2.setSubtype(true);
                                }
                                if (constraint2.isStrictlyWithinHierarchy()) {
                                    handler2.setStrictSubtype(true);
                                }
                                if (!StringUtil.isEmptyOrSpaces((String)constraint2.getRegExp())) {
                                    predicate = new RegExpPredicate(constraint2.getRegExp(), options.isCaseSensitiveMatch(), name, constraint2.isWholeWordsOnly(), constraint2.isPartOfSearchResults());
                                    if (constraint2.isInvertRegExp()) {
                                        predicate = new NotPredicate(predicate);
                                    }
                                    PatternCompiler.addPredicate(handler2, predicate);
                                }
                                if (!StringUtil.isEmptyOrSpaces((String)constraint2.getReferenceConstraint())) {
                                    predicate = new ReferencePredicate(constraint2.getReferenceConstraint(), fileType, project2);
                                    if (constraint2.isInvertReference()) {
                                        predicate = new NotPredicate(predicate);
                                    }
                                    PatternCompiler.addPredicate(handler2, predicate);
                                }
                                PatternCompiler.addExtensionPredicates(options, constraint2, handler2);
                                PatternCompiler.addScriptConstraint(project2, name, constraint2, handler2, variableNames, options, checkForErrors);
                                if (!StringUtil.isEmptyOrSpaces((String)constraint2.getContainsConstraint())) {
                                    predicate = new ContainsPredicate(name, constraint2.getContainsConstraint());
                                    if (constraint2.isInvertContainsConstraint()) {
                                        predicate = new NotPredicate(predicate);
                                    }
                                    PatternCompiler.addPredicate(handler2, predicate);
                                }
                                if (!StringUtil.isEmptyOrSpaces((String)constraint2.getWithinConstraint())) assert (false);
                            }
                            catch (MalformedPatternException e) {
                                if (!checkForErrors) break block39;
                                throw e;
                            }
                        }
                    }
                    prevOffset = offset;
                }
                constraint = options.getVariableConstraint("__context__");
                if (constraint != null) {
                    SubstitutionHandler handler3 = result2.createSubstitutionHandler("__context__", "__context__", constraint.isPartOfSearchResults(), constraint.getMinCount(), constraint.getMaxCount(), constraint.isGreedy());
                    try {
                        if (!StringUtil.isEmptyOrSpaces((String)constraint.getWithinConstraint())) {
                            MatchPredicate predicate = new WithinPredicate(constraint.getWithinConstraint(), fileType, project2);
                            if (constraint.isInvertWithinConstraint()) {
                                predicate = new NotPredicate(predicate);
                            }
                            PatternCompiler.addPredicate(handler3, predicate);
                        }
                        PatternCompiler.addExtensionPredicates(options, constraint, handler3);
                        PatternCompiler.addScriptConstraint(project2, "__context__", constraint, handler3, variableNames, options, checkForErrors);
                    }
                    catch (MalformedPatternException e) {
                        if (!checkForErrors) break block40;
                        throw e;
                    }
                }
            }
            buf.append(text2.substring(prevOffset));
            try {
                PatternContextInfo contextInfo = new PatternContextInfo(PatternTreeContext.Block, options.getPatternContext(), constraint != null ? constraint.getContextConstraint() : null);
                Language dialect = options.getDialect();
                assert (dialect != null);
                patternElements = MatcherImplUtil.createTreeFromText(buf.toString(), contextInfo, fileType, dialect, project2, false);
                if (((PsiElement[])patternElements).length == 0 && checkForErrors) {
                    throw new MalformedPatternException();
                }
            }
            catch (IncorrectOperationException e) {
                if (checkForErrors) {
                    throw new MalformedPatternException(e.getMessage());
                }
                List<PsiElement> list3 = Collections.emptyList();
                if (list3 == null) {
                    PatternCompiler.$$$reportNull$$$0(18);
                }
                return list3;
            }
            NodeFilter filter2 = LexicalNodesFilter.getInstance();
            elements = new SmartList();
            for (PsiElement element : patternElements) {
                if (filter2.accepts(element)) continue;
                elements.add(element);
            }
            compilingVisitor = new GlobalCompilingVisitor();
            try {
                compilingVisitor.compile(elements.toArray(PsiElement.EMPTY_ARRAY), context);
            }
            catch (MalformedPatternException e) {
                if (!checkForErrors) break block41;
                throw e;
            }
        }
        new DeleteNodesAction(compilingVisitor.getLexicalNodes()).run();
        SmartList smartList = elements;
        if (smartList == null) {
            PatternCompiler.$$$reportNull$$$0(19);
        }
        return smartList;
    }

    private static void addExtensionPredicates(@NotNull MatchOptions options, @NotNull MatchVariableConstraint constraint, @NotNull SubstitutionHandler handler2) {
        if (options == null) {
            PatternCompiler.$$$reportNull$$$0(20);
        }
        if (constraint == null) {
            PatternCompiler.$$$reportNull$$$0(21);
        }
        if (handler2 == null) {
            PatternCompiler.$$$reportNull$$$0(22);
        }
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(options.getFileType());
        assert (profile != null);
        for (MatchPredicate matchPredicate : profile.getCustomPredicates(constraint, handler2.getName(), options)) {
            PatternCompiler.addPredicate(handler2, matchPredicate);
        }
    }

    private static void addScriptConstraint(Project project2, String name, MatchVariableConstraint constraint, SubstitutionHandler handler2, Set<String> variableNames, MatchOptions matchOptions, boolean checkForErrors) throws MalformedPatternException {
        block3: {
            String scriptCodeConstraint = constraint.getScriptCodeConstraint();
            if (scriptCodeConstraint.length() > 2) {
                String scriptText = StringUtil.unquoteString((String)scriptCodeConstraint);
                try {
                    Script script = ScriptSupport.buildScript(name, scriptText, matchOptions);
                    PatternCompiler.addPredicate(handler2, new ScriptPredicate(project2, name, script, variableNames));
                }
                catch (MalformedPatternException e) {
                    if (!checkForErrors) break block3;
                    throw new MalformedPatternException(SSRBundle.message("error.script.constraint.for.0.has.problem.1", constraint.getName(), e.getLocalizedMessage()));
                }
            }
        }
    }

    private static void addPredicate(SubstitutionHandler handler2, @NotNull MatchPredicate predicate) {
        if (predicate == null) {
            PatternCompiler.$$$reportNull$$$0(23);
        }
        handler2.setPredicate(handler2.getPredicate() == null ? predicate : new AndPredicate(handler2.getPredicate(), predicate));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 10, 11, 17, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicablePrefixes";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixProvider";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraint";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "compileByAllPrefixes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllTypedVarOffsets";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "doCompile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doCompilePattern";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "compileByAllPrefixes";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doCompile";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addExtensionPredicates";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addPredicate";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 7, 8, 9, 10, 11, 17, 18, 19 -> new IllegalStateException(string2);
        };
    }

    private static class ConstantPrefixProvider
    implements PrefixProvider {
        private final String myPrefix;

        ConstantPrefixProvider(@NotNull String prefix) {
            if (prefix == null) {
                ConstantPrefixProvider.$$$reportNull$$$0(0);
            }
            this.myPrefix = prefix;
        }

        @Override
        @NotNull
        public String getPrefix(int varIndex) {
            String string2 = this.myPrefix;
            if (string2 == null) {
                ConstantPrefixProvider.$$$reportNull$$$0(1);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler$ConstantPrefixProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler$ConstantPrefixProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrefix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }

    private static interface PrefixProvider {
        public String getPrefix(int var1);
    }

    private static class ArrayPrefixProvider
    implements PrefixProvider {
        private final String[] myPrefixes;

        ArrayPrefixProvider(String @NotNull [] prefixes) {
            if (prefixes == null) {
                ArrayPrefixProvider.$$$reportNull$$$0(0);
            }
            this.myPrefixes = prefixes;
        }

        @Override
        public String getPrefix(int varIndex) {
            if (varIndex >= this.myPrefixes.length) {
                return null;
            }
            return this.myPrefixes[varIndex];
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixes", "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler$ArrayPrefixProvider", "<init>"));
        }
    }
}

