/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.htmlInspections.XmlEntitiesInspection;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XHtmlFileType;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.html.HtmlCompatibleFile;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.XmlTypedHandlersAdditionalSupport;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementWalkingVisitor;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.html.HtmlDocumentImpl;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ThreeState;
import com.intellij.xml.Html5SchemaProvider;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlCustomElementDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.XmlAttributeDescriptorImpl;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import com.intellij.xml.util.BasicHtmlUtil;
import com.intellij.xml.util.CharsetDetector;
import com.intellij.xml.util.HtmlPsiUtil;
import com.intellij.xml.util.XmlUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class HtmlUtil {
    private static final Logger LOG = Logger.getInstance(HtmlUtil.class);
    @NonNls
    private static final String JSFC = "jsfc";
    @NonNls
    public static final String HTML5_DATA_ATTR_PREFIX = "data-";
    @NlsSafe
    public static final String SCRIPT_TAG_NAME = "script";
    @NlsSafe
    public static final String STYLE_TAG_NAME = "style";
    @NlsSafe
    public static final String TEMPLATE_TAG_NAME = "template";
    @NlsSafe
    public static final String TEXTAREA_TAG_NAME = "textarea";
    @NlsSafe
    public static final String TITLE_TAG_NAME = "title";
    @NlsSafe
    public static final String SLOT_TAG_NAME = "slot";
    @NlsSafe
    public static final String STYLE_ATTRIBUTE_NAME = "style";
    @NlsSafe
    public static final String SRC_ATTRIBUTE_NAME = "src";
    @NlsSafe
    public static final String ID_ATTRIBUTE_NAME = "id";
    @NlsSafe
    public static final String CLASS_ATTRIBUTE_NAME = "class";
    @NlsSafe
    public static final String TYPE_ATTRIBUTE_NAME = "type";
    @NlsSafe
    public static final String LANGUAGE_ATTRIBUTE_NAME = "language";
    @NlsSafe
    public static final String LANG_ATTRIBUTE_NAME = "lang";
    @NonNls
    public static final String MATH_ML_NAMESPACE = "http://www.w3.org/1998/Math/MathML";
    @NonNls
    public static final String SVG_NAMESPACE = "http://www.w3.org/2000/svg";
    public static final String[] RFC2616_HEADERS = BasicHtmlUtil.RFC2616_HEADERS;

    private HtmlUtil() {
    }

    public static boolean isSingleHtmlTag(@NotNull XmlTag tag, boolean toLowerCase) {
        if (tag == null) {
            HtmlUtil.$$$reportNull$$$0(0);
        }
        String name = tag.getName();
        boolean result2 = BasicHtmlUtil.EMPTY_TAGS_MAP.contains(!toLowerCase || tag.isCaseSensitive() ? name : StringUtil.toLowerCase((String)name));
        return result2 && !XmlCustomElementDescriptor.isCustomElement(tag);
    }

    public static boolean isSingleHtmlTag(String tagName, boolean caseSensitive) {
        return BasicHtmlUtil.isSingleHtmlTag((String)tagName, (boolean)caseSensitive);
    }

    public static boolean isTagWithOptionalEnd(@NotNull String tagName, boolean caseSensitive) {
        if (tagName == null) {
            HtmlUtil.$$$reportNull$$$0(1);
        }
        return BasicHtmlUtil.isTagWithOptionalEnd((String)tagName, (boolean)caseSensitive);
    }

    @NotNull
    public static ThreeState canOpeningTagAutoClose(@NotNull String tagToClose, @NotNull String openingTag, boolean caseSensitive) {
        if (tagToClose == null) {
            HtmlUtil.$$$reportNull$$$0(2);
        }
        if (openingTag == null) {
            HtmlUtil.$$$reportNull$$$0(3);
        }
        ThreeState threeState = BasicHtmlUtil.canOpeningTagAutoClose((String)tagToClose, (String)openingTag, (boolean)caseSensitive);
        if (threeState == null) {
            HtmlUtil.$$$reportNull$$$0(4);
        }
        return threeState;
    }

    public static boolean canClosingTagAutoClose(@NotNull String tagToClose, @NotNull String closingTag, boolean caseSensitive) {
        if (tagToClose == null) {
            HtmlUtil.$$$reportNull$$$0(5);
        }
        if (closingTag == null) {
            HtmlUtil.$$$reportNull$$$0(6);
        }
        return BasicHtmlUtil.canClosingTagAutoClose((String)tagToClose, (String)closingTag, (boolean)caseSensitive);
    }

    public static boolean isHtmlBlockTag(String tagName, boolean caseSensitive) {
        return BasicHtmlUtil.isHtmlBlockTag((String)tagName, (boolean)caseSensitive);
    }

    public static boolean isPossiblyInlineTag(@NotNull String tagName) {
        if (tagName == null) {
            HtmlUtil.$$$reportNull$$$0(7);
        }
        return BasicHtmlUtil.isPossiblyInlineTag((String)tagName);
    }

    public static boolean isInlineTagContainer(String tagName, boolean caseSensitive) {
        return BasicHtmlUtil.isInlineTagContainer((String)tagName, (boolean)caseSensitive);
    }

    public static void addHtmlSpecificCompletions(XmlElementDescriptor descriptor, XmlTag element, List<? super XmlElementDescriptor> variants) {
        block5: {
            XmlNSDescriptor nsDescriptor;
            PsiElement parent;
            block6: {
                String name = descriptor.getName(element);
                if (name == null || !HtmlUtil.isTagWithOptionalEnd(name, false)) break block5;
                parent = element.getParent();
                if (parent instanceof XmlTag && XmlChildRole.CLOSING_TAG_START_FINDER.findChild(parent.getNode()) != null) {
                    return;
                }
                if (parent != null) {
                    parent = parent.getParent();
                }
                if (!(parent instanceof HtmlTag)) break block6;
                XmlElementDescriptor parentDescriptor = ((HtmlTag)parent).getDescriptor();
                if (parentDescriptor == descriptor || parentDescriptor == null) break block5;
                for (XmlElementDescriptor elementsDescriptor : parentDescriptor.getElementsDescriptors((XmlTag)parent)) {
                    if (!HtmlUtil.isHtmlBlockTag(elementsDescriptor.getName(), false)) continue;
                    variants.add(elementsDescriptor);
                }
                break block5;
            }
            if (parent instanceof HtmlDocumentImpl && (nsDescriptor = descriptor.getNSDescriptor()) != null) {
                for (XmlElementDescriptor elementDescriptor : nsDescriptor.getRootElementsDescriptors((XmlDocument)parent)) {
                    if (!HtmlUtil.isHtmlBlockTag(elementDescriptor.getName(), false) || variants.contains(elementDescriptor)) continue;
                    variants.add(elementDescriptor);
                }
            }
        }
    }

    @Nullable
    public static XmlDocument getRealXmlDocument(@Nullable XmlDocument doc) {
        return HtmlPsiUtil.getRealXmlDocument(doc);
    }

    public static boolean isShortNotationOfBooleanAttributePreferred() {
        return Registry.is((String)"html.prefer.short.notation.of.boolean.attributes", (boolean)true);
    }

    @TestOnly
    public static void setShortNotationOfBooleanAttributeIsPreferred(boolean value, Disposable parent) {
        final boolean oldValue = HtmlUtil.isShortNotationOfBooleanAttributePreferred();
        final RegistryValue registryValue = Registry.get((String)"html.prefer.short.notation.of.boolean.attributes");
        registryValue.setValue(value);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                registryValue.setValue(oldValue);
            }
        });
    }

    public static boolean isBooleanAttribute(@NotNull XmlAttributeDescriptor descriptor, @Nullable PsiElement context) {
        if (descriptor == null) {
            HtmlUtil.$$$reportNull$$$0(8);
        }
        if (descriptor.isEnumerated()) {
            String[] values = descriptor.getEnumeratedValues();
            if (values == null) {
                return false;
            }
            if (values.length == 2) {
                return values[0].isEmpty() && values[1].equals(descriptor.getName()) || values[1].isEmpty() && values[0].equals(descriptor.getName());
            }
            if (values.length == 1) {
                return descriptor.getName().equals(values[0]);
            }
        }
        return context != null && HtmlUtil.isCustomBooleanAttribute(descriptor.getName(), context);
    }

    public static boolean isCustomBooleanAttribute(@NotNull String attributeName, @NotNull PsiElement context) {
        String entitiesString;
        if (attributeName == null) {
            HtmlUtil.$$$reportNull$$$0(9);
        }
        if (context == null) {
            HtmlUtil.$$$reportNull$$$0(10);
        }
        if ((entitiesString = HtmlUtil.getEntitiesString(context, "HtmlUnknownBooleanAttribute")) != null) {
            StringTokenizer tokenizer = new StringTokenizer(entitiesString, ",");
            while (tokenizer.hasMoreElements()) {
                if (!tokenizer.nextToken().equalsIgnoreCase(attributeName)) continue;
                return true;
            }
        }
        return false;
    }

    public static XmlAttributeDescriptor[] getCustomAttributeDescriptors(PsiElement context) {
        String entitiesString = HtmlUtil.getEntitiesString(context, "HtmlUnknownAttribute");
        if (entitiesString == null) {
            return XmlAttributeDescriptor.EMPTY;
        }
        StringTokenizer tokenizer = new StringTokenizer(entitiesString, ",");
        XmlAttributeDescriptor[] descriptors = new XmlAttributeDescriptor[tokenizer.countTokens()];
        int index = 0;
        while (tokenizer.hasMoreElements()) {
            final String customName = tokenizer.nextToken();
            if (customName.isEmpty()) continue;
            descriptors[index++] = new XmlAttributeDescriptorImpl(){

                @Override
                public String getName(PsiElement context) {
                    return customName;
                }

                @Override
                public String getName() {
                    return customName;
                }
            };
        }
        return descriptors;
    }

    public static XmlElementDescriptor[] getCustomTagDescriptors(@Nullable PsiElement context) {
        String entitiesString = HtmlUtil.getEntitiesString(context, "HtmlUnknownTag");
        if (entitiesString == null) {
            return XmlElementDescriptor.EMPTY_ARRAY;
        }
        StringTokenizer tokenizer = new StringTokenizer(entitiesString, ",");
        XmlElementDescriptor[] descriptors = new XmlElementDescriptor[tokenizer.countTokens()];
        int index = 0;
        while (tokenizer.hasMoreElements()) {
            String tagName = tokenizer.nextToken();
            if (tagName.isEmpty()) continue;
            descriptors[index++] = new CustomXmlTagDescriptor(tagName);
        }
        return descriptors;
    }

    @Nullable
    public static String getEntitiesString(@Nullable PsiElement context, @NotNull String inspectionName) {
        if (inspectionName == null) {
            HtmlUtil.$$$reportNull$$$0(11);
        }
        if (context == null) {
            return null;
        }
        PsiFile containingFile = context.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        PsiFile originalFile = containingFile.getOriginalFile();
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)context.getProject()).getCurrentProfile();
        XmlEntitiesInspection inspection = (XmlEntitiesInspection)profile.getUnwrappedTool(inspectionName, (PsiElement)originalFile);
        if (inspection != null) {
            return inspection.getAdditionalEntries();
        }
        return null;
    }

    public static XmlAttributeDescriptor[] appendHtmlSpecificAttributeCompletions(XmlTag declarationTag, XmlAttributeDescriptor[] descriptors, XmlAttribute context) {
        if (declarationTag instanceof HtmlTag) {
            descriptors = (XmlAttributeDescriptor[])ArrayUtil.mergeArrays((Object[])descriptors, (Object[])HtmlUtil.getCustomAttributeDescriptors(context));
            return descriptors;
        }
        boolean isJsfHtmlNamespace = false;
        for (String jsfHtmlUri : XmlUtil.JSF_HTML_URIS) {
            if (declarationTag.getPrefixByNamespace(jsfHtmlUri) == null) continue;
            isJsfHtmlNamespace = true;
            break;
        }
        if (isJsfHtmlNamespace && declarationTag.getNSDescriptor("http://www.w3.org/1999/xhtml", true) != null && !"http://java.sun.com/JSP/Page".equals(declarationTag.getNamespace())) {
            descriptors = (XmlAttributeDescriptor[])ArrayUtil.append((Object[])descriptors, (Object)new XmlAttributeDescriptorImpl(){

                @Override
                public String getName(PsiElement context) {
                    return HtmlUtil.JSFC;
                }

                @Override
                public String getName() {
                    return HtmlUtil.JSFC;
                }
            }, XmlAttributeDescriptor.class);
        }
        return descriptors;
    }

    public static boolean isHtml5Document(XmlDocument doc) {
        VirtualFile vFile;
        if (doc == null) {
            return false;
        }
        XmlProlog prolog = doc.getProlog();
        XmlDoctype doctype = prolog != null ? prolog.getDoctype() : null;
        PsiFile htmlFile = doc.getContainingFile();
        String htmlFileFullName = htmlFile != null ? ((vFile = htmlFile.getVirtualFile()) == null ? htmlFile.getName() : vFile.getPath()) : "unknown";
        if (doctype == null) {
            LOG.debug("DOCTYPE for " + htmlFileFullName + " is null");
            return HtmlUtil.isHtmlTagContainingFile(doc) && Html5SchemaProvider.getHtml5SchemaLocation().equals(ExternalResourceManagerEx.getInstanceEx().getDefaultHtmlDoctype(doc.getProject()));
        }
        boolean html5Doctype = HtmlUtil.isHtml5Doctype(doctype);
        String doctypeDescription = "text: " + doctype.getText() + ", dtdUri: " + doctype.getDtdUri() + ", publicId: " + doctype.getPublicId() + ", markupDecl: " + String.valueOf(doctype.getMarkupDecl());
        LOG.debug("DOCTYPE for " + htmlFileFullName + "; " + doctypeDescription + "; HTML5: " + html5Doctype);
        return html5Doctype;
    }

    public static boolean isHtml5Doctype(XmlDoctype doctype) {
        return doctype.getDtdUri() == null && doctype.getPublicId() == null && doctype.getMarkupDecl() == null;
    }

    public static boolean isHtml5Context(XmlElement context) {
        XmlDocument doc = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)context, XmlDocument.class);
        if (doc == null && context != null) {
            return Html5SchemaProvider.getHtml5SchemaLocation().equals(ExternalResourceManagerEx.getInstanceEx().getDefaultHtmlDoctype(context.getProject()));
        }
        return HtmlUtil.isHtml5Document(doc);
    }

    public static boolean isHtmlTag(@NotNull XmlTag tag) {
        if (tag == null) {
            HtmlUtil.$$$reportNull$$$0(12);
        }
        if (!tag.getLanguage().isKindOf((Language)HTMLLanguage.INSTANCE)) {
            return false;
        }
        XmlDocument doc = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)tag, XmlDocument.class);
        String doctype = null;
        if (doc != null) {
            doctype = XmlUtil.getDtdUri(doc);
        }
        doctype = doctype == null ? ExternalResourceManagerEx.getInstanceEx().getDefaultHtmlDoctype(tag.getProject()) : doctype;
        return XmlUtil.XHTML4_SCHEMA_LOCATION.equals(doctype) || !StringUtil.containsIgnoreCase((String)doctype, (String)"xhtml");
    }

    public static boolean hasNonHtml5Doctype(XmlElement context) {
        XmlDocument doc = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)context, XmlDocument.class);
        if (doc == null) {
            return false;
        }
        XmlProlog prolog = doc.getProlog();
        XmlDoctype doctype = prolog != null ? prolog.getDoctype() : null;
        return doctype != null && !HtmlUtil.isHtml5Doctype(doctype);
    }

    public static boolean isHtml5Tag(@NotNull String tagName) {
        if (tagName == null) {
            HtmlUtil.$$$reportNull$$$0(13);
        }
        return BasicHtmlUtil.isHtml5Tag((String)tagName);
    }

    public static boolean isCustomHtml5Attribute(String attributeName) {
        return BasicHtmlUtil.isCustomHtml5Attribute((String)attributeName);
    }

    @Nullable
    public static String getHrefBase(XmlFile file) {
        XmlTag root = file.getRootTag();
        XmlTag head = root != null ? root.findFirstSubTag("head") : null;
        XmlTag base = head != null ? head.findFirstSubTag("base") : null;
        return base != null ? base.getAttributeValue("href") : null;
    }

    public static boolean isOwnHtmlAttribute(XmlAttributeDescriptor descriptor) {
        PsiElement declaration = descriptor.getDeclaration();
        PsiFile file = declaration != null ? declaration.getContainingFile() : null;
        String name = file != null ? file.getName() : null;
        return "meta.rnc".equals(name) || "web-forms.rnc".equals(name) || "embed.rnc".equals(name) || "tables.rnc".equals(name) || "media.rnc".equals(name);
    }

    public static boolean tagHasHtml5Schema(@NotNull XmlTag context) {
        XmlElementDescriptor descriptor;
        if (context == null) {
            HtmlUtil.$$$reportNull$$$0(14);
        }
        XmlNSDescriptor nsDescriptor = (descriptor = context.getDescriptor()) != null ? descriptor.getNSDescriptor() : null;
        return HtmlUtil.isHtml5Schema(nsDescriptor);
    }

    public static boolean isHtml5Schema(@Nullable XmlNSDescriptor nsDescriptor) {
        XmlFile descriptorFile = nsDescriptor != null ? nsDescriptor.getDescriptorFile() : null;
        String descriptorPath = descriptorFile != null ? descriptorFile.getVirtualFile().getPath() : null;
        return Objects.equals(Html5SchemaProvider.getHtml5SchemaLocation(), descriptorPath) || Objects.equals(Html5SchemaProvider.getXhtml5SchemaLocation(), descriptorPath);
    }

    public static String getStartTag(@NotNull String line) {
        if (line == null) {
            HtmlUtil.$$$reportNull$$$0(15);
        }
        return BasicHtmlUtil.getStartTag((String)line);
    }

    public static boolean startsWithTag(@NotNull String line) {
        if (line == null) {
            HtmlUtil.$$$reportNull$$$0(16);
        }
        return BasicHtmlUtil.startsWithTag((String)line);
    }

    public static Charset detectCharsetFromMetaTag(@NotNull CharSequence content) {
        if (content == null) {
            HtmlUtil.$$$reportNull$$$0(17);
        }
        return CharsetDetector.detectCharsetFromMetaTag((CharSequence)content);
    }

    public static boolean isTagWithoutAttributes(@NonNls String tagName) {
        return BasicHtmlUtil.isTagWithoutAttributes((String)tagName);
    }

    public static boolean hasHtml(@NotNull PsiFile file) {
        if (file == null) {
            HtmlUtil.$$$reportNull$$$0(18);
        }
        return BasicHtmlUtil.hasHtml((PsiFile)file);
    }

    public static boolean supportsXmlTypedHandlers(@NotNull PsiFile file) {
        if (file == null) {
            HtmlUtil.$$$reportNull$$$0(19);
        }
        return XmlTypedHandlersAdditionalSupport.supportsTypedHandlers(file);
    }

    public static boolean hasHtmlPrefix(@NotNull String url) {
        if (url == null) {
            HtmlUtil.$$$reportNull$$$0(20);
        }
        return BasicHtmlUtil.hasHtmlPrefix((String)url);
    }

    public static boolean isHtmlFile(@NotNull PsiElement element) {
        if (element == null) {
            HtmlUtil.$$$reportNull$$$0(21);
        }
        return BasicHtmlUtil.isHtmlFile((PsiElement)element);
    }

    public static boolean isHtmlFile(@NotNull VirtualFile file) {
        FileTypeRegistry registry;
        if (file == null) {
            HtmlUtil.$$$reportNull$$$0(22);
        }
        return (registry = FileTypeRegistry.getInstance()).isFileOfType(file, (FileType)HtmlFileType.INSTANCE) || registry.isFileOfType(file, (FileType)XHtmlFileType.INSTANCE);
    }

    public static FileType @NotNull [] getHtmlFileTypes() {
        FileType[] fileTypeArray = new FileType[]{HtmlFileType.INSTANCE, XHtmlFileType.INSTANCE};
        if (fileTypeArray == null) {
            HtmlUtil.$$$reportNull$$$0(23);
        }
        return fileTypeArray;
    }

    public static boolean isHtmlTagContainingFile(PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile != null) {
            if (containingFile instanceof HtmlCompatibleFile) {
                return true;
            }
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class, (boolean)false);
            if (tag instanceof HtmlTag) {
                return true;
            }
            XmlDocument document = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)element, XmlDocument.class, (boolean)false);
            if (document instanceof HtmlDocumentImpl) {
                return true;
            }
            FileViewProvider provider = containingFile.getViewProvider();
            Language language = provider instanceof TemplateLanguageFileViewProvider ? ((TemplateLanguageFileViewProvider)provider).getTemplateDataLanguage() : provider.getBaseLanguage();
            return language == XHTMLLanguage.INSTANCE;
        }
        return false;
    }

    public static boolean isScriptTag(@Nullable XmlTag tag) {
        return tag != null && tag.getLocalName().equalsIgnoreCase(SCRIPT_TAG_NAME);
    }

    @NotNull
    public static Iterable<String> splitClassNames(@Nullable String classAttributeValue) {
        Iterable iterable = BasicHtmlUtil.splitClassNames((String)classAttributeValue);
        if (iterable == null) {
            HtmlUtil.$$$reportNull$$$0(24);
        }
        return iterable;
    }

    @Contract(value="!null -> !null")
    @NlsSafe
    public static String getTagPresentation(@Nullable XmlTag tag) {
        String classValue;
        if (tag == null) {
            return null;
        }
        StringBuilder builder2 = new StringBuilder(tag.getLocalName());
        String idValue = HtmlUtil.getAttributeValue(tag, ID_ATTRIBUTE_NAME);
        if (idValue != null) {
            builder2.append('#').append(idValue);
        }
        if ((classValue = HtmlUtil.getAttributeValue(tag, CLASS_ATTRIBUTE_NAME)) != null) {
            for (String className : HtmlUtil.splitClassNames(classValue)) {
                builder2.append('.').append(className);
            }
        }
        return builder2.toString();
    }

    @Nullable
    private static String getAttributeValue(@NotNull XmlTag tag, @NotNull String attrName) {
        String value;
        XmlAttribute classAttribute;
        if (tag == null) {
            HtmlUtil.$$$reportNull$$$0(25);
        }
        if (attrName == null) {
            HtmlUtil.$$$reportNull$$$0(26);
        }
        if ((classAttribute = HtmlUtil.getAttributeByName(tag, attrName)) != null && !HtmlUtil.containsOuterLanguageElements(classAttribute) && !StringUtil.isEmptyOrSpaces((String)(value = classAttribute.getValue()))) {
            return value;
        }
        return null;
    }

    @Nullable
    private static XmlAttribute getAttributeByName(@NotNull XmlTag tag, @NotNull String name) {
        if (tag == null) {
            HtmlUtil.$$$reportNull$$$0(27);
        }
        if (name == null) {
            HtmlUtil.$$$reportNull$$$0(28);
        }
        for (PsiElement child = tag.getFirstChild(); child != null; child = child.getNextSibling()) {
            PsiElement nameElement;
            if (!(child instanceof XmlAttribute) || (nameElement = child.getFirstChild()) == null || nameElement.getNode().getElementType() != XmlTokenType.XML_NAME || !name.equalsIgnoreCase(nameElement.getText())) continue;
            return (XmlAttribute)child;
        }
        return null;
    }

    private static boolean containsOuterLanguageElements(@NotNull PsiElement element) {
        if (element == null) {
            HtmlUtil.$$$reportNull$$$0(29);
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof CompositeElement) {
                return HtmlUtil.containsOuterLanguageElements(child);
            }
            if (!(child instanceof OuterLanguageElement)) continue;
            return true;
        }
        return false;
    }

    public static List<XmlAttributeValue> getIncludedPathsElements(@NotNull XmlFile file) {
        if (file == null) {
            HtmlUtil.$$$reportNull$$$0(30);
        }
        final ArrayList result2 = new ArrayList();
        file.acceptChildren(new XmlRecursiveElementWalkingVisitor(){

            @Override
            public void visitXmlTag(@NotNull XmlTag tag) {
                if (tag == null) {
                    4.$$$reportNull$$$0(0);
                }
                XmlAttribute attribute = null;
                if ("link".equalsIgnoreCase(tag.getName())) {
                    attribute = tag.getAttribute("href");
                } else if (HtmlUtil.SCRIPT_TAG_NAME.equalsIgnoreCase(tag.getName()) || "img".equalsIgnoreCase(tag.getName())) {
                    attribute = tag.getAttribute(HtmlUtil.SRC_ATTRIBUTE_NAME);
                }
                if (attribute != null) {
                    result2.add(attribute.getValueElement());
                }
                super.visitXmlTag(tag);
            }

            @Override
            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (element.getLanguage() instanceof XMLLanguage) {
                    super.visitElement(element);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tag";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/xml/util/HtmlUtil$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitXmlTag";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return result2.isEmpty() ? Collections.emptyList() : result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 23, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagToClose";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openingTag";
                break;
            }
            case 4: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/util/HtmlUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closingTag";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionName";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 18: 
            case 19: 
            case 22: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 21: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/util/HtmlUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "canOpeningTagAutoClose";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getHtmlFileTypes";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "splitClassNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSingleHtmlTag";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isTagWithOptionalEnd";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canOpeningTagAutoClose";
                break;
            }
            case 4: 
            case 23: 
            case 24: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canClosingTagAutoClose";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isPossiblyInlineTag";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isBooleanAttribute";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isCustomBooleanAttribute";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getEntitiesString";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isHtmlTag";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isHtml5Tag";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "tagHasHtml5Schema";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getStartTag";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "startsWithTag";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "detectCharsetFromMetaTag";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "hasHtml";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "supportsXmlTypedHandlers";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "hasHtmlPrefix";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isHtmlFile";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeValue";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeByName";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "containsOuterLanguageElements";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getIncludedPathsElements";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 23, 24 -> new IllegalStateException(string2);
        };
    }

    public static class CustomXmlTagDescriptor
    extends XmlElementDescriptorImpl {
        private final String myTagName;

        CustomXmlTagDescriptor(String tagName) {
            super(null);
            this.myTagName = tagName;
        }

        @Override
        public String getName(PsiElement context) {
            return this.myTagName;
        }

        @Override
        public String getDefaultName() {
            return this.myTagName;
        }

        @Override
        public boolean allowElementsFromNamespace(String namespace, XmlTag context) {
            return true;
        }
    }
}

