/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.base.fir.scripting.projectStructure;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibraryModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.base.fir.scripting.projectStructure.modules.KaScriptDependencyLibraryModuleImpl;
import org.jetbrains.kotlin.base.fir.scripting.projectStructure.modules.KaScriptModuleImpl;
import org.jetbrains.kotlin.idea.base.fir.projectStructure.K2KaModuleFactory;
import org.jetbrains.kotlin.idea.core.script.KotlinScriptEntitySource;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/base/fir/scripting/projectStructure/K2ScriptingKaModuleFactory;", "Lorg/jetbrains/kotlin/idea/base/fir/projectStructure/K2KaModuleFactory;", "<init>", "()V", "createKaModuleByPsiFile", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "file", "Lcom/intellij/psi/PsiFile;", "createSpecialLibraryModule", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaLibraryModule;", "libraryEntity", "Lcom/intellij/platform/workspace/jps/entities/LibraryEntity;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.base.fir.scripting"})
public final class K2ScriptingKaModuleFactory
implements K2KaModuleFactory {
    @Override
    @Nullable
    public KaModule createKaModuleByPsiFile(@NotNull PsiFile file) {
        KaModule kaModule;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KtFile ktFile2 = file instanceof KtFile ? (KtFile)file : null;
        if (ktFile2 == null) {
            return null;
        }
        KtFile ktFile3 = ktFile2;
        if (Intrinsics.areEqual((Object)((KtFile)file).getVirtualFile().getExtension(), (Object)"kt")) {
            return null;
        }
        if (!ktFile3.isScript()) {
            kaModule = null;
        } else if (ktFile3.isCompiled()) {
            kaModule = null;
        } else {
            Project project = ((KtFile)file).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            VirtualFile virtualFile = ((KtFile)file).getOriginalFile().getVirtualFile();
            Intrinsics.checkNotNull((Object)virtualFile);
            kaModule = new KaScriptModuleImpl(project2, virtualFile);
        }
        return kaModule;
    }

    @Override
    @Nullable
    public KaLibraryModule createSpecialLibraryModule(@NotNull LibraryEntity libraryEntity, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)libraryEntity, (String)"libraryEntity");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (libraryEntity.getEntitySource() instanceof KotlinScriptEntitySource) {
            return new KaScriptDependencyLibraryModuleImpl(libraryEntity.getSymbolicId(), project);
        }
        return null;
    }
}

