/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakePsiSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtRealPsiSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifier;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifierList;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirFunctionParameterChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameterKindKt;
import org.jetbrains.kotlin.fir.declarations.impl.FirPrimaryConstructor;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.psi.KtContextReceiverList;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011*\u00020\u0002H\u0002J\u0012\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0011*\u00020\u0014H\u0002J\u001c\u0010\u0015\u001a\u00020\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00112\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContextParametersDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isDelegationOperator", "", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "getContextParameters", "", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "findContextReceiverListSources", "Lorg/jetbrains/kotlin/KtSourceElement;", "checkSubTypes", "types", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirContextParametersDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirContextParametersDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContextParametersDeclarationChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 5 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 6 KtSourceElement.kt\norg/jetbrains/kotlin/KtSourceElementKt\n+ 7 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 8 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,179:1\n1#2:180\n1563#3:181\n1634#3,3:182\n1869#3,2:185\n1563#3:189\n1634#3,2:190\n1636#3:197\n1563#3:198\n1634#3,2:199\n1636#3:208\n1374#3:209\n1460#3,2:210\n1563#3:212\n1634#3,3:213\n1462#3,3:216\n38#4:187\n225#5:188\n846#6,5:192\n852#6,7:201\n11228#7:219\n11563#7,3:220\n37#8:223\n36#8,3:224\n*S KotlinDebug\n*F\n+ 1 FirContextParametersDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContextParametersDeclarationChecker\n*L\n85#1:181\n85#1:182,3\n110#1:185,2\n134#1:189\n134#1:190,2\n134#1:197\n138#1:198\n138#1:199,2\n138#1:208\n159#1:209\n159#1:210,2\n161#1:212\n161#1:213,3\n159#1:216,3\n120#1:187\n134#1:188\n134#1:192,5\n138#1:201,7\n149#1:219\n149#1:220,3\n156#1:223\n156#1:224,3\n*E\n"})
public final class FirContextParametersDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirContextParametersDeclarationChecker INSTANCE = new FirContextParametersDeclarationChecker();

    private FirContextParametersDeclarationChecker() {
        super(MppCheckerKind.Platform);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        List<FirValueParameter> contextParameters;
        String errorMessage;
        Iterator<FirValueParameter> it;
        Iterator<FirValueParameter> iterator;
        Iterator<FirValueParameter> iterator2;
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        KtSourceElement ktSourceElement = declaration.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
            return;
        }
        KtSourceElement ktSourceElement2 = declaration.getSource();
        List list2 = ktSourceElement2 != null ? this.findContextReceiverListSources(ktSourceElement2) : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        if ((collection = (Collection)list2).isEmpty()) {
            boolean bl = false;
            return;
        }
        List contextListSources = (List)collection;
        KtSourceElement source = (KtSourceElement)CollectionsKt.first((List)contextListSources);
        if (contextListSources.size() > 1) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), (KtDiagnosticFactory0)FirErrors.INSTANCE.getMULTIPLE_CONTEXT_LISTS(), (DiagnosticContext)context, null, (int)8, null);
        }
        boolean contextReceiversEnabled = context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ContextReceivers);
        boolean contextParametersEnabled = context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ContextParameters);
        FirDeclaration firDeclaration = declaration;
        if (firDeclaration instanceof FirTypeAlias) {
            iterator2 = "Context parameters on type aliases are unsupported.";
        } else if (firDeclaration instanceof FirAnonymousInitializer) {
            iterator2 = "Context parameters on initializers are unsupported.";
        } else if (firDeclaration instanceof FirEnumEntry) {
            iterator2 = "Context parameters on enum entries are unsupported.";
        } else if (firDeclaration instanceof FirPropertyAccessor) {
            iterator2 = "Context parameters on property accessors are unsupported.";
        } else if (firDeclaration instanceof FirBackingField) {
            iterator2 = "Context parameters on backing fields are unsupported.";
        } else if (firDeclaration instanceof FirPrimaryConstructor) {
            iterator2 = "Context parameters on primary constructors are unsupported.";
        } else if (firDeclaration instanceof FirProperty && ((FirProperty)declaration).isLocal()) {
            it = iterator = "Context parameters on local properties are unsupported.";
            boolean bl = false;
            iterator2 = contextParametersEnabled ? iterator : null;
        } else if (firDeclaration instanceof FirConstructor) {
            it = iterator = "Context parameters on constructors are unsupported.";
            boolean bl = false;
            iterator2 = contextParametersEnabled ? iterator : null;
        } else if (firDeclaration instanceof FirClass) {
            it = iterator = "Context parameters on classes are unsupported.";
            boolean bl = false;
            iterator2 = contextParametersEnabled ? iterator : null;
        } else if (firDeclaration instanceof FirCallableDeclaration && this.isDelegationOperator((FirCallableDeclaration)declaration)) {
            it = iterator = "Context parameters on delegation operators are unsupported.";
            boolean bl = false;
            iterator2 = contextParametersEnabled ? iterator : null;
        } else if (firDeclaration instanceof FirProperty && ((FirProperty)declaration).getDelegate() != null) {
            it = iterator = "Context parameters on delegated properties are unsupported.";
            boolean bl = false;
            iterator2 = contextParametersEnabled ? iterator : null;
        } else {
            iterator2 = errorMessage = firDeclaration instanceof FirSimpleFunction || firDeclaration instanceof FirProperty || firDeclaration instanceof FirAnonymousFunction ? null : "Context parameters are unsupported in this position.";
        }
        if (errorMessage != null) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), FirErrors.INSTANCE.getUNSUPPORTED(), (Object)errorMessage, (DiagnosticContext)context, null, (int)16, null);
        }
        if ((contextParameters = this.getContextParameters(declaration)).isEmpty()) {
            return;
        }
        if (!contextReceiversEnabled && !contextParametersEnabled) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), FirErrors.INSTANCE.getUNSUPPORTED_FEATURE(), (Object)TuplesKt.to((Object)LanguageFeature.ContextParameters, (Object)context.getLanguageVersionSettings()), (DiagnosticContext)context, null, (int)16, null);
            return;
        }
        if (contextReceiversEnabled) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            iterator = contextParameters;
            FirContextParametersDeclarationChecker firContextParametersDeclarationChecker = this;
            boolean $i$f$map = false;
            void bl = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                FirValueParameter firValueParameter = (FirValueParameter)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl2 = false;
                collection2.add(FirTypeUtilsKt.getConeType(it2.getReturnTypeRef()));
            }
            if (firContextParametersDeclarationChecker.checkSubTypes((List)destination$iv$iv, context)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), (KtDiagnosticFactory0)FirErrors.INSTANCE.getSUBTYPING_BETWEEN_CONTEXT_RECEIVERS(), (DiagnosticContext)context, null, (int)8, null);
            }
            for (FirValueParameter parameter : contextParameters) {
                if (FirValueParameterKindKt.isLegacyContextReceiver(parameter)) continue;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)parameter.getSource()), FirErrors.INSTANCE.getUNSUPPORTED_FEATURE(), (Object)TuplesKt.to((Object)LanguageFeature.ContextParameters, (Object)context.getLanguageVersionSettings()), (DiagnosticContext)context, null, (int)16, null);
            }
        }
        if (contextParametersEnabled) {
            for (FirValueParameter parameter : contextParameters) {
                Object object;
                if (FirValueParameterKindKt.isLegacyContextReceiver(parameter)) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)parameter.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getCONTEXT_PARAMETER_WITHOUT_NAME(), (DiagnosticContext)context, null, (int)8, null);
                }
                if ((object = parameter.getSource()) != null && (object = FirKeywordUtilsKt.getModifierList((KtSourceElement)object)) != null && (object = ((FirModifierList)object).getModifiers()) != null) {
                    Iterable $this$forEach$iv = (Iterable)object;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        FirModifier modifier = (FirModifier)element$iv;
                        boolean bl = false;
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)modifier.getSource()), FirErrors.INSTANCE.getWRONG_MODIFIER_TARGET(), (Object)modifier.getToken(), (Object)"context parameter", (DiagnosticContext)context, null, (int)32, null);
                    }
                }
                FirFunctionParameterChecker.INSTANCE.checkValOrVar$checkers(parameter, reporter, context);
            }
        }
    }

    private final boolean isDelegationOperator(FirCallableDeclaration $this$isDelegationOperator) {
        FirMemberDeclaration $this$isOperator$iv = $this$isDelegationOperator;
        boolean $i$f$isOperator = false;
        return $this$isOperator$iv.getStatus().isOperator() && OperatorNameConventions.DELEGATED_PROPERTY_OPERATORS.contains(FirDeclarationUtilKt.getNameOrSpecialName($this$isDelegationOperator));
    }

    private final List<FirValueParameter> getContextParameters(FirDeclaration $this$getContextParameters) {
        FirDeclaration firDeclaration = $this$getContextParameters;
        return firDeclaration instanceof FirCallableDeclaration ? ((FirCallableDeclaration)$this$getContextParameters).getContextParameters() : (firDeclaration instanceof FirRegularClass ? ((FirRegularClass)$this$getContextParameters).getContextParameters() : CollectionsKt.emptyList());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final List<KtSourceElement> findContextReceiverListSources(KtSourceElement $this$findContextReceiverListSources) {
        block13: {
            block14: {
                block12: {
                    var2_2 = $this$findContextReceiverListSources;
                    if (!(var2_2 instanceof KtPsiSourceElement)) break block12;
                    $this$getChildOfType$iv = ((KtPsiSourceElement)$this$findContextReceiverListSources).getPsi();
                    $i$f$getChildOfType = false;
                    v0 /* !! */  = (KtModifierList)PsiTreeUtil.getChildOfType((PsiElement)$this$getChildOfType$iv, KtModifierList.class);
                    if (v0 /* !! */  != null && (v0 /* !! */  = v0 /* !! */ .getContextReceiverLists()) != null) {
                        $this$map$iv = (Iterable)v0 /* !! */ ;
                        $i$f$map = false;
                        var7_11 = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            var12_22 = (KtContextReceiverList)item$iv$iv;
                            var20_34 = destination$iv$iv;
                            $i$a$-map-FirContextParametersDeclarationChecker$findContextReceiverListSources$1 = false;
                            Intrinsics.checkNotNull((Object)it);
                            $this$toKtPsiSourceElement_u24default$iv = (PsiElement)it;
                            kind$iv = (KtSourceElementKind)KtRealSourceElementKind.INSTANCE;
                            $i$f$toKtPsiSourceElement = false;
                            var17_32 = kind$iv;
                            if (var17_32 instanceof KtRealSourceElementKind) {
                                v1 = (KtPsiSourceElement)new KtRealPsiSourceElement($this$toKtPsiSourceElement_u24default$iv);
                            } else if (var17_32 instanceof KtFakeSourceElementKind) {
                                v1 = (KtPsiSourceElement)new KtFakePsiSourceElement($this$toKtPsiSourceElement_u24default$iv, (KtFakeSourceElementKind)kind$iv);
                            } else {
                                throw new NoWhenBranchMatchedException();
                            }
                            var20_34.add(v1);
                        }
                        v2 = (List)destination$iv$iv;
                    } else {
                        v2 = v3 = null;
                    }
                    if (v2 == null) {
                        v3 = CollectionsKt.emptyList();
                    }
                    break block13;
                }
                if (!(var2_2 instanceof KtLightSourceElement)) break block14;
                v4 = ((KtLightSourceElement)$this$findContextReceiverListSources).getTreeStructure();
                v5 = ((KtLightSourceElement)$this$findContextReceiverListSources).getLighterASTNode();
                v6 = KtNodeTypes.MODIFIER_LIST;
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"MODIFIER_LIST");
                var3_36 = LightTreePositioningStrategiesKt.findChildByType((FlyweightCapableTreeStructure)v4, (LighterASTNode)v5, (IElementType)v6);
                if (var3_36 == null) ** GOTO lbl-1000
                it = var3_36;
                $i$a$-let-FirContextParametersDeclarationChecker$findContextReceiverListSources$2 = false;
                v7 = ((KtLightSourceElement)$this$findContextReceiverListSources).getTreeStructure();
                v8 = KtNodeTypes.CONTEXT_RECEIVER_LIST;
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"CONTEXT_RECEIVER_LIST");
                var4_4 = LightTreePositioningStrategiesKt.findChildrenByType((FlyweightCapableTreeStructure)v7, (LighterASTNode)it, (IElementType)v8);
                if (var4_4 != null) {
                    $this$map$iv = var4_4;
                    $i$f$map = false;
                    $i$a$-let-FirContextParametersDeclarationChecker$findContextReceiverListSources$2 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        it = (LighterASTNode)item$iv$iv;
                        var20_35 = destination$iv$iv;
                        $i$a$-map-FirContextParametersDeclarationChecker$findContextReceiverListSources$3 = false;
                        $this$toKtPsiSourceElement_u24default$iv = it;
                        tree$iv = ((KtLightSourceElement)$this$findContextReceiverListSources).getTreeStructure();
                        kind$iv = (KtSourceElementKind)KtRealSourceElementKind.INSTANCE;
                        startOffset$iv = $this$toKtLightSourceElement_u24default$iv.getStartOffset();
                        endOffset$iv = $this$toKtLightSourceElement_u24default$iv.getEndOffset();
                        $i$f$toKtLightSourceElement = false;
                        var20_35.add(new KtLightSourceElement((LighterASTNode)$this$toKtLightSourceElement_u24default$iv, startOffset$iv, endOffset$iv, tree$iv, kind$iv));
                    }
                    v9 = (List)destination$iv$iv;
                } else lbl-1000:
                // 2 sources

                {
                    v9 = v3 = null;
                }
                if (v9 == null) {
                    v3 = CollectionsKt.emptyList();
                }
                break block13;
            }
            throw new NoWhenBranchMatchedException();
        }
        return v3;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean checkSubTypes(@NotNull List<? extends ConeKotlinType> types, @NotNull CheckerContext context) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(types, (String)"types");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Iterable $this$flatMap$iv = types;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list2;
            ConeKotlinType r = (ConeKotlinType)element$iv$iv;
            boolean bl = false;
            ConeKotlinType coneKotlinType = r;
            if (coneKotlinType instanceof ConeTypeParameterType) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = ((ConeTypeParameterType)r).getLookupTag().getTypeParameterSymbol().getResolvedBounds();
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(it.getConeType());
                }
                list2 = (List)destination$iv$iv2;
            } else {
                list2 = coneKotlinType instanceof ConeClassLikeType ? CollectionsKt.listOf((Object)FirContextParametersDeclarationChecker.checkSubTypes$replaceTypeParametersByStarProjections((ConeClassLikeType)r)) : CollectionsKt.listOf((Object)r);
            }
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List replacedTypeParameters = (List)destination$iv$iv;
        int n = ((Collection)replacedTypeParameters).size();
        for (int i2 = 0; i2 < n; ++i2) {
            int n2 = replacedTypeParameters.size();
            for (int j = i2 + 1; j < n2; ++j) {
                if (!TypeUtilsKt.isSubtypeOf$default((ConeKotlinType)replacedTypeParameters.get(i2), (ConeKotlinType)replacedTypeParameters.get(j), context.getSession(), false, 4, null) && !TypeUtilsKt.isSubtypeOf$default((ConeKotlinType)replacedTypeParameters.get(j), (ConeKotlinType)replacedTypeParameters.get(i2), context.getSession(), false, 4, null)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final ConeClassLikeType checkSubTypes$replaceTypeParametersByStarProjections(ConeClassLikeType type2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ConeTypeProjection[] coneTypeProjectionArray = type2.getTypeArguments();
        ConeClassLikeType coneClassLikeType = type2;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            ConeTypeProjection coneTypeProjection;
            void it;
            void item$iv$iv;
            void var9_10 = item$iv$iv = $this$mapTo$iv$iv[j];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (ConeTypeProjectionKt.isStarProjection((ConeTypeProjection)it)) {
                coneTypeProjection = it;
            } else {
                ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType((ConeTypeProjection)it);
                Intrinsics.checkNotNull((Object)coneKotlinType);
                if (coneKotlinType instanceof ConeTypeParameterType) {
                    coneTypeProjection = ConeStarProjection.INSTANCE;
                } else {
                    ConeKotlinType coneKotlinType2 = ConeTypeProjectionKt.getType((ConeTypeProjection)it);
                    Intrinsics.checkNotNull((Object)coneKotlinType2);
                    if (coneKotlinType2 instanceof ConeClassLikeType) {
                        ConeKotlinType coneKotlinType3 = ConeTypeProjectionKt.getType((ConeTypeProjection)it);
                        Intrinsics.checkNotNull((Object)coneKotlinType3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeClassLikeType");
                        coneTypeProjection = FirContextParametersDeclarationChecker.checkSubTypes$replaceTypeParametersByStarProjections((ConeClassLikeType)coneKotlinType3);
                    } else {
                        coneTypeProjection = it;
                    }
                }
            }
            collection.add(coneTypeProjection);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return ConeTypeUtilsKt.withArguments(coneClassLikeType, thisCollection$iv.toArray(new ConeTypeProjection[0]));
    }
}

