/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirSafeCallExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirWrappedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.UnsafeExpressionUtility;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractConeResolutionAtom;
import org.jetbrains.kotlin.fir.resolve.calls.ConeAtomWithCandidate;
import org.jetbrains.kotlin.fir.resolve.calls.ConeResolutionAtomWithPostponedChild;
import org.jetbrains.kotlin.fir.resolve.calls.ConeResolutionAtomWithSingleChild;
import org.jetbrains.kotlin.fir.resolve.calls.ConeSimpleLeafResolutionAtom;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CandidateFactoryKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \b2\u00020\u0001:\u0001\bB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0005\t\n\u000b\f\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/ConeResolutionAtom;", "Lorg/jetbrains/kotlin/fir/resolve/calls/AbstractConeResolutionAtom;", "<init>", "()V", "expression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getExpression", "()Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "Companion", "Lorg/jetbrains/kotlin/fir/resolve/calls/ConeAtomWithCandidate;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ConePostponedResolvedAtom;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ConeResolutionAtomWithPostponedChild;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ConeResolutionAtomWithSingleChild;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ConeSimpleLeafResolutionAtom;", "resolve"})
public abstract class ConeResolutionAtom
extends AbstractConeResolutionAtom {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private ConeResolutionAtom() {
    }

    @Override
    @NotNull
    public abstract FirExpression getExpression();

    public /* synthetic */ ConeResolutionAtom(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007\u00a2\u0006\u0002\b\bJ\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/ConeResolutionAtom$Companion;", "", "<init>", "()V", "createRawAtom", "Lorg/jetbrains/kotlin/fir/resolve/calls/ConeResolutionAtom;", "expression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "createRawAtomNullable", "createRawAtomForPotentiallyUnresolvedExpression", "allowUnresolvedExpression", "", "resolve"})
    public static final class Companion {
        private Companion() {
        }

        @JvmName(name="createRawAtomNullable")
        @Nullable
        public final ConeResolutionAtom createRawAtomNullable(@Nullable FirExpression expression) {
            return this.createRawAtom(expression, false);
        }

        @NotNull
        public final ConeResolutionAtom createRawAtom(@NotNull FirExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            ConeResolutionAtom coneResolutionAtom = this.createRawAtom(expression, false);
            Intrinsics.checkNotNull((Object)coneResolutionAtom);
            return coneResolutionAtom;
        }

        @UnsafeExpressionUtility
        @NotNull
        public final ConeResolutionAtom createRawAtomForPotentiallyUnresolvedExpression(@NotNull FirExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            ConeResolutionAtom coneResolutionAtom = this.createRawAtom(expression, true);
            Intrinsics.checkNotNull((Object)coneResolutionAtom);
            return coneResolutionAtom;
        }

        private final ConeResolutionAtom createRawAtom(FirExpression expression, boolean allowUnresolvedExpression) {
            ConeResolutionAtom coneResolutionAtom;
            FirExpression firExpression = expression;
            if (firExpression == null) {
                coneResolutionAtom = null;
            } else if (firExpression instanceof FirAnonymousFunctionExpression) {
                coneResolutionAtom = new ConeResolutionAtomWithPostponedChild(expression);
            } else if (firExpression instanceof FirCallableReferenceAccess) {
                coneResolutionAtom = FirTypeUtilsKt.isResolved(expression) ? (ConeResolutionAtom)new ConeSimpleLeafResolutionAtom(expression, allowUnresolvedExpression) : (ConeResolutionAtom)new ConeResolutionAtomWithPostponedChild(expression);
            } else if (firExpression instanceof FirSafeCallExpression) {
                FirStatement firStatement = ((FirSafeCallExpression)expression).getSelector();
                FirExpression firExpression2 = firStatement instanceof FirExpression ? (FirExpression)firStatement : null;
                coneResolutionAtom = new ConeResolutionAtomWithSingleChild(expression, this.createRawAtom(firExpression2 != null ? FirExpressionUtilKt.unwrapSmartcastExpression(firExpression2) : null, allowUnresolvedExpression));
            } else {
                Candidate candidate;
                coneResolutionAtom = firExpression instanceof FirResolvable ? ((candidate = CandidateFactoryKt.candidate((FirResolvable)((Object)expression))) == null ? (ConeResolutionAtom)new ConeSimpleLeafResolutionAtom(expression, allowUnresolvedExpression) : (ConeResolutionAtom)new ConeAtomWithCandidate(expression, candidate)) : (firExpression instanceof FirWrappedArgumentExpression ? (ConeResolutionAtom)new ConeResolutionAtomWithSingleChild(expression, this.createRawAtom(((FirWrappedArgumentExpression)expression).getExpression(), allowUnresolvedExpression)) : (firExpression instanceof FirErrorExpression ? (ConeResolutionAtom)new ConeResolutionAtomWithSingleChild(expression, this.createRawAtom(((FirErrorExpression)expression).getExpression(), allowUnresolvedExpression)) : (firExpression instanceof FirBlock ? (ConeResolutionAtom)new ConeResolutionAtomWithSingleChild(expression, this.createRawAtom(UtilsKt.getLastExpression((FirBlock)expression), allowUnresolvedExpression)) : (ConeResolutionAtom)new ConeSimpleLeafResolutionAtom(expression, allowUnresolvedExpression))));
            }
            return coneResolutionAtom;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

