/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.serialization;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.constant.AnnotationArgumentVisitor;
import org.jetbrains.kotlin.constant.AnnotationValue;
import org.jetbrains.kotlin.constant.ConstantValue;
import org.jetbrains.kotlin.constant.ErrorValue;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.serialization.FirAnnotationArgumentVisitor;
import org.jetbrains.kotlin.fir.serialization.FirAnnotationArgumentVisitorData;
import org.jetbrains.kotlin.fir.serialization.FirElementAwareStringTable;
import org.jetbrains.kotlin.fir.serialization.LocalClassIdOracle;
import org.jetbrains.kotlin.fir.serialization.constant.ConstValueProvider;
import org.jetbrains.kotlin.fir.serialization.constant.FirToConstantValueTransformerKt;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0016J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0016\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u001b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0\u001aH\u0002J\u0019\u0010\u001d\u001a\u00020\u001e2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u001cH\u0000\u00a2\u0006\u0002\b R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/fir/serialization/FirAnnotationSerializer;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "stringTable", "Lorg/jetbrains/kotlin/fir/serialization/FirElementAwareStringTable;", "constValueProvider", "Lorg/jetbrains/kotlin/fir/serialization/constant/ConstValueProvider;", "localClassIdOracle", "Lorg/jetbrains/kotlin/fir/serialization/LocalClassIdOracle;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Lorg/jetbrains/kotlin/fir/serialization/FirElementAwareStringTable;Lorg/jetbrains/kotlin/fir/serialization/constant/ConstValueProvider;Lorg/jetbrains/kotlin/fir/serialization/LocalClassIdOracle;)V", "getStringTable$fir_serialization", "()Lorg/jetbrains/kotlin/fir/serialization/FirElementAwareStringTable;", "getLocalClassIdOracle$fir_serialization", "()Lorg/jetbrains/kotlin/fir/serialization/LocalClassIdOracle;", "serializeAnnotation", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Annotation;", "annotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "Lorg/jetbrains/kotlin/constant/AnnotationValue;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "argumentsMapping", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/constant/ConstantValue;", "valueProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Annotation$Argument$Value$Builder;", "constant", "valueProto$fir_serialization", "fir-serialization"})
@SourceDebugExtension(value={"SMAP\nFirAnnotationSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirAnnotationSerializer.kt\norg/jetbrains/kotlin/fir/serialization/FirAnnotationSerializer\n+ 2 FirToConstantValueTransformer.kt\norg/jetbrains/kotlin/fir/serialization/constant/FirToConstantValueTransformerKt\n*L\n1#1,75:1\n47#2,8:76\n*S KotlinDebug\n*F\n+ 1 FirAnnotationSerializer.kt\norg/jetbrains/kotlin/fir/serialization/FirAnnotationSerializer\n*L\n31#1:76,8\n*E\n"})
public final class FirAnnotationSerializer {
    @NotNull
    private final FirSession session;
    @NotNull
    private final ScopeSession scopeSession;
    @NotNull
    private final FirElementAwareStringTable stringTable;
    @Nullable
    private final ConstValueProvider constValueProvider;
    @NotNull
    private final LocalClassIdOracle localClassIdOracle;

    public FirAnnotationSerializer(@NotNull FirSession session, @NotNull ScopeSession scopeSession, @NotNull FirElementAwareStringTable stringTable2, @Nullable ConstValueProvider constValueProvider, @NotNull LocalClassIdOracle localClassIdOracle2) {
        Intrinsics.checkNotNullParameter((Object)((Object)session), (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        Intrinsics.checkNotNullParameter((Object)stringTable2, (String)"stringTable");
        Intrinsics.checkNotNullParameter((Object)localClassIdOracle2, (String)"localClassIdOracle");
        this.session = session;
        this.scopeSession = scopeSession;
        this.stringTable = stringTable2;
        this.constValueProvider = constValueProvider;
        this.localClassIdOracle = localClassIdOracle2;
    }

    @NotNull
    public final FirElementAwareStringTable getStringTable$fir_serialization() {
        return this.stringTable;
    }

    @NotNull
    public final LocalClassIdOracle getLocalClassIdOracle$fir_serialization() {
        return this.localClassIdOracle;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ProtoBuf.Annotation serializeAnnotation(@NotNull FirAnnotation annotation) {
        ConstantValue constantValue;
        void $this$toConstantValue$iv;
        ConstantValue<?> valueFromIr$iv;
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        FirExpression firExpression = annotation;
        FirSession firSession = this.session;
        ScopeSession scopeSession = this.scopeSession;
        ConstValueProvider constValueProvider$iv = this.constValueProvider;
        boolean $i$f$toConstantValue = false;
        ConstValueProvider constValueProvider = constValueProvider$iv;
        ConstantValue<?> constantValue2 = valueFromIr$iv = constValueProvider != null ? constValueProvider.findConstantValueFor((FirExpression)$this$toConstantValue$iv) : null;
        if (constantValue2 != null) {
            ConstantValue<?> constantValue3 = constantValue2;
            if (!(constantValue2 instanceof AnnotationValue)) {
                constantValue3 = null;
            }
            constantValue = (ConstantValue)((AnnotationValue)constantValue3);
        } else {
            void scopeSession$iv;
            void session$iv;
            ConstantValue valueFromFir$iv = (ConstantValue)FirToConstantValueTransformerKt.access$evaluateToAnnotationValue((FirAnnotation)$this$toConstantValue$iv, (FirSession)session$iv, (ScopeSession)scopeSession$iv);
            ConstantValue constantValue4 = valueFromFir$iv;
            if (!(constantValue4 instanceof AnnotationValue)) {
                constantValue4 = null;
            }
            constantValue = (ConstantValue)((AnnotationValue)constantValue4);
        }
        AnnotationValue annotationValue = (AnnotationValue)constantValue;
        if (annotationValue == null) {
            throw new IllegalStateException(("Cannot serialize annotation " + UtilsKt.render(annotation)).toString());
        }
        AnnotationValue annotationValue2 = annotationValue;
        return this.serializeAnnotation(annotationValue2);
    }

    @NotNull
    public final ProtoBuf.Annotation serializeAnnotation(@NotNull AnnotationValue annotation) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        return this.serializeAnnotation(((AnnotationValue.Value)annotation.getValue()).getClassId(), ((AnnotationValue.Value)annotation.getValue()).getArgumentsMapping());
    }

    private final ProtoBuf.Annotation serializeAnnotation(ClassId classId, Map<Name, ? extends ConstantValue<?>> argumentsMapping) {
        ProtoBuf.Annotation.Builder builder2;
        ProtoBuf.Annotation.Builder $this$serializeAnnotation_u24lambda_u240 = builder2 = ProtoBuf.Annotation.newBuilder();
        boolean bl = false;
        $this$serializeAnnotation_u24lambda_u240.setId(this.stringTable.getQualifiedClassNameIndex(classId));
        for (Map.Entry<Name, ConstantValue<?>> entry : argumentsMapping.entrySet()) {
            Name name2 = entry.getKey();
            ConstantValue<?> argument2 = entry.getValue();
            if (!(argument2 instanceof ErrorValue)) {
                FirAnnotationSerializer.serializeAnnotation$lambda$0$addArgument(this, $this$serializeAnnotation_u24lambda_u240, argument2, name2);
                continue;
            }
            if (((Boolean)FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.session).getFlag(AnalysisFlags.getMetadataCompilation())).booleanValue()) continue;
            ConstantValue<?> constantValue = argument2;
            Object object = constantValue instanceof ErrorValue.ErrorValueWithMessage ? (ErrorValue.ErrorValueWithMessage)constantValue : null;
            if (object == null || (object = object.getMessage()) == null) {
                object = "Error value after conversion of expression of " + name2 + " argument";
            }
            Object object2 = object;
            throw new IllegalStateException(object2.toString());
        }
        ProtoBuf.Annotation annotation = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)annotation, (String)"build(...)");
        return annotation;
    }

    @NotNull
    public final ProtoBuf.Annotation.Argument.Value.Builder valueProto$fir_serialization(@NotNull ConstantValue<?> constant) {
        ProtoBuf.Annotation.Argument.Value.Builder builder2;
        Intrinsics.checkNotNullParameter(constant, (String)"constant");
        ProtoBuf.Annotation.Argument.Value.Builder $this$valueProto_u24lambda_u241 = builder2 = ProtoBuf.Annotation.Argument.Value.newBuilder();
        boolean bl = false;
        AnnotationArgumentVisitor annotationArgumentVisitor = FirAnnotationArgumentVisitor.INSTANCE;
        Intrinsics.checkNotNull((Object)$this$valueProto_u24lambda_u241);
        constant.accept(annotationArgumentVisitor, (Object)new FirAnnotationArgumentVisitorData(this, $this$valueProto_u24lambda_u241));
        ProtoBuf.Annotation.Argument.Value.Builder builder3 = builder2;
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"apply(...)");
        return builder3;
    }

    private static final void serializeAnnotation$lambda$0$addArgument(FirAnnotationSerializer this$0, ProtoBuf.Annotation.Builder $this_apply, ConstantValue<?> argumentExpression, Name parameterName2) {
        ProtoBuf.Annotation.Argument.Builder argument2 = ProtoBuf.Annotation.Argument.newBuilder();
        FirElementAwareStringTable firElementAwareStringTable = this$0.stringTable;
        String string = parameterName2.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        argument2.setNameId(firElementAwareStringTable.getStringIndex(string));
        argument2.setValue(this$0.valueProto$fir_serialization(argumentExpression));
        $this_apply.addArgument(argument2);
    }
}

