/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions.internal;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveVisitor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.FileUtils;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.util.PsiUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001e\u0010\b\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\u0013\u001a\u00020\u000f*\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00192\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J)\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u001e\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/actions/internal/FindImplicitNothingAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "find", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "project", "Lcom/intellij/openapi/project/Project;", "hasExplicitNothing", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isNothingOrNothingFunctionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "selectedKotlinFiles", "Lkotlin/sequences/Sequence;", "allKotlinFiles", "filesOrDirs", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "([Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;)Lkotlin/sequences/Sequence;", "Companion", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nFindImplicitNothingAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FindImplicitNothingAction.kt\norg/jetbrains/kotlin/idea/actions/internal/FindImplicitNothingAction\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,146:1\n81#2:147\n1557#3:148\n1628#3,3:149\n37#4:152\n36#4,3:153\n*S KotlinDebug\n*F\n+ 1 FindImplicitNothingAction.kt\norg/jetbrains/kotlin/idea/actions/internal/FindImplicitNothingAction\n*L\n130#1:147\n90#1:148\n90#1:149,3\n90#1:152\n90#1:153,3\n*E\n"})
public final class FindImplicitNothingAction
extends AnAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        List selectedFiles = SequencesKt.toList(this.selectedKotlinFiles(e));
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        Object object = CommonDataKeys.PROJECT.getData(dataContext);
        Intrinsics.checkNotNull((Object)object);
        Project project = (Project)object;
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> FindImplicitNothingAction.actionPerformed$lambda$0(this, selectedFiles, project), KotlinBundle.message((String)"progress.finding.implicit.nothing.s", (Object[])new Object[0]), true, project);
    }

    private final void find(Collection<? extends KtFile> files, Project project) {
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        ArrayList<KtCallExpression> found = new ArrayList<KtCallExpression>();
        Iterator iterator = ((Iterable)files).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i2 = n++;
            KtFile file = (KtFile)iterator.next();
            ProgressIndicator progressIndicator2 = progressIndicator;
            if (progressIndicator2 != null) {
                Object[] objectArray = new Object[]{i2, files.size(), found.size()};
                progressIndicator2.setText(KotlinBundle.message((String)"scanning.files.0.fo.1.file.2.occurrences.found", (Object[])objectArray));
            }
            ProgressIndicator progressIndicator3 = progressIndicator;
            if (progressIndicator3 != null) {
                progressIndicator3.setText2(file.getVirtualFile().getPath());
            }
            ResolutionFacade resolutionFacade = ResolutionUtils.getResolutionFacade((KtElement)file);
            file.acceptChildren((PsiElementVisitor)new PsiRecursiveVisitor(resolutionFacade, this, found){
                final /* synthetic */ ResolutionFacade $resolutionFacade;
                final /* synthetic */ FindImplicitNothingAction this$0;
                final /* synthetic */ ArrayList<KtCallExpression> $found;
                {
                    this.$resolutionFacade = $resolutionFacade;
                    this.this$0 = $receiver;
                    this.$found = $found;
                }

                public void visitKtElement(KtElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    ProgressManager.checkCanceled();
                    element.acceptChildren((PsiElementVisitor)this);
                }

                public void visitCallExpression(KtCallExpression expression) {
                    Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                    expression.acceptChildren((PsiElementVisitor)this);
                    try {
                        BindingContext bindingContext = ResolutionFacade.analyze$default(this.$resolutionFacade, (KtElement)expression, null, 2, null);
                        KotlinType kotlinType = bindingContext.getType((KtExpression)expression);
                        if (kotlinType == null) {
                            return;
                        }
                        KotlinType type2 = kotlinType;
                        if (KotlinBuiltIns.isNothing((KotlinType)type2) && !FindImplicitNothingAction.access$hasExplicitNothing(this.this$0, (KtExpression)expression, bindingContext)) {
                            this.$found.add(expression);
                        }
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        FindImplicitNothingAction.access$getLOG$cp().error(t);
                    }
                }
            });
            ProgressIndicator progressIndicator4 = progressIndicator;
            if (progressIndicator4 == null) continue;
            progressIndicator4.setFraction((double)(i2 + 1) / (double)files.size());
        }
        SwingUtilities.invokeLater(() -> FindImplicitNothingAction.find$lambda$2(found, project, files));
    }

    private final boolean hasExplicitNothing(KtExpression $this$hasExplicitNothing, BindingContext bindingContext) {
        KtExpression ktExpression = PsiUtilsKt.getCalleeExpressionIfAny((KtElement)((KtElement)$this$hasExplicitNothing));
        if (ktExpression == null) {
            return false;
        }
        KtExpression callee = ktExpression;
        if (callee instanceof KtSimpleNameExpression) {
            KtCallableDeclaration declaration;
            DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)bindingContext.get((ReadOnlySlice)BindingContext.REFERENCE_TARGET, (Object)callee);
            if (declarationDescriptor == null) {
                return false;
            }
            DeclarationDescriptor target = declarationDescriptor;
            CallableDescriptor callableDescriptor = target instanceof CallableDescriptor ? (CallableDescriptor)target : null;
            if (callableDescriptor == null) {
                return false;
            }
            CallableDescriptor callableDescriptor2 = callableDescriptor.getOriginal();
            Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor2, (String)"getOriginal(...)");
            CallableDescriptor callableDescriptor3 = callableDescriptor2;
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)((DeclarationDescriptor)callableDescriptor3));
            KtCallableDeclaration ktCallableDeclaration = declaration = psiElement instanceof KtCallableDeclaration ? (KtCallableDeclaration)psiElement : null;
            if (declaration != null && declaration.getTypeReference() == null) {
                return false;
            }
            KotlinType kotlinType = callableDescriptor3.getReturnType();
            if (kotlinType == null) {
                return false;
            }
            KotlinType type2 = kotlinType;
            return this.isNothingOrNothingFunctionType(type2);
        }
        return this.hasExplicitNothing(callee, bindingContext);
    }

    private final boolean isNothingOrNothingFunctionType(KotlinType $this$isNothingOrNothingFunctionType) {
        return KotlinBuiltIns.isNothing((KotlinType)$this$isNothingOrNothingFunctionType) || FunctionTypesKt.isFunctionType((KotlinType)$this$isNothingOrNothingFunctionType) && this.isNothingOrNothingFunctionType(FunctionTypesKt.getReturnTypeFromFunctionType((KotlinType)$this$isNothingOrNothingFunctionType));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        boolean $i$f$isApplicationInternalMode = false;
        e.getPresentation().setEnabledAndVisible(ApplicationManager.getApplication().isInternal());
    }

    private final Sequence<KtFile> selectedKotlinFiles(AnActionEvent e) {
        VirtualFile[] virtualFileArray = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (virtualFileArray == null) {
            return SequencesKt.sequenceOf((Object[])new KtFile[0]);
        }
        VirtualFile[] virtualFiles = virtualFileArray;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return SequencesKt.sequenceOf((Object[])new KtFile[0]);
        }
        Project project2 = project;
        return this.allKotlinFiles(virtualFiles, project2);
    }

    private final Sequence<KtFile> allKotlinFiles(VirtualFile[] filesOrDirs, Project project) {
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager manager = psiManager;
        return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)FileUtils.getAllFilesRecursively(filesOrDirs)), arg_0 -> FindImplicitNothingAction.allKotlinFiles$lambda$3(manager, arg_0));
    }

    private static final void actionPerformed$lambda$0(FindImplicitNothingAction this$0, List $selectedFiles, Project $project) {
        this$0.find($selectedFiles, $project);
    }

    /*
     * WARNING - void declaration
     */
    private static final void find$lambda$2(ArrayList $found, Project $project, Collection $files) {
        if (!((Collection)$found).isEmpty()) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = $found;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KtCallExpression ktCallExpression = (KtCallExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new UsageInfo2UsageAdapter(new UsageInfo((PsiElement)it)));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            UsageInfo2UsageAdapter[] usages2 = thisCollection$iv.toArray(new UsageInfo2UsageAdapter[0]);
            UsageViewPresentation presentation = new UsageViewPresentation();
            presentation.setTabName(KotlinBundle.message((String)"implicit.nothing.s", (Object[])new Object[0]));
            UsageViewManager.getInstance((Project)$project).showUsages(new UsageTarget[0], (Usage[])usages2, presentation);
        } else {
            Object[] objectArray = new Object[]{$files.size()};
            Messages.showInfoMessage((Project)$project, (String)KotlinBundle.message((String)"not.found.in.0.files", (Object[])objectArray), (String)KotlinBundle.message((String)"titile.not.found", (Object[])new Object[0]));
        }
    }

    private static final KtFile allKotlinFiles$lambda$3(PsiManager $manager, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PsiFile psiFile = $manager.findFile(it);
        return psiFile instanceof KtFile ? (KtFile)psiFile : null;
    }

    public static final /* synthetic */ boolean access$hasExplicitNothing(FindImplicitNothingAction $this, KtExpression $receiver, BindingContext bindingContext) {
        return $this.hasExplicitNothing($receiver, bindingContext);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        Logger logger = Logger.getInstance((String)"#org.jetbrains.kotlin.idea.actions.internal.FindImplicitNothingAction");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/actions/internal/FindImplicitNothingAction$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

