/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.fir.projectStructure;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.workspace.WorkspaceModelKt;
import com.intellij.platform.workspace.jps.entities.InheritedSdkDependency;
import com.intellij.platform.workspace.jps.entities.LibraryDependency;
import com.intellij.platform.workspace.jps.entities.ModuleDependency;
import com.intellij.platform.workspace.jps.entities.ModuleDependencyItem;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.ModuleId;
import com.intellij.platform.workspace.jps.entities.ModuleSourceDependency;
import com.intellij.platform.workspace.jps.entities.SdkDependency;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.platform.KotlinMessageBusProviderKt;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinModificationTopics;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinModuleStateModificationKind;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000e\u001a\u00020\bJ\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/base/fir/projectStructure/KotlinExportedDependenciesCollector;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/platform/workspace/jps/entities/ModuleDependency;", "", "Lcom/intellij/platform/workspace/jps/entities/ModuleDependencyItem;", "dropCaches", "", "getExportedDependencies", "dependency", "computeDependencies", "computeDependenciesOf", "currentSnapshot", "Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;", "dispose", "Companion", "kotlin.base.fir.project-structure"})
@SourceDebugExtension(value={"SMAP\nKotlinExportedDependenciesCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinExportedDependenciesCollector.kt\norg/jetbrains/kotlin/idea/base/fir/projectStructure/KotlinExportedDependenciesCollector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n1#2:115\n1663#3,8:116\n*S KotlinDebug\n*F\n+ 1 KotlinExportedDependenciesCollector.kt\norg/jetbrains/kotlin/idea/base/fir/projectStructure/KotlinExportedDependenciesCollector\n*L\n97#1:116,8\n*E\n"})
public final class KotlinExportedDependenciesCollector
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentMap<ModuleDependency, List<ModuleDependencyItem>> cache;

    public KotlinExportedDependenciesCollector(@NotNull Project project) {
        MessageBusConnection messageBusConnection;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.cache = new ConcurrentHashMap();
        MessageBusConnection $this$_init__u24lambda_u243 = messageBusConnection = KotlinMessageBusProviderKt.getAnalysisMessageBus(this.project).connect((Disposable)this);
        boolean bl = false;
        $this$_init__u24lambda_u243.subscribe(KotlinModificationTopics.INSTANCE.getMODULE_STATE_MODIFICATION(), (arg_0, arg_1) -> KotlinExportedDependenciesCollector.lambda$3$lambda$0(this, arg_0, arg_1));
        $this$_init__u24lambda_u243.subscribe(KotlinModificationTopics.INSTANCE.getGLOBAL_MODULE_STATE_MODIFICATION(), () -> KotlinExportedDependenciesCollector.lambda$3$lambda$1(this));
        $this$_init__u24lambda_u243.subscribe(KotlinModificationTopics.INSTANCE.getGLOBAL_SOURCE_MODULE_STATE_MODIFICATION(), () -> KotlinExportedDependenciesCollector.lambda$3$lambda$2(this));
    }

    private final void dropCaches() {
        this.cache.clear();
    }

    @NotNull
    public final List<ModuleDependencyItem> getExportedDependencies(@NotNull ModuleDependency dependency) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        List list2 = (List)this.cache.get(dependency);
        if (list2 != null) {
            List it = list2;
            boolean bl = false;
            return it;
        }
        ImmutableEntityStorage currentSnapshot = WorkspaceModelKt.getWorkspaceModel((Project)this.project).getCurrentSnapshot();
        return this.computeDependencies(dependency, currentSnapshot);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ModuleDependencyItem> computeDependencies(ModuleDependency computeDependenciesOf, ImmutableEntityStorage currentSnapshot) {
        void $this$distinctBy$iv;
        LinkedHashSet<ModuleId> visitedModules = new LinkedHashSet<ModuleId>();
        List rawResult = new ArrayList();
        KotlinExportedDependenciesCollector.computeDependencies$visit(visitedModules, this, currentSnapshot, rawResult, computeDependenciesOf);
        Iterable iterable = rawResult;
        boolean $i$f$distinctBy = false;
        HashSet<SymbolicEntityId> set$iv = new HashSet<SymbolicEntityId>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            SymbolicEntityId key$iv;
            SymbolicEntityId symbolicEntityId;
            ModuleDependencyItem dep = (ModuleDependencyItem)e$iv;
            boolean bl = false;
            ModuleDependencyItem moduleDependencyItem = dep;
            if (moduleDependencyItem instanceof LibraryDependency) {
                symbolicEntityId = (SymbolicEntityId)((LibraryDependency)dep).getLibrary();
            } else if (moduleDependencyItem instanceof ModuleDependency) {
                symbolicEntityId = (SymbolicEntityId)((ModuleDependency)dep).getModule();
            } else {
                throw new IllegalStateException(("Unexpected dependency type: " + computeDependenciesOf).toString());
            }
            if (!set$iv.add(key$iv = symbolicEntityId)) continue;
            list$iv.add(e$iv);
        }
        List result2 = list$iv;
        List list2 = this.cache.putIfAbsent(computeDependenciesOf, result2);
        if (list2 == null) {
            list2 = result2;
        }
        return list2;
    }

    public void dispose() {
    }

    private static final void lambda$3$lambda$0(KotlinExportedDependenciesCollector this$0, KaModule kaModule, KotlinModuleStateModificationKind kotlinModuleStateModificationKind) {
        Intrinsics.checkNotNullParameter((Object)kaModule, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)((Object)kotlinModuleStateModificationKind), (String)"<unused var>");
        this$0.dropCaches();
    }

    private static final void lambda$3$lambda$1(KotlinExportedDependenciesCollector this$0) {
        this$0.dropCaches();
    }

    private static final void lambda$3$lambda$2(KotlinExportedDependenciesCollector this$0) {
        this$0.dropCaches();
    }

    private static final void computeDependencies$visit(LinkedHashSet<ModuleId> visitedModules, KotlinExportedDependenciesCollector this$0, ImmutableEntityStorage $currentSnapshot, List<ModuleDependencyItem> rawResult, ModuleDependency currentDependency) {
        if (visitedModules.contains(currentDependency.getModule())) {
            return;
        }
        ((Collection)visitedModules).add(currentDependency.getModule());
        List list2 = (List)this$0.cache.get(currentDependency);
        if (list2 != null) {
            List it = list2;
            boolean bl = false;
            CollectionsKt.addAll((Collection)rawResult, (Iterable)it);
            return;
        }
        ModuleEntity moduleEntity = (ModuleEntity)currentDependency.getModule().resolve((EntityStorage)$currentSnapshot);
        if (moduleEntity == null) {
            return;
        }
        ModuleEntity moduleEntity2 = moduleEntity;
        for (ModuleDependencyItem transitiveDependency : moduleEntity2.getDependencies()) {
            ModuleDependencyItem moduleDependencyItem = transitiveDependency;
            if (moduleDependencyItem instanceof LibraryDependency) {
                if (!((LibraryDependency)transitiveDependency).getExported()) continue;
                ((Collection)rawResult).add(transitiveDependency);
                continue;
            }
            if (moduleDependencyItem instanceof ModuleDependency) {
                if (!((ModuleDependency)transitiveDependency).getExported()) continue;
                ((Collection)rawResult).add(transitiveDependency);
                KotlinExportedDependenciesCollector.computeDependencies$visit(visitedModules, this$0, $currentSnapshot, rawResult, (ModuleDependency)transitiveDependency);
                continue;
            }
            if (moduleDependencyItem instanceof SdkDependency || Intrinsics.areEqual((Object)moduleDependencyItem, (Object)ModuleSourceDependency.INSTANCE) || Intrinsics.areEqual((Object)moduleDependencyItem, (Object)InheritedSdkDependency.INSTANCE)) continue;
            throw new NoWhenBranchMatchedException();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/base/fir/projectStructure/KotlinExportedDependenciesCollector$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/base/fir/projectStructure/KotlinExportedDependenciesCollector;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.base.fir.project-structure"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinExportedDependenciesCollector getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(KotlinExportedDependenciesCollector.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (KotlinExportedDependenciesCollector)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

