/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.util.FileUtils;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\bJ\r\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\"\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\t2\u0006\u0010\u000e\u001a\u00020\bH\u0002J*\u0010\u0013\u001a\u00020\u0010*\u0018\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\tj\u0002`\f2\u0006\u0010\u0014\u001a\u00020\bH\u0002J2\u0010\u0015\u001a\u00020\u0016*\u0018\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\tj\u0002`\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\bH\u0002J*\u0010\u0019\u001a\u00020\u0010*\u0018\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\tj\u0002`\f2\u0006\u0010\u001a\u001a\u00020\bH\u0002J*\u0010\u001b\u001a\u00020\u0010*\u0018\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\tj\u0002`\f2\u0006\u0010\u001a\u001a\u00020\u0018H\u0002J\u0015\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b\u001fJ\u0012\u0010 \u001a\u00020\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\bH\u0002J\u0012\u0010!\u001a\u00020\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\bH\u0002J\u0015\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u0006\u001a$\u0012\u0004\u0012\u00020\b\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\tj\u0002`\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/caches/ImplicitPackagePrefixCache;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "implicitPackageCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "Lorg/jetbrains/kotlin/name/FqName;", "", "Lorg/jetbrains/kotlin/idea/caches/ImplicitPackageData;", "getPrefix", "sourceRoot", "clear", "", "clear$kotlin_base_analysis", "analyzeImplicitPackagePrefixes", "addFile", "ktFile", "addPsiFile", "", "psiFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "removeFile", "file", "updateFile", "update", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "update$kotlin_base_analysis", "checkNewFileInSourceRoot", "checkDeletedFileInSourceRoot", "kotlin.base.analysis"})
@SourceDebugExtension(value={"SMAP\nPerModulePackageCacheService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerModulePackageCacheService.kt\norg/jetbrains/kotlin/idea/caches/ImplicitPackagePrefixCache\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,461:1\n72#2,2:462\n1#3:464\n3829#4:465\n4344#4,2:466\n381#5,7:468\n*S KotlinDebug\n*F\n+ 1 PerModulePackageCacheService.kt\norg/jetbrains/kotlin/idea/caches/ImplicitPackagePrefixCache\n*L\n118#1:462,2\n118#1:464\n128#1:465\n128#1:466,2\n145#1:468,7\n*E\n"})
public final class ImplicitPackagePrefixCache {
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentHashMap<VirtualFile, Map<FqName, List<VirtualFile>>> implicitPackageCache;

    public ImplicitPackagePrefixCache(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.implicitPackageCache = new ConcurrentHashMap();
    }

    @NotNull
    public final FqName getPrefix(@NotNull VirtualFile sourceRoot) {
        Map implicitPackageMap;
        FqName fqName2;
        Intrinsics.checkNotNullParameter((Object)sourceRoot, (String)"sourceRoot");
        ConcurrentMap $this$getOrPut$iv = this.implicitPackageCache;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(sourceRoot);
        if (object == null) {
            boolean bl = false;
            Map<FqName, List<VirtualFile>> default$iv = this.analyzeImplicitPackagePrefixes(sourceRoot);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(sourceRoot, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        if ((fqName2 = (FqName)CollectionsKt.singleOrNull((Iterable)(implicitPackageMap = (Map)object).keySet())) == null) {
            fqName2 = FqName.ROOT;
        }
        return fqName2;
    }

    public final void clear$kotlin_base_analysis() {
        this.implicitPackageCache.clear();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<FqName, List<VirtualFile>> analyzeImplicitPackagePrefixes(VirtualFile sourceRoot) {
        void $this$filterTo$iv$iv;
        Map result2 = new LinkedHashMap();
        VirtualFile[] virtualFileArray = sourceRoot.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
        Object[] $this$filter$iv = virtualFileArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile p0 = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!FileUtils.isKotlinFileType(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List ktFiles = (List)destination$iv$iv;
        for (VirtualFile ktFile2 : ktFiles) {
            Intrinsics.checkNotNull((Object)ktFile2);
            this.addFile(result2, ktFile2);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addFile(Map<FqName, List<VirtualFile>> $this$addFile, VirtualFile ktFile2) {
        Map<FqName, List<VirtualFile>> map2 = $this$addFile;
        synchronized (map2) {
            boolean bl = false;
            PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(ktFile2);
            KtFile ktFile3 = psiFile instanceof KtFile ? (KtFile)psiFile : null;
            if (ktFile3 == null) {
                return;
            }
            KtFile psiFile2 = ktFile3;
            boolean bl2 = this.addPsiFile($this$addFile, psiFile2, ktFile2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean addPsiFile(Map<FqName, List<VirtualFile>> $this$addPsiFile, KtFile psiFile, VirtualFile ktFile2) {
        Object object;
        void $this$getOrPut$iv;
        Map<FqName, List<VirtualFile>> map2 = $this$addPsiFile;
        FqName key$iv = psiFile.getPackageFqName();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return ((List)object).add(ktFile2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeFile(Map<FqName, List<VirtualFile>> $this$removeFile, VirtualFile file) {
        Map<FqName, List<VirtualFile>> map2 = $this$removeFile;
        synchronized (map2) {
            boolean bl = false;
            for (Map.Entry<FqName, List<VirtualFile>> entry : $this$removeFile.entrySet()) {
                FqName key = entry.getKey();
                List<VirtualFile> value = entry.getValue();
                if (!value.remove(file)) continue;
                if (!value.isEmpty()) break;
                $this$removeFile.remove(key);
                break;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateFile(Map<FqName, List<VirtualFile>> $this$updateFile, KtFile file) {
        Map<FqName, List<VirtualFile>> map2 = $this$updateFile;
        synchronized (map2) {
            boolean bl = false;
            VirtualFile virtualFile = file.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            this.removeFile($this$updateFile, virtualFile);
            VirtualFile virtualFile2 = file.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
            boolean bl2 = this.addPsiFile($this$updateFile, file, virtualFile2);
        }
    }

    public final void update$kotlin_base_analysis(@NotNull VFileEvent event) {
        block3: {
            VFileEvent vFileEvent;
            block5: {
                block4: {
                    block2: {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        vFileEvent = event;
                        if (!(vFileEvent instanceof VFileCreateEvent)) break block2;
                        this.checkNewFileInSourceRoot(((VFileCreateEvent)event).getFile());
                        break block3;
                    }
                    if (!(vFileEvent instanceof VFileDeleteEvent)) break block4;
                    this.checkDeletedFileInSourceRoot(((VFileDeleteEvent)event).getFile());
                    break block3;
                }
                if (!(vFileEvent instanceof VFileCopyEvent)) break block5;
                VirtualFile virtualFile = ((VFileCopyEvent)event).getNewParent();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getNewParent(...)");
                VirtualFile newParent = virtualFile;
                if (!newParent.isValid()) break block3;
                this.checkNewFileInSourceRoot(newParent.findChild(((VFileCopyEvent)event).getNewChildName()));
                break block3;
            }
            if (!(vFileEvent instanceof VFileMoveEvent)) break block3;
            this.checkNewFileInSourceRoot(((VFileMoveEvent)event).getFile());
            VirtualFile virtualFile = ((VFileMoveEvent)event).getOldParent();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getOldParent(...)");
            if (Intrinsics.areEqual((Object)ProjectRootsUtilKt.getSourceRoot(virtualFile, this.project), (Object)((VFileMoveEvent)event).getOldParent())) {
                Map<FqName, List<VirtualFile>> map2 = this.implicitPackageCache.get(((VFileMoveEvent)event).getOldParent());
                if (map2 != null) {
                    VirtualFile virtualFile2 = ((VFileMoveEvent)event).getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
                    this.removeFile(map2, virtualFile2);
                }
            }
        }
    }

    private final void checkNewFileInSourceRoot(VirtualFile file) {
        block2: {
            if (file == null) {
                return;
            }
            if (!Intrinsics.areEqual((Object)ProjectRootsUtilKt.getSourceRoot(file, this.project), (Object)file.getParent())) break block2;
            Map<FqName, List<VirtualFile>> map2 = this.implicitPackageCache.get(file.getParent());
            if (map2 != null) {
                this.addFile(map2, file);
            }
        }
    }

    private final void checkDeletedFileInSourceRoot(VirtualFile file) {
        block2: {
            VirtualFile directory;
            VirtualFile virtualFile = file;
            Object object = directory = virtualFile != null ? virtualFile.getParent() : null;
            if (directory == null || !directory.isValid()) {
                return;
            }
            if (!Intrinsics.areEqual((Object)ProjectRootsUtilKt.getSourceRoot(directory, this.project), (Object)directory)) break block2;
            Map<FqName, List<VirtualFile>> map2 = this.implicitPackageCache.get(directory);
            if (map2 != null) {
                this.removeFile(map2, file);
            }
        }
    }

    public final void update$kotlin_base_analysis(@NotNull KtFile ktFile2) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)ktFile2, (String)"ktFile");
            VirtualFile virtualFile = ktFile2.getVirtualFile();
            if (virtualFile == null || (virtualFile = virtualFile.getParent()) == null) {
                return;
            }
            VirtualFile parent2 = virtualFile;
            if (!Intrinsics.areEqual((Object)ProjectRootsUtilKt.getSourceRoot((PsiFileSystemItem)ktFile2), (Object)parent2)) break block2;
            Map<FqName, List<VirtualFile>> map2 = this.implicitPackageCache.get(parent2);
            if (map2 != null) {
                this.updateFile(map2, ktFile2);
            }
        }
    }
}

